/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConvertUtils;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlCreateViewConverter
implements SqlNodeConverter<SqlCreateView> {
    @Override
    public Operation convertSqlNode(SqlCreateView sqlCreateView, SqlNodeConverter.ConvertContext context) {
        SqlNode query = sqlCreateView.getQuery();
        List<SqlNode> viewFields = sqlCreateView.getFieldList().getList();
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateView.fullViewName());
        ObjectIdentifier identifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        String viewComment = sqlCreateView.getComment().map(c -> c.getValueAs(NlsString.class).getValue()).orElse(null);
        Map<String, String> viewOptions = OperationConverterUtils.extractProperties(sqlCreateView.getProperties().orElse(null));
        CatalogView catalogView = SqlNodeConvertUtils.toCatalogView(query, viewFields, viewOptions, viewComment, context);
        return new CreateViewOperation(identifier, catalogView, sqlCreateView.isIfNotExists(), sqlCreateView.isTemporary());
    }
}

