/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.UserCodeClassLoader;

public final class SocketSource
implements Source<RowData, DummySplit, DummyCheckpoint>,
ResultTypeQueryable<RowData> {
    private final String hostname;
    private final int port;
    private final byte byteDelimiter;
    private final DeserializationSchema<RowData> deserializer;

    public SocketSource(String hostname, int port, byte byteDelimiter, DeserializationSchema<RowData> deserializer) {
        this.hostname = hostname;
        this.port = port;
        this.byteDelimiter = byteDelimiter;
        this.deserializer = deserializer;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.deserializer.getProducedType();
    }

    public Boundedness getBoundedness() {
        return Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public SplitEnumerator<DummySplit, DummyCheckpoint> createEnumerator(SplitEnumeratorContext<DummySplit> enumContext) throws Exception {
        return null;
    }

    public SplitEnumerator<DummySplit, DummyCheckpoint> restoreEnumerator(SplitEnumeratorContext<DummySplit> enumContext, DummyCheckpoint checkpoint) throws Exception {
        return null;
    }

    public SimpleVersionedSerializer<DummySplit> getSplitSerializer() {
        return new NoOpDummySplitSerializer();
    }

    public SimpleVersionedSerializer<DummyCheckpoint> getEnumeratorCheckpointSerializer() {
        return null;
    }

    public SourceReader<RowData, DummySplit> createReader(final SourceReaderContext readerContext) throws Exception {
        Preconditions.checkState((readerContext.currentParallelism() == 1 ? 1 : 0) != 0, (Object)"SocketSource can only work with a parallelism of 1.");
        this.deserializer.open(new DeserializationSchema.InitializationContext(){

            public MetricGroup getMetricGroup() {
                return readerContext.metricGroup().addGroup("deserializer");
            }

            public UserCodeClassLoader getUserCodeClassLoader() {
                return readerContext.getUserCodeClassLoader();
            }
        });
        return new SocketReader();
    }

    private static class NoOpDummySplitSerializer
    implements SimpleVersionedSerializer<DummySplit> {
        private NoOpDummySplitSerializer() {
        }

        public int getVersion() {
            return 0;
        }

        public byte[] serialize(DummySplit split) throws IOException {
            return new byte[0];
        }

        public DummySplit deserialize(int version, byte[] serialized) throws IOException {
            return new DummySplit();
        }
    }

    private class SocketReader
    implements SourceReader<RowData, DummySplit> {
        private Socket socket;
        private ByteArrayOutputStream buffer;
        private InputStream stream;
        int b;

        private SocketReader() {
        }

        public void start() {
            while (this.socket == null) {
                try {
                    this.socket = new Socket();
                    this.socket.connect(new InetSocketAddress(SocketSource.this.hostname, SocketSource.this.port), 0);
                    this.buffer = new ByteArrayOutputStream();
                    this.stream = this.socket.getInputStream();
                }
                catch (Throwable t) {
                    this.socket = null;
                    try {
                        System.err.printf("Cannot connect to %s:%d. Retrying in 5 seconds...%n", SocketSource.this.hostname, SocketSource.this.port);
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        public InputStatus pollNext(ReaderOutput<RowData> output) throws Exception {
            while ((this.b = this.stream.read()) >= 0) {
                if (this.b != SocketSource.this.byteDelimiter) {
                    this.buffer.write(this.b);
                    continue;
                }
                try {
                    output.collect(SocketSource.this.deserializer.deserialize(this.buffer.toByteArray()));
                }
                catch (Exception e) {
                    System.err.printf("Malformed data row: %s. A valid sample: INSERT|Alice|12%n", this.buffer.toString());
                }
                this.buffer.reset();
                return InputStatus.MORE_AVAILABLE;
            }
            return InputStatus.END_OF_INPUT;
        }

        public List<DummySplit> snapshotState(long checkpointId) {
            return Collections.emptyList();
        }

        public CompletableFuture<Void> isAvailable() {
            return null;
        }

        public void addSplits(List<DummySplit> splits) {
        }

        public void notifyNoMoreSplits() {
        }

        public void close() throws Exception {
            try {
                this.buffer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class DummyCheckpoint {
    }

    public static class DummySplit
    implements SourceSplit {
        public String splitId() {
            return "dummy";
        }
    }
}

