/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flume.CounterGroup;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.node.ConfigurationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigurationSource
implements ConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfigurationSource.class);
    private final Path path;
    private final URI uri;
    private final CounterGroup counterGroup;
    private byte[] data;
    private long lastChange;

    public FileConfigurationSource(URI uri) {
        this.uri = uri;
        this.path = Paths.get(uri);
        this.counterGroup = new CounterGroup();
        try {
            this.lastChange = this.path.toFile().lastModified();
            this.data = Files.readAllBytes(this.path);
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to read {}: {}", (Object)this.path.toString(), (Object)ioe.getMessage());
            throw new ConfigurationException("Unable to read file " + this.path.toString(), (Throwable)ioe);
        }
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String getUri() {
        return this.uri.toString();
    }

    @Override
    public String getExtension() {
        int length = this.uri.getPath().indexOf(".");
        if (length <= 1) {
            return "properties";
        }
        return this.uri.getPath().substring(length + 1);
    }

    @Override
    public boolean isModified() {
        LOGGER.debug("Checking file:{} for changes", (Object)this.path.toString());
        this.counterGroup.incrementAndGet("file.checks");
        long lastModified = this.path.toFile().lastModified();
        if (lastModified > this.lastChange) {
            LOGGER.info("Reloading configuration file:{}", (Object)this.path.toString());
            this.counterGroup.incrementAndGet("file.loads");
            this.lastChange = lastModified;
            try {
                this.data = Files.readAllBytes(this.path);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to load configuration data. Exception follows.", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.error("Failed to start agent because dependencies were not found in classpath.Error follows.", (Throwable)e);
            }
            catch (Throwable t) {
                LOGGER.error("Unhandled error", t);
            }
        }
        return false;
    }

    public String toString() {
        return "{ file:" + this.path.toString() + "}";
    }
}

