/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.serialization.EventDeserializer;
import org.apache.flume.serialization.ResettableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlobDeserializer
implements EventDeserializer {
    private ResettableInputStream in;
    private final int maxBlobLength;
    private volatile boolean isOpen;
    public static final String MAX_BLOB_LENGTH_KEY = "maxBlobLength";
    public static final int MAX_BLOB_LENGTH_DEFAULT = 100000000;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobDeserializer.class);

    protected BlobDeserializer(Context context, ResettableInputStream in) {
        this.in = in;
        this.maxBlobLength = context.getInteger(MAX_BLOB_LENGTH_KEY, Integer.valueOf(100000000));
        if (this.maxBlobLength <= 0) {
            throw new ConfigurationException("Configuration parameter maxBlobLength must be greater than zero: " + this.maxBlobLength);
        }
        this.isOpen = true;
    }

    public Event readEvent() throws IOException {
        this.ensureOpen();
        ByteArrayOutputStream blob = null;
        byte[] buf = new byte[Math.min(this.maxBlobLength, 8192)];
        int blobLength = 0;
        int n = 0;
        while ((n = this.in.read(buf, 0, Math.min(buf.length, this.maxBlobLength - blobLength))) != -1) {
            if (blob == null) {
                blob = new ByteArrayOutputStream(n);
            }
            blob.write(buf, 0, n);
            if ((blobLength += n) < this.maxBlobLength) continue;
            LOGGER.warn("File length exceeds maxBlobLength ({}), truncating BLOB event!", (Object)this.maxBlobLength);
            break;
        }
        if (blob == null) {
            return null;
        }
        return EventBuilder.withBody((byte[])blob.toByteArray());
    }

    public List<Event> readEvents(int numEvents) throws IOException {
        Event event;
        this.ensureOpen();
        LinkedList events = Lists.newLinkedList();
        for (int i = 0; i < numEvents && (event = this.readEvent()) != null; ++i) {
            events.add(event);
        }
        return events;
    }

    public void mark() throws IOException {
        this.ensureOpen();
        this.in.mark();
    }

    public void reset() throws IOException {
        this.ensureOpen();
        this.in.reset();
    }

    public void close() throws IOException {
        if (this.isOpen) {
            this.reset();
            this.in.close();
            this.isOpen = false;
        }
    }

    private void ensureOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Serializer has been closed");
        }
    }

    public static class Builder
    implements EventDeserializer.Builder {
        public BlobDeserializer build(Context context, ResettableInputStream in) {
            return new BlobDeserializer(context, in);
        }
    }
}

