/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.thriftLegacy;

import com.cloudera.flume.handlers.thrift.ThriftFlumeEvent;
import com.cloudera.flume.handlers.thrift.ThriftFlumeEventServer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftLegacySource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    static final Logger LOG = LoggerFactory.getLogger(ThriftLegacySource.class);
    static final String HOST = "host";
    static final String TIMESTAMP = "timestamp";
    static final String PRIORITY = "pri";
    static final String NANOS = "nanos";
    static final String OG_EVENT = "FlumeOG";
    private CounterGroup counterGroup;
    private String host;
    private int port;
    private TServer server;
    private TServerTransport serverTransport;
    private Thread thriftHandlerThread;
    private Charset UTF_8 = Charset.forName("UTF-8");

    public void configure(Context context) {
        this.port = Integer.parseInt(context.getString("port"));
        this.host = context.getString(HOST);
    }

    public ThriftLegacySource() {
        this.counterGroup = new CounterGroup();
    }

    public void start() {
        try {
            InetSocketAddress bindAddr = new InetSocketAddress(this.host, this.port);
            this.serverTransport = new TServerSocket(bindAddr);
            ThriftFlumeEventServer.Processor<ThriftFlumeEventServerImpl> processor = new ThriftFlumeEventServer.Processor<ThriftFlumeEventServerImpl>(new ThriftFlumeEventServerImpl());
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args(this.serverTransport).processor(processor));
        }
        catch (TTransportException e) {
            throw new FlumeException("Failed starting source", (Throwable)e);
        }
        ThriftHandler thriftHandler = new ThriftHandler(this.server);
        this.thriftHandlerThread = new Thread(thriftHandler);
        this.thriftHandlerThread.start();
        super.start();
    }

    public void stop() {
        this.server.stop();
        this.serverTransport.close();
        try {
            this.thriftHandlerThread.join();
        }
        catch (InterruptedException eI) {
            LOG.warn("stop interrupted", (Throwable)eI);
            return;
        }
        super.stop();
    }

    public static class ThriftHandler
    implements Runnable {
        private TServer server;

        public ThriftHandler(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }

    private class ThriftFlumeEventServerImpl
    implements ThriftFlumeEventServer.Iface {
        private ThriftFlumeEventServerImpl() {
        }

        @Override
        public void append(ThriftFlumeEvent evt) {
            if (evt == null) {
                return;
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(ThriftLegacySource.HOST, evt.getHost());
            headers.put(ThriftLegacySource.TIMESTAMP, Long.toString(evt.getTimestamp()));
            headers.put(ThriftLegacySource.PRIORITY, evt.getPriority().toString());
            headers.put(ThriftLegacySource.NANOS, Long.toString(evt.getNanos()));
            for (Map.Entry<String, ByteBuffer> entry : evt.getFields().entrySet()) {
                headers.put(entry.getKey().toString(), ThriftLegacySource.this.UTF_8.decode(entry.getValue()).toString());
            }
            headers.put(ThriftLegacySource.OG_EVENT, "yes");
            Event event = EventBuilder.withBody((byte[])evt.getBody(), headers);
            ThriftLegacySource.this.counterGroup.incrementAndGet("rpc.events");
            try {
                ThriftLegacySource.this.getChannelProcessor().processEvent(event);
            }
            catch (ChannelException ex) {
                LOG.warn("Failed to process event", (Throwable)ex);
                return;
            }
            ThriftLegacySource.this.counterGroup.incrementAndGet("rpc.successful");
        }

        @Override
        public void close() {
        }
    }
}

