/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.cache.LoadingCache;
import com.google.protobuf.InvalidProtocolBufferException;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.hbase.async.AppendRequest;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.BatchableRpc;
import org.hbase.async.BrokenMetaException;
import org.hbase.async.BufferedIncrement;
import org.hbase.async.BufferedMultiColumnIncrement;
import org.hbase.async.Bytes;
import org.hbase.async.ClientStats;
import org.hbase.async.CompareAndSetRequest;
import org.hbase.async.Config;
import org.hbase.async.Counter;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.GetResultOrException;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.HasFailedRpcException;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.MultiAction;
import org.hbase.async.MultiColumnAtomicIncrementRequest;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PleaseThrottleException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionClient;
import org.hbase.async.RegionClientStats;
import org.hbase.async.RegionInfo;
import org.hbase.async.RegionLocation;
import org.hbase.async.RegionMovedException;
import org.hbase.async.RegionServerStoppedException;
import org.hbase.async.RowLock;
import org.hbase.async.RowLockRequest;
import org.hbase.async.Scanner;
import org.hbase.async.TableNotFoundException;
import org.hbase.async.UnknownProtocolException;
import org.hbase.async.generated.ZooKeeperPB;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioChannelConfig;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseClient.class);
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static final byte[] ZERO_ARRAY = new byte[]{0};
    protected static final byte[] ROOT = new byte[]{45, 82, 79, 79, 84, 45};
    protected static final byte[] ROOT_REGION = new byte[]{45, 82, 79, 79, 84, 45, 44, 44, 48};
    static final byte[] HBASE98_ROOT = new byte[]{104, 98, 97, 115, 101, 58, 114, 111, 111, 116};
    static final byte[] HBASE98_ROOT_REGION = new byte[]{104, 98, 97, 115, 101, 58, 114, 111, 111, 116, 44, 44, 48};
    protected static final byte[] META = new byte[]{46, 77, 69, 84, 65, 46};
    protected static final byte[] INFO = new byte[]{105, 110, 102, 111};
    protected static final byte[] REGIONINFO = new byte[]{114, 101, 103, 105, 111, 110, 105, 110, 102, 111};
    protected static final byte[] SERVER = new byte[]{115, 101, 114, 118, 101, 114};
    protected static final byte[] HBASE96_META = new byte[]{104, 98, 97, 115, 101, 58, 109, 101, 116, 97};
    protected static final byte[] META_REGION_NAME = new byte[]{104, 98, 97, 115, 101, 58, 109, 101, 116, 97, 44, 44, 49};
    protected static final RegionInfo META_REGION = new RegionInfo(HBASE96_META, META_REGION_NAME, EMPTY_ARRAY);
    static final int PBUF_MAGIC = 1346524486;
    private final HashedWheelTimer timer;
    private final HashedWheelTimer rpc_timeout_timer;
    private volatile short flush_interval;
    private volatile int increment_buffer_size;
    private int nsre_low_watermark;
    private int nsre_high_watermark;
    private final ClientSocketChannelFactory channel_factory;
    private final ZKClient zkclient;
    private volatile RegionClient rootregion;
    volatile boolean has_root = true;
    private final ConcurrentSkipListMap<byte[], RegionInfo> regions_cache = new ConcurrentSkipListMap(RegionInfo.REGION_NAME_CMP);
    private final ConcurrentHashMap<RegionInfo, RegionClient> region2client = new ConcurrentHashMap();
    private final ConcurrentHashMap<RegionClient, ArrayList<RegionInfo>> client2regions = new ConcurrentHashMap();
    private final HashMap<String, RegionClient> ip2client = new HashMap();
    private final ConcurrentSkipListMap<byte[], ArrayList<HBaseRpc>> got_nsre = new ConcurrentSkipListMap(RegionInfo.REGION_NAME_CMP);
    private volatile LoadingCache<BufferedIncrement, BufferedIncrement.Amount> increment_buffer;
    private volatile LoadingCache<BufferedMultiColumnIncrement, BufferedMultiColumnIncrement.Amounts> multi_column_increment_buffer;
    private final Config config;
    static final AtomicInteger BOSS_THREAD_ID = new AtomicInteger();
    static final AtomicInteger WORKER_THREAD_ID = new AtomicInteger();
    static final AtomicInteger TIMER_THREAD_ID = new AtomicInteger();
    private final int rpc_timeout;
    private volatile boolean scan_meta;
    protected boolean split_meta;
    private boolean increment_buffer_durable = false;
    private final Counter num_connections_created = new Counter();
    private final Counter root_lookups = new Counter();
    private final Counter meta_lookups_with_permit = new Counter();
    private final Counter meta_lookups_wo_permit = new Counter();
    private final Counter num_flushes = new Counter();
    private final Counter num_nsres = new Counter();
    private final Counter num_nsre_rpcs = new Counter();
    final Counter num_multi_rpcs = new Counter();
    private final Counter num_gets = new Counter();
    private final Counter num_scanners_opened = new Counter();
    private final Counter num_scans = new Counter();
    private final Counter num_puts = new Counter();
    private final Counter num_appends = new Counter();
    private final Counter num_row_locks = new Counter();
    private final Counter num_deletes = new Counter();
    private final Counter num_atomic_increments = new Counter();
    private final Counter idle_connections_closed = new Counter();
    private static final Callback<ArrayList<KeyValue>, Object> got = new Callback<ArrayList<KeyValue>, Object>(){

        public ArrayList<KeyValue> call(Object response) {
            if (response instanceof ArrayList) {
                ArrayList row = (ArrayList)response;
                return row;
            }
            throw new InvalidResponseException(ArrayList.class, response);
        }

        public String toString() {
            return "type get response";
        }
    };
    private static final Callback<GetResultOrException, Object> MUL_GOT_ONE = new Callback<GetResultOrException, Object>(){

        public GetResultOrException call(Object response) {
            if (response instanceof ArrayList) {
                ArrayList row = (ArrayList)response;
                return new GetResultOrException(row);
            }
            if (response instanceof Exception) {
                Exception e = (Exception)response;
                return new GetResultOrException(e);
            }
            return new GetResultOrException(new InvalidResponseException(ArrayList.class, response));
        }

        public String toString() {
            return "type mul get one response";
        }
    };
    private static final Callback<Object, Object> scanner_opened = new Callback<Object, Object>(){

        public Object call(Object response) {
            if (response instanceof Scanner.Response) {
                return (Scanner.Response)response;
            }
            if (response instanceof Long) {
                return (Long)response;
            }
            throw new InvalidResponseException(Long.class, response);
        }

        public String toString() {
            return "type openScanner response";
        }
    };
    private static final Callback<Long, Object> icv_done = new Callback<Long, Object>(){

        public Long call(Object response) {
            if (response instanceof Long) {
                return (Long)response;
            }
            throw new InvalidResponseException(Long.class, response);
        }

        public String toString() {
            return "type incrementColumnValue response";
        }
    };
    private static final Callback<Map<byte[], Long>, Object> micv_done = new Callback<Map<byte[], Long>, Object>(){

        public Map<byte[], Long> call(Object response) {
            if (response instanceof Map) {
                return (Map)response;
            }
            throw new InvalidResponseException(Long.class, response);
        }

        public String toString() {
            return "type incrementColumnValue response";
        }
    };
    private static final AppendCB APPEND_CB = new AppendCB();
    private static final CompareAndSetCB CAS_CB = new CompareAndSetCB();
    private final MetaWithRegionLocationCB meta_lookup_done_return_location = new MetaWithRegionLocationCB();
    private final MetaCB meta_lookup_done = new MetaCB();
    private final RootCB root_lookup_done = new RootCB();
    private static final short NSRE_LOG_EVERY = 500;
    protected static byte[] PROBE_SUFFIX = new byte[]{58, 65, 115, 121, 110, 99, 72, 66, 97, 115, 101, 126, 112, 114, 111, 98, 101, 126, 60, 59, 95, 60};

    public HBaseClient(String quorum_spec) {
        this(quorum_spec, "/hbase");
    }

    public HBaseClient(String quorum_spec, String base_path) {
        this(quorum_spec, base_path, (ClientSocketChannelFactory)HBaseClient.defaultChannelFactory(new Config()));
    }

    public HBaseClient(String quorum_spec, String base_path, Executor executor) {
        this(quorum_spec, base_path, (ClientSocketChannelFactory)new CustomChannelFactory(executor));
    }

    public HBaseClient(String quorum_spec, String base_path, ClientSocketChannelFactory channel_factory) {
        this.channel_factory = channel_factory;
        this.zkclient = new ZKClient(quorum_spec, base_path);
        this.config = new Config();
        this.rpc_timeout = this.config.getInt("hbase.rpc.timeout");
        this.timer = HBaseClient.newTimer(this.config, "HBaseClient");
        this.rpc_timeout_timer = HBaseClient.newTimer(this.config, "RPC Timeout Timer");
        this.flush_interval = this.config.getShort("hbase.rpcs.buffered_flush_interval");
        this.increment_buffer_size = this.config.getInt("hbase.increments.buffer_size");
        this.nsre_low_watermark = this.config.getInt("hbase.nsre.low_watermark");
        this.nsre_high_watermark = this.config.getInt("hbase.nsre.high_watermark");
        if (this.config.properties.containsKey("hbase.increments.durable")) {
            this.increment_buffer_durable = this.config.getBoolean("hbase.increments.durable");
        }
        this.scan_meta = this.config.hasProperty("hbase.meta.scan") ? this.config.getBoolean("hbase.meta.scan") : Boolean.parseBoolean(System.getProperty("hbase.meta.scan", "false"));
        this.split_meta = this.config.hasProperty("hbase.meta.split") ? this.config.getBoolean("hbase.meta.split") : Boolean.parseBoolean(System.getProperty("hbase.meta.split", "false"));
    }

    public HBaseClient(Config config) {
        this(config, (ClientSocketChannelFactory)HBaseClient.defaultChannelFactory(config));
    }

    public HBaseClient(Config config, Executor executor) {
        this(config, (ClientSocketChannelFactory)new CustomChannelFactory(executor));
    }

    public HBaseClient(Config config, ClientSocketChannelFactory channel_factory) {
        this.channel_factory = channel_factory;
        this.zkclient = new ZKClient(config.getString("hbase.zookeeper.quorum"), config.getString("hbase.zookeeper.znode.parent"));
        this.config = config;
        this.rpc_timeout = config.getInt("hbase.rpc.timeout");
        this.timer = HBaseClient.newTimer(config, "HBaseClient");
        this.rpc_timeout_timer = HBaseClient.newTimer(config, "RPC Timeout Timer");
        this.flush_interval = config.getShort("hbase.rpcs.buffered_flush_interval");
        this.increment_buffer_size = config.getInt("hbase.increments.buffer_size");
        this.nsre_low_watermark = config.getInt("hbase.nsre.low_watermark");
        this.nsre_high_watermark = config.getInt("hbase.nsre.high_watermark");
        if (config.properties.containsKey("hbase.increments.durable")) {
            this.increment_buffer_durable = config.getBoolean("hbase.increments.durable");
        }
        this.scan_meta = config.hasProperty("hbase.meta.scan") ? config.getBoolean("hbase.meta.scan") : Boolean.parseBoolean(System.getProperty("hbase.meta.scan", "false"));
        this.split_meta = config.hasProperty("hbase.meta.split") ? config.getBoolean("hbase.meta.split") : Boolean.parseBoolean(System.getProperty("hbase.meta.split", "false"));
    }

    static HashedWheelTimer newTimer(Config config, String name) {
        class TimerThreadNamer
        implements ThreadNameDeterminer {
            final /* synthetic */ String val$name;

            TimerThreadNamer(String string) {
                this.val$name = string;
            }

            public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                return "AsyncHBase Timer " + this.val$name + " #" + TIMER_THREAD_ID.incrementAndGet();
            }
        }
        if (config == null) {
            return new HashedWheelTimer(Executors.defaultThreadFactory(), (ThreadNameDeterminer)new TimerThreadNamer(name), 100L, TimeUnit.MILLISECONDS, 512);
        }
        return new HashedWheelTimer(Executors.defaultThreadFactory(), (ThreadNameDeterminer)new TimerThreadNamer(name), (long)config.getShort("hbase.timer.tick"), TimeUnit.MILLISECONDS, config.getInt("hbase.timer.ticks_per_wheel"));
    }

    private static NioClientSocketChannelFactory defaultChannelFactory(Config config) {
        ExecutorService executor = Executors.newCachedThreadPool();
        class BossThreadNamer
        implements ThreadNameDeterminer {
            BossThreadNamer() {
            }

            public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                return "AsyncHBase I/O Boss #" + BOSS_THREAD_ID.incrementAndGet();
            }
        }
        NioClientBossPool boss_pool = new NioClientBossPool((Executor)executor, 1, (Timer)HBaseClient.newTimer(config, "Boss Pool"), (ThreadNameDeterminer)new BossThreadNamer());
        int num_workers = config.hasProperty("hbase.workers.size") ? config.getInt("hbase.workers.size") : Runtime.getRuntime().availableProcessors() * 2;
        class WorkerThreadNamer
        implements ThreadNameDeterminer {
            WorkerThreadNamer() {
            }

            public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                return "AsyncHBase I/O Worker #" + WORKER_THREAD_ID.incrementAndGet();
            }
        }
        NioWorkerPool worker_pool = new NioWorkerPool((Executor)executor, num_workers, (ThreadNameDeterminer)new WorkerThreadNamer());
        return new NioClientSocketChannelFactory((BossPool)boss_pool, (WorkerPool)worker_pool);
    }

    public ClientStats stats() {
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> cache = this.increment_buffer;
        long inflight_rpcs = 0L;
        long pending_rpcs = 0L;
        long pending_batched_rpcs = 0L;
        int dead_region_clients = 0;
        Set region_clients = this.client2regions.keySet();
        for (RegionClient rc : region_clients) {
            RegionClientStats stats = rc.stats();
            inflight_rpcs += (long)stats.inflightRPCs();
            pending_rpcs += (long)stats.pendingRPCs();
            pending_batched_rpcs += (long)stats.pendingBatchedRPCs();
            if (!stats.isDead()) continue;
            ++dead_region_clients;
        }
        return new ClientStats(this.num_connections_created.get(), this.root_lookups.get(), this.meta_lookups_with_permit.get(), this.meta_lookups_wo_permit.get(), this.num_flushes.get(), this.num_nsres.get(), this.num_nsre_rpcs.get(), this.num_multi_rpcs.get(), this.num_gets.get(), this.num_scanners_opened.get(), this.num_scans.get(), this.num_puts.get(), this.num_appends.get(), this.num_row_locks.get(), this.num_deletes.get(), this.num_atomic_increments.get(), cache != null ? cache.stats() : BufferedIncrement.ZERO_STATS, inflight_rpcs, pending_rpcs, pending_batched_rpcs, dead_region_clients, region_clients.size(), this.idle_connections_closed.get());
    }

    public List<RegionClientStats> regionStats() {
        Set region_clients = this.client2regions.keySet();
        ArrayList<RegionClientStats> stats = new ArrayList<RegionClientStats>(region_clients.size());
        for (RegionClient rc : region_clients) {
            stats.add(rc.stats());
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> flush() {
        boolean need_sync;
        Deferred<Object> d = this.zkclient.getDeferredRootIfBeingLookedUp();
        if (d != null) {
            LOG.debug("Flush needs to wait on {} to come back", (Object)(this.has_root ? (this.split_meta ? new String(HBASE98_ROOT_REGION) : new String(ROOT)) : (this.split_meta ? new String(HBASE96_META) : new String(META))));
            final class RetryFlush
            implements Callback<Object, Object> {
                RetryFlush() {
                }

                public Object call(Object arg) {
                    LOG.debug("Flush retrying after {} came back", (Object)(HBaseClient.this.has_root ? (HBaseClient.this.split_meta ? new String(HBASE98_ROOT_REGION) : new String(ROOT)) : (HBaseClient.this.split_meta ? new String(HBASE96_META) : new String(META))));
                    return HBaseClient.this.flush();
                }

                public String toString() {
                    return "retry flush";
                }
            }
            return d.addBoth((Callback)new RetryFlush());
        }
        this.num_flushes.increment();
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> buf = this.increment_buffer;
        if (buf != null && !buf.asMap().isEmpty()) {
            HBaseClient.flushBufferedIncrements(buf);
            need_sync = true;
        } else {
            LoadingCache<BufferedMultiColumnIncrement, BufferedMultiColumnIncrement.Amounts> multiColumnBuf = this.multi_column_increment_buffer;
            if (multiColumnBuf != null && !multiColumnBuf.asMap().isEmpty()) {
                HBaseClient.flushBufferedMultiColumnIncrements(multiColumnBuf);
                need_sync = true;
            } else {
                need_sync = false;
            }
        }
        ArrayList<Deferred<Object>> d2 = new ArrayList<Deferred<Object>>(this.client2regions.size() + this.got_nsre.size() * 8);
        for (RegionClient client : this.client2regions.keySet()) {
            d2.add(need_sync ? client.sync() : client.flush());
        }
        Iterator<Object> i$ = this.got_nsre.values().iterator();
        while (i$.hasNext()) {
            ArrayList nsred;
            ArrayList arrayList = nsred = (ArrayList)i$.next();
            synchronized (arrayList) {
                for (HBaseRpc rpc : nsred) {
                    if (!(rpc instanceof HBaseRpc.IsEdit)) continue;
                    d2.add(rpc.getDeferred());
                }
            }
        }
        Deferred flushed = Deferred.group(d2);
        return flushed;
    }

    public short setFlushInterval(short flush_interval) {
        if (flush_interval < 0) {
            throw new IllegalArgumentException("Negative: " + flush_interval);
        }
        short prev = this.config.getShort("hbase.rpcs.buffered_flush_interval");
        this.config.overrideConfig("hbase.rpcs.buffered_flush_interval", Short.toString(flush_interval));
        this.flush_interval = flush_interval;
        return prev;
    }

    public int setIncrementBufferSize(int increment_buffer_size) {
        if (increment_buffer_size < 0) {
            throw new IllegalArgumentException("Negative: " + increment_buffer_size);
        }
        int current = this.config.getInt("hbase.increments.buffer_size");
        if (current == increment_buffer_size) {
            return current;
        }
        this.config.overrideConfig("hbase.increments.buffer_size", Integer.toString(increment_buffer_size));
        this.increment_buffer_size = increment_buffer_size;
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> prev = this.increment_buffer;
        if (prev != null) {
            this.makeIncrementBuffer();
            HBaseClient.flushBufferedIncrements(prev);
        }
        return current;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Config getConfig() {
        return this.config;
    }

    void newTimeout(TimerTask task, long timeout_ms) {
        try {
            this.timer.newTimeout(task, timeout_ms, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException e) {
            LOG.warn("Failed to schedule timer.  Ignore this if we're shutting down.", (Throwable)e);
        }
    }

    public short getFlushInterval() {
        return this.flush_interval;
    }

    public int getDefaultRpcTimeout() {
        return this.rpc_timeout;
    }

    public int getIncrementBufferSize() {
        return this.increment_buffer_size;
    }

    public Deferred<Object> shutdown() {
        Deferred<Object> d = this.zkclient.getDeferredRootIfBeingLookedUp();
        if (d != null) {
            LOG.debug("Shutdown needs to wait on {} to come back", (Object)(this.has_root ? (this.split_meta ? new String(HBASE98_ROOT_REGION) : new String(ROOT)) : (this.split_meta ? new String(HBASE96_META) : new String(META))));
            final class RetryShutdown
            implements Callback<Object, Object> {
                RetryShutdown() {
                }

                public Object call(Object arg) {
                    LOG.debug("Shutdown retrying after {} came back", (Object)(HBaseClient.this.has_root ? (HBaseClient.this.split_meta ? new String(HBASE98_ROOT_REGION) : new String(ROOT)) : (HBaseClient.this.split_meta ? new String(HBASE96_META) : new String(META))));
                    return HBaseClient.this.shutdown();
                }

                public String toString() {
                    return "retry shutdown";
                }
            }
            return d.addBoth((Callback)new RetryShutdown());
        }
        final class DisconnectCB
        implements Callback<Object, Object> {
            DisconnectCB() {
            }

            public Object call(Object arg) {
                final class ReleaseResourcesCB
                implements Callback<Object, Object> {
                    ReleaseResourcesCB() {
                    }

                    public Object call(Object arg) {
                        LOG.debug("Releasing all remaining resources");
                        HBaseClient.this.timer.stop();
                        HBaseClient.this.rpc_timeout_timer.stop();
                        final class ShutdownThread
                        extends Thread {
                            ShutdownThread() {
                                super("HBaseClient@" + HBaseClient.super.hashCode() + " shutdown");
                            }

                            @Override
                            public void run() {
                                HBaseClient.this.channel_factory.releaseExternalResources();
                            }
                        }
                        new ShutdownThread().start();
                        return arg;
                    }

                    public String toString() {
                        return "release resources callback";
                    }
                }
                return HBaseClient.this.disconnectEverything().addCallback((Callback)new ReleaseResourcesCB());
            }

            public String toString() {
                return "disconnect callback";
            }
        }
        return this.flush().addCallback((Callback)new DisconnectCB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<Object> disconnectEverything() {
        HashMap<String, RegionClient> ip2client_copy;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            ip2client_copy = new HashMap<String, RegionClient>(this.ip2client);
        }
        ArrayList<Deferred<Object>> d = new ArrayList<Deferred<Object>>(ip2client_copy.values().size() + 1);
        for (RegionClient client : ip2client_copy.values()) {
            d.add(client.shutdown());
        }
        if (this.rootregion != null && this.rootregion.isAlive()) {
            d.add(this.rootregion.shutdown());
        }
        ip2client_copy = null;
        final int size = d.size();
        return Deferred.group(d).addCallback((Callback)new Callback<Object, ArrayList<Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(ArrayList<Object> arg) {
                HashMap logme = null;
                HashMap hashMap = HBaseClient.this.ip2client;
                synchronized (hashMap) {
                    if (!HBaseClient.this.ip2client.isEmpty()) {
                        logme = new HashMap(HBaseClient.this.ip2client);
                    }
                }
                if (logme != null) {
                    LOG.error("Some clients are left in the client cache and haven't been cleaned up: " + logme);
                    logme = null;
                    return HBaseClient.this.disconnectEverything();
                }
                HBaseClient.this.zkclient.disconnectZK();
                return arg;
            }

            public String toString() {
                return "wait " + size + " RegionClient.shutdown()";
            }
        });
    }

    public Deferred<Object> ensureTableFamilyExists(String table, String family) {
        return this.ensureTableFamilyExists(table.getBytes(), family.getBytes());
    }

    public Deferred<Object> ensureTableFamilyExists(byte[] table, byte[] family) {
        HBaseRpc dummy = family == EMPTY_ARRAY ? GetRequest.exists(table, HBaseClient.probeKey(ZERO_ARRAY)) : GetRequest.exists(table, HBaseClient.probeKey(ZERO_ARRAY), family);
        Deferred<Object> d = this.sendRpcToRegion(dummy);
        return d;
    }

    public Deferred<Object> ensureTableExists(String table) {
        return this.ensureTableFamilyExists(table.getBytes(), EMPTY_ARRAY);
    }

    public Deferred<Object> ensureTableExists(byte[] table) {
        return this.ensureTableFamilyExists(table, EMPTY_ARRAY);
    }

    public Deferred<ArrayList<KeyValue>> get(GetRequest request) {
        this.num_gets.increment();
        return this.sendRpcToRegion(request).addCallbacks(got, Callback.PASSTHROUGH);
    }

    public Deferred<List<GetResultOrException>> get(List<GetRequest> requests) {
        return Deferred.groupInOrder(this.multiGet(requests)).addCallback((Callback)new Callback<List<GetResultOrException>, ArrayList<GetResultOrException>>(){

            public List<GetResultOrException> call(ArrayList<GetResultOrException> results) {
                return results;
            }
        });
    }

    private List<Deferred<GetResultOrException>> multiGet(List<GetRequest> requests) {
        ArrayList<Deferred<GetResultOrException>> result_deferreds = new ArrayList<Deferred<GetResultOrException>>(requests.size());
        HashMap<RegionClient, MultiAction> batch_by_region = new HashMap<RegionClient, MultiAction>();
        for (int i = 0; i < requests.size(); ++i) {
            GetRequest request = requests.get(i);
            byte[] table = request.table;
            byte[] key = request.key;
            RegionInfo region = this.getRegion(table, key);
            RegionClient client = null;
            if (region != null) {
                RegionClient regionClient = client = Bytes.equals(region.table(), this.split_meta ? HBASE98_ROOT_REGION : ROOT) ? this.rootregion : this.region2client.get(region);
            }
            if (client == null || !client.isAlive()) {
                result_deferreds.add((Deferred<GetResultOrException>)this.sendRpcToRegion(request).addBoth(MUL_GOT_ONE));
                continue;
            }
            request.setRegion(region);
            MultiAction batch = (MultiAction)batch_by_region.get((Object)client);
            if (batch == null) {
                batch = new MultiAction();
                batch_by_region.put(client, batch);
            }
            batch.add(request);
            result_deferreds.add((Deferred<GetResultOrException>)request.getDeferred().addBoth(MUL_GOT_ONE));
        }
        for (Map.Entry entry : batch_by_region.entrySet()) {
            MultiAction request = (MultiAction)entry.getValue();
            Deferred<Object> d = request.getDeferred();
            final class MultiActionCallback
            implements Callback<Object, Object> {
                final MultiAction request;

                public MultiActionCallback(MultiAction request) {
                    this.request = request;
                }

                public Object call(Object resp) {
                    if (!(resp instanceof MultiAction.Response)) {
                        if (resp instanceof BatchableRpc) {
                            return null;
                        }
                        if (resp instanceof Exception) {
                            return this.handleException((Exception)resp);
                        }
                        throw new InvalidResponseException(MultiAction.Response.class, resp);
                    }
                    MultiAction.Response response = (MultiAction.Response)resp;
                    ArrayList<BatchableRpc> batch = this.request.batch();
                    int n = batch.size();
                    for (int i = 0; i < n; ++i) {
                        BatchableRpc rpc = batch.get(i);
                        Object r = response.result(i);
                        if (r instanceof RecoverableException) {
                            if (!(r instanceof NotServingRegionException) && !(r instanceof RegionMovedException) && !(r instanceof RegionServerStoppedException)) continue;
                            try {
                                HBaseClient.this.handleNSRE(rpc, rpc.getRegion().name(), (NotServingRegionException)r);
                            }
                            catch (RuntimeException e) {
                                LOG.error("Unexpected exception processing NSRE for RPC " + rpc, (Throwable)e);
                                rpc.callback(e);
                            }
                            continue;
                        }
                        rpc.callback(r);
                    }
                    return null;
                }

                private Object handleException(Exception e) {
                    if (!(e instanceof RecoverableException)) {
                        for (BatchableRpc rpc : this.request.batch()) {
                            rpc.callback(e);
                        }
                        return e;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this + " Multi-action request failed, retrying each of the " + this.request.size() + " RPCs individually.", (Throwable)e);
                    }
                    for (BatchableRpc rpc : this.request.batch()) {
                        if (!(e instanceof NotServingRegionException) && !(e instanceof RegionMovedException) && !(e instanceof RegionServerStoppedException)) continue;
                        try {
                            HBaseClient.this.handleNSRE(rpc, rpc.getRegion().name(), (NotServingRegionException)e);
                        }
                        catch (RuntimeException ex) {
                            LOG.error("Unexpected exception trying to NSRE the RPC " + rpc, (Throwable)ex);
                            rpc.callback(ex);
                        }
                    }
                    return null;
                }

                public String toString() {
                    return "multi-action response";
                }
            }
            d.addBoth((Callback)new MultiActionCallback(request));
            ((RegionClient)((Object)entry.getKey())).sendRpc(request);
        }
        return result_deferreds;
    }

    public Scanner newScanner(byte[] table) {
        return new Scanner(this, table);
    }

    public Scanner newScanner(String table) {
        return new Scanner(this, table.getBytes());
    }

    Deferred<Object> openScanner(Scanner scanner) {
        return this.openScanner(scanner, scanner.getOpenRequest());
    }

    Deferred<Object> openScanner(final Scanner scanner, HBaseRpc open_req) {
        this.num_scanners_opened.increment();
        HBaseRpc req = open_req;
        return this.sendRpcToRegion(req).addCallbacks(scanner_opened, (Callback)new Callback<Object, Object>(){

            public Object call(Object error) {
                scanner.invalidate();
                return error;
            }

            public String toString() {
                return "openScanner errback";
            }
        });
    }

    Deferred<Object> openReverseScanner(final Scanner scanner) {
        return this.locateRegionClosestBeforeKey(scanner.getOpenRequest(), scanner.table(), scanner.startKey()).addCallbacks((Callback)new Callback<Object, Object>(){

            public Object call(Object arg) {
                return HBaseClient.this.openScanner(scanner, scanner.getOpenRequestForReverseScan(((RegionLocation)arg).startKey()));
            }
        }, (Callback)new Callback<Object, Object>(){

            public Object call(Object error) {
                LOG.info("Lookup to construct reverse scanner failed on table " + Bytes.pretty(scanner.table()) + " and start key " + Bytes.pretty(scanner.startKey()));
                return error;
            }

            public String toString() {
                return "openReverseScanner errback";
            }
        });
    }

    private RegionClient clientFor(RegionInfo region) {
        if (region == null) {
            return null;
        }
        if (region == META_REGION || Bytes.equals(region.table(), ROOT) || Bytes.equals(region.table(), HBASE98_ROOT)) {
            return this.rootregion;
        }
        return this.region2client.get(region);
    }

    Deferred<Object> scanNextRows(Scanner scanner) {
        RegionInfo region = scanner.currentRegion();
        RegionClient client = this.clientFor(region);
        if (client == null) {
            scanner.invalidate();
            Deferred<ArrayList<ArrayList<KeyValue>>> d = scanner.nextRows();
            return d;
        }
        this.num_scans.increment();
        HBaseRpc next_request = scanner.getNextRowsRequest();
        Deferred<Object> d = next_request.getDeferred();
        client.sendRpc(next_request);
        return d;
    }

    Deferred<Object> closeScanner(Scanner scanner) {
        RegionInfo region = scanner.currentRegion();
        RegionClient client = this.clientFor(region);
        if (client == null) {
            LOG.warn("Cannot close " + scanner + " properly, no connection open for " + Bytes.pretty(region == null ? null : region.name()));
            return Deferred.fromResult(null);
        }
        HBaseRpc close_request = scanner.getCloseRequest();
        Deferred<Object> d = close_request.getDeferred();
        client.sendRpc(close_request);
        return d;
    }

    public Deferred<Long> atomicIncrement(AtomicIncrementRequest request) {
        this.num_atomic_increments.increment();
        return this.sendRpcToRegion(request).addCallbacks(icv_done, Callback.PASSTHROUGH);
    }

    public Deferred<Map<byte[], Long>> atomicIncrement(MultiColumnAtomicIncrementRequest request) {
        this.num_atomic_increments.increment();
        return this.sendRpcToRegion(request).addCallbacks(micv_done, Callback.PASSTHROUGH);
    }

    public Deferred<Long> bufferAtomicIncrement(AtomicIncrementRequest request) {
        long value = request.getAmount();
        if (!BufferedIncrement.Amount.checkOverflow(value) || this.flush_interval == 0) {
            return this.atomicIncrement(request);
        }
        BufferedIncrement incr = new BufferedIncrement(request.table(), request.key(), request.family(), request.qualifier());
        while (true) {
            BufferedIncrement.Amount amount;
            try {
                amount = (BufferedIncrement.Amount)this.increment_buffer.getUnchecked((Object)incr);
            }
            catch (NullPointerException e) {
                this.setupIncrementCoalescing();
                amount = (BufferedIncrement.Amount)this.increment_buffer.getUnchecked((Object)incr);
            }
            if (amount.update(value)) {
                Deferred deferred = new Deferred();
                amount.deferred.chain(deferred);
                return deferred;
            }
            this.increment_buffer.refresh((Object)incr);
        }
    }

    public Deferred<Map<byte[], Long>> bufferMultiColumnAtomicIncrement(MultiColumnAtomicIncrementRequest request) {
        long[] values;
        if (this.flush_interval == 0) {
            return this.atomicIncrement(request);
        }
        for (long value : values = request.getAmounts()) {
            if (BufferedIncrement.Amount.checkOverflow(value)) continue;
            return this.atomicIncrement(request);
        }
        BufferedMultiColumnIncrement incr = new BufferedMultiColumnIncrement(request.table(), request.key(), request.family(), request.qualifiers());
        while (true) {
            BufferedMultiColumnIncrement.Amounts amounts;
            try {
                amounts = (BufferedMultiColumnIncrement.Amounts)this.multi_column_increment_buffer.getUnchecked((Object)incr);
            }
            catch (NullPointerException e) {
                this.setupMultiColumnIncrementCoalescing();
                amounts = (BufferedMultiColumnIncrement.Amounts)this.multi_column_increment_buffer.getUnchecked((Object)incr);
            }
            if (amounts.update(values)) {
                Deferred deferred = new Deferred();
                amounts.deferred.chain(deferred);
                return deferred;
            }
            this.multi_column_increment_buffer.refresh((Object)incr);
        }
    }

    private synchronized void setupIncrementCoalescing() {
        if (this.increment_buffer != null) {
            return;
        }
        this.makeIncrementBuffer();
        short interval = this.flush_interval;
        final class FlushBufferedIncrementsTimer
        implements TimerTask {
            FlushBufferedIncrementsTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout timeout) {
                try {
                    HBaseClient.flushBufferedIncrements((LoadingCache<BufferedIncrement, BufferedIncrement.Amount>)HBaseClient.this.increment_buffer);
                }
                catch (Throwable throwable) {
                    short interval = HBaseClient.this.flush_interval;
                    HBaseClient.this.newTimeout(this, interval > 0 ? (long)interval : 100L);
                    throw throwable;
                }
                short interval = HBaseClient.this.flush_interval;
                HBaseClient.this.newTimeout(this, interval > 0 ? (long)interval : 100L);
            }
        }
        this.timer.newTimeout((TimerTask)new FlushBufferedIncrementsTimer(), interval > 0 ? (long)interval : 1L, TimeUnit.MILLISECONDS);
    }

    private synchronized void setupMultiColumnIncrementCoalescing() {
        if (this.multi_column_increment_buffer != null) {
            return;
        }
        this.makeMultiColumnIncrementBuffer();
        short interval = this.flush_interval;
        final class FlushBufferedMultiColumnIncrementsTimer
        implements TimerTask {
            FlushBufferedMultiColumnIncrementsTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout timeout) {
                try {
                    HBaseClient.flushBufferedMultiColumnIncrements((LoadingCache<BufferedMultiColumnIncrement, BufferedMultiColumnIncrement.Amounts>)HBaseClient.this.multi_column_increment_buffer);
                }
                catch (Throwable throwable) {
                    short interval = HBaseClient.this.flush_interval;
                    HBaseClient.this.newTimeout(this, interval > 0 ? (long)interval : 100L);
                    throw throwable;
                }
                short interval = HBaseClient.this.flush_interval;
                HBaseClient.this.newTimeout(this, interval > 0 ? (long)interval : 100L);
            }
        }
        this.timer.newTimeout((TimerTask)new FlushBufferedMultiColumnIncrementsTimer(), interval > 0 ? (long)interval : 1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushBufferedIncrements(LoadingCache<BufferedIncrement, BufferedIncrement.Amount> increment_buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing " + increment_buffer.size() + " buffered increments");
        }
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> loadingCache = increment_buffer;
        synchronized (loadingCache) {
            increment_buffer.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushBufferedMultiColumnIncrements(LoadingCache<BufferedMultiColumnIncrement, BufferedMultiColumnIncrement.Amounts> multicolumn_increment_buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing " + multicolumn_increment_buffer.size() + " buffered multi-column increments");
        }
        LoadingCache<BufferedMultiColumnIncrement, BufferedMultiColumnIncrement.Amounts> loadingCache = multicolumn_increment_buffer;
        synchronized (loadingCache) {
            multicolumn_increment_buffer.invalidateAll();
        }
    }

    private void makeIncrementBuffer() {
        int size = this.increment_buffer_size;
        this.increment_buffer = BufferedIncrement.newCache(this, size, this.increment_buffer_durable);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created increment buffer of " + size + " entries");
        }
    }

    private void makeMultiColumnIncrementBuffer() {
        int size = this.increment_buffer_size;
        this.multi_column_increment_buffer = BufferedMultiColumnIncrement.newCache(this, size);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created multi column increment buffer of " + size + " entries");
        }
    }

    public Deferred<Long> atomicIncrement(AtomicIncrementRequest request, boolean durable) {
        request.setDurable(durable);
        return this.atomicIncrement(request);
    }

    public Deferred<Object> put(PutRequest request) {
        this.num_puts.increment();
        return this.sendRpcToRegion(request);
    }

    public Deferred<Object> append(AppendRequest request) {
        this.num_appends.increment();
        return this.sendRpcToRegion(request).addCallback((Callback)APPEND_CB);
    }

    public Deferred<Boolean> compareAndSet(PutRequest edit, byte[] expected) {
        return this.sendRpcToRegion(new CompareAndSetRequest(edit, expected)).addCallback((Callback)CAS_CB);
    }

    public Deferred<Boolean> compareAndSet(PutRequest edit, String expected) {
        return this.compareAndSet(edit, expected.getBytes());
    }

    public Deferred<Boolean> atomicCreate(PutRequest edit) {
        return this.compareAndSet(edit, EMPTY_ARRAY);
    }

    public Deferred<RowLock> lockRow(final RowLockRequest request) {
        this.num_row_locks.increment();
        return this.sendRpcToRegion(request).addCallbacks((Callback)new Callback<RowLock, Object>(){

            public RowLock call(Object response) {
                if (response instanceof Long) {
                    return new RowLock(request.getRegion().name(), (Long)response);
                }
                throw new InvalidResponseException(Long.class, response);
            }

            public String toString() {
                return "type lockRow response";
            }
        }, Callback.PASSTHROUGH);
    }

    public Deferred<Object> unlockRow(RowLock lock) {
        byte[] region_name = lock.region();
        RegionInfo region = this.regions_cache.get(region_name);
        if (HBaseClient.knownToBeNSREd(region)) {
            return Deferred.fromResult(null);
        }
        RegionClient client = this.clientFor(region);
        if (client == null) {
            LOG.warn("Cannot release " + lock + ", no connection open for " + Bytes.pretty(region_name));
            return Deferred.fromResult(null);
        }
        RowLockRequest.ReleaseRequest release = new RowLockRequest.ReleaseRequest(lock, region);
        release.setRegion(region);
        Deferred<Object> d = release.getDeferred();
        client.sendRpc(release);
        return d;
    }

    public Deferred<Object> delete(DeleteRequest request) {
        this.num_deletes.increment();
        return this.sendRpcToRegion(request);
    }

    public Deferred<Object> prefetchMeta(String table) {
        return this.prefetchMeta(table.getBytes(), EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public Deferred<Object> prefetchMeta(String table, String start, String stop) {
        return this.prefetchMeta(table.getBytes(), start.getBytes(), stop.getBytes());
    }

    public Deferred<Object> prefetchMeta(byte[] table) {
        return this.prefetchMeta(table, EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public Deferred<Object> prefetchMeta(byte[] table, byte[] start, byte[] stop) {
        return this.findTableRegions(table, start, stop, true, false);
    }

    private Deferred<Object> findTableRegions(final byte[] table, final byte[] start, final byte[] stop, final boolean cache, final boolean return_locations) {
        byte[] meta_stop;
        if (Bytes.equals(table, HBASE96_META) || Bytes.equals(table, META) || Bytes.equals(table, ROOT) || Bytes.equals(table, HBASE98_ROOT)) {
            return Deferred.fromResult(null);
        }
        byte[] meta_start = HBaseClient.createRegionSearchKey(table, start);
        meta_start[meta_start.length - 1] = 0;
        if (stop.length == 0) {
            meta_stop = HBaseClient.createRegionSearchKey(table, stop);
            meta_stop[table.length] = 0;
            meta_stop[meta_stop.length - 1] = 44;
        } else {
            meta_stop = HBaseClient.createRegionSearchKey(table, stop);
        }
        if (this.rootregion == null) {
            class Retry
            implements Callback<Object, Object> {
                Retry() {
                }

                public Object call(Object unused) {
                    return HBaseClient.this.findTableRegions(table, start, stop, cache, return_locations);
                }

                public String toString() {
                    return "retry (" + Bytes.pretty(table) + ", " + Bytes.pretty(start) + ", " + Bytes.pretty(stop) + ")";
                }
            }
            return this.ensureTableExists(table).addCallback((Callback)new Retry());
        }
        final ArrayList regions = return_locations ? new ArrayList() : null;
        final Scanner meta_scanner = this.newScanner(this.has_root && !this.split_meta ? META : HBASE96_META);
        meta_scanner.setStartKey(meta_start);
        meta_scanner.setStopKey(meta_stop);
        class MetaScanner
        implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
            MetaScanner() {
            }

            public Object call(ArrayList<ArrayList<KeyValue>> results) {
                if (results != null && !results.isEmpty()) {
                    for (ArrayList<KeyValue> row : results) {
                        RegionLocation region_location;
                        if (return_locations && (region_location = HBaseClient.this.toRegionLocation(row)) != null) {
                            regions.add(region_location);
                        }
                        if (!cache) continue;
                        HBaseClient.this.discoverRegion(row);
                    }
                    return meta_scanner.nextRows().addCallback((Callback)this);
                }
                return regions;
            }

            public String toString() {
                return "MetaScanner scanner=" + meta_scanner;
            }
        }
        return meta_scanner.nextRows().addCallback((Callback)new MetaScanner());
    }

    Deferred<Object> sendRpcToRegion(final HBaseRpc request) {
        if (this.cannotRetryRequest(request)) {
            return HBaseClient.tooManyAttempts(request, null);
        }
        request.attempt = (byte)(request.attempt + 1);
        byte[] table = request.table;
        byte[] key = request.key;
        RegionInfo region = this.getRegion(table, key);
        if (region != null) {
            if (HBaseClient.knownToBeNSREd(region)) {
                NotServingRegionException nsre = new NotServingRegionException("Region known to be unavailable", request);
                Deferred<Object> d = request.getDeferred();
                this.handleNSRE(request, region.name(), nsre);
                return d;
            }
            RegionClient client = this.clientFor(region);
            if (client != null && client.isAlive()) {
                request.setRegion(region);
                Deferred<Object> d = request.getDeferred();
                client.sendRpc(request);
                return d;
            }
        }
        final class RetryRpc
        implements Callback<Deferred<Object>, Object> {
            RetryRpc() {
            }

            public Deferred<Object> call(Object arg) {
                if (arg instanceof NonRecoverableException) {
                    HBaseException e = (NonRecoverableException)arg;
                    if (e instanceof HasFailedRpcException && ((HasFailedRpcException)((Object)e)).getFailedRpc() != request) {
                        e = ((HBaseException)e).make(e, request);
                    }
                    request.callback(e);
                    return Deferred.fromError((Exception)e);
                }
                return HBaseClient.this.sendRpcToRegion(request);
            }

            public String toString() {
                return "retry RPC";
            }
        }
        return this.locateRegion(request, table, key).addBothDeferring((Callback)new RetryRpc());
    }

    @Deprecated
    public long rootLookupCount() {
        return this.root_lookups.get();
    }

    @Deprecated
    public long uncontendedMetaLookupCount() {
        return this.meta_lookups_with_permit.get();
    }

    @Deprecated
    public long contendedMetaLookupCount() {
        return this.meta_lookups_wo_permit.get();
    }

    boolean cannotRetryRequest(HBaseRpc rpc) {
        return rpc.attempt > this.config.getInt("hbase.client.retries.number");
    }

    static Deferred<Object> tooManyAttempts(HBaseRpc request, HBaseException cause) {
        NonRecoverableException e = new NonRecoverableException("Too many attempts: " + request, cause);
        request.callback(e);
        return Deferred.fromError((Exception)e);
    }

    private RegionLocation toRegionLocation(ArrayList<KeyValue> meta_row) {
        if (meta_row.isEmpty()) {
            throw new TableNotFoundException();
        }
        String host = null;
        int port = -1;
        RegionInfo region = null;
        byte[] start_key = null;
        for (KeyValue kv : meta_row) {
            int colon;
            byte[] qualifier = kv.qualifier();
            if (Arrays.equals(REGIONINFO, qualifier)) {
                byte[][] tmp = new byte[1][];
                region = RegionInfo.fromKeyValue(kv, tmp);
                start_key = tmp[0];
                continue;
            }
            if (!Arrays.equals(SERVER, qualifier) || kv.value() == EMPTY_ARRAY) continue;
            byte[] hostport = kv.value();
            for (colon = hostport.length - 1; colon > 0 && hostport[colon] != 58; --colon) {
            }
            if (colon == 0) {
                throw BrokenMetaException.badKV(region, "an `info:server' cell doesn't contain `:' to separate the `host:port'" + Bytes.pretty(hostport), kv);
            }
            host = HBaseClient.getIP(new String(hostport, 0, colon));
            try {
                port = HBaseClient.parsePortNumber(new String(hostport, colon + 1, hostport.length - colon - 1));
            }
            catch (NumberFormatException e) {
                throw BrokenMetaException.badKV(region, "an `info:server' cell contains an invalid port: " + e.getMessage() + " in " + Bytes.pretty(hostport), kv);
            }
        }
        if (start_key == null) {
            throw new BrokenMetaException(null, "It didn't contain any `info:regioninfo' cell:  " + meta_row);
        }
        return new RegionLocation(region, start_key, host, port);
    }

    public Deferred<List<RegionLocation>> locateRegions(String table) {
        return this.locateRegions(table.getBytes());
    }

    public Deferred<List<RegionLocation>> locateRegions(byte[] table) {
        class TypeCB
        implements Callback<Deferred<List<RegionLocation>>, Object> {
            TypeCB() {
            }

            public Deferred<List<RegionLocation>> call(Object results) throws Exception {
                if (results == null) {
                    return Deferred.fromResult(null);
                }
                if (results instanceof Exception) {
                    return Deferred.fromError((Exception)((Exception)results));
                }
                return Deferred.fromResult((Object)((List)results));
            }

            public String toString() {
                return "locateRegions type converter CB";
            }
        }
        return this.findTableRegions(table, EMPTY_ARRAY, EMPTY_ARRAY, false, true).addCallbackDeferring((Callback)new TypeCB());
    }

    HashedWheelTimer getRpcTimeoutTimer() {
        return this.rpc_timeout_timer;
    }

    Deferred<Object> locateRegionClosestBeforeKey(HBaseRpc request, byte[] table, byte[] key) {
        return this.locateRegion(request, table, key, true, true);
    }

    private Deferred<Object> locateRegion(HBaseRpc request, byte[] table, byte[] key) {
        return this.locateRegion(request, table, key, false, false);
    }

    private Deferred<Object> locateRegion(final HBaseRpc request, final byte[] table, final byte[] key, final boolean closest_before, final boolean return_location) {
        RegionClient rootregion;
        byte[] root_region_name;
        byte[] root_table_name;
        byte[] meta_name;
        RegionInfo meta_region;
        byte[] meta_key;
        boolean is_meta = Bytes.equals(table, META) || Bytes.equals(table, HBASE96_META);
        boolean is_root = !is_meta && (Bytes.equals(table, ROOT) || Bytes.equals(table, HBASE98_ROOT));
        byte[] byArray = meta_key = is_root ? null : HBaseClient.createRegionSearchKey(table, key, closest_before);
        if (this.has_root) {
            meta_region = is_meta || is_root ? null : this.getRegion(this.split_meta ? HBASE96_META : META, meta_key);
            byte[] byArray2 = meta_name = this.split_meta ? HBASE96_META : META;
            if (this.split_meta) {
                root_table_name = HBASE98_ROOT;
                root_region_name = HBASE98_ROOT_REGION;
            } else {
                root_table_name = ROOT;
                root_region_name = ROOT_REGION;
            }
        } else {
            meta_region = META_REGION;
            meta_name = HBASE96_META;
            root_table_name = null;
            root_region_name = null;
        }
        if (meta_region != null) {
            RegionClient client;
            RegionClient regionClient = client = this.has_root ? this.region2client.get(meta_region) : this.rootregion;
            if (client != null && client.isAlive()) {
                boolean has_permit = client.acquireMetaLookupPermit();
                if (!has_permit && this.getRegion(table, key) != null) {
                    return Deferred.fromResult(null);
                }
                Deferred d = null;
                try {
                    class ErrorCB
                    implements Callback<Deferred<Object>, Exception> {
                        ErrorCB() {
                        }

                        public Deferred<Object> call(Exception ex) throws Exception {
                            Throwable cause = ex;
                            if (ex instanceof DeferredGroupException) {
                                cause = ((DeferredGroupException)ex).getCause();
                            }
                            if (cause instanceof UnknownProtocolException) {
                                LOG.info("HBase may be running version 2.0 or newer. Trying to search meta via scan instead of gets.");
                                HBaseClient.this.scan_meta = true;
                                return HBaseClient.this.locateRegion(request, table, key, closest_before, return_location);
                            }
                            throw ex;
                        }
                    }
                    d = return_location ? (this.scan_meta ? this.scanMeta(client, meta_region, meta_name, meta_key, INFO).addCallback((Callback)this.meta_lookup_done_return_location) : client.getClosestRowBefore(meta_region, meta_name, meta_key, INFO).addCallback((Callback)this.meta_lookup_done_return_location).addErrback((Callback)new ErrorCB())) : (this.scan_meta ? this.scanMeta(client, meta_region, meta_name, meta_key, INFO).addCallback((Callback)this.meta_lookup_done) : client.getClosestRowBefore(meta_region, meta_name, meta_key, INFO).addCallback((Callback)this.meta_lookup_done).addErrback((Callback)new ErrorCB()));
                }
                catch (RuntimeException e) {
                    LOG.error("Unexpected exception while performing meta lookup", (Throwable)e);
                    if (has_permit) {
                        client.releaseMetaLookupPermit();
                    }
                    throw e;
                }
                if (has_permit) {
                    final class ReleaseMetaLookupPermit
                    implements Callback<Object, Object> {
                        ReleaseMetaLookupPermit() {
                        }

                        public Object call(Object arg) {
                            client.releaseMetaLookupPermit();
                            return arg;
                        }

                        public String toString() {
                            return "release meta table lookup permit";
                        }
                    }
                    d.addBoth((Callback)new ReleaseMetaLookupPermit());
                    this.meta_lookups_with_permit.increment();
                } else {
                    this.meta_lookups_wo_permit.increment();
                }
                return d.addErrback(this.newLocateRegionErrback(request, table, key, closest_before, return_location));
            }
        }
        if ((rootregion = this.rootregion) == null || !rootregion.isAlive()) {
            return this.zkclient.getDeferredRoot();
        }
        if (is_root || root_table_name == null) {
            return Deferred.fromResult(null);
        }
        byte[] root_key = HBaseClient.createRegionSearchKey(meta_name, meta_key);
        RegionInfo root_region = new RegionInfo(root_table_name, root_region_name, EMPTY_ARRAY);
        this.root_lookups.increment();
        if (this.scan_meta) {
            return this.scanMeta(rootregion, root_region, root_table_name, root_key, INFO).addCallback((Callback)this.root_lookup_done).addErrback(this.newLocateRegionErrback(request, table, key, closest_before, return_location));
        }
        return rootregion.getClosestRowBefore(root_region, root_table_name, root_key, INFO).addCallback((Callback)this.root_lookup_done).addErrback(this.newLocateRegionErrback(request, table, key, closest_before, return_location));
    }

    Deferred<ArrayList<KeyValue>> scanMeta(RegionClient client, RegionInfo region, byte[] table, byte[] row, byte[] family) {
        final Scanner scanner = this.newScanner(table);
        scanner.setReversed(true);
        scanner.setMaxNumRows(1);
        scanner.setStartKey(row);
        scanner.setFamily(family);
        scanner.setRegionName(region);
        final Deferred deferred = new Deferred();
        HBaseRpc open_request = scanner.getOpenRequestForReverseScan(row);
        open_request.region = region;
        class MetaScanCB
        implements Callback<Void, ArrayList<ArrayList<KeyValue>>> {
            MetaScanCB() {
            }

            public Void call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                ArrayList row = rows == null || rows.isEmpty() ? new ArrayList(0) : rows.get(0);
                scanner.close();
                deferred.callback(row);
                return null;
            }

            public String toString() {
                return "scanMeta.MetaScanCB";
            }
        }
        class ErrorCB
        implements Callback<Object, Exception> {
            ErrorCB() {
            }

            public Object call(Exception ex) throws Exception {
                scanner.close();
                deferred.callback((Object)ex);
                return null;
            }

            public String toString() {
                return "scanMeta.ErrorCB";
            }
        }
        open_request.getDeferred().addCallbackDeferring(scanner.opened_scanner).addCallbacks((Callback)new MetaScanCB(), (Callback)new ErrorCB());
        client.sendRpc(open_request);
        return deferred;
    }

    private Callback<Object, Exception> newLocateRegionErrback(HBaseRpc request, byte[] table, byte[] key) {
        return this.newLocateRegionErrback(request, table, key, false, false);
    }

    private Callback<Object, Exception> newLocateRegionErrback(final HBaseRpc request, final byte[] table, final byte[] key, final boolean closest_before, final boolean return_location) {
        return new Callback<Object, Exception>(){

            public Object call(Exception e) {
                if (e instanceof TableNotFoundException) {
                    return new TableNotFoundException(table);
                }
                if (e instanceof RecoverableException) {
                    if (HBaseClient.this.cannotRetryRequest(request)) {
                        return HBaseClient.tooManyAttempts(request, null);
                    }
                    request.attempt = (byte)(request.attempt + 1);
                    return HBaseClient.this.locateRegion(request, table, key, closest_before, return_location);
                }
                return e;
            }

            public String toString() {
                return "locateRegion errback";
            }
        };
    }

    static byte[] createRegionSearchKey(byte[] table, byte[] key) {
        return HBaseClient.createRegionSearchKey(table, key, false);
    }

    static byte[] createRegionSearchKey(byte[] table, byte[] key, boolean closest_before) {
        byte[] meta_key = new byte[table.length + key.length + 3];
        System.arraycopy(table, 0, meta_key, 0, table.length);
        meta_key[table.length] = 44;
        System.arraycopy(key, 0, meta_key, table.length + 1, key.length);
        meta_key[meta_key.length - 2] = 44;
        meta_key[meta_key.length - 1] = closest_before ? 47 : 58;
        return meta_key;
    }

    RegionInfo getRegion(byte[] table, byte[] key) {
        byte[] region_name;
        Map.Entry<byte[], RegionInfo> entry;
        if (this.has_root) {
            if (Bytes.equals(table, HBASE98_ROOT)) {
                return new RegionInfo(HBASE98_ROOT, HBASE98_ROOT_REGION, EMPTY_ARRAY);
            }
            if (Bytes.equals(table, ROOT)) {
                return new RegionInfo(ROOT, ROOT_REGION, EMPTY_ARRAY);
            }
        } else if (Bytes.equals(table, HBASE96_META)) {
            return META_REGION;
        }
        if ((entry = this.regions_cache.floorEntry(region_name = HBaseClient.createRegionSearchKey(table, key))) == null) {
            return null;
        }
        if (!HBaseClient.isCacheKeyForTable(table, entry.getKey())) {
            return null;
        }
        region_name = null;
        RegionInfo region = entry.getValue();
        entry = null;
        byte[] stop_key = region.stopKey();
        if (stop_key != EMPTY_ARRAY && Bytes.memcmp(key, stop_key) >= 0) {
            return null;
        }
        return region;
    }

    private static boolean isCacheKeyForTable(byte[] table, byte[] cache_key) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == cache_key[i]) continue;
            return false;
        }
        return cache_key[table.length] == 44;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegionClient discoverRegion(ArrayList<KeyValue> meta_row) {
        int nregions;
        ArrayList<RegionInfo> regions;
        RegionInfo oldregion;
        RegionClient oldclient;
        if (meta_row.isEmpty()) {
            throw new TableNotFoundException();
        }
        String host = null;
        int port = -42;
        RegionInfo region = null;
        byte[] start_key = null;
        for (KeyValue kv : meta_row) {
            int colon;
            byte[] qualifier = kv.qualifier();
            if (Arrays.equals(REGIONINFO, qualifier)) {
                byte[][] tmp = new byte[1][];
                region = RegionInfo.fromKeyValue(kv, tmp);
                if (HBaseClient.knownToBeNSREd(region)) {
                    this.invalidateRegionCache(region.name(), true, "has marked it as split.");
                    return null;
                }
                start_key = tmp[0];
                continue;
            }
            if (!Arrays.equals(SERVER, qualifier) || kv.value() == EMPTY_ARRAY) continue;
            byte[] hostport = kv.value();
            for (colon = hostport.length - 1; colon > 0 && hostport[colon] != 58; --colon) {
            }
            if (colon == 0) {
                throw BrokenMetaException.badKV(region, "an `info:server' cell doesn't contain `:' to separate the `host:port'" + Bytes.pretty(hostport), kv);
            }
            host = HBaseClient.getIP(new String(hostport, 0, colon));
            try {
                port = HBaseClient.parsePortNumber(new String(hostport, colon + 1, hostport.length - colon - 1));
            }
            catch (NumberFormatException e) {
                throw BrokenMetaException.badKV(region, "an `info:server' cell contains an invalid port: " + e.getMessage() + " in " + Bytes.pretty(hostport), kv);
            }
        }
        if (start_key == null) {
            throw new BrokenMetaException("It didn't contain any `info:regioninfo' cell:  " + meta_row);
        }
        byte[] region_name = region.name();
        if (host == null) {
            this.invalidateRegionCache(region_name, true, "no longer has it assigned.");
            return null;
        }
        RegionClient client = this.newClient(host, port);
        if (client == (oldclient = this.region2client.put(region, client))) {
            return client;
        }
        RegionClient regionClient = client;
        synchronized (regionClient) {
            oldregion = this.regions_cache.put(region_name, region);
            regions = this.client2regions.get((Object)client);
            if (regions != null) {
                ArrayList<RegionInfo> arrayList = regions;
                synchronized (arrayList) {
                    regions.add(region);
                    nregions = regions.size();
                }
            } else {
                nregions = 0;
            }
        }
        if (nregions == 0 || regions != this.client2regions.get((Object)client)) {
            return null;
        }
        LOG.info((oldclient == null ? "Added" : "Replaced") + " client for" + " region " + region + ", which was " + (oldregion == null ? "added to" : "updated in") + " the" + " regions cache.  Now we know that " + (Object)((Object)client) + " is hosting " + nregions + " region" + (nregions > 1 ? Character.valueOf('s') : "") + '.');
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateRegionCache(byte[] region_name, boolean mark_as_nsred, String reason) {
        if (region_name == META_REGION_NAME && !this.has_root || region_name == ROOT_REGION || region_name == HBASE98_ROOT_REGION) {
            if (reason != null) {
                LOG.info("Invalidated cache for " + (this.has_root ? (region_name == ROOT_REGION ? new String(ROOT_REGION) : new String(HBASE98_ROOT_REGION)) : (this.split_meta ? new String(HBASE96_META) : new String(META))) + " as " + (Object)((Object)this.rootregion) + ' ' + reason);
            }
            this.rootregion = null;
            return;
        }
        RegionInfo oldregion = mark_as_nsred ? this.regions_cache.put(region_name, new RegionInfo(EMPTY_ARRAY, region_name, EMPTY_ARRAY)) : this.regions_cache.remove(region_name);
        RegionInfo region = oldregion != null ? oldregion : new RegionInfo(EMPTY_ARRAY, region_name, EMPTY_ARRAY);
        RegionClient client = this.region2client.remove(region);
        if (oldregion != null && !Bytes.equals(oldregion.name(), region_name)) {
            LOG.warn("Oops, invalidated the wrong regions cache entry.  Meant to remove " + Bytes.pretty(region_name) + " but instead removed " + oldregion);
        }
        if (client == null) {
            return;
        }
        ArrayList<RegionInfo> regions = this.client2regions.get((Object)client);
        if (regions != null) {
            ArrayList<RegionInfo> arrayList = regions;
            synchronized (arrayList) {
                regions.remove(region);
            }
        }
        if (reason != null) {
            LOG.info("Invalidated cache for " + region + " as " + (Object)((Object)client) + ' ' + reason);
        }
    }

    private static boolean knownToBeNSREd(RegionInfo region) {
        return region.table() == EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNSRE(HBaseRpc rpc, final byte[] region_name, RecoverableException e) {
        this.num_nsre_rpcs.increment();
        if (rpc.isProbe()) {
            rpc.setSuspendedProbe(true);
        }
        boolean can_retry_rpc = !this.cannotRetryRequest(rpc);
        boolean known_nsre = true;
        ArrayList<HBaseRpc> nsred_rpcs = this.got_nsre.get(region_name);
        HBaseRpc exists_rpc = null;
        if (nsred_rpcs == null) {
            ArrayList<HBaseRpc> newlist = new ArrayList<HBaseRpc>(64);
            exists_rpc = GetRequest.exists(rpc.table, HBaseClient.probeKey(rpc.key));
            newlist.add(exists_rpc);
            if (can_retry_rpc) {
                newlist.add(rpc);
            }
            if ((nsred_rpcs = this.got_nsre.putIfAbsent(region_name, newlist)) == null) {
                nsred_rpcs = newlist;
                known_nsre = false;
            }
        }
        if (known_nsre) {
            int size;
            boolean reject = true;
            ArrayList<HBaseRpc> arrayList = nsred_rpcs;
            synchronized (arrayList) {
                size = nsred_rpcs.size();
                if (size == 0) {
                    ArrayList<HBaseRpc> added = this.got_nsre.putIfAbsent(region_name, nsred_rpcs);
                    if (added == null) {
                        exists_rpc = GetRequest.exists(rpc.table, HBaseClient.probeKey(rpc.key));
                        nsred_rpcs.add(exists_rpc);
                        if (can_retry_rpc) {
                            nsred_rpcs.add(rpc);
                        }
                        known_nsre = false;
                    } else {
                        if (can_retry_rpc) {
                            ArrayList<HBaseRpc> arrayList2 = added;
                            synchronized (arrayList2) {
                                if (added.isEmpty()) {
                                    LOG.error("WTF?  Shouldn't happen!  Lost 2 races and found an empty list of NSRE'd RPCs (" + added + ") for " + Bytes.pretty(region_name));
                                    exists_rpc = GetRequest.exists(rpc.table, HBaseClient.probeKey(rpc.key));
                                    added.add(exists_rpc);
                                } else {
                                    exists_rpc = added.get(0);
                                }
                                if (can_retry_rpc) {
                                    added.add(rpc);
                                }
                            }
                        }
                        nsred_rpcs = added;
                    }
                } else {
                    exists_rpc = nsred_rpcs.get(0);
                    if (exists_rpc != rpc) {
                        if (size < this.nsre_high_watermark) {
                            if (size == this.nsre_low_watermark) {
                                nsred_rpcs.add(null);
                            } else if (can_retry_rpc) {
                                reject = false;
                                if (nsred_rpcs.contains(rpc)) {
                                    LOG.debug("Trying to add " + rpc + " twice to NSREd RPC" + " on " + Bytes.pretty(region_name));
                                } else {
                                    nsred_rpcs.add(rpc);
                                }
                            }
                        }
                    } else {
                        reject = false;
                    }
                }
            }
            if (known_nsre && exists_rpc != rpc && !exists_rpc.isSuspendedProbe()) {
                if (size != this.nsre_high_watermark && size % 500 == 0) {
                    String msg = "There are now " + size + " RPCs pending due to NSRE on " + Bytes.pretty(region_name);
                    if (size + 500 < this.nsre_high_watermark) {
                        LOG.info(msg);
                    } else {
                        LOG.warn(msg);
                    }
                }
                if (reject) {
                    rpc.callback(new PleaseThrottleException(size + " RPCs waiting on " + Bytes.pretty(region_name) + " to come back online", e, rpc, exists_rpc.getDeferred()));
                }
                return;
            }
            exists_rpc.setSuspendedProbe(false);
        }
        this.num_nsres.increment();
        this.invalidateRegionCache(region_name, true, (known_nsre ? "still " : "") + "seems to be splitting or closing it.");
        final ArrayList<HBaseRpc> rpcs = nsred_rpcs;
        final HBaseRpc probe = exists_rpc;
        nsred_rpcs = null;
        exists_rpc = null;
        if (known_nsre && probe.attempt > 1) {
            probe.attempt = (byte)(probe.attempt - 1);
        } else if (!can_retry_rpc) {
            rpc.callback(HBaseClient.tooManyAttempts(rpc, e));
        }
        rpc = null;
        final class NSRETimer
        implements TimerTask {
            NSRETimer() {
            }

            public void run(Timeout timeout) {
                if (probe.attempt == 0) {
                    final class RetryNSREd
                    implements Callback<Object, Object> {
                        final /* synthetic */ HBaseRpc val$probe;
                        final /* synthetic */ byte[] val$region_name;
                        final /* synthetic */ ArrayList val$rpcs;

                        RetryNSREd() {
                            this.val$probe = hBaseRpc;
                            this.val$region_name = byArray;
                            this.val$rpcs = arrayList;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object call(Object arg) {
                            ArrayList arrayList;
                            ArrayList removed;
                            if (arg instanceof Exception) {
                                LOG.warn("Probe " + this.val$probe + " failed", (Throwable)((Exception)arg));
                            }
                            if ((removed = (ArrayList)HBaseClient.this.got_nsre.remove(this.val$region_name)) != this.val$rpcs && removed != null) {
                                arrayList = removed;
                                synchronized (arrayList) {
                                    ArrayList arrayList2 = this.val$rpcs;
                                    synchronized (arrayList2) {
                                        LOG.error("WTF?  Impossible!  Removed the wrong list of RPCs from got_nsre.  Was expecting list@" + System.identityHashCode(this.val$rpcs) + " (size=" + this.val$rpcs.size() + "), got list@" + System.identityHashCode(removed) + " (size=" + removed.size() + ')');
                                    }
                                    for (HBaseRpc r : removed) {
                                        if (r == null || r == this.val$probe) continue;
                                        HBaseClient.this.sendRpcToRegion(r);
                                    }
                                    removed.clear();
                                }
                            }
                            removed = null;
                            arrayList = this.val$rpcs;
                            synchronized (arrayList) {
                                if (LOG.isDebugEnabled()) {
                                    if (arg instanceof Exception) {
                                        LOG.debug("Retrying " + this.val$rpcs.size() + " RPCs on NSREd region " + Bytes.pretty(this.val$region_name));
                                    } else {
                                        LOG.debug("Retrying " + this.val$rpcs.size() + " RPCs now that the NSRE on " + Bytes.pretty(this.val$region_name) + " seems to have cleared");
                                    }
                                }
                                ArrayList rpcs_to_replay = new ArrayList(this.val$rpcs);
                                this.val$rpcs.clear();
                                Iterator i = rpcs_to_replay.iterator();
                                if (i.hasNext()) {
                                    HBaseRpc r = (HBaseRpc)i.next();
                                    if (r != this.val$probe) {
                                        LOG.error("WTF?  Impossible!  Expected first == probe but first=" + r + " and probe=" + this.val$probe);
                                        HBaseClient.this.sendRpcToRegion(r);
                                    }
                                    while (i.hasNext()) {
                                        r = (HBaseRpc)i.next();
                                        if (r == null) continue;
                                        HBaseClient.this.sendRpcToRegion(r);
                                    }
                                } else {
                                    LOG.debug("Empty rpcs array=" + rpcs_to_replay + " found by " + this);
                                }
                            }
                            return arg;
                        }

                        public String toString() {
                            return "retry other RPCs NSRE'd on " + Bytes.pretty(this.val$region_name);
                        }
                    }
                    probe.getDeferred().addBoth((Callback)new RetryNSREd(HBaseClient.this, probe, region_name, rpcs));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Done waiting after NSRE on " + Bytes.pretty(region_name) + ", retrying " + probe);
                }
                HBaseClient.this.invalidateRegionCache(region_name, false, null);
                HBaseClient.this.sendRpcToRegion(probe);
            }

            public String toString() {
                return "probe NSRE " + probe;
            }
        }
        this.newTimeout(new NSRETimer(), probe.getRetryDelay());
    }

    private static byte[] probeKey(byte[] key) {
        byte[] testKey = new byte[key.length + 64];
        System.arraycopy(key, 0, testKey, 0, key.length);
        System.arraycopy(PROBE_SUFFIX, 0, testKey, testKey.length - PROBE_SUFFIX.length, PROBE_SUFFIX.length);
        return testKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionClient newClient(String host, int port) {
        RegionClient client;
        String hostport = host + ':' + port;
        SocketChannel chan = null;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            client = this.ip2client.get(hostport);
            if (client != null && client.isAlive()) {
                return client;
            }
            RegionClientPipeline pipeline = new RegionClientPipeline();
            client = pipeline.init();
            chan = this.channel_factory.newChannel((ChannelPipeline)pipeline);
            this.ip2client.put(hostport, client);
        }
        this.client2regions.put(client, new ArrayList());
        this.num_connections_created.increment();
        SocketChannelConfig socket_config = chan.getConfig();
        socket_config.setConnectTimeoutMillis(this.config.getInt("hbase.ipc.client.socket.timeout.connect"));
        socket_config.setTcpNoDelay(this.config.getBoolean("hbase.ipc.client.tcpnodelay"));
        socket_config.setKeepAlive(this.config.getBoolean("hbase.ipc.client.tcpkeepalive"));
        if (this.config.hasProperty("hbase.ipc.client.socket.write.high_watermark")) {
            ((NioChannelConfig)this.config).setWriteBufferHighWaterMark(this.config.getInt("hbase.ipc.client.socket.write.high_watermark"));
        }
        if (this.config.hasProperty("hbase.ipc.client.socket.write.low_watermark")) {
            ((NioChannelConfig)this.config).setWriteBufferLowWaterMark(this.config.getInt("hbase.ipc.client.socket.write.low_watermark"));
        }
        if (this.config.hasProperty("hbase.ipc.client.socket.sendBufferSize")) {
            socket_config.setOption("sendBufferSize", (Object)this.config.getInt("hbase.ipc.client.socket.sendBufferSize"));
        }
        if (this.config.hasProperty("hbase.ipc.client.socket.receiveBufferSize")) {
            socket_config.setOption("receiveBufferSize", (Object)this.config.getInt("hbase.ipc.client.socket.receiveBufferSize"));
        }
        chan.connect((SocketAddress)new InetSocketAddress(host, port));
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress slowSearchClientIP(RegionClient client) {
        int port;
        String hostport = null;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            for (Map.Entry<String, RegionClient> e : this.ip2client.entrySet()) {
                if (e.getValue() != client) continue;
                hostport = e.getKey();
                break;
            }
        }
        if (hostport == null) {
            HashMap<String, RegionClient> copy;
            HashMap<String, RegionClient> i$ = this.ip2client;
            synchronized (i$) {
                copy = new HashMap<String, RegionClient>(this.ip2client);
            }
            LOG.error("WTF?  Should never happen!  Couldn't find " + (Object)((Object)client) + " in " + copy);
            return null;
        }
        LOG.warn("Couldn't connect to the RegionServer @ " + hostport);
        int lastColon = hostport.lastIndexOf(58);
        if (lastColon < 1) {
            LOG.error("WTF?  Should never happen!  No `:' found in " + hostport);
            return null;
        }
        String host = HBaseClient.getIP(hostport.substring(0, lastColon));
        try {
            port = HBaseClient.parsePortNumber(hostport.substring(lastColon + 1, hostport.length()));
        }
        catch (NumberFormatException e) {
            LOG.error("WTF?  Should never happen!  Bad port in " + hostport, (Throwable)e);
            return null;
        }
        return new InetSocketAddress(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientFromCache(RegionClient client, SocketAddress remote) {
        RegionClient old;
        InetAddress addr;
        InetSocketAddress sock;
        ArrayList<RegionInfo> regions;
        if (client == this.rootregion) {
            LOG.info("Lost connection with the " + (this.has_root ? (this.split_meta ? new String(HBASE98_ROOT_REGION) : new String(ROOT)) : (this.split_meta ? new String(HBASE96_META) : new String(META))) + " region");
            this.rootregion = null;
        }
        if ((regions = this.client2regions.remove((Object)client)) != null) {
            RegionInfo[] regions_copy;
            ArrayList<RegionInfo> arrayList = regions;
            synchronized (arrayList) {
                regions_copy = regions.toArray(new RegionInfo[regions.size()]);
                regions = null;
            }
            for (RegionInfo region : regions_copy) {
                RegionClient oldclient;
                byte[] table = region.table();
                byte[] stop_key = region.stopKey();
                byte[] search_key = HBaseClient.createRegionSearchKey(stop_key.length == 0 ? Arrays.copyOf(table, table.length + 1) : table, stop_key);
                Map.Entry<byte[], RegionInfo> entry = this.regions_cache.lowerEntry(search_key);
                if (entry != null && entry.getValue() == region) {
                    this.regions_cache.remove(entry.getKey());
                    LOG.debug("Removed from regions cache: {}", (Object)region);
                }
                if (client == (oldclient = this.region2client.remove(region))) {
                    LOG.debug("Association removed: {} -> {}", (Object)region, (Object)client);
                    continue;
                }
                if (oldclient == null) continue;
                LOG.warn("When handling disconnection of " + (Object)((Object)client) + " and removing " + region + " from region2client" + ", it was found that " + (Object)((Object)oldclient) + " was in fact" + " serving this region");
            }
        }
        if (remote == null) {
            return;
        }
        String hostport = null;
        if (remote instanceof InetSocketAddress) {
            sock = (InetSocketAddress)remote;
            addr = sock.getAddress();
            if (addr == null) {
                LOG.error("WTF?  Unresolved IP for " + remote + ".  This shouldn't happen.");
                return;
            }
        } else {
            LOG.error("WTF?  Found a non-InetSocketAddress remote: " + remote + ".  This shouldn't happen.");
            return;
        }
        hostport = addr.getHostAddress() + ':' + sock.getPort();
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            old = this.ip2client.remove(hostport);
        }
        LOG.debug("Removed from IP cache: {} -> {}", (Object)hostport, (Object)client);
        if (old == null) {
            LOG.warn("When expiring " + (Object)((Object)client) + " from the client cache (host:port=" + hostport + "), it was found that there was no entry" + " corresponding to " + remote + ".  This shouldn't happen.");
        }
    }

    private static String getIP(String host) {
        long start = System.nanoTime();
        try {
            String ip;
            boolean preferV6 = Boolean.valueOf(System.getProperty("java.net.preferIPv6Addresses"));
            if (preferV6) {
                LOG.debug("Trying to get IPv6 address for host: " + host);
                InetAddress ipv6 = null;
                LOG.debug("All resolved IPs for host: " + host + " are: " + Arrays.toString(InetAddress.getAllByName(host)));
                for (InetAddress ia : InetAddress.getAllByName(host)) {
                    if (!(ia instanceof Inet6Address)) continue;
                    ipv6 = ia;
                    break;
                }
                ip = ipv6 != null ? ipv6.getHostAddress() : InetAddress.getByName(host).getHostAddress();
            } else {
                LOG.debug("Trying to get IPv4 address for host: " + host);
                ip = InetAddress.getByName(host).getHostAddress();
            }
            LOG.info("Resolved IP address for host: " + host + " is: " + ip);
            long latency = System.nanoTime() - start;
            if (latency > 500000L && LOG.isDebugEnabled()) {
                LOG.debug("Resolved IP of `" + host + "' to " + ip + " in " + latency + "ns");
            } else if (latency >= 3000000L) {
                LOG.warn("Slow DNS lookup!  Resolved IP of `" + host + "' to " + ip + " in " + latency + "ns");
            }
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve the IP of `" + host + "' in " + (System.nanoTime() - start) + "ns");
            return null;
        }
    }

    private static int parsePortNumber(String portnum) throws NumberFormatException {
        int port = Integer.parseInt(portnum);
        if (port <= 0 || port > 65535) {
            throw new NumberFormatException(port == 0 ? "port is zero" : (port < 0 ? "port is negative: " : "port is too large: ") + port);
        }
        return port;
    }

    protected final class ZKClient
    implements Watcher {
        private final String quorum_spec;
        private final String base_path;
        private ZooKeeper zk;
        private ArrayList<Deferred<Object>> deferred_rootregion;

        public ZKClient(String quorum_spec, String base_path) {
            this.quorum_spec = quorum_spec;
            this.base_path = base_path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Deferred<Object> getDeferredRoot() {
            Deferred d = new Deferred();
            ZKClient zKClient = this;
            synchronized (zKClient) {
                try {
                    this.connectZK();
                    if (this.deferred_rootregion == null) {
                        LOG.info("Need to find the " + (HBaseClient.this.has_root ? (HBaseClient.this.split_meta ? new String(HBASE98_ROOT_REGION) : new String(ROOT)) : (HBaseClient.this.split_meta ? new String(HBASE96_META) : new String(META))) + " region");
                        this.deferred_rootregion = new ArrayList();
                    }
                    this.deferred_rootregion.add((Deferred<Object>)d);
                }
                catch (NonRecoverableException e) {
                    LOG.error(e.getMessage(), e.getCause());
                    d.callback((Object)e);
                }
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Deferred<Object> getDeferredRootIfBeingLookedUp() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.deferred_rootregion == null) {
                    return null;
                }
                Deferred d = new Deferred();
                this.deferred_rootregion.add((Deferred<Object>)d);
                return d;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<Deferred<Object>> atomicGetAndRemoveWaiters() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                ArrayList<Deferred<Object>> arrayList;
                try {
                    arrayList = this.deferred_rootregion;
                    this.deferred_rootregion = null;
                }
                catch (Throwable throwable) {
                    this.deferred_rootregion = null;
                    throw throwable;
                }
                return arrayList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            LOG.debug("Got ZooKeeper event: {}", (Object)event);
            try {
                switch (event.getState()) {
                    case SyncConnected: {
                        this.getRootRegion();
                        break;
                    }
                    default: {
                        this.disconnectZK();
                        ZKClient zKClient = this;
                        synchronized (zKClient) {
                            if (this.deferred_rootregion != null) {
                                LOG.warn("No longer connected to ZooKeeper, event=" + event);
                                this.connectZK();
                            }
                        }
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Uncaught exception when handling event " + event, (Throwable)e);
                return;
            }
            LOG.debug("Done handling ZooKeeper event: {}", (Object)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectZK() {
            try {
                ZKClient zKClient = this;
                synchronized (zKClient) {
                    if (this.zk != null) {
                        return;
                    }
                    this.zk = new ZooKeeper(this.quorum_spec, HBaseClient.this.config.getInt("hbase.zookeeper.session.timeout"), (Watcher)this);
                }
            }
            catch (UnknownHostException e) {
                throw new NonRecoverableException("Cannot connect to ZooKeeper, is the quorum specification valid? " + this.quorum_spec, e);
            }
            catch (IOException e) {
                LOG.error("Failed to connect to ZooKeeper", (Throwable)e);
                this.connectZK();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnectZK() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.zk == null) {
                    return;
                }
                try {
                    LOG.debug("Ignore any DEBUG exception from ZooKeeper");
                    long start = System.nanoTime();
                    this.zk.close();
                    LOG.debug("ZooKeeper#close completed in {}ns", (Object)(System.nanoTime() - start));
                }
                catch (InterruptedException e) {
                    LOG.error("Should never happen", (Throwable)e);
                }
                this.zk = null;
            }
        }

        private void retryGetRootRegionLater() {
            HBaseClient.this.newTimeout(new TimerTask(){

                public void run(Timeout timeout) {
                    if (!ZKClient.this.getRootRegion()) {
                        ZKClient.this.connectZK();
                    }
                }
            }, HBaseClient.this.config.getInt("hbase.zookeeper.getroot.retry_delay"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getRootRegion() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.zk != null) {
                    LOG.debug("Finding the ROOT or META region in ZooKeeper");
                    ZKCallback cb = new ZKCallback();
                    this.zk.getData(this.base_path + "/root-region-server", (Watcher)this, (AsyncCallback.DataCallback)cb, null);
                    this.zk.getData(this.base_path + "/meta-region-server", (Watcher)this, (AsyncCallback.DataCallback)cb, null);
                    return true;
                }
            }
            return false;
        }

        final class ZKCallback
        implements AsyncCallback.DataCallback {
            protected static final byte MAGIC = -1;
            private static final byte UNKNOWN = 0;
            private static final byte FOUND = 1;
            private static final byte NOTFOUND = 2;
            private byte found_root;
            private byte found_meta;

            ZKCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                RegionClient client;
                boolean is_root;
                if (path.endsWith("/root-region-server")) {
                    is_root = true;
                } else if (path.endsWith("/meta-region-server")) {
                    is_root = false;
                } else {
                    LOG.error("WTF? We got a callback from ZooKeeper for a znode we did not expect: " + path + " / stat: " + stat + " / data: " + Bytes.pretty(data));
                    ZKClient.this.retryGetRootRegionLater();
                    return;
                }
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    boolean both_znode_failed;
                    if (is_root) {
                        this.found_root = (byte)2;
                        both_znode_failed = this.found_meta == 2;
                    } else {
                        this.found_meta = (byte)2;
                        boolean bl = both_znode_failed = this.found_root == 2;
                    }
                    if (both_znode_failed) {
                        LOG.error("The znode for the -ROOT- region doesn't exist!");
                        ZKClient.this.retryGetRootRegionLater();
                    }
                    return;
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Looks like our ZK session expired or is broken, rc=" + rc + ": " + KeeperException.Code.get((int)rc));
                    ZKClient.this.disconnectZK();
                    ZKClient.this.connectZK();
                    return;
                }
                if (data == null || data.length == 0 || data.length > Short.MAX_VALUE) {
                    LOG.error("The location of the -ROOT- region in ZooKeeper is " + (data == null || data.length == 0 ? "empty" : "too large (" + data.length + " bytes!)"));
                    ZKClient.this.retryGetRootRegionLater();
                    return;
                }
                if (is_root) {
                    this.found_root = 1;
                    client = this.handleRootZnode(data);
                } else {
                    this.found_meta = 1;
                    client = this.handleMetaZnode(data);
                }
                if (client == null) {
                    ZKClient.this.retryGetRootRegionLater();
                    return;
                }
                ArrayList ds = ZKClient.this.atomicGetAndRemoveWaiters();
                if (ds != null) {
                    for (Deferred d : ds) {
                        d.callback((Object)client);
                    }
                }
                ZKClient.this.disconnectZK();
                ZKClient zKClient = ZKClient.this;
                synchronized (zKClient) {
                    if (ZKClient.this.deferred_rootregion != null) {
                        ZKClient.this.connectZK();
                    }
                }
            }

            protected RegionClient handleRootZnode(byte[] data) {
                short portend;
                String host;
                int offset;
                boolean newstyle;
                int firstsep = -1;
                if (data[0] == -1) {
                    newstyle = true;
                    int metadata_length = Bytes.getInt(data, 1);
                    if (metadata_length < 1 || metadata_length > 65000) {
                        LOG.error("Malformed meta-data in " + Bytes.pretty(data) + ", invalid metadata length=" + metadata_length);
                        return null;
                    }
                    offset = (short)(5 + metadata_length);
                } else {
                    newstyle = false;
                    offset = 0;
                }
                short n = (short)data.length;
                block4: for (short i = (short)(offset + 1); i < n; i = (short)(i + 1)) {
                    switch (data[i]) {
                        case 44: {
                            newstyle = true;
                        }
                        case 58: {
                            firstsep = i;
                            break block4;
                        }
                        default: {
                            continue block4;
                        }
                    }
                }
                if (firstsep == -1) {
                    LOG.error("-ROOT- location doesn't contain a separator (':' or ','): " + Bytes.pretty(data));
                    return null;
                }
                if (newstyle) {
                    short i;
                    host = new String(data, offset, firstsep - offset);
                    for (i = (short)(firstsep + 2); i < n && data[i] != 44; i = (short)(i + 1)) {
                    }
                    portend = i;
                } else {
                    host = new String(data, 0, firstsep);
                    portend = n;
                }
                int port = HBaseClient.parsePortNumber(new String(data, firstsep + 1, portend - firstsep - 1));
                String ip = HBaseClient.getIP(host);
                if (ip == null) {
                    LOG.error("Couldn't resolve the IP of the -ROOT- region from " + host + " in \"" + Bytes.pretty(data) + '\"');
                    return null;
                }
                LOG.info("Connecting to -ROOT- region @ " + ip + ':' + port);
                HBaseClient.this.has_root = true;
                RegionClient client = HBaseClient.this.rootregion = HBaseClient.this.newClient(ip, port);
                return client;
            }

            protected RegionClient handleMetaZnode(byte[] data) {
                int port;
                String ip;
                if (data[0] != -1) {
                    LOG.error("Malformed META region meta-data in " + Bytes.pretty(data) + ", invalid leading magic number: " + data[0]);
                    return null;
                }
                int metadata_length = Bytes.getInt(data, 1);
                if (metadata_length < 1 || metadata_length > 65000) {
                    LOG.error("Malformed META region meta-data in " + Bytes.pretty(data) + ", invalid metadata length=" + metadata_length);
                    return null;
                }
                short offset = (short)(5 + metadata_length);
                int pbuf_magic = Bytes.getInt(data, offset);
                if (pbuf_magic != 1346524486) {
                    LOG.error("Malformed META region meta-data in " + Bytes.pretty(data) + ", invalid magic number=" + pbuf_magic);
                    return null;
                }
                offset = (short)(offset + 4);
                try {
                    ZooKeeperPB.MetaRegionServer meta = ((ZooKeeperPB.MetaRegionServer.Builder)ZooKeeperPB.MetaRegionServer.newBuilder().mergeFrom(data, offset, data.length - offset)).build();
                    ip = HBaseClient.getIP(meta.getServer().getHostName());
                    port = meta.getServer().getPort();
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error("Failed to parse the protobuf in " + Bytes.pretty(data), (Throwable)e);
                    return null;
                }
                LOG.info("Connecting to " + (HBaseClient.this.split_meta ? new String(HBASE96_META) : new String(META)) + " region @ " + ip + ':' + port);
                HBaseClient.this.has_root = HBaseClient.this.split_meta;
                RegionClient client = HBaseClient.this.rootregion = HBaseClient.this.newClient(ip, port);
                return client;
            }
        }
    }

    private final class RegionClientIdleStateHandler
    extends IdleStateAwareChannelHandler {
        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
            block3: {
                if (e.getState() == IdleState.ALL_IDLE) {
                    HBaseClient.this.idle_connections_closed.increment();
                    LOG.info("Closing idle connection to HBase region server: " + e.getChannel());
                    try {
                        e.getChannel().close();
                    }
                    catch (Exception ex) {
                        if (ex instanceof ClosedChannelException) break block3;
                        throw ex;
                    }
                }
            }
        }
    }

    private final class RegionClientPipeline
    extends DefaultChannelPipeline {
        private boolean disconnected = false;
        private final ChannelHandler timeout_handler;

        RegionClientPipeline() {
            this.timeout_handler = new IdleStateHandler((Timer)HBaseClient.this.timer, 0, 0, HBaseClient.this.config.getInt("hbase.hbase.ipc.client.connection.idle_timeout"));
        }

        RegionClient init() {
            RegionClient client = new RegionClient(HBaseClient.this);
            super.addLast("idle_handler", this.timeout_handler);
            super.addLast("idle_cleanup", (ChannelHandler)new RegionClientIdleStateHandler());
            super.addLast("handler", (ChannelHandler)client);
            return client;
        }

        public void sendDownstream(ChannelEvent event) {
            if (event instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)event);
            }
            super.sendDownstream(event);
        }

        public void sendUpstream(ChannelEvent event) {
            if (event instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)event);
            }
            super.sendUpstream(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDisconnect(ChannelStateEvent state_event) {
            if (this.disconnected) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel " + state_event.getChannel().toString() + "'s state changed: " + state_event);
            }
            switch (state_event.getState()) {
                case OPEN: {
                    if (state_event.getValue() == Boolean.FALSE) break;
                    return;
                }
                case CONNECTED: {
                    if (state_event.getValue() == null) break;
                    return;
                }
                default: {
                    return;
                }
            }
            LOG.info("Channel " + state_event.getChannel().toString() + " is disconnecting: " + state_event);
            this.disconnected = true;
            try {
                RegionClient client = (RegionClient)super.get(RegionClient.class);
                SocketAddress remote = super.getChannel().getRemoteAddress();
                if (remote == null) {
                    remote = HBaseClient.this.slowSearchClientIP(client);
                }
                RegionClient regionClient = client;
                synchronized (regionClient) {
                    HBaseClient.this.removeClientFromCache(client, remote);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(RegionClientPipeline.class).error("Uncaught exception when handling a disconnection of " + this.getChannel(), (Throwable)e);
            }
        }
    }

    private final class RootCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private RootCB() {
        }

        public Object call(ArrayList<KeyValue> arg) {
            return HBaseClient.this.discoverRegion(arg);
        }

        public String toString() {
            return "locateRegion in ROOT";
        }
    }

    private final class MetaCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private MetaCB() {
        }

        public Object call(ArrayList<KeyValue> arg) {
            return HBaseClient.this.discoverRegion(arg);
        }

        public String toString() {
            return "locateRegion in META";
        }
    }

    private final class MetaWithRegionLocationCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private MetaWithRegionLocationCB() {
        }

        public Object call(ArrayList<KeyValue> arg) {
            HBaseClient.this.discoverRegion(arg);
            return HBaseClient.this.toRegionLocation(arg);
        }

        public String toString() {
            return "locateRegion in META with returning RegionLocation";
        }
    }

    private static final class CompareAndSetCB
    implements Callback<Boolean, Object> {
        private CompareAndSetCB() {
        }

        public Boolean call(Object response) {
            if (response instanceof Boolean) {
                return (Boolean)response;
            }
            throw new InvalidResponseException(Boolean.class, response);
        }

        public String toString() {
            return "type compareAndSet response";
        }
    }

    private static final class AppendCB
    implements Callback<Object, Object> {
        private AppendCB() {
        }

        public Object call(Object response) {
            if (response == null) {
                return null;
            }
            if (response instanceof KeyValue) {
                return (KeyValue)response;
            }
            if (response instanceof MultiAction.MultiActionSuccess) {
                return null;
            }
            throw new InvalidResponseException(KeyValue.class, response);
        }

        public String toString() {
            return "type append response";
        }
    }

    private static final class CustomChannelFactory
    extends NioClientSocketChannelFactory {
        CustomChannelFactory(Executor executor) {
            super(executor, executor);
        }

        public void releaseExternalResources() {
        }
    }
}

