/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import org.hbase.async.HBaseClient;
import org.hbase.async.auth.ClientAuthProvider;

public class SimpleClientAuthProvider
extends ClientAuthProvider {
    public static final String USERNAME_KEY = "hbase.security.simple.username";
    private final String username;

    public SimpleClientAuthProvider(HBaseClient hbase_client) {
        super(hbase_client);
        if (!hbase_client.getConfig().hasProperty(USERNAME_KEY)) {
            throw new IllegalArgumentException("Missing client username");
        }
        this.username = hbase_client.getConfig().getString(USERNAME_KEY);
        if (this.username == null || this.username.isEmpty()) {
            throw new IllegalArgumentException("Missing client username");
        }
    }

    @Override
    public SaslClient newSaslClient(String service_ip, Map<String, String> props) {
        return null;
    }

    @Override
    public String getClientUsername() {
        return this.username;
    }

    @Override
    public byte getAuthMethodCode() {
        return 80;
    }

    @Override
    public Subject getClientSubject() {
        return null;
    }
}

