/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.util;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.flume.util.OrderSelector;
import org.apache.flume.util.SpecificOrderIterator;

public class RandomOrderSelector<T>
extends OrderSelector<T> {
    private Random random = new Random(System.currentTimeMillis());

    public RandomOrderSelector(boolean shouldBackOff) {
        super(shouldBackOff);
    }

    @Override
    public synchronized Iterator<T> createIterator() {
        List<Integer> indexList = this.getIndexList();
        int size = indexList.size();
        int[] indexOrder = new int[size];
        while (indexList.size() != 1) {
            int pick = this.random.nextInt(indexList.size());
            indexOrder[indexList.size() - 1] = indexList.remove(pick);
        }
        indexOrder[0] = indexList.get(0);
        return new SpecificOrderIterator(indexOrder, this.getObjects());
    }
}

