/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Function;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.ParallelIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseAllMetadataTableScan
extends BaseMetadataTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAllMetadataTableScan.class);

    BaseAllMetadataTableScan(Table table, Schema schema, MetadataTableType tableType) {
        super(table, schema, tableType);
    }

    BaseAllMetadataTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
        super(table, schema, tableType, context);
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        throw new UnsupportedOperationException("Cannot select snapshot in table: " + String.valueOf((Object)this.tableType()));
    }

    @Override
    public TableScan useRef(String ref) {
        throw new UnsupportedOperationException("Cannot select ref in table: " + String.valueOf((Object)this.tableType()));
    }

    @Override
    public TableScan asOfTime(long timestampMillis) {
        throw new UnsupportedOperationException("Cannot select snapshot in table: " + String.valueOf((Object)this.tableType()));
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        String metadataTableName = this.table().name() + "." + this.tableType().name().toLowerCase(Locale.ROOT);
        LOG.info("Scanning metadata table {} with filter {}.", (Object)metadataTableName, (Object)ExpressionUtil.toSanitizedString((Expression)this.filter()));
        Listeners.notifyAll((Object)new ScanEvent(metadataTableName, 0L, this.filter(), this.schema()));
        return this.doPlanFiles();
    }

    protected CloseableIterable<ManifestFile> reachableManifests(Function<Snapshot, Iterable<ManifestFile>> toManifests) {
        CloseableIterable closeableIterable;
        Iterable snapshots = this.table().snapshots();
        Iterable manifestIterables = Iterables.transform((Iterable)snapshots, toManifests);
        ParallelIterable iterable = new ParallelIterable(manifestIterables, this.planExecutor());
        try {
            closeableIterable = CloseableIterable.withNoopClose((Iterable)Sets.newHashSet(iterable));
        }
        catch (Throwable throwable) {
            try {
                try {
                    iterable.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close parallel iterable", e);
            }
        }
        iterable.close();
        return closeableIterable;
    }
}

