/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TableRecordReaderImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TableRecordReaderImpl.class);
    private byte[] startRow;
    private byte[] endRow;
    private byte[] lastSuccessfulRow;
    private Filter trrRowFilter;
    private ResultScanner scanner;
    private Table htable;
    private byte[][] trrInputColumns;
    private long timestamp;
    private int rowcount;
    private boolean logScannerActivity = false;
    private int logPerRowCount = 100;

    public void restart(byte[] firstRow) throws IOException {
        Scan currentScan;
        if (this.endRow != null && this.endRow.length > 0) {
            if (this.trrRowFilter != null) {
                Scan scan = new Scan(firstRow, this.endRow);
                TableInputFormat.addColumns(scan, this.trrInputColumns);
                scan.setFilter(this.trrRowFilter);
                scan.setCacheBlocks(false);
                this.scanner = this.htable.getScanner(scan);
                currentScan = scan;
            } else {
                LOG.debug("TIFB.restart, firstRow: " + Bytes.toStringBinary((byte[])firstRow) + ", endRow: " + Bytes.toStringBinary((byte[])this.endRow));
                Scan scan = new Scan(firstRow, this.endRow);
                TableInputFormat.addColumns(scan, this.trrInputColumns);
                this.scanner = this.htable.getScanner(scan);
                currentScan = scan;
            }
        } else {
            LOG.debug("TIFB.restart, firstRow: " + Bytes.toStringBinary((byte[])firstRow) + ", no endRow");
            Scan scan = new Scan(firstRow);
            TableInputFormat.addColumns(scan, this.trrInputColumns);
            scan.setFilter(this.trrRowFilter);
            this.scanner = this.htable.getScanner(scan);
            currentScan = scan;
        }
        if (this.logScannerActivity) {
            LOG.info("Current scan=" + currentScan.toString());
            this.timestamp = EnvironmentEdgeManager.currentTime();
            this.rowcount = 0;
        }
    }

    public void init() throws IOException {
        this.restart(this.startRow);
    }

    byte[] getStartRow() {
        return this.startRow;
    }

    public void setHTable(Table htable) {
        Configuration conf = htable.getConfiguration();
        this.logScannerActivity = conf.getBoolean("hbase.client.log.scanner.activity", false);
        this.logPerRowCount = conf.getInt("hbase.mapreduce.log.scanner.rowcount", 100);
        this.htable = htable;
    }

    public void setInputColumns(byte[][] inputColumns) {
        this.trrInputColumns = inputColumns;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(byte[] endRow) {
        this.endRow = endRow;
    }

    public void setRowFilter(Filter rowFilter) {
        this.trrRowFilter = rowFilter;
    }

    public void close() {
        if (this.scanner != null) {
            this.scanner.close();
        }
        try {
            this.htable.close();
        }
        catch (IOException ioe) {
            LOG.warn("Error closing table", (Throwable)ioe);
        }
    }

    public ImmutableBytesWritable createKey() {
        return new ImmutableBytesWritable();
    }

    public Result createValue() {
        return new Result();
    }

    public long getPos() {
        return 0L;
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
        try {
            Result result;
            try {
                result = this.scanner.next();
                if (this.logScannerActivity) {
                    ++this.rowcount;
                    if (this.rowcount >= this.logPerRowCount) {
                        long now = EnvironmentEdgeManager.currentTime();
                        LOG.info("Mapper took " + (now - this.timestamp) + "ms to process " + this.rowcount + " rows");
                        this.timestamp = now;
                        this.rowcount = 0;
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof DoNotRetryIOException) {
                    throw e;
                }
                LOG.debug("recovered from " + StringUtils.stringifyException((Throwable)e));
                if (this.lastSuccessfulRow == null) {
                    LOG.warn("We are restarting the first next() invocation, if your mapper has restarted a few other times like this then you should consider killing this job and investigate why it's taking so long.");
                }
                if (this.lastSuccessfulRow == null) {
                    this.restart(this.startRow);
                } else {
                    this.restart(this.lastSuccessfulRow);
                    this.scanner.next();
                }
                result = this.scanner.next();
            }
            if (result != null && result.size() > 0) {
                key.set(result.getRow());
                this.lastSuccessfulRow = key.get();
                value.copyFrom(result);
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            if (this.logScannerActivity) {
                long now = EnvironmentEdgeManager.currentTime();
                LOG.info("Mapper took " + (now - this.timestamp) + "ms to process " + this.rowcount + " rows");
                LOG.info(ioe.toString(), (Throwable)ioe);
                String lastRow = this.lastSuccessfulRow == null ? "null" : Bytes.toStringBinary((byte[])this.lastSuccessfulRow);
                LOG.info("lastSuccessfulRow=" + lastRow);
            }
            throw ioe;
        }
    }
}

