/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WrapperAsyncFSOutput
implements AsyncFSOutput {
    private final FSDataOutputStream out;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final ExecutorService executor;
    private volatile long syncedLength = 0L;

    public WrapperAsyncFSOutput(Path file, FSDataOutputStream out) {
        this.out = out;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AsyncFSOutputFlusher-" + file.toString().replace("%", "%%")).build());
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.write(b, off, len);
    }

    @Override
    public void writeInt(int i) {
        this.buffer.writeInt(i);
    }

    @Override
    public void write(ByteBuffer bb) {
        this.buffer.write(bb, bb.position(), bb.remaining());
    }

    @Override
    public int buffered() {
        return this.buffer.size();
    }

    @Override
    public DatanodeInfo[] getPipeline() {
        return new DatanodeInfo[0];
    }

    private void flush0(CompletableFuture<Long> future, ByteArrayOutputStream buffer, boolean sync) {
        try {
            long pos;
            if (buffer.size() > 0) {
                this.out.write(buffer.getBuffer(), 0, buffer.size());
                if (sync) {
                    this.out.hsync();
                } else {
                    this.out.hflush();
                }
            }
            this.syncedLength = pos = this.out.getPos();
            future.complete(pos);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return;
        }
    }

    @Override
    public CompletableFuture<Long> flush(boolean sync) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        ByteArrayOutputStream buffer = this.buffer;
        this.buffer = new ByteArrayOutputStream();
        this.executor.execute(() -> this.flush0(future, buffer, sync));
        return future;
    }

    @Override
    public void recoverAndClose(CancelableProgressable reporter) throws IOException {
        this.executor.shutdown();
        this.out.close();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((this.buffer.size() == 0 ? 1 : 0) != 0, (Object)"should call flush first before calling close");
        this.executor.shutdown();
        this.out.close();
    }

    @Override
    public boolean isBroken() {
        return false;
    }

    @Override
    public long getSyncedLength() {
        return this.syncedLength;
    }
}

