/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.api.exceptions.HelixConflictException;
import org.apache.helix.api.status.ClusterManagementMode;
import org.apache.helix.api.status.ClusterManagementModeRequest;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.model.CloudConfig;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ControllerHistory;
import org.apache.helix.model.CustomizedStateConfig;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.RESTConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.rest.acl.AclRegister;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.server.filters.ClusterAuth;
import org.apache.helix.rest.server.filters.NamespaceAuth;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.rest.server.service.ClusterServiceImpl;
import org.apache.helix.rest.server.service.VirtualTopologyGroupService;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters")
@Api(value="", description="Helix REST Clusters  APIs")
public class ClusterAccessor
extends AbstractHelixResource {
    private static Logger LOG = LoggerFactory.getLogger((String)ClusterAccessor.class.getName());

    @NamespaceAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @ApiOperation(value="Return list of all clusters", notes="Helix REST Cluster Get API")
    public Response getClusters() {
        HelixAdmin helixAdmin = this.getHelixAdmin();
        List clusters = helixAdmin.getClusters();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        dataMap.put(ClusterProperties.clusters.name(), clusters);
        return this.JSONRepresentation(dataMap);
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @ApiOperation(value="Return information for particular cluster", notes="Helix REST Cluster  Get API")
    @Path(value="{clusterId}")
    public Response getClusterInfo(@PathParam(value="clusterId") String clusterId) {
        if (!this.doesClusterExist(clusterId)) {
            return this.notFound();
        }
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        HashMap<String, Object> clusterInfo = new HashMap<String, Object>();
        clusterInfo.put(AbstractResource.Properties.id.name(), clusterId);
        LiveInstance controller = (LiveInstance)dataAccessor.getProperty(keyBuilder.controllerLeader());
        if (controller != null) {
            clusterInfo.put(ClusterProperties.controller.name(), controller.getInstanceName());
        } else {
            clusterInfo.put(ClusterProperties.controller.name(), "No Lead Controller!");
        }
        boolean paused = dataAccessor.getBaseDataAccessor().exists(keyBuilder.pause().getPath(), AccessOption.PERSISTENT);
        clusterInfo.put(ClusterProperties.paused.name(), paused);
        boolean maintenance = this.getHelixAdmin().isInMaintenanceMode(clusterId);
        clusterInfo.put(ClusterProperties.maintenance.name(), maintenance);
        List idealStates = dataAccessor.getChildNames(keyBuilder.idealStates());
        clusterInfo.put(ClusterProperties.resources.name(), idealStates);
        List instances = dataAccessor.getChildNames(keyBuilder.instanceConfigs());
        clusterInfo.put(ClusterProperties.instances.name(), instances);
        List liveInstances = dataAccessor.getChildNames(keyBuilder.liveInstances());
        clusterInfo.put(ClusterProperties.liveInstances.name(), liveInstances);
        return this.JSONRepresentation(clusterInfo);
    }

    @NamespaceAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{clusterId}")
    public Response createCluster(@PathParam(value="clusterId") String clusterId, @DefaultValue(value="false") @QueryParam(value="recreate") String recreate, @DefaultValue(value="false") @QueryParam(value="addCloudConfig") String addCloudConfig, String cloudConfigManifest) {
        boolean recreateIfExists = Boolean.parseBoolean(recreate);
        boolean cloudConfigIncluded = Boolean.parseBoolean(addCloudConfig);
        ClusterSetup clusterSetup = this.getClusterSetup();
        CloudConfig cloudConfig = null;
        if (cloudConfigIncluded) {
            try {
                ZNRecord record = ClusterAccessor.toZNRecord(cloudConfigManifest);
                cloudConfig = new CloudConfig.Builder(record).build();
            }
            catch (IOException | HelixException e) {
                String errMsg = "Failed to generate a valid CloudConfig from " + cloudConfigManifest;
                LOG.error(errMsg, e);
                return this.badRequest(errMsg + " Exception: " + e.getMessage());
            }
        }
        try {
            this.getAclRegister().createACL(this._servletRequest);
        }
        catch (Exception ex) {
            LOG.error("Failed to create ACL for cluster {}. Exception: {}.", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        try {
            clusterSetup.addCluster(clusterId, recreateIfExists, cloudConfig);
        }
        catch (Exception ex) {
            LOG.error("Failed to create cluster {}. Exception: {}.", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        return this.created();
    }

    @NamespaceAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{clusterId}")
    public Response deleteCluster(@PathParam(value="clusterId") String clusterId) {
        ClusterSetup clusterSetup = this.getClusterSetup();
        try {
            clusterSetup.deleteCluster(clusterId);
        }
        catch (HelixException ex) {
            LOG.info("Failed to delete cluster {}, cluster is still in use. Exception: {}.", (Object)clusterId, (Object)ex);
            return this.badRequest(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Failed to delete cluster {}. Exception: {}.", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}")
    public Response updateCluster(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, @QueryParam(value="superCluster") String superCluster, @QueryParam(value="duration") Long duration, String content) {
        AbstractResource.Command command;
        try {
            command = this.getCommand(commandStr);
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        ClusterSetup clusterSetup = this.getClusterSetup();
        HelixAdmin helixAdmin = this.getHelixAdmin();
        switch (command) {
            case activate: {
                if (superCluster == null) {
                    return this.badRequest("Super Cluster name is missing!");
                }
                try {
                    clusterSetup.activateCluster(clusterId, superCluster, true);
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Failed to add cluster {} to super cluster {}.", (Object)clusterId, (Object)superCluster);
                    return this.serverError(ex);
                }
            }
            case deactivate: {
                if (superCluster == null) {
                    return this.badRequest("Super Cluster name is missing!");
                }
                try {
                    clusterSetup.activateCluster(clusterId, superCluster, false);
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Failed to deactivate cluster {} from super cluster {}.", (Object)clusterId, (Object)superCluster);
                    return this.serverError(ex);
                }
            }
            case addVirtualTopologyGroup: {
                try {
                    this.addVirtualTopologyGroup(clusterId, content);
                    break;
                }
                catch (JsonProcessingException ex) {
                    LOG.error("Failed to parse json string: {}", (Object)content, (Object)ex);
                    return this.badRequest("Invalid payload json body: " + content);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Illegal input {} for command {}.", new Object[]{content, command, ex});
                    return this.badRequest(String.format("Illegal input %s for command %s", new Object[]{content, command}));
                }
                catch (Exception ex) {
                    LOG.error("Failed to add virtual topology group to cluster {}", (Object)clusterId, (Object)ex);
                    return this.serverError(ex);
                }
            }
            case expand: {
                try {
                    clusterSetup.expandCluster(clusterId);
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Failed to expand cluster {}.", (Object)clusterId);
                    return this.serverError(ex);
                }
            }
            case enable: {
                try {
                    helixAdmin.enableCluster(clusterId, true);
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Failed to enable cluster {}.", (Object)clusterId);
                    return this.serverError(ex);
                }
            }
            case disable: {
                try {
                    helixAdmin.enableCluster(clusterId, false);
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Failed to disable cluster {}.", (Object)clusterId);
                    return this.serverError(ex);
                }
            }
            case enableMaintenanceMode: 
            case disableMaintenanceMode: {
                Map customFieldsMap = null;
                try {
                    customFieldsMap = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)new TypeReference<HashMap<String, String>>(){});
                    content = null;
                    for (Map.Entry entry : customFieldsMap.entrySet()) {
                        if (!"reason".equalsIgnoreCase((String)entry.getKey())) continue;
                        content = (String)entry.getValue();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                helixAdmin.manuallyEnableMaintenanceMode(clusterId, command == AbstractResource.Command.enableMaintenanceMode, content, customFieldsMap);
                break;
            }
            case enableWagedRebalanceForAllResources: {
                List resources = helixAdmin.getResourcesInCluster(clusterId);
                try {
                    helixAdmin.enableWagedRebalance(clusterId, resources);
                    break;
                }
                catch (HelixException e) {
                    return this.badRequest(e.getMessage());
                }
            }
            case purgeOfflineParticipants: {
                if (duration == null || duration < 0L) {
                    helixAdmin.purgeOfflineInstances(clusterId, -1L);
                    break;
                }
                helixAdmin.purgeOfflineInstances(clusterId, duration.longValue());
                break;
            }
            case onDemandRebalance: {
                try {
                    helixAdmin.onDemandRebalance(clusterId);
                    break;
                }
                catch (Exception ex) {
                    LOG.error("Cannot start on-demand rebalance for cluster: {}, Exception: {}", (Object)clusterId, (Object)ex);
                    return this.serverError(ex);
                }
            }
            default: {
                return this.badRequest("Unsupported command {}." + command);
            }
        }
        return this.OK();
    }

    private void addVirtualTopologyGroup(String clusterId, String content) throws JsonProcessingException {
        ClusterServiceImpl clusterService = new ClusterServiceImpl(this.getDataAccssor(clusterId), this.getConfigAccessor());
        VirtualTopologyGroupService service = new VirtualTopologyGroupService(this.getHelixAdmin(), clusterService, this.getConfigAccessor(), this.getDataAccssor(clusterId));
        Map customFieldsMap = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        service.addVirtualTopologyGroup(clusterId, customFieldsMap);
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/management-mode")
    public Response getClusterManagementMode(@PathParam(value="clusterId") String clusterId, @QueryParam(value="showDetails") boolean showDetails) {
        ClusterManagementMode mode = this.getHelixAdmin().getClusterManagementMode(clusterId);
        if (mode == null) {
            return this.notFound("Cluster " + clusterId + " is not in management mode");
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("cluster", clusterId);
        responseMap.put("mode", mode.getMode());
        responseMap.put("status", mode.getStatus());
        if (showDetails) {
            responseMap.put("details", this.getManagementModeDetails(clusterId, mode));
        }
        return this.JSONRepresentation(responseMap);
    }

    private Map<String, Object> getManagementModeDetails(String clusterId, ClusterManagementMode mode) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        HashMap<String, Object> participantDetails = new HashMap<String, Object>();
        ClusterManagementMode.Status status = mode.getStatus();
        details.put("cluster", ImmutableMap.of((Object)"cluster", (Object)clusterId, (Object)"status", (Object)status.name()));
        boolean hasPendingST = false;
        HashSet<String> liveInstancesInProgress = new HashSet<String>();
        if (ClusterManagementMode.Status.IN_PROGRESS.equals((Object)status)) {
            HelixDataAccessor accessor = this.getDataAccssor(clusterId);
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            List liveInstances = accessor.getChildValues(keyBuilder.liveInstances());
            BaseDataAccessor baseAccessor = accessor.getBaseDataAccessor();
            if (ClusterManagementMode.Type.CLUSTER_FREEZE.equals((Object)mode.getMode())) {
                for (LiveInstance liveInstance : liveInstances) {
                    Stat stat;
                    String instanceName = liveInstance.getInstanceName();
                    if (!LiveInstance.LiveInstanceStatus.FROZEN.equals((Object)liveInstance.getStatus())) {
                        liveInstancesInProgress.add(instanceName);
                    }
                    if ((stat = baseAccessor.getStat(keyBuilder.messages(instanceName).getPath(), AccessOption.PERSISTENT)).getNumChildren() <= 0) continue;
                    hasPendingST = true;
                    liveInstancesInProgress.add(instanceName);
                }
            } else if (ClusterManagementMode.Type.NORMAL.equals((Object)mode.getMode())) {
                for (LiveInstance liveInstance : liveInstances) {
                    if (!LiveInstance.LiveInstanceStatus.FROZEN.equals((Object)liveInstance.getStatus())) continue;
                    liveInstancesInProgress.add(liveInstance.getInstanceName());
                }
            }
        }
        participantDetails.put("status", status.name());
        participantDetails.put("liveInstancesInProgress", liveInstancesInProgress);
        if (ClusterManagementMode.Type.CLUSTER_FREEZE.equals((Object)mode.getMode())) {
            participantDetails.put("hasPendingStateTransition", hasPendingST);
        }
        details.put(ClusterProperties.liveInstances.name(), participantDetails);
        return details;
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}/management-mode")
    public Response updateClusterManagementMode(@PathParam(value="clusterId") String clusterId, @DefaultValue(value="{}") String content) {
        ClusterManagementModeRequest request;
        try {
            request = (ClusterManagementModeRequest)OBJECT_MAPPER.readerFor(ClusterManagementModeRequest.class).readValue(content);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Failed to parse json string: {}", (Object)content, (Object)e);
            return this.badRequest("Invalid payload json body: " + content);
        }
        request = ClusterManagementModeRequest.newBuilder().withClusterName(clusterId).withMode(request.getMode()).withCancelPendingST(request.isCancelPendingST()).withReason(request.getReason()).build();
        try {
            this.getHelixAdmin().setClusterManagementMode(request);
        }
        catch (HelixConflictException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (HelixException e) {
            return this.serverError(e.getMessage());
        }
        return this.JSONRepresentation(ImmutableMap.of((Object)"acknowledged", (Object)true));
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/configs")
    public Response getClusterConfig(@PathParam(value="clusterId") String clusterId) {
        ConfigAccessor accessor = this.getConfigAccessor();
        ClusterConfig config = null;
        try {
            config = accessor.getClusterConfig(clusterId);
        }
        catch (HelixException ex) {
            LOG.info("Failed to get cluster config for cluster {}, cluster not found. Exception: {}.", (Object)clusterId, (Object)ex);
        }
        catch (Exception ex) {
            LOG.error("Failed to get cluster config for cluster {}. Exception: {}", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        if (config == null) {
            return this.notFound();
        }
        return this.JSONRepresentation(config.getRecord());
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{clusterId}/customized-state-config")
    public Response addCustomizedStateConfig(@PathParam(value="clusterId") String clusterId, String content) {
        ZNRecord record;
        if (!this.doesClusterExist(clusterId)) {
            return this.notFound(String.format("Cluster %s does not exist", clusterId));
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            return this.badRequest("Input is not a vaild ZNRecord!");
        }
        try {
            CustomizedStateConfig customizedStateConfig = new CustomizedStateConfig.Builder(record).build();
            admin.addCustomizedStateConfig(clusterId, customizedStateConfig);
        }
        catch (Exception ex) {
            LOG.error("Cannot add CustomizedStateConfig to cluster: {} Exception: {}", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{clusterId}/customized-state-config")
    public Response removeCustomizedStateConfig(@PathParam(value="clusterId") String clusterId) {
        if (!this.doesClusterExist(clusterId)) {
            return this.notFound(String.format("Cluster %s does not exist", clusterId));
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            admin.removeCustomizedStateConfig(clusterId);
        }
        catch (Exception ex) {
            LOG.error("Cannot remove CustomizedStateConfig from cluster: {}, Exception: {}", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/customized-state-config")
    public Response getCustomizedStateConfig(@PathParam(value="clusterId") String clusterId) {
        if (!this.doesClusterExist(clusterId)) {
            return this.notFound(String.format("Cluster %s does not exist", clusterId));
        }
        ConfigAccessor configAccessor = this.getConfigAccessor();
        CustomizedStateConfig customizedStateConfig = configAccessor.getCustomizedStateConfig(clusterId);
        if (customizedStateConfig != null) {
            return this.JSONRepresentation(customizedStateConfig.getRecord());
        }
        return this.notFound();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}/customized-state-config")
    public Response updateCustomizedStateConfig(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, @QueryParam(value="type") String type) {
        AbstractResource.Command command;
        if (!this.doesClusterExist(clusterId)) {
            return this.notFound(String.format("Cluster %s does not exist", clusterId));
        }
        if (commandStr == null || commandStr.isEmpty()) {
            command = AbstractResource.Command.add;
        } else {
            try {
                command = this.getCommand(commandStr);
            }
            catch (HelixException ex) {
                return this.badRequest(ex.getMessage());
            }
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            switch (command) {
                case delete: {
                    admin.removeTypeFromCustomizedStateConfig(clusterId, type);
                    break;
                }
                case add: {
                    admin.addTypeToCustomizedStateConfig(clusterId, type);
                    break;
                }
                default: {
                    return this.badRequest("Unsupported command " + commandStr);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to {} CustomizedStateConfig for cluster {} new type: {}, Exception: {}", new Object[]{command, clusterId, type, ex});
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/topology")
    public Response getClusterTopology(@PathParam(value="clusterId") String clusterId) throws IOException {
        ClusterServiceImpl clusterService = new ClusterServiceImpl(this.getDataAccssor(clusterId), this.getConfigAccessor());
        ObjectMapper objectMapper = new ObjectMapper();
        ClusterTopology clusterTopology = clusterService.getClusterTopology(clusterId);
        return this.OK(objectMapper.writeValueAsString((Object)clusterTopology));
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/topologymap")
    public Response getClusterTopologyMap(@PathParam(value="clusterId") String clusterId) {
        Map topologyMap;
        HelixAdmin admin = this.getHelixAdmin();
        try {
            topologyMap = admin.getClusterTopology(clusterId).getTopologyMap();
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        return this.JSONRepresentation(topologyMap);
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/faultzonemap")
    public Response getClusterFaultZoneMap(@PathParam(value="clusterId") String clusterId) {
        Map faultZoneMap;
        HelixAdmin admin = this.getHelixAdmin();
        try {
            faultZoneMap = admin.getClusterTopology(clusterId).getFaultZoneMap();
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        return this.JSONRepresentation(faultZoneMap);
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}/configs")
    public Response updateClusterConfig(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, String content) {
        ZNRecord record;
        AbstractResource.Command command;
        try {
            command = this.getCommand(commandStr);
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input {}. Exception: {}.", (Object)content, (Object)e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        if (!clusterId.equals(record.getId())) {
            return this.badRequest("ID does not match the cluster name in input!");
        }
        ClusterConfig config = new ClusterConfig(record);
        ConfigAccessor configAccessor = this.getConfigAccessor();
        try {
            switch (command) {
                case update: {
                    configAccessor.updateClusterConfig(clusterId, config);
                    break;
                }
                case delete: {
                    HelixConfigScope clusterScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(clusterId).build();
                    configAccessor.remove(clusterScope, config.getRecord());
                    break;
                }
                default: {
                    return this.badRequest("Unsupported command " + commandStr);
                }
            }
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Failed to {} cluster config, cluster {}, new config: {}. Exception: {}.", new Object[]{command, clusterId, content, ex});
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/controller")
    public Response getClusterController(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        HashMap<String, String> controllerInfo = new HashMap<String, String>();
        controllerInfo.put(AbstractResource.Properties.id.name(), clusterId);
        LiveInstance leader = (LiveInstance)dataAccessor.getProperty(dataAccessor.keyBuilder().controllerLeader());
        if (leader != null) {
            controllerInfo.put(ClusterProperties.controller.name(), leader.getInstanceName());
            controllerInfo.putAll(leader.getRecord().getSimpleFields());
        } else {
            controllerInfo.put(ClusterProperties.controller.name(), "No Lead Controller!");
        }
        return this.JSONRepresentation(controllerInfo);
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/controller/history")
    public Response getClusterControllerLeadershipHistory(@PathParam(value="clusterId") String clusterId) {
        return this.JSONRepresentation(this.getControllerHistory(clusterId, ControllerHistory.HistoryType.CONTROLLER_LEADERSHIP));
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/controller/maintenanceHistory")
    public Response getClusterMaintenanceHistory(@PathParam(value="clusterId") String clusterId) {
        return this.JSONRepresentation(this.getControllerHistory(clusterId, ControllerHistory.HistoryType.MAINTENANCE));
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/controller/maintenanceSignal")
    public Response getClusterMaintenanceSignal(@PathParam(value="clusterId") String clusterId) {
        boolean inMaintenanceMode = this.getHelixAdmin().isInMaintenanceMode(clusterId);
        if (inMaintenanceMode) {
            HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
            MaintenanceSignal maintenanceSignal = (MaintenanceSignal)dataAccessor.getProperty(dataAccessor.keyBuilder().maintenance());
            Map<String, String> maintenanceInfo = maintenanceSignal != null ? maintenanceSignal.getRecord().getSimpleFields() : new HashMap();
            maintenanceInfo.put(ClusterProperties.clusterName.name(), clusterId);
            return this.JSONRepresentation(maintenanceInfo);
        }
        return this.notFound(String.format("Cluster %s is not in maintenance mode!", clusterId));
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/controller/messages")
    public Response getClusterControllerMessages(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        HashMap<String, Object> controllerMessages = new HashMap<String, Object>();
        controllerMessages.put(AbstractResource.Properties.id.name(), clusterId);
        List messages = dataAccessor.getChildNames(dataAccessor.keyBuilder().controllerMessages());
        controllerMessages.put(ClusterProperties.messages.name(), messages);
        controllerMessages.put(AbstractResource.Properties.count.name(), messages.size());
        return this.JSONRepresentation(controllerMessages);
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/controller/messages/{messageId}")
    public Response getClusterControllerMessages(@PathParam(value="clusterId") String clusterId, @PathParam(value="messageId") String messageId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        Message message = (Message)dataAccessor.getProperty(dataAccessor.keyBuilder().controllerMessage(messageId));
        return this.JSONRepresentation(message.getRecord());
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/statemodeldefs")
    public Response getClusterStateModelDefinitions(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        List stateModelDefs = dataAccessor.getChildNames(dataAccessor.keyBuilder().stateModelDefs());
        HashMap<String, Object> clusterStateModelDefs = new HashMap<String, Object>();
        clusterStateModelDefs.put(AbstractResource.Properties.id.name(), clusterId);
        clusterStateModelDefs.put(ClusterProperties.stateModelDefinitions.name(), stateModelDefs);
        return this.JSONRepresentation(clusterStateModelDefs);
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response getClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        StateModelDefinition stateModelDef = (StateModelDefinition)dataAccessor.getProperty(dataAccessor.keyBuilder().stateModelDef(statemodel));
        if (stateModelDef == null) {
            return this.badRequest("Statemodel not found!");
        }
        return this.JSONRepresentation(stateModelDef.getRecord());
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response createClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel, String content) {
        ZNRecord record;
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input {}. Exception: {}.", (Object)content, (Object)e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        String path = PropertyPathBuilder.stateModelDef((String)clusterId);
        try {
            ZKUtil.createChildren((RealmAwareZkClient)zkClient, (String)path, (ZNRecord)record);
        }
        catch (Exception e) {
            LOG.error("Failed to create zk node with path {}. Exception: {}", (Object)path, (Object)e);
            return this.badRequest("Failed to create a Znode for stateModel! " + e);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response setClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel, String content) {
        ZNRecord record;
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input {}. Exception: {}.", (Object)content, (Object)e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        StateModelDefinition stateModelDefinition = new StateModelDefinition(record);
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        PropertyKey key = dataAccessor.keyBuilder().stateModelDef(stateModelDefinition.getId());
        boolean retcode = true;
        try {
            retcode = dataAccessor.setProperty(key, (HelixProperty)stateModelDefinition);
        }
        catch (Exception e) {
            LOG.error("Failed to set StateModelDefinition key: {}. Exception: {}.", (Object)key, (Object)e);
            return this.badRequest("Failed to set the content " + content);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response removeClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel) {
        if (!StringUtils.isAlphanumeric((CharSequence)statemodel)) {
            return this.badRequest("Invalid statemodel name!");
        }
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        PropertyKey key = dataAccessor.keyBuilder().stateModelDef(statemodel);
        boolean retcode = true;
        try {
            retcode = dataAccessor.removeProperty(key);
        }
        catch (Exception e) {
            LOG.error("Failed to remove StateModelDefinition key: {}. Exception: {}.", (Object)key, (Object)e);
            retcode = false;
        }
        if (!retcode) {
            return this.badRequest("Failed to remove!");
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{clusterId}/restconfig")
    public Response createRESTConfig(@PathParam(value="clusterId") String clusterId, String content) {
        ZNRecord record;
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input {}. Exception: {}.", (Object)content, (Object)e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        if (!record.getId().equals(clusterId)) {
            return this.badRequest("ID does not match the cluster name in input!");
        }
        RESTConfig config = new RESTConfig(record);
        ConfigAccessor configAccessor = this.getConfigAccessor();
        try {
            configAccessor.setRESTConfig(clusterId, config);
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Failed to create rest config, cluster {}, new config: {}. Exception: {}.", new Object[]{clusterId, content, ex});
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}/restconfig")
    public Response updateRESTConfig(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, String content) {
        ZNRecord record;
        AbstractResource.Command command;
        try {
            command = this.getCommand(commandStr);
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input {}. Exception: {}", (Object)content, (Object)e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        RESTConfig config = new RESTConfig(record);
        ConfigAccessor configAccessor = this.getConfigAccessor();
        try {
            switch (command) {
                case update: {
                    configAccessor.updateRESTConfig(clusterId, config);
                    break;
                }
                case delete: {
                    HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.REST).forCluster(clusterId).build();
                    configAccessor.remove(scope, config.getRecord());
                    break;
                }
                default: {
                    return this.badRequest("Unsupported command " + commandStr);
                }
            }
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Failed to {} rest config, cluster {}, new config: {}. Exception: {}", new Object[]{command, clusterId, content, ex});
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/restconfig")
    public Response getRESTConfig(@PathParam(value="clusterId") String clusterId) {
        ConfigAccessor accessor = this.getConfigAccessor();
        RESTConfig config = null;
        try {
            config = accessor.getRESTConfig(clusterId);
        }
        catch (HelixException ex) {
            LOG.info("Failed to get rest config for cluster {}, cluster not found. Exception: {}.", (Object)clusterId, (Object)ex);
        }
        catch (Exception ex) {
            LOG.error("Failed to get rest config for cluster {}. Exception: {}.", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        if (config == null) {
            return this.notFound();
        }
        return this.JSONRepresentation(config.getRecord());
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{clusterId}/restconfig")
    public Response deleteRESTConfig(@PathParam(value="clusterId") String clusterId) {
        ConfigAccessor accessor = this.getConfigAccessor();
        try {
            accessor.deleteRESTConfig(clusterId);
        }
        catch (HelixException ex) {
            LOG.info("Failed to delete rest config for cluster {}, cluster rest config is not found. Exception: {}.", (Object)clusterId, (Object)ex);
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Failed to delete rest config, cluster {}, Exception: {}.", (Object)clusterId, (Object)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/maintenance")
    public Response getClusterMaintenanceMode(@PathParam(value="clusterId") String clusterId) {
        return this.JSONRepresentation(ImmutableMap.of((Object)ClusterProperties.maintenance.name(), (Object)this.getHelixAdmin().isInMaintenanceMode(clusterId)));
    }

    private boolean doesClusterExist(String cluster) {
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        return ZKUtil.isClusterSetup((String)cluster, (RealmAwareZkClient)zkClient);
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{clusterId}/cloudconfig")
    public Response addCloudConfig(@PathParam(value="clusterId") String clusterId, String content) {
        ZNRecord record;
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        if (!ZKUtil.isClusterSetup((String)clusterId, (RealmAwareZkClient)zkClient)) {
            return this.notFound("Cluster is not properly setup!");
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a vaild ZNRecord!");
        }
        try {
            CloudConfig cloudConfig = new CloudConfig.Builder(record).build();
            admin.addCloudConfig(clusterId, cloudConfig);
        }
        catch (HelixException ex) {
            LOG.error("Error in adding a CloudConfig to cluster: " + clusterId, (Throwable)ex);
            return this.badRequest(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Cannot add CloudConfig to cluster: " + clusterId, (Throwable)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{clusterId}/cloudconfig")
    public Response getCloudConfig(@PathParam(value="clusterId") String clusterId) {
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        if (!ZKUtil.isClusterSetup((String)clusterId, (RealmAwareZkClient)zkClient)) {
            return this.notFound();
        }
        ConfigAccessor configAccessor = new ConfigAccessor(zkClient);
        CloudConfig cloudConfig = configAccessor.getCloudConfig(clusterId);
        if (cloudConfig != null) {
            return this.JSONRepresentation(cloudConfig.getRecord());
        }
        return this.notFound();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{clusterId}/cloudconfig")
    public Response deleteCloudConfig(@PathParam(value="clusterId") String clusterId) {
        HelixAdmin admin = this.getHelixAdmin();
        admin.removeCloudConfig(clusterId);
        return this.OK();
    }

    @ClusterAuth
    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{clusterId}/cloudconfig")
    public Response updateCloudConfig(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, String content) {
        CloudConfig cloudConfig;
        AbstractResource.Command command;
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        if (!ZKUtil.isClusterSetup((String)clusterId, (RealmAwareZkClient)zkClient)) {
            return this.notFound();
        }
        ConfigAccessor configAccessor = new ConfigAccessor(zkClient);
        if (commandStr == null || commandStr.isEmpty()) {
            command = AbstractResource.Command.update;
        } else {
            try {
                command = this.getCommand(commandStr);
            }
            catch (HelixException ex) {
                return this.badRequest(ex.getMessage());
            }
        }
        try {
            ZNRecord record = ClusterAccessor.toZNRecord(content);
            cloudConfig = new CloudConfig(record);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a vaild ZNRecord!");
        }
        try {
            switch (command) {
                case delete: {
                    configAccessor.deleteCloudConfigFields(clusterId, cloudConfig);
                    break;
                }
                case update: {
                    try {
                        configAccessor.updateCloudConfig(clusterId, cloudConfig);
                        break;
                    }
                    catch (HelixException ex) {
                        LOG.error("Error in updating a CloudConfig to cluster: " + clusterId, (Throwable)ex);
                        return this.badRequest(ex.getMessage());
                    }
                    catch (Exception ex) {
                        LOG.error("Cannot update CloudConfig for cluster: " + clusterId, (Throwable)ex);
                        return this.serverError(ex);
                    }
                }
                default: {
                    return this.badRequest("Unsupported command " + commandStr);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to " + command + " cloud config, cluster " + clusterId + " new config: " + content + ", Exception: " + ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    private Map<String, Object> getControllerHistory(String clusterId, ControllerHistory.HistoryType historyType) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        HashMap<String, Object> history = new HashMap<String, Object>();
        history.put(AbstractResource.Properties.id.name(), clusterId);
        ControllerHistory historyRecord = (ControllerHistory)dataAccessor.getProperty(dataAccessor.keyBuilder().controllerLeaderHistory());
        switch (historyType) {
            case CONTROLLER_LEADERSHIP: {
                history.put(AbstractResource.Properties.history.name(), historyRecord != null ? historyRecord.getHistoryList() : Collections.emptyList());
                break;
            }
            case MAINTENANCE: {
                history.put(ClusterProperties.maintenanceHistory.name(), historyRecord != null ? historyRecord.getMaintenanceHistoryList() : Collections.emptyList());
            }
        }
        return history;
    }

    private AclRegister getAclRegister() {
        return (AclRegister)this._application.getProperties().get(ContextPropertyKeys.ACL_REGISTER.name());
    }

    public static enum ClusterProperties {
        controller,
        instances,
        liveInstances,
        resources,
        paused,
        maintenance,
        messages,
        stateModelDefinitions,
        clusters,
        maintenanceSignal,
        maintenanceHistory,
        clusterName;

    }
}

