/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.SamePartitionOnInstanceConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidGroupTagConstraint
extends HardConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(SamePartitionOnInstanceConstraint.class);

    ValidGroupTagConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        if (!replica.hasResourceInstanceGroupTag()) {
            return true;
        }
        if (!node.getInstanceTags().contains(replica.getResourceInstanceGroupTag())) {
            if (this.enableLogging) {
                LOG.info("Instance doesn't have the tag of the replica ({})", (Object)replica.getResourceInstanceGroupTag());
            }
            return false;
        }
        return true;
    }

    @Override
    String getDescription() {
        return "Instance doesn't have the tag of the replica";
    }
}

