/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.prometheus.parser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.prometheus.parser.MetricFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineParser {
    private static final Logger log = LoggerFactory.getLogger(OnlineParser.class);
    private static final Map<Integer, Integer> escapeMap = new HashMap<Integer, Integer>(8);
    private static final char RIGHT_BRACKET = '}';
    private static final char LEFT_BRACKET = '{';
    private static final char UTF8_REPLACEMENT_CHARACTER = '\ufffd';

    private OnlineParser() {
    }

    public static Map<String, MetricFamily> parseMetrics(InputStream inputStream) throws IOException {
        ConcurrentHashMap<String, MetricFamily> metricFamilyMap = new ConcurrentHashMap<String, MetricFamily>(10);
        try {
            int i = OnlineParser.getChar(inputStream);
            while (i != -1) {
                if (i == 35 || i == 10) {
                    OnlineParser.skipToLineEnd(inputStream).maybeEol().maybeEof().noElse();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((char)i);
                    OnlineParser.parseMetric(inputStream, metricFamilyMap, stringBuilder);
                }
                if ((i = OnlineParser.getChar(inputStream)) != 13) continue;
                i = OnlineParser.getChar(inputStream);
            }
        }
        catch (FormatException e) {
            log.error("prometheus parser failed because of wrong input format. {}", (Object)e.getMessage());
            return null;
        }
        return metricFamilyMap;
    }

    public static Map<String, MetricFamily> parseMetrics(InputStream inputStream, String metric) throws IOException {
        ConcurrentHashMap<String, MetricFamily> metricFamilyMap = new ConcurrentHashMap<String, MetricFamily>(10);
        try {
            int i = OnlineParser.getChar(inputStream);
            while (i != -1) {
                if (i == 35 || i == 10) {
                    OnlineParser.skipToLineEnd(inputStream).maybeEol().maybeEof().noElse();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((char)i);
                    int next = OnlineParser.parseMetricName(inputStream, stringBuilder).maybeSpace().maybeLeftBracket().noElse();
                    String metricName = stringBuilder.toString();
                    stringBuilder.delete(0, stringBuilder.length());
                    if (metric.equals(metricName)) {
                        OnlineParser.parseMetricFromName(inputStream, stringBuilder, metricFamilyMap, metricName, next);
                    } else {
                        OnlineParser.skipToLineEnd(inputStream).maybeEol().maybeEof().noElse();
                    }
                }
                if ((i = OnlineParser.getChar(inputStream)) != 13) continue;
                i = OnlineParser.getChar(inputStream);
            }
        }
        catch (FormatException e) {
            log.error("prometheus parser failed because of wrong input format. {}", (Object)e.getMessage());
            return null;
        }
        return metricFamilyMap;
    }

    private static CharChecker parseMetricFromName(InputStream inputStream, StringBuilder stringBuilder, Map<String, MetricFamily> metricFamilyMap, String metricName, int next) throws IOException, FormatException {
        MetricFamily metricFamily;
        MetricFamily.Metric metric = new MetricFamily.Metric();
        if (!metricFamilyMap.containsKey(metricName)) {
            metricFamily = new MetricFamily();
            metricFamily.setMetricList(new ArrayList<MetricFamily.Metric>());
            metricFamily.setName(metricName);
            metricFamilyMap.put(metricName, metricFamily);
        } else {
            metricFamily = metricFamilyMap.get(metricName);
        }
        int i = next;
        if (i == 32) {
            i = OnlineParser.skipSpaces(inputStream).getInt();
        }
        LinkedList<MetricFamily.Label> labelList = new LinkedList<MetricFamily.Label>();
        metric.setLabels(labelList);
        if (i == 123) {
            OnlineParser.parseLabels(inputStream, stringBuilder, labelList);
            i = OnlineParser.skipSpaces(inputStream).getInt();
        }
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append((char)i);
        i = OnlineParser.parseOneDouble(inputStream, stringBuilder).maybeSpace().maybeEol().maybeEof().noElse();
        metric.setValue(OnlineParser.toDouble(stringBuilder.toString()));
        if (i == 10 || i == -1) {
            metricFamily.getMetricList().add(metric);
            return new CharChecker(i);
        }
        i = OnlineParser.skipSpaces(inputStream).getInt();
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append((char)i);
        i = OnlineParser.skipOneLong(inputStream).maybeSpace().maybeEol().maybeEof().noElse();
        if (i == 10 || i == -1) {
            metricFamily.getMetricList().add(metric);
            return new CharChecker(i);
        }
        i = OnlineParser.skipSpaces(inputStream).maybeEol().maybeEof().noElse();
        metricFamily.getMetricList().add(metric);
        return new CharChecker(i);
    }

    private static int getChar(InputStream inputStream) throws IOException, FormatException {
        int i = inputStream.read();
        if (i == 92) {
            i = inputStream.read();
            if (escapeMap.containsKey(i)) {
                return escapeMap.get(i);
            }
            throw new FormatException("Escape character failed.");
        }
        return i;
    }

    private static CharChecker parseOneDouble(InputStream inputStream, StringBuilder stringBuilder) throws IOException, FormatException {
        int i = OnlineParser.getChar(inputStream);
        while (i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90 || i == 45 || i == 43 || i == 46) {
            stringBuilder.append((char)i);
            i = OnlineParser.getChar(inputStream);
        }
        if (i == 13) {
            i = OnlineParser.getChar(inputStream);
        }
        return new CharChecker(i);
    }

    private static CharChecker skipOneLong(InputStream inputStream) throws IOException, FormatException {
        int i = OnlineParser.getChar(inputStream);
        while (i >= 48 && i <= 57) {
            i = OnlineParser.getChar(inputStream);
        }
        if (i == 13) {
            i = OnlineParser.getChar(inputStream);
        }
        return new CharChecker(i);
    }

    private static CharChecker parseMetricName(InputStream inputStream, StringBuilder stringBuilder) throws IOException, FormatException {
        int i = OnlineParser.getChar(inputStream);
        while (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 95 || i == 58) {
            stringBuilder.append((char)i);
            i = OnlineParser.getChar(inputStream);
        }
        return new CharChecker(i);
    }

    private static CharChecker parseLabelName(InputStream inputStream, StringBuilder stringBuilder) throws IOException, FormatException {
        int i = OnlineParser.getChar(inputStream);
        while (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 95) {
            stringBuilder.append((char)i);
            i = OnlineParser.getChar(inputStream);
        }
        return new CharChecker(i);
    }

    private static CharChecker parseLabelValue(InputStream inputStream, StringBuilder stringBuilder) throws IOException, FormatException {
        int i = inputStream.read();
        while (i != 34 && i != -1) {
            if (i == 92) {
                i = inputStream.read();
                switch (i) {
                    case 110: {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 92: {
                        stringBuilder.append('\\');
                        break;
                    }
                    case 34: {
                        stringBuilder.append('\"');
                        break;
                    }
                    default: {
                        stringBuilder.append('\\');
                        if (i != -1) {
                            stringBuilder.append((char)i);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (i <= 127) {
                stringBuilder.append((char)i);
            } else {
                OnlineParser.handleUtf8Character(i, inputStream, stringBuilder);
            }
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static void handleUtf8Character(int firstByte, InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        byte[] byteArray = new byte[4];
        byteArray[0] = (byte)firstByte;
        int additionalBytes = OnlineParser.calculateUtf8ContinuationBytes(firstByte);
        if (additionalBytes == -1) {
            OnlineParser.appendInvalidCharacters(stringBuilder);
            return;
        }
        int totalBytes = 1;
        for (int i = 0; i < additionalBytes; ++i) {
            int nextByte = inputStream.read();
            if (nextByte == -1) {
                OnlineParser.appendInvalidCharacters(stringBuilder);
                return;
            }
            if ((nextByte & 0xC0) != 128) {
                OnlineParser.appendInvalidCharacters(stringBuilder);
                return;
            }
            byteArray[i + 1] = (byte)nextByte;
            ++totalBytes;
        }
        try {
            String utf8Chars = new String(byteArray, 0, totalBytes, StandardCharsets.UTF_8);
            stringBuilder.append(utf8Chars);
        }
        catch (Exception e) {
            log.debug("Invalid UTF-8 sequence detected at firstByte: {}", (Object)Integer.toHexString(firstByte));
            OnlineParser.appendInvalidCharacters(stringBuilder);
        }
    }

    private static void appendInvalidCharacters(StringBuilder stringBuilder) {
        Optional.ofNullable(stringBuilder).ifPresent(t -> t.append('\ufffd'));
    }

    private static boolean isInvalidLabelValue(String labelValue) {
        return StringUtils.isNotBlank((CharSequence)labelValue) && labelValue.contains(String.valueOf('\ufffd'));
    }

    private static int calculateUtf8ContinuationBytes(int firstByte) {
        if ((firstByte & 0xE0) == 192) {
            if (firstByte <= 193) {
                return -1;
            }
            return 1;
        }
        if ((firstByte & 0xF0) == 224) {
            return 2;
        }
        if ((firstByte & 0xF8) == 240) {
            if (firstByte >= 245) {
                return -1;
            }
            return 3;
        }
        return -1;
    }

    private static CharChecker skipSpaces(InputStream inputStream) throws IOException, FormatException {
        int i = OnlineParser.getChar(inputStream);
        while (i == 32) {
            i = OnlineParser.getChar(inputStream);
        }
        return new CharChecker(i);
    }

    private static CharChecker skipToLineEnd(InputStream inputStream) throws IOException, FormatException {
        int i = OnlineParser.getChar(inputStream);
        while (i != 10 && i != -1) {
            i = OnlineParser.getChar(inputStream);
        }
        return new CharChecker(i);
    }

    private static Double toDouble(String string) throws FormatException {
        switch (string) {
            case "+Inf": {
                return Double.POSITIVE_INFINITY;
            }
            case "-Inf": {
                return Double.NEGATIVE_INFINITY;
            }
            case "NaN": {
                return Double.NaN;
            }
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return bigDecimal.doubleValue();
        }
        catch (NumberFormatException e) {
            throw new FormatException();
        }
    }

    private static CharChecker parseLabel(InputStream inputStream, StringBuilder stringBuilder, List<MetricFamily.Label> labelList) throws IOException, FormatException {
        MetricFamily.Label label = new MetricFamily.Label();
        int i = OnlineParser.skipSpaces(inputStream).getInt();
        if (i == 125) {
            return new CharChecker(i);
        }
        stringBuilder.append((char)i);
        i = OnlineParser.parseLabelName(inputStream, stringBuilder).maybeSpace().maybeEqualsSign().noElse();
        label.setName(stringBuilder.toString());
        stringBuilder.delete(0, stringBuilder.length());
        if (i == 32) {
            OnlineParser.skipSpaces(inputStream).maybeEqualsSign().noElse();
        }
        OnlineParser.skipSpaces(inputStream).maybeQuotationMark().noElse();
        OnlineParser.parseLabelValue(inputStream, stringBuilder).maybeQuotationMark().noElse();
        String labelValue = stringBuilder.toString();
        if (OnlineParser.isInvalidLabelValue(labelValue)) {
            log.error("Invalid UTF-8 sequence detected at labelValue.");
            throw new FormatException();
        }
        label.setValue(labelValue);
        stringBuilder.delete(0, stringBuilder.length());
        labelList.add(label);
        return new CharChecker(i);
    }

    private static void parseLabels(InputStream inputStream, StringBuilder stringBuilder, List<MetricFamily.Label> labelList) throws IOException, FormatException {
        int i;
        do {
            CharChecker charChecker = OnlineParser.parseLabel(inputStream, stringBuilder, labelList);
            if (charChecker.i != 125) continue;
            return;
        } while ((i = OnlineParser.skipSpaces(inputStream).maybeSpace().maybeComma().maybeRightBracket().noElse()) != 125);
    }

    private static CharChecker parseMetric(InputStream inputStream, Map<String, MetricFamily> metricFamilyMap, StringBuilder stringBuilder) throws IOException, FormatException {
        MetricFamily metricFamily;
        MetricFamily.Metric metric = new MetricFamily.Metric();
        int i = OnlineParser.parseMetricName(inputStream, stringBuilder).maybeSpace().maybeLeftBracket().noElse();
        String metricName = stringBuilder.toString();
        stringBuilder.delete(0, stringBuilder.length());
        if (!metricFamilyMap.containsKey(metricName)) {
            metricFamily = new MetricFamily();
            metricFamily.setMetricList(new ArrayList<MetricFamily.Metric>());
            metricFamily.setName(metricName);
            metricFamilyMap.put(metricName, metricFamily);
        } else {
            metricFamily = metricFamilyMap.get(metricName);
        }
        if (i == 32) {
            i = OnlineParser.skipSpaces(inputStream).getInt();
        }
        LinkedList<MetricFamily.Label> labelList = new LinkedList<MetricFamily.Label>();
        metric.setLabels(labelList);
        if (i == 123) {
            OnlineParser.parseLabels(inputStream, stringBuilder, labelList);
            i = OnlineParser.skipSpaces(inputStream).getInt();
        }
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append((char)i);
        i = OnlineParser.parseOneDouble(inputStream, stringBuilder).maybeSpace().maybeEol().maybeEof().noElse();
        metric.setValue(OnlineParser.toDouble(stringBuilder.toString()));
        if (i == 10 || i == -1) {
            metricFamily.getMetricList().add(metric);
            return new CharChecker(i);
        }
        i = OnlineParser.skipSpaces(inputStream).getInt();
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append((char)i);
        i = OnlineParser.skipOneLong(inputStream).maybeSpace().maybeEol().maybeEof().noElse();
        if (i == 10 || i == -1) {
            metricFamily.getMetricList().add(metric);
            return new CharChecker(i);
        }
        i = OnlineParser.skipSpaces(inputStream).maybeEol().maybeEof().noElse();
        metricFamily.getMetricList().add(metric);
        return new CharChecker(i);
    }

    static {
        escapeMap.put(110, 10);
        escapeMap.put(98, 8);
        escapeMap.put(116, 9);
        escapeMap.put(114, 13);
        escapeMap.put(102, 12);
        escapeMap.put(39, 39);
        escapeMap.put(34, 34);
        escapeMap.put(92, 92);
    }

    private static class CharChecker {
        int i;
        boolean satisfied;

        CharChecker(int i) {
            this.i = i;
            this.satisfied = false;
        }

        private CharChecker maybeLeftBracket() {
            if (this.i == 123) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeRightBracket() {
            if (this.i == 125) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeEqualsSign() {
            if (this.i == 61) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeQuotationMark() {
            if (this.i == 34) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeSpace() {
            if (this.i == 32) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeComma() {
            if (this.i == 44) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeEof() {
            if (this.i == -1) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeEol() {
            if (this.i == 10) {
                this.satisfied = true;
            }
            return this;
        }

        private int noElse() throws FormatException {
            if (!this.satisfied) {
                throw new FormatException();
            }
            return this.i;
        }

        private int getInt() {
            return this.i;
        }
    }

    private static class FormatException
    extends Exception {
        public FormatException() {
        }

        public FormatException(String message) {
            super(message);
        }
    }
}

