/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.FactoryProvider;
import io.questdb.ServerConfiguration;
import io.questdb.ServerMain;
import io.questdb.cairo.DefaultWalJobFactory;
import io.questdb.cairo.WalJobFactory;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.cutlass.auth.LineAuthenticatorFactory;
import io.questdb.cutlass.http.DefaultHttpCookieHandler;
import io.questdb.cutlass.http.DefaultHttpHeaderParserFactory;
import io.questdb.cutlass.http.HttpAuthenticatorFactory;
import io.questdb.cutlass.http.HttpCookieHandler;
import io.questdb.cutlass.pgwire.DefaultPGAuthenticatorFactory;
import io.questdb.cutlass.pgwire.PGAuthenticatorFactory;
import io.questdb.network.PlainSocketFactory;
import io.questdb.network.SocketFactory;
import org.jetbrains.annotations.NotNull;

public class FactoryProviderImpl
implements FactoryProvider {
    private final DefaultWalJobFactory defaultWalJobFactory = new DefaultWalJobFactory();
    private final HttpAuthenticatorFactory httpAuthenticatorFactory;
    private final LineAuthenticatorFactory lineAuthenticatorFactory;
    private final PGAuthenticatorFactory pgAuthenticatorFactory;
    private final SecurityContextFactory securityContextFactory;

    public FactoryProviderImpl(ServerConfiguration configuration) {
        this.lineAuthenticatorFactory = ServerMain.getLineAuthenticatorFactory(configuration);
        this.securityContextFactory = ServerMain.getSecurityContextFactory(configuration);
        this.pgAuthenticatorFactory = new DefaultPGAuthenticatorFactory(configuration);
        this.httpAuthenticatorFactory = ServerMain.getHttpAuthenticatorFactory(configuration);
    }

    @Override
    @NotNull
    public HttpAuthenticatorFactory getHttpAuthenticatorFactory() {
        return this.httpAuthenticatorFactory;
    }

    @Override
    @NotNull
    public HttpCookieHandler getHttpCookieHandler() {
        return DefaultHttpCookieHandler.INSTANCE;
    }

    @Override
    @NotNull
    public DefaultHttpHeaderParserFactory getHttpHeaderParserFactory() {
        return DefaultHttpHeaderParserFactory.INSTANCE;
    }

    @Override
    @NotNull
    public SocketFactory getHttpMinSocketFactory() {
        return PlainSocketFactory.INSTANCE;
    }

    @Override
    @NotNull
    public SocketFactory getHttpSocketFactory() {
        return PlainSocketFactory.INSTANCE;
    }

    @Override
    @NotNull
    public LineAuthenticatorFactory getLineAuthenticatorFactory() {
        return this.lineAuthenticatorFactory;
    }

    @Override
    @NotNull
    public SocketFactory getLineSocketFactory() {
        return PlainSocketFactory.INSTANCE;
    }

    @Override
    @NotNull
    public SocketFactory getPGWireSocketFactory() {
        return PlainSocketFactory.INSTANCE;
    }

    @Override
    @NotNull
    public PGAuthenticatorFactory getPgWireAuthenticatorFactory() {
        return this.pgAuthenticatorFactory;
    }

    @Override
    @NotNull
    public SecurityContextFactory getSecurityContextFactory() {
        return this.securityContextFactory;
    }

    @Override
    @NotNull
    public WalJobFactory getWalJobFactory() {
        return this.defaultWalJobFactory;
    }
}

