/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.ConfigReloader;
import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.Metrics;
import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CursorPrinter;
import io.questdb.cairo.DataID;
import io.questdb.cairo.DatabaseCheckpointAgent;
import io.questdb.cairo.DatabaseCheckpointStatus;
import io.questdb.cairo.DdlListener;
import io.questdb.cairo.DefaultDdlListener;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.IDGeneratorFactory;
import io.questdb.cairo.MetadataCache;
import io.questdb.cairo.MetadataCacheWriter;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.PartitionOverwriteControl;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableConverter;
import io.questdb.cairo.TableFlagResolver;
import io.questdb.cairo.TableFlagResolverImpl;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableNameRegistryRO;
import io.questdb.cairo.TableNameRegistryRW;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.TxnScoreboardPool;
import io.questdb.cairo.TxnScoreboardPoolFactory;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.frm.file.FrameFactory;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewGraph;
import io.questdb.cairo.mv.MatViewRefreshTask;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateReader;
import io.questdb.cairo.mv.MatViewStateStore;
import io.questdb.cairo.mv.MatViewStateStoreImpl;
import io.questdb.cairo.mv.MatViewTimerTask;
import io.questdb.cairo.mv.NoOpMatViewStateStore;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.cairo.pool.SequencerMetadataPool;
import io.questdb.cairo.pool.SqlCompilerPool;
import io.questdb.cairo.pool.TableMetadataPool;
import io.questdb.cairo.pool.WalWriterPool;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.security.AllowAllSecurityContext;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.DefaultWalDirectoryPolicy;
import io.questdb.cairo.wal.DefaultWalListener;
import io.questdb.cairo.wal.WalDirectoryPolicy;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.WalListener;
import io.questdb.cairo.wal.WalReader;
import io.questdb.cairo.wal.WalUtils;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cutlass.text.CopyContext;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionFactoryCacheBuilder;
import io.questdb.griffin.QueryRegistry;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlCompilerFactory;
import io.questdb.griffin.SqlCompilerFactoryImpl;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.engine.ops.CreateMatViewOperation;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.ConcurrentQueue;
import io.questdb.mp.Job;
import io.questdb.mp.MPSequence;
import io.questdb.mp.NoOpQueue;
import io.questdb.mp.Queue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SimpleWaitingLock;
import io.questdb.mp.SynchronizedJob;
import io.questdb.preferences.SettingsStore;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.ThreadLocal;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.MutableCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.AbstractTelemetryTask;
import io.questdb.tasks.TelemetryMatViewTask;
import io.questdb.tasks.TelemetryTask;
import io.questdb.tasks.TelemetryWalTask;
import io.questdb.tasks.WalTxnNotificationTask;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CairoEngine
implements Closeable,
WriterSource {
    public static final String REASON_BUSY_READER = "busyReader";
    public static final String REASON_BUSY_SEQUENCER_METADATA_POOL = "busySequencerMetaPool";
    public static final String REASON_BUSY_TABLE_READER_METADATA_POOL = "busyTableReaderMetaPool";
    public static final String REASON_CHECKPOINT_IN_PROGRESS = "checkpointInProgress";
    private static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private static final int MAX_SLEEP_MILLIS = 250;
    private static final ThreadLocal<MatViewRefreshTask> tlMatViewRefreshTask = new ThreadLocal<MatViewRefreshTask>(MatViewRefreshTask::new);
    protected final CairoConfiguration configuration;
    private final AtomicLong asyncCommandCorrelationId = new AtomicLong();
    private final DatabaseCheckpointAgent checkpointAgent;
    private final CopyContext copyContext;
    private final ConcurrentHashMap<TableToken> createTableLock = new ConcurrentHashMap();
    private final DataID dataID;
    private final EngineMaintenanceJob engineMaintenanceJob;
    private final FunctionFactoryCache ffCache;
    private final MatViewGraph matViewGraph;
    private final Queue<MatViewTimerTask> matViewTimerQueue;
    private final MessageBusImpl messageBus;
    private final MetadataCache metadataCache;
    private final Metrics metrics;
    private final PartitionOverwriteControl partitionOverwriteControl = new PartitionOverwriteControl();
    private final QueryRegistry queryRegistry;
    private final ReaderPool readerPool;
    private final SqlExecutionContext rootExecutionContext;
    private final TxnScoreboardPool scoreboardPool;
    private final SequencerMetadataPool sequencerMetadataPool;
    private final SettingsStore settingsStore;
    private final SqlCompilerPool sqlCompilerPool;
    private final TableFlagResolver tableFlagResolver;
    private final IDGenerator tableIdGenerator;
    private final TableMetadataPool tableMetadataPool;
    private final TableNameRegistry tableNameRegistry;
    private final TableSequencerAPI tableSequencerAPI;
    private final ObjList<Telemetry<? extends AbstractTelemetryTask>> telemetries;
    private final Telemetry<TelemetryTask> telemetry;
    private final Telemetry<TelemetryMatViewTask> telemetryMatView;
    private final Telemetry<TelemetryWalTask> telemetryWal;
    private final AtomicLong unpublishedWalTxnCount = new AtomicLong(1L);
    private final WalWriterPool walWriterPool;
    private final WriterPool writerPool;
    @NotNull
    private ConfigReloader configReloader = () -> false;
    @NotNull
    private DdlListener ddlListener = DefaultDdlListener.INSTANCE;
    private FrameFactory frameFactory;
    @NotNull
    private MatViewStateStore matViewStateStore = NoOpMatViewStateStore.INSTANCE;
    @NotNull
    private WalDirectoryPolicy walDirectoryPolicy = DefaultWalDirectoryPolicy.INSTANCE;
    @NotNull
    private WalListener walListener = DefaultWalListener.INSTANCE;

    public CairoEngine(CairoConfiguration configuration) {
        try {
            this.ffCache = new FunctionFactoryCache(configuration, this.getFunctionFactories());
            this.tableFlagResolver = this.newTableFlagResolver(configuration);
            this.configuration = configuration;
            this.copyContext = new CopyContext(configuration);
            this.tableSequencerAPI = new TableSequencerAPI(this, configuration);
            this.messageBus = new MessageBusImpl(configuration);
            this.metrics = configuration.getMetrics();
            this.writerPool = new WriterPool(configuration, this);
            this.scoreboardPool = TxnScoreboardPoolFactory.createPool(configuration);
            this.readerPool = new ReaderPool(configuration, this.scoreboardPool, this.messageBus, this.partitionOverwriteControl);
            this.sequencerMetadataPool = new SequencerMetadataPool(configuration, this);
            this.tableMetadataPool = new TableMetadataPool(configuration);
            this.walWriterPool = new WalWriterPool(configuration, this);
            this.engineMaintenanceJob = new EngineMaintenanceJob(configuration);
            this.telemetry = this.createTelemetry(TelemetryTask.TELEMETRY, configuration);
            this.telemetryWal = this.createTelemetry(TelemetryWalTask.WAL_TELEMETRY, configuration);
            this.telemetryMatView = this.createTelemetry(TelemetryMatViewTask.MAT_VIEW_TELEMETRY, configuration);
            this.telemetries = new ObjList<Telemetry>(this.telemetry, this.telemetryWal, this.telemetryMatView);
            this.tableIdGenerator = IDGeneratorFactory.newIDGenerator(configuration, "_tab_index.d", 1);
            this.checkpointAgent = new DatabaseCheckpointAgent(this);
            this.queryRegistry = new QueryRegistry(configuration);
            this.rootExecutionContext = this.createRootExecutionContext();
            this.matViewTimerQueue = this.createMatViewTimerQueue();
            this.matViewGraph = new MatViewGraph();
            this.frameFactory = new FrameFactory(configuration);
            this.dataID = DataID.open(configuration);
            this.settingsStore = new SettingsStore(configuration);
            this.settingsStore.init();
            this.tableIdGenerator.open();
            this.checkpointRecover();
            EngineMigration.migrateEngineTo(this, 426, 427, false);
            this.tableNameRegistry = configuration.isReadOnlyInstance() ? new TableNameRegistryRO(this, this.tableFlagResolver) : new TableNameRegistryRW(this, this.tableFlagResolver);
            this.tableNameRegistry.reload();
            this.sqlCompilerPool = new SqlCompilerPool(this);
            if (configuration.isPartitionO3OverwriteControlEnabled()) {
                this.enablePartitionOverwriteControl();
            }
            this.metadataCache = new MetadataCache(this);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static void execute(SqlCompiler compiler, CharSequence sqlText, SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        CompiledQuery cq = compiler.compile(sqlText, sqlExecutionContext);
        switch (cq.getType()) {
            case 7: 
            case 9: 
            case 21: 
            case 32: {
                assert (sqlExecutionContext.getCairoEngine() == compiler.getEngine());
                try (Operation op = cq.getOperation();){
                    assert (op != null);
                    try (OperationFuture fut = op.execute(sqlExecutionContext, null);){
                        fut.await();
                        break;
                    }
                }
            }
            case 2: 
            case 10: {
                CairoEngine.insert(cq, sqlExecutionContext);
                break;
            }
            case 1: {
                throw SqlException.$(0, "use select()");
            }
            default: {
                try (OperationFuture future = cq.execute(eventSubSeq);){
                    future.await();
                    break;
                }
            }
        }
    }

    public static RecordCursorFactory select(SqlCompiler compiler, CharSequence selectSql, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return compiler.compile(selectSql, sqlExecutionContext).getRecordCursorFactory();
    }

    public void applyTableRename(TableToken token, TableToken updatedTableToken) {
        this.tableNameRegistry.rename(token.getTableName(), updatedTableToken.getTableName(), token);
        if (token.isWal()) {
            this.tableSequencerAPI.applyRename(updatedTableToken);
        }
        if (updatedTableToken.isMatView()) {
            this.matViewGraph.updateToken(updatedTableToken);
        }
    }

    public void attachReader(TableReader reader) {
        this.readerPool.attach(reader);
    }

    public void awaitTable(String tableName, long timeout, TimeUnit timeoutUnit) {
        this.awaitTxn(tableName, -1L, timeout, timeoutUnit);
    }

    public void awaitTxn(String tableName, long txn, long timeout, TimeUnit timeoutUnit) {
        long startTime = this.configuration.getMillisecondClock().getTicks();
        long maxWait = timeoutUnit.toMillis(timeout);
        int sleep = 10;
        TableToken tableToken = null;
        long seqTxn = txn;
        long writerTxn = -1L;
        while (this.configuration.getMillisecondClock().getTicks() - startTime < maxWait) {
            if (tableToken == null) {
                try {
                    tableToken = this.verifyTableName(tableName);
                }
                catch (CairoException ex) {
                    Os.sleep(sleep);
                    sleep = Math.min(250, sleep * 2);
                    continue;
                }
            }
            if (tableToken == null) continue;
            if ((seqTxn = seqTxn > -1L ? seqTxn : this.getTableSequencerAPI().getTxnTracker(tableToken).getSeqTxn()) <= (writerTxn = this.getTableSequencerAPI().getTxnTracker(tableToken).getWriterTxn())) {
                return;
            }
            boolean isSuspended = this.getTableSequencerAPI().isSuspended(tableToken);
            if (isSuspended) {
                throw CairoException.nonCritical().put("table is suspended [tableName=").put(tableName).put(']');
            }
            Os.sleep(sleep);
            sleep = Math.min(250, sleep * 2);
        }
        throw CairoException.nonCritical().put("txn timed out [table=").put(tableName).put(", expectedTxn=").put(seqTxn).put(", writerTxn=").put(writerTxn);
    }

    public void buildMatViewGraph() {
        ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet<TableToken>();
        this.getTableTokens(tableTokenBucket, false);
        try (Path path = new Path();
             BlockFileReader reader = new BlockFileReader(this.configuration);
             WalEventReader walEventReader = new WalEventReader(this.configuration.getFilesFacade());
             MemoryCMR txnMem = Vm.getCMRInstance();){
            path.of(this.configuration.getDbRoot());
            int pathLen = path.size();
            MatViewStateReader matViewStateReader = new MatViewStateReader();
            int n = tableTokenBucket.size();
            for (int i = 0; i < n; ++i) {
                TableToken tableToken = tableTokenBucket.get(i);
                if (!tableToken.isMatView() || !TableUtils.isMatViewDefinitionFileExists(this.configuration, path, tableToken.getDirName())) continue;
                try {
                    boolean baseTableExists;
                    MatViewState state;
                    MatViewDefinition viewDefinition = this.matViewGraph.getViewDefinition(tableToken);
                    if (viewDefinition == null) {
                        viewDefinition = new MatViewDefinition();
                        MatViewDefinition.readFrom(viewDefinition, reader, path, pathLen, tableToken);
                        if (this.matViewGraph.addView(viewDefinition)) {
                            this.matViewStateStore.createViewState(viewDefinition);
                        }
                    }
                    if ((state = this.matViewStateStore.getViewState(tableToken)) == null) continue;
                    TableToken baseTableToken = this.tableNameRegistry.getTableToken(viewDefinition.getBaseTableName());
                    boolean bl = baseTableExists = baseTableToken != null && !this.tableNameRegistry.isTableDropped(baseTableToken);
                    if (!baseTableExists) {
                        LOG.info().$("base table for materialized view does not exist [table=").$safe(viewDefinition.getBaseTableName()).$(", view=").$(tableToken).I$();
                        this.matViewStateStore.enqueueInvalidate(tableToken, "base table does not exist");
                        continue;
                    }
                    if (!baseTableToken.isWal()) {
                        LOG.info().$("base table for materialized view is not WAL table [table=").$safe(viewDefinition.getBaseTableName()).$(", view=").$(tableToken).I$();
                        this.matViewStateStore.enqueueInvalidate(tableToken, "base table is not WAL table");
                        continue;
                    }
                    path.trimTo(pathLen).concat(tableToken);
                    if (!WalUtils.readMatViewState(path, tableToken, this.configuration, txnMem, walEventReader, reader, matViewStateReader)) {
                        LOG.info().$("could not find materialized view state, default values will be used [table=").$safe(viewDefinition.getBaseTableName()).$(", view=").$(tableToken).I$();
                        continue;
                    }
                    state.initFromReader(matViewStateReader);
                    if (state.isInvalid()) continue;
                    long baseTableLastTxn = this.getTableSequencerAPI().lastTxn(baseTableToken);
                    if (state.getLastRefreshBaseTxn() > baseTableLastTxn) {
                        LOG.info().$("materialized view is ahead of base table and cannot be synchronized [table=").$safe(viewDefinition.getBaseTableName()).$(", view=").$(tableToken).$(", matViewBaseTxn=").$(state.getLastRefreshBaseTxn()).$(", baseTableTxn=").$(baseTableLastTxn).I$();
                        this.matViewStateStore.enqueueInvalidate(tableToken, "materialized view is ahead of base table and cannot be synchronized");
                        continue;
                    }
                    if (viewDefinition.getRefreshType() != 0) continue;
                    this.matViewStateStore.enqueueIncrementalRefresh(tableToken);
                    continue;
                }
                catch (Throwable th) {
                    LogRecord rec = LOG.error().$("could not load materialized view [view=").$(tableToken);
                    if (th instanceof CairoException) {
                        CairoException ce = (CairoException)th;
                        rec.$(", msg=").$safe(ce.getFlyweightMessage()).$(", errno=").$(ce.getErrno());
                    } else {
                        rec.$(", msg=").$safe(th.getMessage());
                    }
                    rec.I$();
                }
            }
        }
    }

    public void checkpointCreate(SqlExecutionContext executionContext) throws SqlException {
        this.checkpointAgent.checkpointCreate(executionContext, false);
    }

    public final void checkpointRecover() {
        this.checkpointAgent.recover();
    }

    public void checkpointRelease() throws SqlException {
        this.checkpointAgent.checkpointRelease();
    }

    public boolean clear() {
        this.checkpointAgent.clear();
        this.messageBus.clear();
        try (MetadataCacheWriter w = this.getMetadataCache().writeLock();){
            w.clearCache();
        }
        this.matViewGraph.clear();
        this.matViewStateStore.clear();
        this.matViewTimerQueue.clear();
        boolean b1 = this.readerPool.releaseAll();
        boolean b2 = this.writerPool.releaseAll();
        boolean b3 = this.tableSequencerAPI.releaseAll();
        boolean b4 = this.sequencerMetadataPool.releaseAll();
        boolean b5 = this.walWriterPool.releaseAll();
        boolean b6 = this.tableMetadataPool.releaseAll();
        this.scoreboardPool.clear();
        this.partitionOverwriteControl.clear();
        this.frameFactory.clear();
        return b1 & b2 & b3 & b4 & b5 & b6;
    }

    @Override
    public void close() {
        Misc.free(this.sqlCompilerPool);
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
        Misc.free(this.sequencerMetadataPool);
        Misc.free(this.tableMetadataPool);
        Misc.free(this.walWriterPool);
        Misc.free(this.tableIdGenerator);
        Misc.free(this.messageBus);
        Misc.free(this.tableSequencerAPI);
        Misc.freeObjList(this.telemetries);
        Misc.free(this.tableNameRegistry);
        Misc.free(this.checkpointAgent);
        Misc.free(this.metadataCache);
        Misc.free(this.scoreboardPool);
        Misc.free(this.matViewStateStore);
        Misc.free(this.settingsStore);
        Misc.free(this.frameFactory);
    }

    public void closeNameRegistry() {
        this.tableNameRegistry.close();
    }

    public void configureThreadLocalReaderPoolSupervisor(@NotNull ResourcePoolSupervisor<ReaderPool.R> supervisor) {
        this.readerPool.configureThreadLocalPoolSupervisor(supervisor);
    }

    @NotNull
    public MatViewDefinition createMatView(SecurityContext securityContext, MemoryMARW mem, BlockFileWriter blockFileWriter, Path path, boolean ifNotExists, CreateMatViewOperation struct, boolean keepLock, boolean inVolume) {
        securityContext.authorizeMatViewCreate();
        TableToken matViewToken = this.createTableOrMatViewUnsecure(mem, blockFileWriter, path, ifNotExists, struct, keepLock, inVolume);
        this.getDdlListener(matViewToken).onTableOrMatViewCreated(securityContext, matViewToken);
        MatViewDefinition matViewDefinition = struct.getMatViewDefinition();
        try {
            if (this.matViewGraph.addView(matViewDefinition)) {
                this.matViewStateStore.createViewState(matViewDefinition);
                if (!matViewDefinition.isDeferred()) {
                    this.matViewStateStore.enqueueIncrementalRefresh(matViewToken);
                }
            }
        }
        catch (CairoException e) {
            this.dropTableOrMatView(path, matViewToken);
            throw e;
        }
        return matViewDefinition;
    }

    @NotNull
    public TableToken createTable(SecurityContext securityContext, MemoryMARW mem, Path path, boolean ifNotExists, TableStructure struct, boolean keepLock) {
        return this.createTable(securityContext, mem, path, ifNotExists, struct, keepLock, false);
    }

    @NotNull
    public TableToken createTable(SecurityContext securityContext, MemoryMARW mem, Path path, boolean ifNotExists, TableStructure struct, boolean keepLock, boolean inVolume) {
        securityContext.authorizeTableCreate();
        TableToken tableToken = this.createTableOrMatViewUnsecure(mem, null, path, ifNotExists, struct, keepLock, inVolume);
        this.getDdlListener(tableToken).onTableOrMatViewCreated(securityContext, tableToken);
        return tableToken;
    }

    public void detachReader(TableReader reader) {
        this.readerPool.detach(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrMatView(Path path, TableToken tableToken) {
        this.verifyTableToken(tableToken);
        if (tableToken.isWal()) {
            if (this.notifyDropped(tableToken)) {
                this.tableSequencerAPI.dropTable(tableToken, false);
                this.matViewStateStore.removeViewState(tableToken);
                this.matViewGraph.removeView(tableToken);
            } else {
                LOG.info().$("table is already dropped [table=").$(tableToken).I$();
            }
        } else {
            String lockedReason = this.lockAll(tableToken, "removeTable", false);
            this.scoreboardPool.remove(tableToken);
            if (lockedReason == null) {
                try {
                    path.of(this.configuration.getDbRoot()).concat(tableToken).$();
                    if (!this.configuration.getFilesFacade().unlinkOrRemove(path, LOG)) {
                        throw CairoException.critical(this.configuration.getFilesFacade().errno()).put("could not remove table [table=").put(tableToken).put(']');
                    }
                }
                finally {
                    this.unlockTableUnsafe(tableToken, null, false);
                }
                this.tableNameRegistry.dropTable(tableToken);
                return;
            }
            throw CairoException.nonCritical().put("could not lock '").put(tableToken).put("' [reason='").put(lockedReason).put("']");
        }
    }

    public void enablePartitionOverwriteControl() {
        LOG.info().$("partition overwrite control is enabled").$();
        this.partitionOverwriteControl.enable();
    }

    public void execute(CharSequence sqlText) throws SqlException {
        this.execute(sqlText, this.rootExecutionContext);
    }

    public void execute(CharSequence sqlText, SqlExecutionContext sqlExecutionContext) throws SqlException {
        this.execute(sqlText, sqlExecutionContext, null);
    }

    public void execute(CharSequence sqlText, SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        while (true) {
            try (SqlCompiler compiler = this.getSqlCompiler();){
                CairoEngine.execute(compiler, sqlText, sqlExecutionContext, eventSubSeq);
                return;
            }
            catch (TableReferenceOutOfDateException tableReferenceOutOfDateException) {
                continue;
            }
            break;
        }
    }

    public TableWriter getBackupWriter(TableToken tableToken, CharSequence backupDirName) {
        this.verifyTableToken(tableToken);
        return new TableWriter(this.configuration, tableToken, this.messageBus, null, true, DefaultLifecycleManager.INSTANCE, backupDirName, this.getDdlListener(tableToken), this.checkpointAgent, this);
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public DatabaseCheckpointStatus getCheckpointStatus() {
        return this.checkpointAgent;
    }

    public long getCommandCorrelationId() {
        return this.asyncCommandCorrelationId.incrementAndGet();
    }

    @NotNull
    public ConfigReloader getConfigReloader() {
        return this.configReloader;
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public CopyContext getCopyContext() {
        return this.copyContext;
    }

    public DataID getDataID() {
        return this.dataID;
    }

    @NotNull
    public DdlListener getDdlListener(TableToken tableToken) {
        return this.tableFlagResolver.isSystem(tableToken.getTableName()) ? DefaultDdlListener.INSTANCE : this.ddlListener;
    }

    public Job getEngineMaintenanceJob() {
        return this.engineMaintenanceJob;
    }

    public FrameFactory getFrameFactory() {
        return this.frameFactory;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.ffCache;
    }

    public TableRecordMetadata getLegacyMetadata(TableToken tableToken) {
        return this.getLegacyMetadata(tableToken, -1L);
    }

    public TableRecordMetadata getLegacyMetadata(TableToken tableToken, long desiredVersion) {
        if (!tableToken.isWal()) {
            return this.getTableMetadata(tableToken, desiredVersion);
        }
        return this.getSequencerMetadata(tableToken, desiredVersion);
    }

    @NotNull
    public MatViewGraph getMatViewGraph() {
        return this.matViewGraph;
    }

    @NotNull
    public MatViewStateStore getMatViewStateStore() {
        return this.matViewStateStore;
    }

    public Queue<MatViewTimerTask> getMatViewTimerQueue() {
        return this.matViewTimerQueue;
    }

    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public MetadataCache getMetadataCache() {
        return this.metadataCache;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getNextTableId() {
        return (int)this.tableIdGenerator.getNextId();
    }

    public PartitionOverwriteControl getPartitionOverwriteControl() {
        return this.partitionOverwriteControl;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public QueryRegistry getQueryRegistry() {
        return this.queryRegistry;
    }

    public TableReader getReader(CharSequence tableName) {
        TableToken tableToken = this.verifyTableNameForRead(tableName);
        return (TableReader)this.readerPool.get(tableToken);
    }

    public TableReader getReader(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return (TableReader)this.readerPool.get(tableToken);
    }

    public TableReader getReader(TableToken tableToken, long metadataVersion) {
        this.verifyTableToken(tableToken);
        int tableId = tableToken.getTableId();
        TableReader reader = (TableReader)this.readerPool.get(tableToken);
        if (metadataVersion > -1L && reader.getMetadataVersion() != metadataVersion || tableId > -1 && reader.getMetadata().getTableId() != tableId) {
            TableReferenceOutOfDateException ex = TableReferenceOutOfDateException.of(tableToken, tableId, reader.getMetadata().getTableId(), metadataVersion, reader.getMetadataVersion());
            reader.close();
            throw ex;
        }
        return reader;
    }

    public TableReader getReaderAtTxn(TableReader srcReader) {
        assert (srcReader.isOpen() && srcReader.isActive());
        if (this.readerPool.isDetached(srcReader) && this.readerPool.getDetachedRefCount(srcReader) == 0) {
            this.readerPool.incDetachedRefCount(srcReader);
            return srcReader;
        }
        return this.readerPool.getCopyOf(srcReader);
    }

    public Map<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>> getReaderPoolEntries() {
        return this.readerPool.entries();
    }

    public TableReader getReaderWithRepair(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        try {
            return this.getReader(tableToken);
        }
        catch (CairoException e) {
            this.tryRepairTable(tableToken, e);
            try {
                return this.getReader(tableToken);
            }
            catch (CairoException e2) {
                LOG.critical().$("could not open reader [table=").$(tableToken).$(", msg=").$safe(e2.getFlyweightMessage()).$(", errno=").$(e2.getErrno()).I$();
                throw e2;
            }
        }
    }

    public TableRecordMetadata getSequencerMetadata(TableToken tableToken) {
        return this.getSequencerMetadata(tableToken, -1L);
    }

    public TableRecordMetadata getSequencerMetadata(TableToken tableToken, long desiredVersion) {
        assert (tableToken.isWal());
        this.verifyTableToken(tableToken);
        TableRecordMetadata metadata = (TableRecordMetadata)this.sequencerMetadataPool.get(tableToken);
        this.validateDesiredMetadataVersion(tableToken, metadata, desiredVersion);
        return metadata;
    }

    @NotNull
    public SettingsStore getSettingsStore() {
        return this.settingsStore;
    }

    public SqlCompiler getSqlCompiler() {
        return this.sqlCompilerPool.get();
    }

    public SqlCompilerFactory getSqlCompilerFactory() {
        return SqlCompilerFactoryImpl.INSTANCE;
    }

    public TableFlagResolver getTableFlagResolver() {
        return this.tableFlagResolver;
    }

    public IDGenerator getTableIdGenerator() {
        return this.tableIdGenerator;
    }

    public TableMetadata getTableMetadata(TableToken tableToken) {
        return this.getTableMetadata(tableToken, -1L);
    }

    public TableMetadata getTableMetadata(TableToken tableToken, long desiredVersion) {
        this.verifyTableToken(tableToken);
        try {
            TableMetadata metadata = (TableMetadata)this.tableMetadataPool.get(tableToken);
            this.validateDesiredMetadataVersion(tableToken, metadata, desiredVersion);
            return metadata;
        }
        catch (CairoException e) {
            if (tableToken.isWal()) {
                throw e;
            }
            this.tryRepairTable(tableToken, e);
            TableMetadata metadata = (TableMetadata)this.tableMetadataPool.get(tableToken);
            this.validateDesiredMetadataVersion(tableToken, metadata, desiredVersion);
            return metadata;
        }
    }

    public TableSequencerAPI getTableSequencerAPI() {
        return this.tableSequencerAPI;
    }

    public int getTableStatus(Path path, TableToken tableToken) {
        if (tableToken == TableNameRegistry.LOCKED_TOKEN) {
            return 2;
        }
        if (tableToken == TableNameRegistry.LOCKED_DROP_TOKEN) {
            return 1;
        }
        if (tableToken == null || !tableToken.equals(this.tableNameRegistry.getTableToken(tableToken.getTableName()))) {
            return 1;
        }
        return TableUtils.exists(this.configuration.getFilesFacade(), path, (CharSequence)this.configuration.getDbRoot(), tableToken.getDirName());
    }

    public int getTableStatus(Path path, CharSequence tableName) {
        TableToken tableToken = this.tableNameRegistry.getTableToken(tableName);
        if (tableToken == null) {
            return 1;
        }
        return this.getTableStatus(path, tableToken);
    }

    public int getTableStatus(CharSequence tableName) {
        return this.getTableStatus(Path.getThreadLocal(this.configuration.getDbRoot()), tableName);
    }

    public TableToken getTableTokenByDirName(CharSequence dirName) {
        return this.tableNameRegistry.getTableTokenByDirName(dirName);
    }

    public int getTableTokenCount(boolean includeDropped) {
        return this.tableNameRegistry.getTableTokenCount(includeDropped);
    }

    public TableToken getTableTokenIfExists(CharSequence tableName) {
        TableToken token = this.tableNameRegistry.getTableToken(tableName);
        if (TableNameRegistry.isLocked(token)) {
            return null;
        }
        return token;
    }

    public TableToken getTableTokenIfExists(CharSequence tableName, int lo, int hi) {
        StringSink sink = Misc.getThreadLocalSink();
        sink.put(tableName, lo, hi);
        return this.getTableTokenIfExists(sink);
    }

    public void getTableTokens(ObjHashSet<TableToken> bucket, boolean includeDropped) {
        this.tableNameRegistry.getTableTokens(bucket, includeDropped);
    }

    @Override
    public TableWriterAPI getTableWriterAPI(TableToken tableToken, @NotNull String lockReason) {
        this.verifyTableToken(tableToken);
        if (!tableToken.isWal()) {
            return this.writerPool.get(tableToken, lockReason);
        }
        return (TableWriterAPI)this.walWriterPool.get(tableToken);
    }

    @Override
    public TableWriterAPI getTableWriterAPI(CharSequence tableName, @NotNull String lockReason) {
        TableToken tableToken = this.verifyTableNameForRead(tableName);
        if (!tableToken.isWal()) {
            return this.writerPool.get(tableToken, lockReason);
        }
        return (TableWriterAPI)this.walWriterPool.get(tableToken);
    }

    public ObjList<Telemetry<? extends AbstractTelemetryTask>> getTelemetries() {
        return this.telemetries;
    }

    public Telemetry<TelemetryTask> getTelemetry() {
        return this.telemetry;
    }

    public Telemetry<TelemetryMatViewTask> getTelemetryMatView() {
        return this.telemetryMatView;
    }

    public Telemetry<TelemetryWalTask> getTelemetryWal() {
        return this.telemetryWal;
    }

    public TxnScoreboard getTxnScoreboard(@NotNull TableToken tableToken) {
        return this.scoreboardPool.getTxnScoreboard(tableToken);
    }

    public TxnScoreboardPool getTxnScoreboardPool() {
        return this.scoreboardPool;
    }

    public long getUnpublishedWalTxnCount() {
        return this.unpublishedWalTxnCount.get();
    }

    public TableToken getUpdatedTableToken(TableToken tableToken) {
        return this.tableNameRegistry.getTokenByDirName(tableToken.getDirName());
    }

    @NotNull
    public WalDirectoryPolicy getWalDirectoryPolicy() {
        return this.walDirectoryPolicy;
    }

    @NotNull
    public WalListener getWalListener() {
        return this.walListener;
    }

    public WalReader getWalReader(SecurityContext securityContext, TableToken tableToken, CharSequence walName, int segmentId, long walRowCount) {
        if (tableToken.isWal()) {
            return new WalReader(this.configuration, tableToken, walName, segmentId, walRowCount);
        }
        throw CairoException.nonCritical().put("WAL reader is not supported for table ").put(tableToken.getTableName());
    }

    @NotNull
    public WalWriter getWalWriter(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return (WalWriter)this.walWriterPool.get(tableToken);
    }

    public TableWriter getWriter(TableToken tableToken, @NotNull String lockReason) {
        this.verifyTableToken(tableToken);
        return this.writerPool.get(tableToken, lockReason);
    }

    public TableWriter getWriterOrPublishCommand(TableToken tableToken, @NotNull AsyncWriterCommand asyncWriterCommand) {
        this.verifyTableToken(tableToken);
        return this.writerPool.getWriterOrPublishCommand(tableToken, asyncWriterCommand.getCommandName(), asyncWriterCommand);
    }

    public Map<CharSequence, WriterPool.Entry> getWriterPoolEntries() {
        return this.writerPool.entries();
    }

    public TableWriter getWriterUnsafe(TableToken tableToken, @NotNull String lockReason) {
        return this.writerPool.get(tableToken, lockReason);
    }

    public boolean isTableDropped(TableToken tableToken) {
        return this.tableNameRegistry.isTableDropped(tableToken);
    }

    public boolean isWalTable(TableToken tableToken) {
        return tableToken.isWal();
    }

    public boolean isWalTableDropped(CharSequence tableDir) {
        return this.tableNameRegistry.isWalTableDropped(tableDir);
    }

    public void load() {
        ObjList<TableToken> convertedTables = TableConverter.convertTables(this, this.tableSequencerAPI, this.tableFlagResolver, this.tableNameRegistry);
        this.tableNameRegistry.reload(convertedTables);
        this.matViewStateStore = this.createMatViewStateStore();
    }

    public String lockAll(TableToken tableToken, String lockReason, boolean ignoreInProgressCheckpoint) {
        String lockedReason;
        assert (lockReason != null);
        if (!ignoreInProgressCheckpoint && this.checkpointAgent.isInProgress()) {
            return REASON_CHECKPOINT_IN_PROGRESS;
        }
        if (this.tableMetadataPool.lock(tableToken)) {
            if (this.sequencerMetadataPool.lock(tableToken)) {
                lockedReason = this.writerPool.lock(tableToken, lockReason);
                if (lockedReason == null) {
                    if (this.readerPool.lock(tableToken)) {
                        LOG.info().$("locked [table=`").$(tableToken).$("`, thread=").$(Thread.currentThread().getId()).I$();
                        return null;
                    }
                    this.writerPool.unlock(tableToken);
                    lockedReason = REASON_BUSY_READER;
                }
                this.sequencerMetadataPool.unlock(tableToken);
            } else {
                lockedReason = REASON_BUSY_SEQUENCER_METADATA_POOL;
            }
            this.tableMetadataPool.unlock(tableToken);
        } else {
            lockedReason = REASON_BUSY_TABLE_READER_METADATA_POOL;
        }
        return lockedReason;
    }

    public boolean lockReaders(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return this.lockReadersByTableToken(tableToken);
    }

    public boolean lockReadersAndMetadata(TableToken tableToken) {
        if (this.checkpointAgent.isInProgress()) {
            return false;
        }
        if (this.readerPool.lock(tableToken)) {
            if (this.tableMetadataPool.lock(tableToken)) {
                return true;
            }
            this.readerPool.unlock(tableToken);
        }
        return false;
    }

    public boolean lockReadersByTableToken(TableToken tableToken) {
        if (this.checkpointAgent.isInProgress()) {
            return false;
        }
        return this.readerPool.lock(tableToken);
    }

    public boolean lockTableCreate(TableToken tableToken) {
        return this.createTableLock.putIfAbsent(tableToken.getTableName(), tableToken) == null;
    }

    public TableToken lockTableName(CharSequence tableName) {
        int tableId = this.getNextTableId();
        return this.lockTableName(tableName, tableId, false, false);
    }

    @Nullable
    public TableToken lockTableName(CharSequence tableName, int tableId, boolean isMatView, boolean isWal) {
        String tableNameStr = Chars.toString(tableName);
        String dirName = TableUtils.getTableDir(this.configuration.mangleTableDirNames(), tableNameStr, tableId, isWal);
        return this.lockTableName(tableNameStr, dirName, tableId, isMatView, isWal);
    }

    @Nullable
    public TableToken lockTableName(CharSequence tableName, String dirName, int tableId, boolean isMatView, boolean isWal) {
        this.validNameOrThrow(tableName);
        String tableNameStr = Chars.toString(tableName);
        return this.tableNameRegistry.lockTableName(tableNameStr, dirName, tableId, isMatView, isWal);
    }

    public boolean notifyDropped(TableToken tableToken) {
        if (this.tableNameRegistry.dropTable(tableToken)) {
            MatViewRefreshTask matViewRefreshTask = tlMatViewRefreshTask.get();
            matViewRefreshTask.clear();
            matViewRefreshTask.baseTableToken = tableToken;
            matViewRefreshTask.operation = 3;
            matViewRefreshTask.invalidationReason = "table drop operation";
            this.notifyMatViewBaseTableCommit(matViewRefreshTask, this.tableSequencerAPI.lastTxn(tableToken));
            return true;
        }
        return false;
    }

    public void notifyMatViewBaseTableCommit(MatViewRefreshTask task, long seqTxn) {
        this.matViewStateStore.notifyBaseTableCommit(task, seqTxn);
    }

    public boolean notifyWalTxnCommitted(@NotNull TableToken tableToken) {
        long cursor;
        MPSequence pubSeq = this.messageBus.getWalTxnNotificationPubSequence();
        do {
            if ((cursor = pubSeq.next()) <= -1L) continue;
            WalTxnNotificationTask task = this.messageBus.getWalTxnNotificationQueue().get(cursor);
            task.of(tableToken);
            pubSeq.done(cursor);
            return true;
        } while (cursor != -1L);
        LOG.info().$("cannot publish WAL notifications, queue is full [current=").$(pubSeq.current()).$(", table=").$(tableToken).I$();
        this.notifyWalTxnRepublisher(tableToken);
        return false;
    }

    public void notifyWalTxnRepublisher(TableToken tableToken) {
        this.tableSequencerAPI.updateWriterTxns(tableToken, -1L, -1L);
        this.unpublishedWalTxnCount.incrementAndGet();
    }

    public void print(CharSequence sql, MutableCharSink<?> sink) throws SqlException {
        this.print(sql, sink, this.rootExecutionContext);
    }

    public void print(CharSequence sql, MutableCharSink<?> sink, SqlExecutionContext executionContext) throws SqlException {
        sink.clear();
        try (RecordCursorFactory factory = this.select(sql, executionContext);
             RecordCursor cursor = factory.getCursor(executionContext);){
            CursorPrinter.println(cursor, factory.getMetadata(), sink);
        }
    }

    public void reconcileTableNameRegistryState() {
        this.tableNameRegistry.reconcile();
    }

    public void registerTableToken(TableToken tableToken) {
        this.tableNameRegistry.registerName(tableToken);
    }

    public boolean releaseAllReaders() {
        boolean b1 = this.sequencerMetadataPool.releaseAll();
        boolean b2 = this.tableMetadataPool.releaseAll();
        return this.readerPool.releaseAll() & b1 & b2;
    }

    public void releaseAllWalWriters() {
        this.walWriterPool.releaseAll();
    }

    public void releaseAllWriters() {
        this.writerPool.releaseAll();
    }

    public boolean releaseInactive() {
        boolean useful = this.writerPool.releaseInactive();
        useful |= this.readerPool.releaseInactive();
        useful |= this.tableSequencerAPI.releaseInactive();
        useful |= this.sequencerMetadataPool.releaseInactive();
        useful |= this.tableMetadataPool.releaseInactive();
        useful |= this.walWriterPool.releaseInactive();
        return useful |= this.scoreboardPool.releaseInactive();
    }

    public void releaseInactiveTableSequencers() {
        this.walWriterPool.releaseInactive();
        this.tableSequencerAPI.releaseInactive();
    }

    public boolean reloadTableNames() {
        return this.reloadTableNames(null);
    }

    public boolean reloadTableNames(@Nullable ObjList<TableToken> convertedTables) {
        return this.tableNameRegistry.reload(convertedTables);
    }

    public void removeTableToken(TableToken tableToken) {
        this.tableNameRegistry.purgeToken(tableToken);
        this.tableSequencerAPI.purgeTxnTracker(tableToken.getDirName());
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent((byte)5, Thread.currentThread().getId(), tableToken, (short)26, (short)0, (short)0);
        }
    }

    public void removeThreadLocalReaderPoolSupervisor() {
        this.readerPool.removeThreadLocalPoolSupervisor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableToken rename(SecurityContext securityContext, Path fromPath, MemoryMARW memory, CharSequence fromTableName, Path toPath, CharSequence toTableName) {
        this.validNameOrThrow(fromTableName);
        this.validNameOrThrow(toTableName);
        TableToken fromTableToken = this.verifyTableName(fromTableName);
        if (Chars.equalsIgnoreCaseNc(fromTableName, toTableName)) {
            return fromTableToken;
        }
        securityContext.authorizeTableRename(fromTableToken);
        if (fromTableToken != null) {
            TableToken toTableToken;
            if (fromTableToken.isWal()) {
                String toTableNameStr = Chars.toString(toTableName);
                toTableToken = this.tableNameRegistry.addTableAlias(toTableNameStr, fromTableToken);
                if (toTableToken != null) {
                    boolean renamed = false;
                    try {
                        try (WalWriter walWriter = this.getWalWriter(fromTableToken);){
                            long seqTxn = walWriter.renameTable(fromTableName, toTableNameStr);
                            LOG.info().$("renaming table [from='").$safe(fromTableName).$("', to='").$safe(toTableName).$("', wal=").$(walWriter.getWalId()).$("', seqTxn=").$(seqTxn).I$();
                            renamed = true;
                        }
                        TableUtils.overwriteTableNameFile(fromPath.of(this.configuration.getDbRoot()).concat(toTableToken), memory, this.configuration.getFilesFacade(), toTableToken.getTableName());
                    }
                    finally {
                        if (renamed) {
                            this.tableNameRegistry.rename(fromTableToken, toTableToken);
                            if (fromTableToken.isWal()) {
                                this.matViewStateStore.enqueueInvalidateDependentViews(fromTableToken, "table rename operation");
                            }
                        } else {
                            LOG.info().$("failed to rename table [from=").$safe(fromTableName).$(", to=").$safe(toTableName).I$();
                            this.tableNameRegistry.removeAlias(toTableToken);
                        }
                    }
                }
                throw CairoException.nonCritical().put("cannot rename table, new name is already in use [table=").put(fromTableName).put(", toTableName=").put(toTableName).put(']');
            }
            String lockedReason = this.lockAll(fromTableToken, "renameTable", false);
            if (lockedReason == null) {
                try {
                    this.scoreboardPool.remove(fromTableToken);
                    toTableToken = this.rename0(fromPath, fromTableToken, toPath, toTableName);
                    TableUtils.overwriteTableNameFile(fromPath.of(this.configuration.getDbRoot()).concat(toTableToken), memory, this.configuration.getFilesFacade(), toTableToken.getTableName());
                }
                finally {
                    this.unlock(securityContext, fromTableToken, null, false);
                }
                this.tableNameRegistry.dropTable(fromTableToken);
            } else {
                LOG.error().$("could not lock and rename [from=").$safe(fromTableName).$("', to=").$safe(toTableName).$("', reason=").$(lockedReason).I$();
                throw EntryUnavailableException.instance(lockedReason);
            }
            this.getDdlListener(fromTableToken).onTableRenamed(securityContext, fromTableToken, toTableToken);
            return toTableToken;
        }
        LOG.error().$("cannot rename, table does not exist [table=").$safe(fromTableName).I$();
        throw CairoException.nonCritical().put("cannot rename, table does not exist [table=").put(fromTableName).put(']');
    }

    public void resetFrameFactory() {
        this.frameFactory.close();
        this.frameFactory = new FrameFactory(this.configuration);
    }

    public void resetNameRegistryMemory() {
        this.tableNameRegistry.resetMemory();
    }

    public RecordCursorFactory select(CharSequence selectSql, SqlExecutionContext sqlExecutionContext) throws SqlException {
        try (SqlCompiler compiler = this.getSqlCompiler();){
            RecordCursorFactory recordCursorFactory = CairoEngine.select(compiler, selectSql, sqlExecutionContext);
            return recordCursorFactory;
        }
    }

    public void setConfigReloader(@NotNull ConfigReloader configReloader) {
        this.configReloader = configReloader;
    }

    public void setDdlListener(@NotNull DdlListener ddlListener) {
        this.ddlListener = ddlListener;
    }

    public void setPoolListener(PoolListener poolListener) {
        this.tableMetadataPool.setPoolListener(poolListener);
        this.sequencerMetadataPool.setPoolListener(poolListener);
        this.writerPool.setPoolListener(poolListener);
        this.readerPool.setPoolListener(poolListener);
        this.walWriterPool.setPoolListener(poolListener);
    }

    public void setReaderListener(ReaderPool.ReaderListener readerListener) {
        this.readerPool.setTableReaderListener(readerListener);
    }

    public void setUp() {
    }

    public void setWalDirectoryPolicy(@NotNull WalDirectoryPolicy walDirectoryPolicy) {
        this.walDirectoryPolicy = walDirectoryPolicy;
    }

    public void setWalListener(@NotNull WalListener walListener) {
        this.walListener = walListener;
    }

    public void setWalPurgeJobRunLock(@Nullable SimpleWaitingLock walPurgeJobRunLock) {
        this.checkpointAgent.setWalPurgeJobRunLock(walPurgeJobRunLock);
    }

    public void snapshotCreate(SqlExecutionContext executionContext) throws SqlException {
        this.checkpointAgent.checkpointCreate(executionContext, true);
    }

    public void unlock(SecurityContext securityContext, TableToken tableToken, @Nullable TableWriter writer, boolean newTable) {
        this.verifyTableToken(tableToken);
        this.unlockTableUnsafe(tableToken, writer, newTable);
        LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
    }

    public void unlockReaders(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        this.readerPool.unlock(tableToken);
    }

    public void unlockReadersAndMetadata(TableToken tableToken) {
        this.readerPool.unlock(tableToken);
        this.tableMetadataPool.unlock(tableToken);
    }

    public void unlockTableCreate(TableToken tableToken) {
        this.createTableLock.remove(tableToken.getTableName(), tableToken);
    }

    public void unlockTableName(TableToken tableToken) {
        this.tableNameRegistry.unlockTableName(tableToken);
    }

    public long update(CharSequence updateSql, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return this.update(updateSql, sqlExecutionContext, null);
    }

    /*
     * Exception decompiling
     */
    public long update(CharSequence updateSql, SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TableToken verifyTableName(CharSequence tableName) {
        TableToken tableToken = this.tableNameRegistry.getTableToken(tableName);
        if (tableToken == null) {
            throw CairoException.tableDoesNotExist(tableName);
        }
        if (tableToken == TableNameRegistry.LOCKED_TOKEN) {
            throw CairoException.nonCritical().put("table name is reserved [table=").put(tableName).put("]");
        }
        if (tableToken == TableNameRegistry.LOCKED_DROP_TOKEN) {
            throw CairoException.tableDoesNotExist(tableName);
        }
        return tableToken;
    }

    public TableToken verifyTableName(CharSequence tableName, int lo, int hi) {
        StringSink sink = Misc.getThreadLocalSink();
        sink.put(tableName, lo, hi);
        return this.verifyTableName(sink);
    }

    public void verifyTableToken(TableToken tableToken) {
        TableToken tt = this.tableNameRegistry.getTableToken(tableToken.getTableName());
        if (tt == null || TableNameRegistry.isLocked(tt)) {
            throw CairoException.tableDoesNotExist(tableToken.getTableName());
        }
        if (!tt.equals(tableToken)) {
            throw TableReferenceOutOfDateException.of(tableToken, tableToken.getTableId(), tt.getTableId(), tt.getTableId(), -1L);
        }
    }

    private static void insert(CompiledQuery cq, SqlExecutionContext sqlExecutionContext) throws SqlException {
        switch (cq.getType()) {
            case 2: 
            case 10: {
                try (InsertOperation insertOperation = cq.popInsertOperation();
                     InsertMethod insertMethod = insertOperation.createMethod(sqlExecutionContext);){
                    insertMethod.execute(sqlExecutionContext);
                    insertMethod.commit();
                    break;
                }
            }
            case 1: {
                throw SqlException.$(0, "use select()");
            }
            case 7: {
                throw SqlException.$(0, "use drop()");
            }
            default: {
                throw SqlException.$(0, "use ddl()");
            }
        }
    }

    private void createTableOrMatViewInVolumeUnsafe(MemoryMARW mem, @Nullable BlockFileWriter blockFileWriter, Path path, TableStructure struct, TableToken tableToken) {
        if (1 != TableUtils.existsInVolume(this.configuration.getFilesFacade(), path, tableToken.getDirName())) {
            throw CairoException.nonCritical().put("name is reserved [table=").put(tableToken.getTableName()).put(']');
        }
        TableUtils.createTableOrMatViewInVolume(this.configuration.getFilesFacade(), this.configuration.getDbRoot(), this.configuration.getMkDirMode(), mem, blockFileWriter, path, tableToken.getDirName(), struct, 426, tableToken.getTableId());
    }

    private void createTableOrMatViewUnsafe(MemoryMARW mem, @Nullable BlockFileWriter blockFileWriter, Path path, TableStructure struct, TableToken tableToken) {
        if (TableUtils.exists(this.configuration.getFilesFacade(), path, (CharSequence)this.configuration.getDbRoot(), tableToken.getDirName()) != 1) {
            throw CairoException.nonCritical().put("name is reserved [table=").put(tableToken.getTableName()).put(']');
        }
        TableUtils.createTableOrMatView(this.configuration.getFilesFacade(), this.configuration.getDbRoot(), this.configuration.getMkDirMode(), mem, blockFileWriter, path, tableToken.getDirName(), struct, 426, tableToken.getTableId());
    }

    @NotNull
    private TableToken createTableOrMatViewUnsecure(MemoryMARW mem, @Nullable BlockFileWriter blockFileWriter, Path path, boolean ifNotExists, TableStructure struct, boolean keepLock, boolean inVolume) {
        TableToken tableToken;
        block23: {
            assert (!struct.isWalEnabled() || PartitionBy.isPartitioned(struct.getPartitionBy())) : "WAL is only supported for partitioned tables";
            CharSequence tableName = struct.getTableName();
            this.validNameOrThrow(tableName);
            int tableId = (int)this.tableIdGenerator.getNextId();
            while ((tableToken = this.lockTableName(tableName, tableId, struct.isMatView(), struct.isWalEnabled())) == null) {
                if (ifNotExists) {
                    tableToken = this.getTableTokenIfExists(tableName);
                    if (tableToken != null) {
                        struct.init(tableToken);
                        return tableToken;
                    }
                    Os.pause();
                    continue;
                }
                throw EntryUnavailableException.instance("table exists");
            }
            struct.init(tableToken);
            while (!this.lockTableCreate(tableToken)) {
                Os.pause();
            }
            try {
                String lockedReason = this.lockAll(tableToken, "createTable", true);
                boolean locked = true;
                if (lockedReason == null) {
                    try {
                        if (inVolume) {
                            this.createTableOrMatViewInVolumeUnsafe(mem, blockFileWriter, path, struct, tableToken);
                        } else {
                            this.createTableOrMatViewUnsafe(mem, blockFileWriter, path, struct, tableToken);
                        }
                        if (struct.isWalEnabled()) {
                            this.tableSequencerAPI.registerTable(tableToken.getTableId(), struct, tableToken);
                        }
                        if (!keepLock) {
                            this.unlockTableUnsafe(tableToken, null, true);
                            locked = false;
                            LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
                        }
                        this.tableNameRegistry.registerName(tableToken);
                        break block23;
                    }
                    catch (Throwable e) {
                        keepLock = false;
                        throw e;
                    }
                    finally {
                        if (!keepLock && locked) {
                            this.unlockTableUnsafe(tableToken, null, false);
                            LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
                        }
                    }
                }
                if (!ifNotExists) {
                    throw EntryUnavailableException.instance(lockedReason);
                }
            }
            catch (Throwable th) {
                if (struct.isWalEnabled()) {
                    this.tableSequencerAPI.dropTable(tableToken, true);
                }
                throw th;
            }
            finally {
                this.tableNameRegistry.unlockTableName(tableToken);
                this.unlockTableCreate(tableToken);
            }
        }
        return tableToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableToken rename0(Path fromPath, TableToken fromTableToken, Path toPath, CharSequence toTableName) {
        FilesFacade ff = this.configuration.getFilesFacade();
        String root = this.configuration.getDbRoot();
        fromPath.of(root).concat(fromTableToken).$();
        TableToken toTableToken = this.lockTableName(toTableName, fromTableToken.getTableId(), fromTableToken.isMatView(), fromTableToken.isWal());
        if (toTableToken == null) {
            LOG.error().$("rename target exists [from='").$safe(fromTableToken.getTableName()).$("', to='").$safe(toTableName).I$();
            throw CairoException.nonCritical().put("Rename target exists");
        }
        while (!this.lockTableCreate(toTableToken)) {
            Os.pause();
        }
        if (ff.exists(toPath.of(root).concat(toTableToken).$())) {
            this.tableNameRegistry.unlockTableName(toTableToken);
        }
        try {
            if (ff.rename(fromPath.$(), toPath.$()) != 0) {
                int error = ff.errno();
                LOG.error().$("could not rename [from='").$(fromPath).$("', to='").$(toPath).$("', error=").$(error).I$();
                throw CairoException.critical(error).put("could not rename [from='").put(fromPath).put("', to='").put(toPath).put(']');
            }
            this.tableNameRegistry.registerName(toTableToken);
            TableToken tableToken = toTableToken;
            return tableToken;
        }
        finally {
            this.tableNameRegistry.unlockTableName(toTableToken);
            this.unlockTableCreate(toTableToken);
        }
    }

    private void tryRepairTable(TableToken tableToken, CairoException rethrow) {
        LOG.info().$("starting table repair [table=").$(tableToken).$(", cause=").$safe(rethrow.getFlyweightMessage()).I$();
        try {
            this.writerPool.get(tableToken, "repair").close();
            LOG.info().$("table repair succeeded [table=").$(tableToken).I$();
        }
        catch (EntryUnavailableException e) {
            LOG.info().$("writer is busy, skipping repair [table=").$(tableToken).I$();
            throw rethrow;
        }
        catch (Throwable th) {
            LOG.critical().$("table repair failed [table=").$(tableToken).$(", error=").$safe(th.getMessage()).I$();
            throw rethrow;
        }
    }

    private void unlockTableUnsafe(TableToken tableToken, TableWriter writer, boolean newTable) {
        this.readerPool.unlock(tableToken);
        this.writerPool.unlock(tableToken, writer, newTable);
        this.sequencerMetadataPool.unlock(tableToken);
        this.tableMetadataPool.unlock(tableToken);
    }

    private void validNameOrThrow(CharSequence tableName) {
        if (!TableUtils.isValidTableName(tableName, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid table name [table=").putAsPrintable(tableName).put(']');
        }
    }

    private void validateDesiredMetadataVersion(TableToken tableToken, TableRecordMetadata metadata, long desiredVersion) {
        if (desiredVersion != -1L && metadata.getMetadataVersion() != desiredVersion || tableToken.getTableId() != metadata.getTableId()) {
            TableReferenceOutOfDateException ex = TableReferenceOutOfDateException.of(tableToken, tableToken.getTableId(), metadata.getTableId(), desiredVersion, metadata.getMetadataVersion());
            metadata.close();
            throw ex;
        }
    }

    @NotNull
    private TableToken verifyTableNameForRead(CharSequence tableName) {
        TableToken token = this.getTableTokenIfExists(tableName);
        if (token == null || TableNameRegistry.isLocked(token)) {
            throw CairoException.tableDoesNotExist(tableName);
        }
        return token;
    }

    protected MatViewStateStore createMatViewStateStore() {
        return this.configuration.isMatViewEnabled() ? new MatViewStateStoreImpl(this) : NoOpMatViewStateStore.INSTANCE;
    }

    protected Queue<MatViewTimerTask> createMatViewTimerQueue() {
        return this.configuration.isMatViewEnabled() ? ConcurrentQueue.createConcurrentQueue(MatViewTimerTask.ITEM_FACTORY) : new NoOpQueue();
    }

    protected SqlExecutionContext createRootExecutionContext() {
        return new SqlExecutionContextImpl(this, 0).with(AllowAllSecurityContext.INSTANCE);
    }

    @NotNull
    protected <T extends AbstractTelemetryTask> Telemetry<T> createTelemetry(Telemetry.TelemetryTypeBuilder<T> builder, CairoConfiguration configuration) {
        return new Telemetry<T>(builder, configuration);
    }

    protected Iterable<FunctionFactory> getFunctionFactories() {
        return new FunctionFactoryCacheBuilder().scan(LOG).build();
    }

    protected TableFlagResolver newTableFlagResolver(CairoConfiguration configuration) {
        return new TableFlagResolverImpl(configuration.getSystemTableNamePrefix().toString());
    }

    private class EngineMaintenanceJob
    extends SynchronizedJob {
        private final long checkInterval;
        private final MicrosecondClock clock;
        private long last = 0L;

        public EngineMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getMicrosecondClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return CairoEngine.this.releaseInactive();
            }
            return false;
        }
    }
}

