/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoColumn;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableToken;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;

public class CairoTable
implements Sinkable {
    public final LowerCaseCharSequenceIntHashMap columnNameIndexMap;
    public final IntList columnOrderList;
    public final ObjList<CairoColumn> columns;
    private boolean dedup;
    private int matViewRefreshLimitHoursOrMonths;
    private int matViewTimerInterval;
    private long matViewTimerStart;
    private char matViewTimerUnit;
    private int maxUncommittedRows;
    private long metadataVersion = -1L;
    private long o3MaxLag;
    private int partitionBy;
    private boolean softLink;
    private int timestampIndex;
    private TableToken token;
    private int ttlHoursOrMonths;

    public CairoTable(@NotNull TableToken token) {
        this.token = token;
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
        this.columnOrderList = new IntList();
        this.columns = new ObjList();
    }

    public CairoTable(@NotNull TableToken token, CairoTable fromTab) {
        this.token = token;
        this.columnOrderList = fromTab.columnOrderList;
        this.columns = fromTab.columns;
        this.columnNameIndexMap = fromTab.columnNameIndexMap;
        this.metadataVersion = fromTab.getMetadataVersion();
        this.partitionBy = fromTab.getPartitionBy();
        this.maxUncommittedRows = fromTab.getMaxUncommittedRows();
        this.o3MaxLag = fromTab.getO3MaxLag();
        this.timestampIndex = fromTab.getTimestampIndex();
        this.ttlHoursOrMonths = fromTab.getTtlHoursOrMonths();
        this.softLink = fromTab.isSoftLink();
        this.dedup = fromTab.hasDedup();
        this.matViewRefreshLimitHoursOrMonths = fromTab.getMatViewRefreshLimitHoursOrMonths();
        this.matViewTimerStart = fromTab.getMatViewTimerStart();
        this.matViewTimerInterval = fromTab.getMatViewTimerInterval();
        this.matViewTimerUnit = fromTab.getMatViewTimerUnit();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ObjList<CharSequence> getColumnNames() {
        return this.columnNameIndexMap.keys();
    }

    public CairoColumn getColumnQuiet(@NotNull CharSequence columnName) {
        int index = this.columnNameIndexMap.get(columnName);
        if (index != -1) {
            return this.columns.getQuiet(index);
        }
        return null;
    }

    public CairoColumn getColumnQuiet(int position) {
        return this.columns.getQuiet(position);
    }

    public String getDirectoryName() {
        return this.token.getDirName();
    }

    public int getId() {
        return this.token.getTableId();
    }

    public int getMatViewRefreshLimitHoursOrMonths() {
        return this.matViewRefreshLimitHoursOrMonths;
    }

    public int getMatViewTimerInterval() {
        return this.matViewTimerInterval;
    }

    public long getMatViewTimerStart() {
        return this.matViewTimerStart;
    }

    public char getMatViewTimerUnit() {
        return this.matViewTimerUnit;
    }

    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    public long getMetadataVersion() {
        return this.metadataVersion;
    }

    public long getO3MaxLag() {
        return this.o3MaxLag;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    @NotNull
    public String getPartitionByName() {
        return PartitionBy.toString(this.partitionBy);
    }

    @NotNull
    public String getTableName() {
        return this.token.getTableName();
    }

    public TableToken getTableToken() {
        return this.token;
    }

    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public CharSequence getTimestampName() {
        CairoColumn timestampColumn;
        if (this.timestampIndex != -1 && (timestampColumn = this.getColumnQuiet(this.timestampIndex)) != null) {
            return timestampColumn.getName();
        }
        return null;
    }

    public int getTtlHoursOrMonths() {
        return this.ttlHoursOrMonths;
    }

    public boolean hasDedup() {
        return this.dedup;
    }

    public boolean isSoftLink() {
        return this.softLink;
    }

    public boolean isWalEnabled() {
        return this.token.isWal();
    }

    public void setDedupFlag(boolean dedup) {
        this.dedup = dedup;
    }

    public void setMatViewRefreshLimitHoursOrMonths(int matViewRefreshLimitHoursOrMonths) {
        this.matViewRefreshLimitHoursOrMonths = matViewRefreshLimitHoursOrMonths;
    }

    public void setMatViewTimerInterval(int matViewTimerInterval) {
        this.matViewTimerInterval = matViewTimerInterval;
    }

    public void setMatViewTimerStart(long matViewTimerStart) {
        this.matViewTimerStart = matViewTimerStart;
    }

    public void setMatViewTimerUnit(char matViewTimerUnit) {
        this.matViewTimerUnit = matViewTimerUnit;
    }

    public void setMaxUncommittedRows(int maxUncommittedRows) {
        this.maxUncommittedRows = maxUncommittedRows;
    }

    public void setMetadataVersion(long metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    public void setO3MaxLag(long o3MaxLag) {
        this.o3MaxLag = o3MaxLag;
    }

    public void setPartitionBy(int partitionBy) {
        this.partitionBy = partitionBy;
    }

    public void setSoftLinkFlag(boolean softLink) {
        this.softLink = softLink;
    }

    public void setTableToken(TableToken token) {
        this.token = token;
    }

    public void setTimestampIndex(int timestampIndex) {
        this.timestampIndex = timestampIndex;
    }

    public void setTtlHoursOrMonths(int ttlHoursOrMonths) {
        this.ttlHoursOrMonths = ttlHoursOrMonths;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put("CairoTable [");
        sink.put("name=").put(this.getTableName()).put(", ");
        sink.put("id=").put(this.getId()).put(", ");
        sink.put("directoryName=").put(this.getDirectoryName()).put(", ");
        sink.put("hasDedup=").put(this.hasDedup()).put(", ");
        sink.put("isSoftLink=").put(this.isSoftLink()).put(", ");
        sink.put("metadataVersion=").put(this.getMetadataVersion()).put(", ");
        sink.put("maxUncommittedRows=").put(this.getMaxUncommittedRows()).put(", ");
        sink.put("o3MaxLag=").put(this.getO3MaxLag()).put(", ");
        sink.put("partitionBy=").put(this.getPartitionByName()).put(", ");
        sink.put("timestampIndex=").put(this.getTimestampIndex()).put(", ");
        sink.put("timestampName=").put(this.getTimestampName()).put(", ");
        int ttlHoursOrMonths = this.getTtlHoursOrMonths();
        if (ttlHoursOrMonths >= 0) {
            sink.put("ttlHours=").put(ttlHoursOrMonths).put(", ");
        } else {
            sink.put("ttlMonths=").put(-ttlHoursOrMonths).put(", ");
        }
        sink.put("walEnabled=").put(this.isWalEnabled()).put(", ");
        sink.put("columnCount=").put(this.getColumnCount()).put("]");
        sink.put('\n');
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            sink.put("\t\t");
            this.columns.getQuick(i).toSink(sink);
            if (i == this.columns.size() - 1) continue;
            sink.put('\n');
        }
    }

    public void upsertColumn(@NotNull CairoColumn newColumn) throws CairoException {
        CharSequence columnName = newColumn.getName();
        CairoColumn existingColumn = this.getColumnQuiet(columnName);
        if (existingColumn != null) {
            int denseIndex = this.columnNameIndexMap.get(columnName);
            this.columns.getAndSetQuick(denseIndex, newColumn);
        } else {
            this.columns.add(newColumn);
            int denseIndex = this.columns.size() - 1;
            this.columnNameIndexMap.put(columnName, denseIndex);
        }
    }
}

