/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.TxnScoreboardPool;
import io.questdb.cairo.TxnScoreboardV1;
import io.questdb.std.str.Path;

public class TxnScoreboardPoolV1
implements TxnScoreboardPool {
    private final CairoConfiguration configuration;
    private final ThreadLocal<ScoreboardPoolTenant> tlScoreboardPoolV1 = new ThreadLocal();

    public TxnScoreboardPoolV1(CairoConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void clear() {
        this.tlScoreboardPoolV1.remove();
    }

    @Override
    public TxnScoreboard getTxnScoreboard(TableToken token) {
        ScoreboardPoolTenant scoreboard = this.tlScoreboardPoolV1.get();
        if (scoreboard == null) {
            scoreboard = new ScoreboardPoolTenant(this.configuration, this, token);
        } else {
            this.tlScoreboardPoolV1.set(null);
        }
        Path path = Path.getThreadLocal(this.configuration.getDbRoot());
        scoreboard.ofRW(token, path.concat(token));
        assert (this.tlScoreboardPoolV1.get() == null);
        return scoreboard;
    }

    @Override
    public boolean releaseInactive() {
        return false;
    }

    @Override
    public void remove(TableToken token) {
    }

    static class ScoreboardPoolTenant
    extends TxnScoreboardV1 {
        private final TxnScoreboardPoolV1 parent;

        public ScoreboardPoolTenant(CairoConfiguration configuration, TxnScoreboardPoolV1 parent, TableToken tableToken) {
            super(configuration.getFilesFacade(), configuration.getTxnScoreboardEntryCount(), tableToken);
            this.parent = parent;
        }

        @Override
        public void close() {
            super.close();
            if (this.parent.tlScoreboardPoolV1.get() == null) {
                this.parent.tlScoreboardPoolV1.set(this);
            }
        }
    }
}

