/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.file.AppendableBlock;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewStateReader;
import io.questdb.cairo.mv.MatViewTelemetryFacade;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatViewState
implements QuietCloseable {
    public static final String MAT_VIEW_STATE_FILE_NAME = "_mv.s";
    public static final int MAT_VIEW_STATE_FORMAT_EXTRA_INTERVALS_MSG_TYPE = 3;
    public static final int MAT_VIEW_STATE_FORMAT_EXTRA_PERIOD_MSG_TYPE = 2;
    public static final int MAT_VIEW_STATE_FORMAT_EXTRA_TS_MSG_TYPE = 1;
    public static final int MAT_VIEW_STATE_FORMAT_MSG_TYPE = 0;
    private final AtomicBoolean latch = new AtomicBoolean(false);
    private final LongList refreshIntervals = new LongList();
    private final AtomicLong refreshIntervalsSeq = new AtomicLong();
    private final AtomicLong refreshSeq = new AtomicLong();
    private final MatViewTelemetryFacade telemetryFacade;
    private RecordCursorFactory cursorFactory;
    private volatile boolean dropped;
    private volatile boolean invalid;
    private volatile long lastPeriodHi = Long.MIN_VALUE;
    private volatile long lastRefreshBaseTxn = -1L;
    private volatile long lastRefreshFinishTimestamp = Long.MIN_VALUE;
    private volatile long lastRefreshStartTimestamp = Long.MIN_VALUE;
    private volatile boolean pendingInvalidation;
    private long recordRowCopierMetadataVersion;
    private RecordToRowCopier recordToRowCopier;
    private volatile long refreshIntervalsBaseTxn = -1L;
    private volatile MatViewDefinition viewDefinition;

    public MatViewState(@NotNull MatViewDefinition viewDefinition, MatViewTelemetryFacade telemetryFacade) {
        this.viewDefinition = viewDefinition;
        this.telemetryFacade = telemetryFacade;
    }

    public static void append(long lastRefreshTimestamp, long lastRefreshBaseTxn, boolean invalid, @Nullable CharSequence invalidationReason, long lastPeriodHi, @Nullable LongList refreshIntervals, long refreshIntervalsBaseTxn, @NotNull BlockFileWriter writer) {
        AppendableBlock block = writer.append();
        MatViewState.appendState(lastRefreshBaseTxn, invalid, invalidationReason, block);
        block.commit(0);
        block = writer.append();
        MatViewState.appendTs(lastRefreshTimestamp, block);
        block.commit(1);
        block = writer.append();
        MatViewState.appendPeriodHi(lastPeriodHi, block);
        block.commit(2);
        block = writer.append();
        MatViewState.appendRefreshIntervals(refreshIntervals, refreshIntervalsBaseTxn, block);
        block.commit(3);
        writer.commit();
    }

    public static void append(@Nullable MatViewStateReader refreshState, @NotNull BlockFileWriter writer) {
        if (refreshState != null) {
            MatViewState.append(refreshState.getLastRefreshTimestamp(), refreshState.getLastRefreshBaseTxn(), refreshState.isInvalid(), refreshState.getInvalidationReason(), refreshState.getLastPeriodHi(), refreshState.getRefreshIntervals(), refreshState.getRefreshIntervalsBaseTxn(), writer);
        } else {
            MatViewState.append(Long.MIN_VALUE, -1L, false, null, Long.MIN_VALUE, null, -1L, writer);
        }
    }

    public static void appendPeriodHi(long periodHi, @NotNull AppendableBlock block) {
        block.putLong(periodHi);
    }

    public static void appendRefreshIntervals(@Nullable LongList refreshIntervals, long refreshIntervalsBaseTxn, @NotNull AppendableBlock block) {
        block.putLong(refreshIntervalsBaseTxn);
        if (refreshIntervals != null) {
            block.putInt(refreshIntervals.size());
            int n = refreshIntervals.size();
            for (int i = 0; i < n; ++i) {
                block.putLong(refreshIntervals.getQuick(i));
            }
        } else {
            block.putInt(-1);
        }
    }

    public static void appendState(long lastRefreshBaseTxn, boolean invalid, @Nullable CharSequence invalidationReason, @NotNull AppendableBlock block) {
        block.putBool(invalid);
        block.putLong(lastRefreshBaseTxn);
        block.putStr(invalidationReason);
    }

    public static void appendTs(long lastRefreshTimestamp, @NotNull AppendableBlock block) {
        block.putLong(lastRefreshTimestamp);
    }

    public RecordCursorFactory acquireRecordFactory() {
        assert (this.latch.get());
        RecordCursorFactory factory = this.cursorFactory;
        this.cursorFactory = null;
        return factory;
    }

    @Override
    public void close() {
        this.cursorFactory = Misc.free(this.cursorFactory);
    }

    public long getLastPeriodHi() {
        return this.lastPeriodHi;
    }

    public long getLastRefreshBaseTxn() {
        return this.lastRefreshBaseTxn;
    }

    public long getLastRefreshFinishTimestamp() {
        return this.lastRefreshFinishTimestamp;
    }

    public long getLastRefreshStartTimestamp() {
        return this.lastRefreshStartTimestamp;
    }

    public long getRecordRowCopierMetadataVersion() {
        return this.recordRowCopierMetadataVersion;
    }

    public RecordToRowCopier getRecordToRowCopier() {
        return this.recordToRowCopier;
    }

    public LongList getRefreshIntervals() {
        return this.refreshIntervals;
    }

    public long getRefreshIntervalsBaseTxn() {
        return this.refreshIntervalsBaseTxn;
    }

    public long getRefreshIntervalsSeq() {
        return this.refreshIntervalsSeq.get();
    }

    public long getRefreshSeq() {
        return this.refreshSeq.get();
    }

    @NotNull
    public MatViewDefinition getViewDefinition() {
        return this.viewDefinition;
    }

    public void incrementRefreshIntervalsSeq() {
        this.refreshIntervalsSeq.incrementAndGet();
    }

    public void incrementRefreshSeq() {
        this.refreshSeq.incrementAndGet();
    }

    public void init() {
        this.telemetryFacade.store((short)200, this.viewDefinition.getMatViewToken(), Long.MIN_VALUE, null, 0L);
    }

    public void initFromReader(MatViewStateReader reader) {
        this.invalid = reader.isInvalid();
        this.lastRefreshBaseTxn = reader.getLastRefreshBaseTxn();
        this.lastRefreshFinishTimestamp = reader.getLastRefreshTimestamp();
        this.lastPeriodHi = reader.getLastPeriodHi();
        this.refreshIntervalsBaseTxn = reader.getRefreshIntervalsBaseTxn();
        this.refreshIntervals.clear();
        this.refreshIntervals.addAll(reader.getRefreshIntervals());
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isLocked() {
        return this.latch.get();
    }

    public boolean isPendingInvalidation() {
        return this.pendingInvalidation;
    }

    public void markAsDropped() {
        this.dropped = true;
        this.telemetryFacade.store((short)201, this.viewDefinition.getMatViewToken(), Long.MIN_VALUE, null, 0L);
    }

    public void markAsInvalid(CharSequence invalidationReason) {
        if (!this.invalid) {
            this.telemetryFacade.store((short)202, this.viewDefinition.getMatViewToken(), Long.MIN_VALUE, invalidationReason, 0L);
        }
        this.invalid = true;
    }

    public void markAsPendingInvalidation() {
        this.pendingInvalidation = true;
    }

    public void markAsValid() {
        this.invalid = false;
        this.pendingInvalidation = false;
    }

    public void rangeRefreshSuccess(RecordCursorFactory factory, RecordToRowCopier copier, long recordRowCopierMetadataVersion, long refreshFinishedTimestamp, long refreshTriggeredTimestamp, long periodHi) {
        assert (this.latch.get());
        this.cursorFactory = factory;
        this.recordToRowCopier = copier;
        this.recordRowCopierMetadataVersion = recordRowCopierMetadataVersion;
        this.lastRefreshFinishTimestamp = refreshFinishedTimestamp;
        this.lastPeriodHi = periodHi;
        this.telemetryFacade.store((short)204, this.viewDefinition.getMatViewToken(), -1L, null, refreshFinishedTimestamp - refreshTriggeredTimestamp);
    }

    public void refreshFail(long refreshTimestamp, CharSequence errorMessage) {
        assert (this.latch.get());
        this.lastRefreshFinishTimestamp = refreshTimestamp;
        this.markAsInvalid(errorMessage);
        this.telemetryFacade.store((short)203, this.viewDefinition.getMatViewToken(), Long.MIN_VALUE, errorMessage, 0L);
    }

    public void refreshSuccess(RecordCursorFactory factory, RecordToRowCopier copier, long recordRowCopierMetadataVersion, long refreshFinishedTimestamp, long refreshTriggeredTimestamp, long baseTableTxn, long periodHi) {
        assert (this.latch.get());
        this.cursorFactory = factory;
        this.recordToRowCopier = copier;
        this.recordRowCopierMetadataVersion = recordRowCopierMetadataVersion;
        this.lastRefreshFinishTimestamp = refreshFinishedTimestamp;
        this.lastRefreshBaseTxn = baseTableTxn;
        this.lastPeriodHi = periodHi;
        this.refreshIntervalsBaseTxn = -1L;
        this.refreshIntervals.clear();
        this.telemetryFacade.store((short)204, this.viewDefinition.getMatViewToken(), baseTableTxn, null, refreshFinishedTimestamp - refreshTriggeredTimestamp);
    }

    public void refreshSuccessNoRows(long refreshFinishedTimestamp, long refreshTriggeredTimestamp, long baseTableTxn, long periodHi) {
        assert (this.latch.get());
        this.lastRefreshFinishTimestamp = refreshFinishedTimestamp;
        this.lastRefreshBaseTxn = baseTableTxn;
        this.lastPeriodHi = periodHi;
        this.refreshIntervalsBaseTxn = -1L;
        this.refreshIntervals.clear();
        this.telemetryFacade.store((short)204, this.viewDefinition.getMatViewToken(), baseTableTxn, null, refreshFinishedTimestamp - refreshTriggeredTimestamp);
    }

    public void setLastPeriodHi(long lastPeriodHi) {
        this.lastPeriodHi = lastPeriodHi;
    }

    public void setLastRefreshBaseTableTxn(long txn) {
        this.lastRefreshBaseTxn = txn;
    }

    public void setLastRefreshStartTimestamp(long ts) {
        this.lastRefreshStartTimestamp = ts;
    }

    public void setLastRefreshTimestamp(long ts) {
        this.lastRefreshFinishTimestamp = ts;
    }

    public void setRefreshIntervals(LongList refreshIntervals) {
        this.refreshIntervals.clear();
        this.refreshIntervals.addAll(refreshIntervals);
    }

    public void setRefreshIntervalsBaseTxn(long refreshIntervalsBaseTxn) {
        this.refreshIntervalsBaseTxn = refreshIntervalsBaseTxn;
    }

    public void setViewDefinition(MatViewDefinition viewDefinition) {
        this.viewDefinition = viewDefinition;
    }

    public void tryCloseIfDropped() {
        if (this.dropped && this.tryLock()) {
            try {
                this.close();
            }
            finally {
                this.unlock();
            }
        }
    }

    public boolean tryLock() {
        return this.latch.compareAndSet(false, true);
    }

    public void unlock() {
        if (!this.latch.compareAndSet(true, false)) {
            throw new IllegalStateException("cannot unlock, not locked");
        }
    }
}

