/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewGraph;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateStore;
import io.questdb.cairo.mv.MatViewTimerTask;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Queue;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatViewTimerJob
extends SynchronizedJob {
    private static final int INITIAL_QUEUE_CAPACITY = 16;
    private static final Log LOG = LogFactory.getLog(MatViewTimerJob.class);
    private static final Comparator<Timer> timerComparator = Comparator.comparingLong(Timer::getDeadline);
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final ObjList<Timer> expired = new ObjList();
    private final Predicate<Timer> filterByDirName;
    private final MatViewGraph matViewGraph;
    private final MatViewStateStore matViewStateStore;
    private final PriorityQueue<Timer> timerQueue = new PriorityQueue<Timer>(16, timerComparator);
    private final MatViewTimerTask timerTask = new MatViewTimerTask();
    private final Queue<MatViewTimerTask> timerTaskQueue;
    private String filteredDirName;

    public MatViewTimerJob(CairoEngine engine) {
        this.configuration = engine.getConfiguration();
        this.clock = this.configuration.getMicrosecondClock();
        this.timerTaskQueue = engine.getMatViewTimerQueue();
        this.matViewGraph = engine.getMatViewGraph();
        this.matViewStateStore = engine.getMatViewStateStore();
        this.filterByDirName = this::filterByDirName;
    }

    public static long periodDelayMicros(int periodDelay, char periodDelayUnit) {
        switch (periodDelayUnit) {
            case 'm': {
                return (long)periodDelay * 60000000L;
            }
            case 'h': {
                return (long)periodDelay * 3600000000L;
            }
            case 'd': {
                return (long)periodDelay * 86400000000L;
            }
        }
        return 0L;
    }

    private void addTimers(TableToken viewToken, long now) {
        MatViewDefinition viewDefinition = this.matViewGraph.getViewDefinition(viewToken);
        if (viewDefinition == null) {
            LOG.info().$("materialized view definition not found [view=").$(viewToken).I$();
            return;
        }
        try {
            if (viewDefinition.getRefreshType() != 0) {
                this.createUpdateRefreshIntervalsTimer(viewDefinition, now);
            }
            long timerStart = viewDefinition.getTimerStart();
            TimeZoneRules timerTzRules = viewDefinition.getTimerTzRules();
            if (viewDefinition.getPeriodLength() > 0) {
                this.createPeriodTimer(viewDefinition, now);
                timerStart = now;
                timerTzRules = null;
            }
            if (viewDefinition.getRefreshType() == 1) {
                this.createTimer(viewDefinition, timerStart, timerTzRules, now);
            }
        }
        catch (Throwable th) {
            LOG.error().$("could not initialize timer for materialized view [view=").$(viewToken).$(", ex=").$(th).I$();
        }
    }

    private void createPeriodTimer(@NotNull MatViewDefinition viewDefinition, long now) {
        TimestampSampler sampler;
        TableToken viewToken = viewDefinition.getMatViewToken();
        long start = viewDefinition.getTimerStart();
        int length = viewDefinition.getPeriodLength();
        char lengthUnit = viewDefinition.getPeriodLengthUnit();
        try {
            sampler = TimestampSamplerFactory.getInstance((long)length, lengthUnit, -1);
        }
        catch (SqlException e) {
            throw CairoException.nonCritical().put("invalid LENGTH interval and/or unit: ").put(length).put(", ").put(lengthUnit);
        }
        int delay = viewDefinition.getPeriodDelay();
        char delayUnit = viewDefinition.getPeriodDelayUnit();
        long delayMicros = MatViewTimerJob.periodDelayMicros(delay, delayUnit);
        Timer periodTimer = new Timer(1, viewToken, sampler, viewDefinition.getTimerTzRules(), delayMicros, start, now);
        this.timerQueue.add(periodTimer);
        LOG.info().$("created period timer for materialized view [view=").$(viewToken).$(", start=").$ts(start).$(", tz=").$(viewDefinition.getTimerTimeZone()).$(", length=").$(length).$(lengthUnit).$(", delay=").$(delay).$(delayUnit).I$();
    }

    private void createTimer(@NotNull MatViewDefinition viewDefinition, long timerStart, @Nullable TimeZoneRules timerTzRules, long now) {
        TimestampSampler sampler;
        TableToken viewToken = viewDefinition.getMatViewToken();
        int interval = viewDefinition.getTimerInterval();
        char unit = viewDefinition.getTimerUnit();
        try {
            sampler = TimestampSamplerFactory.getInstance((long)interval, unit, -1);
        }
        catch (SqlException e) {
            throw CairoException.nonCritical().put("invalid EVERY interval and/or unit: ").put(interval).put(", ").put(unit);
        }
        Timer timer = new Timer(0, viewToken, sampler, timerTzRules, 0L, timerStart, now);
        this.timerQueue.add(timer);
        LOG.info().$("created timer for materialized view [view=").$(viewToken).$(", start=").$ts(timerStart).$(", tz=").$(viewDefinition.getTimerTimeZone()).$(", interval=").$(interval).$(unit).I$();
    }

    private void createUpdateRefreshIntervalsTimer(@NotNull MatViewDefinition viewDefinition, long now) {
        TimestampSampler sampler;
        TableToken viewToken = viewDefinition.getMatViewToken();
        long periodMs = this.configuration.getMatViewRefreshIntervalsUpdatePeriod();
        try {
            sampler = TimestampSamplerFactory.getInstance(periodMs, 'T', -1);
        }
        catch (SqlException e) {
            throw CairoException.nonCritical().put("invalid refresh intervals update period: ").put(periodMs);
        }
        Timer timer = new Timer(2, viewToken, sampler, null, 0L, now, now);
        this.timerQueue.add(timer);
        LOG.info().$("created refresh intervals update timer for materialized view [view=").$(viewToken).$(", start=").$ts(now).$(", interval=").$(periodMs).$('T').I$();
    }

    private boolean filterByDirName(Timer timer) {
        return this.filteredDirName != null && this.filteredDirName.equals(timer.getMatViewToken().getDirName());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processExpiredTimers(long now) {
        Timer timer;
        this.expired.clear();
        boolean ran = false;
        while ((timer = this.timerQueue.peek()) != null && timer.getDeadline() <= now) {
            block12: {
                TableToken viewToken;
                block11: {
                    timer = this.timerQueue.poll();
                    this.expired.add(timer);
                    viewToken = timer.getMatViewToken();
                    MatViewState state = this.matViewStateStore.getViewState(viewToken);
                    if (state == null) break block11;
                    if (state.isDropped()) {
                        this.expired.remove(this.expired.size() - 1);
                        LOG.info().$("unregistered timer for dropped materialized view [view=").$(viewToken).$(", type=").$(timer.getType()).I$();
                        break block12;
                    } else if (!state.isPendingInvalidation() && !state.isInvalid()) {
                        switch (timer.getType()) {
                            case 0: {
                                long refreshSeq = state.getRefreshSeq();
                                if (timer.getKnownSeq() == refreshSeq) break;
                                this.matViewStateStore.enqueueIncrementalRefresh(viewToken);
                                timer.setKnownSeq(refreshSeq);
                                break;
                            }
                            case 1: {
                                this.matViewStateStore.enqueueRangeRefresh(viewToken, Long.MIN_VALUE, timer.getPeriodHi() - 1L);
                                break;
                            }
                            case 2: {
                                long refreshIntervalsSeq = state.getRefreshIntervalsSeq();
                                if (timer.getKnownSeq() == refreshIntervalsSeq) break;
                                this.matViewStateStore.enqueueUpdateRefreshIntervals(viewToken);
                                timer.setKnownSeq(refreshIntervalsSeq);
                                break;
                            }
                            default: {
                                LOG.error().$("unexpected timer type [view=").$(viewToken).$(", type=").$(timer.getType()).I$();
                                break;
                            }
                        }
                    }
                    break block12;
                }
                LOG.info().$("state for materialized view not found [view=").$(viewToken).I$();
            }
            ran = true;
        }
        int i = 0;
        int n = this.expired.size();
        while (i < n) {
            timer = this.expired.getQuick(i);
            timer.nextDeadline();
            this.timerQueue.add(timer);
            ++i;
        }
        return ran;
    }

    private boolean removeTimers(TableToken viewToken) {
        this.filteredDirName = viewToken.getDirName();
        try {
            if (this.timerQueue.removeIf(this.filterByDirName)) {
                LOG.info().$("unregistered timers for materialized view [view=").$(viewToken).I$();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.filteredDirName = null;
        }
        LOG.info().$("timers for materialized view not found [view=").$(viewToken).I$();
        return false;
    }

    @Override
    protected boolean runSerially() {
        boolean ran = false;
        long now = this.clock.getTicks();
        while (this.timerTaskQueue.tryDequeue(this.timerTask)) {
            TableToken viewToken = this.timerTask.getMatViewToken();
            switch (this.timerTask.getOperation()) {
                case 0: {
                    this.addTimers(viewToken, now);
                    break;
                }
                case 1: {
                    this.removeTimers(viewToken);
                    break;
                }
                case 2: {
                    if (!this.removeTimers(viewToken)) break;
                    this.addTimers(viewToken, now);
                    break;
                }
                default: {
                    LOG.error().$("unknown refresh timer operation [op=").$(this.timerTask.getOperation()).I$();
                }
            }
            ran = true;
        }
        return ran |= this.processExpiredTimers(now);
    }

    private static class Timer {
        private static final byte INCREMENTAL_REFRESH_TYPE = 0;
        private static final byte PERIOD_REFRESH_TYPE = 1;
        private static final byte UPDATE_REFRESH_INTERVALS_TYPE = 2;
        private final long delay;
        private final TableToken matViewToken;
        private final TimestampSampler sampler;
        private final byte type;
        private final TimeZoneRules tzRules;
        private long deadlineLocal;
        private long deadlineUtc;
        private long knownSeq = -1L;

        public Timer(byte type, @NotNull TableToken matViewToken, @NotNull TimestampSampler sampler, @Nullable TimeZoneRules tzRules, long delay, long start, long now) {
            this.type = type;
            this.matViewToken = matViewToken;
            this.sampler = sampler;
            this.tzRules = tzRules;
            this.delay = delay;
            sampler.setStart(start);
            long nowLocal = Timer.toLocal(now, tzRules);
            switch (type) {
                case 0: 
                case 2: {
                    this.deadlineLocal = nowLocal > start ? sampler.nextTimestamp(sampler.round(nowLocal - 1L)) : start;
                    break;
                }
                case 1: {
                    this.deadlineLocal = nowLocal > start ? sampler.round(nowLocal) : start;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected timer type: " + type);
                }
            }
            this.deadlineUtc = Timer.toUtc(this.deadlineLocal, tzRules);
        }

        public long getDeadline() {
            return this.deadlineUtc + this.delay;
        }

        public long getKnownSeq() {
            return this.knownSeq;
        }

        public TableToken getMatViewToken() {
            return this.matViewToken;
        }

        public long getPeriodHi() {
            return this.deadlineUtc;
        }

        public byte getType() {
            return this.type;
        }

        public void setKnownSeq(long knownSeq) {
            this.knownSeq = knownSeq;
        }

        private static long toLocal(long utcTime, TimeZoneRules tzRules) {
            return tzRules != null ? utcTime + tzRules.getOffset(utcTime) : utcTime;
        }

        private static long toUtc(long localTime, TimeZoneRules tzRules) {
            return tzRules != null ? localTime - tzRules.getOffset(localTime) : localTime;
        }

        private void nextDeadline() {
            this.deadlineLocal = this.sampler.nextTimestamp(this.deadlineLocal);
            this.deadlineUtc = Timer.toUtc(this.deadlineLocal, this.tzRules);
        }
    }
}

