/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.ptt;

import io.questdb.cairo.ptt.PartitionDateParseUtil;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsoWeekPartitionFormat
implements DateFormat {
    @Override
    public void format(long timestamp, @NotNull DateLocale locale, @Nullable CharSequence timeZoneName, @NotNull CharSink<?> sink) {
        long weekTime = timestamp - Timestamps.floorWW(timestamp);
        TimestampFormatUtils.WEEK_FORMAT.format(timestamp, locale, timeZoneName, sink);
        if (weekTime > 0L) {
            int dayOfWeek = (int)(weekTime / 86400000000L) + 1;
            int hour = (int)(weekTime % 86400000000L / 3600000000L);
            int minute = (int)(weekTime % 3600000000L / 60000000L);
            int second = (int)(weekTime % 60000000L / 1000000L);
            int milliMicros = (int)(weekTime % 1000000L);
            sink.putAscii('-');
            sink.put(dayOfWeek);
            if (hour > 0 || minute > 0 || second > 0 || milliMicros > 0) {
                sink.putAscii('T');
                TimestampFormatUtils.append0(sink, hour);
                if (minute > 0 || second > 0 || milliMicros > 0) {
                    TimestampFormatUtils.append0(sink, minute);
                    TimestampFormatUtils.append0(sink, second);
                    if (milliMicros > 0) {
                        sink.putAscii('-');
                        TimestampFormatUtils.append00000(sink, milliMicros);
                    }
                }
            }
        }
    }

    @Override
    public long parse(@NotNull CharSequence in, @NotNull DateLocale locale) throws NumericException {
        return this.parse(in, 0, in.length(), locale);
    }

    @Override
    public long parse(@NotNull CharSequence in, int lo, int hi, @NotNull DateLocale locale) throws NumericException {
        long baseTs = TimestampFormatUtils.WEEK_FORMAT.parse(in, lo, lo + 8, locale);
        if ((lo += 8) < hi) {
            return PartitionDateParseUtil.parseDayTime(in, hi, lo, baseTs, 7, 1);
        }
        return baseTs;
    }
}

