/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordRandomAccess;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.griffin.engine.table.parquet.RowGroupBuffers;
import io.questdb.std.DirectIntList;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

public class PageFrameMemoryPool
implements RecordRandomAccess,
QuietCloseable,
Mutable {
    private static final byte FRAME_MEMORY_MASK = 4;
    private static final byte RECORD_A_MASK = 1;
    private static final byte RECORD_B_MASK = 2;
    private final ObjList<ParquetBuffers> cachedParquetBuffers;
    private final PageFrameMemoryImpl frameMemory;
    private final ObjList<ParquetBuffers> freeParquetBuffers;
    private final IntList fromParquetColumnIndexes;
    private final int parquetCacheSize;
    private final DirectIntList parquetColumns;
    private final PartitionDecoder parquetDecoder;
    private final IntList toParquetColumnIndexes;
    private PageFrameAddressCache addressCache;

    public PageFrameMemoryPool(int parquetCacheSize) {
        try {
            this.parquetCacheSize = parquetCacheSize;
            this.cachedParquetBuffers = new ObjList(parquetCacheSize);
            this.freeParquetBuffers = new ObjList(parquetCacheSize);
            for (int i = 0; i < parquetCacheSize; ++i) {
                this.freeParquetBuffers.add(new ParquetBuffers());
            }
            this.frameMemory = new PageFrameMemoryImpl();
            this.toParquetColumnIndexes = new IntList(16);
            this.fromParquetColumnIndexes = new IntList(16);
            this.parquetColumns = new DirectIntList(32L, 19);
            this.parquetDecoder = new PartitionDecoder();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        Misc.free(this.parquetDecoder);
        this.toParquetColumnIndexes.restoreInitialCapacity();
        this.fromParquetColumnIndexes.restoreInitialCapacity();
        this.parquetColumns.resetCapacity();
        this.freeParquetBuffers.addAll(this.cachedParquetBuffers);
        this.cachedParquetBuffers.clear();
        Misc.freeObjListAndKeepObjects(this.freeParquetBuffers);
        this.frameMemory.clear();
        this.addressCache = null;
    }

    @Override
    public void close() {
        Misc.free(this.parquetDecoder);
        Misc.free(this.parquetColumns);
        this.freeParquetBuffers.addAll(this.cachedParquetBuffers);
        this.cachedParquetBuffers.clear();
        Misc.freeObjListAndKeepObjects(this.freeParquetBuffers);
        this.addressCache = null;
    }

    public void navigateTo(int frameIndex, PageFrameMemoryRecord record) {
        if (record.getFrameIndex() == frameIndex) {
            return;
        }
        byte format = this.addressCache.getFrameFormat(frameIndex);
        if (format == 0) {
            record.init(frameIndex, format, this.addressCache.getRowIdOffset(frameIndex), this.addressCache.getPageAddresses(frameIndex), this.addressCache.getAuxPageAddresses(frameIndex), this.addressCache.getPageSizes(frameIndex), this.addressCache.getAuxPageSizes(frameIndex));
        } else if (format == 1) {
            this.openParquet(frameIndex);
            byte usageBit = record.getLetter() == 0 ? (byte)1 : 2;
            ParquetBuffers parquetBuffers = this.nextFreeBuffers(frameIndex, usageBit);
            int rowGroupIndex = this.addressCache.getParquetRowGroup(frameIndex);
            int rowGroupLo = this.addressCache.getParquetRowGroupLo(frameIndex);
            int rowGroupHi = this.addressCache.getParquetRowGroupHi(frameIndex);
            parquetBuffers.decode(this.parquetDecoder, this.parquetColumns, rowGroupIndex, rowGroupLo, rowGroupHi);
            record.init(frameIndex, format, this.addressCache.getRowIdOffset(frameIndex), parquetBuffers.pageAddresses, parquetBuffers.auxPageAddresses, parquetBuffers.pageSizes, parquetBuffers.auxPageSizes);
        }
    }

    public PageFrameMemory navigateTo(int frameIndex) {
        if (this.frameMemory.frameIndex == frameIndex) {
            return this.frameMemory;
        }
        byte format = this.addressCache.getFrameFormat(frameIndex);
        if (format == 0) {
            this.frameMemory.pageAddresses = this.addressCache.getPageAddresses(frameIndex);
            this.frameMemory.auxPageAddresses = this.addressCache.getAuxPageAddresses(frameIndex);
            this.frameMemory.pageSizes = this.addressCache.getPageSizes(frameIndex);
            this.frameMemory.auxPageSizes = this.addressCache.getAuxPageSizes(frameIndex);
        } else if (format == 1) {
            this.openParquet(frameIndex);
            ParquetBuffers parquetBuffers = this.nextFreeBuffers(frameIndex, (byte)4);
            int rowGroupIndex = this.addressCache.getParquetRowGroup(frameIndex);
            int rowGroupLo = this.addressCache.getParquetRowGroupLo(frameIndex);
            int rowGroupHi = this.addressCache.getParquetRowGroupHi(frameIndex);
            parquetBuffers.decode(this.parquetDecoder, this.parquetColumns, rowGroupIndex, rowGroupLo, rowGroupHi);
            this.frameMemory.pageAddresses = parquetBuffers.pageAddresses;
            this.frameMemory.auxPageAddresses = parquetBuffers.auxPageAddresses;
            this.frameMemory.pageSizes = parquetBuffers.pageSizes;
            this.frameMemory.auxPageSizes = parquetBuffers.auxPageSizes;
        }
        this.frameMemory.frameIndex = frameIndex;
        this.frameMemory.frameFormat = format;
        return this.frameMemory;
    }

    public void of(PageFrameAddressCache addressCache) {
        this.addressCache = addressCache;
        this.parquetColumns.reopen();
        int n = this.freeParquetBuffers.size();
        for (int i = 0; i < n; ++i) {
            this.freeParquetBuffers.getQuick(i).reopen();
        }
        this.frameMemory.clear();
        Misc.free(this.parquetDecoder);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        this.navigateTo(Rows.toPartitionIndex(atRowId), frameMemoryRecord);
        frameMemoryRecord.setRowIndex(Rows.toLocalRowID(atRowId));
    }

    @NotNull
    private ParquetBuffers nextFreeBuffers(int frameIndex, byte usageBit) {
        ParquetBuffers buffers;
        int n = this.cachedParquetBuffers.size();
        for (int i = 0; i < n; ++i) {
            buffers = this.cachedParquetBuffers.getQuick(i);
            buffers.usageFlags = (byte)(buffers.usageFlags & (byte)(~usageBit));
        }
        int cached = this.cachedParquetBuffers.size();
        for (int i = 0; i < cached; ++i) {
            buffers = this.cachedParquetBuffers.getQuick(i);
            if (buffers.frameIndex != frameIndex) continue;
            buffers.usageFlags = (byte)(buffers.usageFlags | usageBit);
            this.cachedParquetBuffers.setQuick(i, this.cachedParquetBuffers.getQuick(cached - 1));
            this.cachedParquetBuffers.setQuick(cached - 1, buffers);
            return buffers;
        }
        int free = this.freeParquetBuffers.size();
        if (free > 0) {
            buffers = this.freeParquetBuffers.getQuick(free - 1);
            this.freeParquetBuffers.remove(free - 1);
            buffers.frameIndex = frameIndex;
            buffers.usageFlags = usageBit;
            this.cachedParquetBuffers.add(buffers);
            return buffers;
        }
        for (int i = 0; i < cached; ++i) {
            ParquetBuffers buffers2 = this.cachedParquetBuffers.getQuick(i);
            if (buffers2.usageFlags != 0) continue;
            buffers2.frameIndex = frameIndex;
            buffers2.usageFlags = usageBit;
            this.cachedParquetBuffers.setQuick(i, this.cachedParquetBuffers.getQuick(cached - 1));
            this.cachedParquetBuffers.setQuick(cached - 1, buffers2);
            return buffers2;
        }
        throw CairoException.critical(0).put("insufficient memory pool size [size=").put(this.parquetCacheSize).put(", usageBit=").put(usageBit).put(']');
    }

    private void openParquet(int frameIndex) {
        int columnIndex;
        int i;
        PartitionDecoder.Metadata parquetMetadata;
        long addr = this.addressCache.getParquetAddr(frameIndex);
        long fileSize = this.addressCache.getParquetFileSize(frameIndex);
        if (this.parquetDecoder.getFileAddr() != addr || this.parquetDecoder.getFileSize() != fileSize) {
            this.parquetDecoder.of(addr, fileSize, 65);
        }
        if ((parquetMetadata = this.parquetDecoder.metadata()).columnCount() < this.addressCache.getColumnCount()) {
            throw CairoException.nonCritical().put("parquet column count is less than number of queried table columns [parquetColumnCount=").put(parquetMetadata.columnCount()).put(", columnCount=").put(this.addressCache.getColumnCount());
        }
        this.toParquetColumnIndexes.clear();
        int n = parquetMetadata.columnCount();
        for (i = 0; i < n; ++i) {
            columnIndex = parquetMetadata.columnId(i);
            this.toParquetColumnIndexes.extendAndSet(columnIndex, i);
        }
        this.parquetColumns.clear();
        this.fromParquetColumnIndexes.clear();
        this.fromParquetColumnIndexes.setAll(parquetMetadata.columnCount(), -1);
        n = this.addressCache.getColumnCount();
        for (i = 0; i < n; ++i) {
            columnIndex = this.addressCache.getColumnIndexes().getQuick(i);
            int parquetColumnIndex = this.toParquetColumnIndexes.getQuick(columnIndex);
            int columnType = this.addressCache.getColumnTypes().getQuick(i);
            this.parquetColumns.add(parquetColumnIndex);
            this.fromParquetColumnIndexes.setQuick(parquetColumnIndex, i);
            this.parquetColumns.add(columnType);
        }
    }

    private class ParquetBuffers
    implements QuietCloseable,
    Reopenable {
        private final LongList auxPageAddresses = new LongList();
        private final LongList auxPageSizes = new LongList();
        private final LongList pageAddresses = new LongList();
        private final LongList pageSizes = new LongList();
        private final RowGroupBuffers rowGroupBuffers = new RowGroupBuffers(65);
        private int frameIndex = -1;
        private byte usageFlags;

        private ParquetBuffers() {
        }

        public void clearAddresses() {
            this.pageAddresses.clear();
            this.pageSizes.clear();
            this.auxPageAddresses.clear();
            this.auxPageSizes.clear();
        }

        @Override
        public void close() {
            Misc.free(this.rowGroupBuffers);
            this.clearAddresses();
            this.usageFlags = 0;
            this.frameIndex = -1;
        }

        public void decode(PartitionDecoder parquetDecoder, DirectIntList parquetColumns, int rowGroup, int rowLo, int rowHi) {
            this.clearAddresses();
            if (parquetColumns.size() > 0L) {
                parquetDecoder.decodeRowGroup(this.rowGroupBuffers, parquetColumns, rowGroup, rowLo, rowHi);
                int columnCount = PageFrameMemoryPool.this.addressCache.getColumnCount();
                this.pageAddresses.setAll(columnCount, 0L);
                this.pageSizes.setAll(columnCount, 0L);
                this.auxPageAddresses.setAll(columnCount, 0L);
                this.auxPageSizes.setAll(columnCount, 0L);
                int n = (int)(parquetColumns.size() / 2L);
                for (int i = 0; i < n; ++i) {
                    int parquetColumnIndex = parquetColumns.get(2L * (long)i);
                    int columnIndex = PageFrameMemoryPool.this.fromParquetColumnIndexes.getQuick(parquetColumnIndex);
                    int columnType = parquetColumns.get(2L * (long)i + 1L);
                    this.pageAddresses.setQuick(columnIndex, this.rowGroupBuffers.getChunkDataPtr(i));
                    this.pageSizes.setQuick(columnIndex, this.rowGroupBuffers.getChunkDataSize(i));
                    if (!ColumnType.isVarSize(columnType)) continue;
                    this.auxPageAddresses.setQuick(columnIndex, this.rowGroupBuffers.getChunkAuxPtr(i));
                    this.auxPageSizes.setQuick(columnIndex, this.rowGroupBuffers.getChunkAuxSize(i));
                }
            }
        }

        @Override
        public void reopen() {
            this.rowGroupBuffers.reopen();
        }
    }

    private class PageFrameMemoryImpl
    implements PageFrameMemory,
    Mutable {
        private LongList auxPageAddresses;
        private LongList auxPageSizes;
        private byte frameFormat = (byte)-1;
        private int frameIndex = -1;
        private LongList pageAddresses;
        private LongList pageSizes;

        private PageFrameMemoryImpl() {
        }

        @Override
        public void clear() {
            this.frameIndex = -1;
            this.frameFormat = (byte)-1;
            this.pageAddresses = null;
            this.auxPageAddresses = null;
            this.pageSizes = null;
            this.auxPageSizes = null;
        }

        @Override
        public long getAuxPageAddress(int columnIndex) {
            return this.auxPageAddresses.getQuick(columnIndex);
        }

        @Override
        public LongList getAuxPageAddresses() {
            return this.auxPageAddresses;
        }

        @Override
        public LongList getAuxPageSizes() {
            return this.auxPageSizes;
        }

        @Override
        public int getColumnCount() {
            return PageFrameMemoryPool.this.addressCache.getColumnCount();
        }

        @Override
        public byte getFrameFormat() {
            return this.frameFormat;
        }

        @Override
        public int getFrameIndex() {
            return this.frameIndex;
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return this.pageAddresses.getQuick(columnIndex);
        }

        @Override
        public LongList getPageAddresses() {
            return this.pageAddresses;
        }

        @Override
        public long getPageSize(int columnIndex) {
            return this.pageSizes.getQuick(columnIndex);
        }

        @Override
        public LongList getPageSizes() {
            return this.pageSizes;
        }

        @Override
        public long getRowIdOffset() {
            return PageFrameMemoryPool.this.addressCache.getRowIdOffset(this.frameIndex);
        }

        @Override
        public boolean hasColumnTops() {
            int n = this.pageAddresses.size();
            for (int i = 0; i < n; ++i) {
                if (this.pageAddresses.getQuick(i) != 0L || this.auxPageAddresses.getQuick(i) != 0L) continue;
                return true;
            }
            return false;
        }
    }
}

