/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.DefaultFactoryProvider;
import io.questdb.FactoryProvider;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cutlass.http.DefaultHttpContextConfiguration;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.WaitProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.line.LineTcpTimestampAdapter;
import io.questdb.network.DefaultIODispatcherConfiguration;
import io.questdb.std.ConcurrentCacheConfiguration;
import io.questdb.std.DefaultConcurrentCacheConfiguration;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.NanosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;
import java.io.IOException;
import java.io.InputStream;

public class DefaultHttpServerConfiguration
extends DefaultIODispatcherConfiguration
implements HttpFullFatServerConfiguration {
    protected final MimeTypesCache mimeTypesCache;
    private final HttpContextConfiguration httpContextConfiguration;
    private final JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new DefaultJsonQueryProcessorConfiguration(){};
    private final LineHttpProcessorConfiguration lineHttpProcessorConfiguration;
    private final StaticContentProcessorConfiguration staticContentProcessorConfiguration = new StaticContentProcessorConfiguration(){

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public String getKeepAliveHeader() {
            return null;
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return DefaultHttpServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return ".";
        }

        @Override
        public byte getRequiredAuthType() {
            return 1;
        }
    };

    public DefaultHttpServerConfiguration(CairoConfiguration cairoConfiguration) {
        this(cairoConfiguration, new DefaultHttpContextConfiguration());
    }

    public DefaultHttpServerConfiguration(CairoConfiguration cairoConfiguration, HttpContextConfiguration httpContextConfiguration) {
        try (InputStream inputStream = DefaultHttpServerConfiguration.class.getResourceAsStream("/io/questdb/site/conf/mime.types");){
            this.mimeTypesCache = new MimeTypesCache(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lineHttpProcessorConfiguration = new DefaultLineHttpProcessorConfiguration(cairoConfiguration);
        this.httpContextConfiguration = httpContextConfiguration;
    }

    @Override
    public ConcurrentCacheConfiguration getConcurrentCacheConfiguration() {
        return DefaultConcurrentCacheConfiguration.DEFAULT;
    }

    @Override
    public FactoryProvider getFactoryProvider() {
        return DefaultFactoryProvider.INSTANCE;
    }

    @Override
    public HttpContextConfiguration getHttpContextConfiguration() {
        return this.httpContextConfiguration;
    }

    @Override
    public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
        return this.jsonQueryProcessorConfiguration;
    }

    @Override
    public LineHttpProcessorConfiguration getLineHttpProcessorConfiguration() {
        return this.lineHttpProcessorConfiguration;
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public String getPoolName() {
        return "http";
    }

    @Override
    public byte getRequiredAuthType() {
        return 0;
    }

    @Override
    public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
        return this.staticContentProcessorConfiguration;
    }

    @Override
    public String getUsername() {
        return "";
    }

    @Override
    public WaitProcessorConfiguration getWaitProcessorConfiguration() {
        return new WaitProcessorConfiguration(){

            @Override
            public MillisecondClock getClock() {
                return MillisecondClockImpl.INSTANCE;
            }

            @Override
            public double getExponentialWaitMultiplier() {
                return 2.0;
            }

            @Override
            public int getInitialWaitQueueSize() {
                return 64;
            }

            @Override
            public int getMaxProcessingQueueSize() {
                return 4096;
            }

            @Override
            public long getMaxWaitCapMs() {
                return 1000L;
            }
        };
    }

    @Override
    public int getWorkerCount() {
        return 2;
    }

    @Override
    public boolean isPessimisticHealthCheckEnabled() {
        return false;
    }

    @Override
    public boolean isQueryCacheEnabled() {
        return true;
    }

    @Override
    public boolean isSettingsReadOnly() {
        return false;
    }

    @Override
    public boolean preAllocateBuffers() {
        return false;
    }

    public static class DefaultLineHttpProcessorConfiguration
    implements LineHttpProcessorConfiguration {
        private final CairoConfiguration cairoConfiguration;

        public DefaultLineHttpProcessorConfiguration(CairoConfiguration cairoConfiguration) {
            this.cairoConfiguration = cairoConfiguration;
        }

        @Override
        public boolean autoCreateNewColumns() {
            return true;
        }

        @Override
        public boolean autoCreateNewTables() {
            return true;
        }

        @Override
        public CairoConfiguration getCairoConfiguration() {
            return this.cairoConfiguration;
        }

        @Override
        public short getDefaultColumnTypeForFloat() {
            return 10;
        }

        @Override
        public short getDefaultColumnTypeForInteger() {
            return 6;
        }

        @Override
        public int getDefaultPartitionBy() {
            return 0;
        }

        @Override
        public CharSequence getInfluxPingVersion() {
            return "v2.7.4";
        }

        @Override
        public long getMaxRecvBufferSize() {
            return 0x40000000L;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public long getSymbolCacheWaitUsBeforeReload() {
            return 500000L;
        }

        @Override
        public LineTcpTimestampAdapter getTimestampAdapter() {
            return LineTcpTimestampAdapter.DEFAULT_TS_INSTANCE;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isStringToCharCastAllowed() {
            return false;
        }

        @Override
        public boolean isUseLegacyStringDefault() {
            return true;
        }

        @Override
        public boolean logMessageOnError() {
            return true;
        }
    }

    public class DefaultJsonQueryProcessorConfiguration
    implements JsonQueryProcessorConfiguration {
        @Override
        public int getConnectionCheckFrequency() {
            return 1000000;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return DefaultFactoryProvider.INSTANCE;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return "Keep-Alive: timeout=5, max=10000\r\n";
        }

        @Override
        public long getMaxQueryResponseRowLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return DefaultHttpServerConfiguration.this.httpContextConfiguration.getMillisecondClock();
        }

        @Override
        public NanosecondClock getNanosecondClock() {
            return DefaultHttpServerConfiguration.this.httpContextConfiguration.getNanosecondClock();
        }
    }
}

