/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.metrics.Target;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Files;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.DirectUtf8Sink;
import org.jetbrains.annotations.NotNull;

public class PrometheusMetricsProcessor
implements HttpRequestProcessor,
HttpRequestHandler {
    private static final CharSequence CONTENT_TYPE_TEXT = "text/plain; version=0.0.4; charset=utf-8";
    private static final LocalValue<RequestState> LV = new LocalValue();
    private final Target metrics;
    private final RequestStatePool pool;
    private final byte requiredAuthType;

    public PrometheusMetricsProcessor(Target metrics, HttpServerConfiguration configuration, RequestStatePool pool) {
        this.metrics = metrics;
        this.requiredAuthType = configuration.getRequiredAuthType();
        this.pool = pool;
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        RequestState state = this.setupState(context);
        this.metrics.scrapeIntoPrometheus(state.sink);
        HttpChunkedResponse response = context.getChunkedResponse();
        response.status(200, CONTENT_TYPE_TEXT);
        response.sendHeader();
        this.sendResponse(response, state);
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        context.resumeResponseSend();
        RequestState state = LV.get(context);
        assert (state != null);
        HttpChunkedResponse response = context.getChunkedResponse();
        this.sendResponse(response, state);
    }

    private void sendNextChunk(HttpChunkedResponse r, RequestState state) throws PeerIsSlowToReadException, PeerDisconnectedException {
        int pending = state.countPending();
        int wrote = r.writeBytes(state.sink.ptr() + (long)state.written, pending);
        state.written += wrote;
        r.sendChunk(wrote == pending);
    }

    private void sendResponse(HttpChunkedResponse r, RequestState state) throws PeerIsSlowToReadException, PeerDisconnectedException {
        while (state.countPending() > 0) {
            this.sendNextChunk(r, state);
        }
    }

    private RequestState setupState(HttpConnectionContext context) {
        RequestState state = LV.get(context);
        if (state == null) {
            state = this.pool.pop();
            LV.set(context, state);
        } else {
            state.clear();
        }
        return state;
    }

    public static class RequestStatePool
    implements QuietCloseable {
        private final int maxPoolSize;
        private final ObjList<RequestState> objects = new ObjList();

        public RequestStatePool(int maxPoolSize) {
            assert (maxPoolSize > 0);
            this.maxPoolSize = maxPoolSize;
        }

        @Override
        public void close() {
            int n = this.objects.size();
            for (int i = 0; i < n; ++i) {
                this.objects.getQuick(i).free();
            }
            this.objects.clear();
        }

        public synchronized RequestState pop() {
            RequestState state;
            if (this.objects.size() > 0) {
                int last = this.objects.size() - 1;
                state = this.objects.getQuick(last);
                this.objects.remove(last);
            } else {
                state = new RequestState(this);
            }
            return state;
        }

        public synchronized void push(RequestState requestState) {
            if (this.objects.size() < this.maxPoolSize) {
                this.objects.add(requestState);
            } else {
                requestState.free();
            }
        }

        public synchronized int size() {
            return this.objects.size();
        }
    }

    public static class RequestState
    implements QuietCloseable,
    Mutable {
        @NotNull
        public final DirectUtf8Sink sink = new DirectUtf8Sink(Files.PAGE_SIZE);
        private final RequestStatePool pool;
        public int written = 0;

        private RequestState(RequestStatePool pool) {
            this.pool = pool;
        }

        @Override
        public void clear() {
            this.sink.clear();
            this.written = 0;
        }

        @Override
        public void close() {
            this.clear();
            this.pool.push(this);
        }

        public int countPending() {
            return this.sink.size() - this.written;
        }

        public void free() {
            this.sink.close();
        }
    }
}

