/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.cutlass.line.AbstractLineSender;
import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.tcp.PlainTcpLineChannel;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.datetime.microtime.Timestamps;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public abstract class AbstractLineTcpSender
extends AbstractLineSender {
    @Deprecated
    public AbstractLineTcpSender(int ip, int port, int bufferCapacity) {
        super(new PlainTcpLineChannel(NetworkFacadeImpl.INSTANCE, ip, port, bufferCapacity * 2), bufferCapacity, 127);
    }

    public AbstractLineTcpSender(LineChannel channel, int bufferCapacity, int maxNameLength) {
        super(channel, bufferCapacity, maxNameLength);
    }

    @Override
    public final void at(long timestamp, ChronoUnit unit) {
        this.putAsciiInternal(' ').put(timestamp * AbstractLineTcpSender.unitToNanos(unit));
        this.atNow();
    }

    @Override
    public final void at(Instant timestamp) {
        this.putAsciiInternal(' ').put(timestamp.getEpochSecond() * 1000000000L + (long)timestamp.getNano());
        this.atNow();
    }

    @Override
    public void cancelRow() {
        throw new LineSenderException((CharSequence)"cancelRow() not supported by TCP transport");
    }

    @Override
    public void flush() {
        this.validateNotClosed();
        this.sendAll();
    }

    @Override
    public final AbstractLineSender timestampColumn(CharSequence name, Instant value) {
        this.writeFieldName(name).put((value.getEpochSecond() * 1000000000L + (long)value.getNano()) / 1000L).put('t');
        return this;
    }

    @Override
    public final AbstractLineSender timestampColumn(CharSequence name, long value, ChronoUnit unit) {
        this.writeFieldName(name).put(Timestamps.toMicros(value, unit)).put('t');
        return this;
    }

    @Override
    protected void send00() {
        this.sendAll();
    }
}

