/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.Nullable;

public class LineProtocolException
extends CairoException {
    private static final ThreadLocal<LineProtocolException> tlException = new ThreadLocal<LineProtocolException>(LineProtocolException::new);

    public static LineProtocolException boundsError(long entityValue, int colType, CharSequence tableNameUtf16, CharSequence columnName) {
        return LineProtocolException.instance().put("table: ").put(tableNameUtf16).put(", column: ").put(columnName).put("; line protocol value: ").put(entityValue).put(" is out bounds of column type: ").put(ColumnType.nameOf(colType));
    }

    public static LineProtocolException boundsError(long entityValue, int colType, CharSequence tableNameUtf16, int columnIndex) {
        return LineProtocolException.instance().put("table: ").put(tableNameUtf16).put(", column: ").put(columnIndex).put("; line protocol value: ").put(entityValue).put(" is out bounds of column type: ").put(ColumnType.nameOf(colType));
    }

    public static LineProtocolException castError(String tableNameUtf16, String ilpType, int colType, DirectUtf8Sequence columnName) {
        LineProtocolException instance = LineProtocolException.instance();
        instance.put("table: ").put(tableNameUtf16).put(", column: ").put(columnName).put("; cast error from protocol type: ").put(ilpType).put(" to column type: ").put(ColumnType.nameOf(colType));
        if (colType <= 0) {
            instance.put('(').put(colType).put(')');
        }
        return instance;
    }

    public static LineProtocolException designatedTimestampMustBePositive(String tableNameUtf16, long timestamp) {
        return LineProtocolException.instance().put("table: ").put(tableNameUtf16).put(", timestamp: ").put(timestamp).put("; designated timestamp before 1970-01-01 is not allowed");
    }

    public static LineProtocolException invalidColNameError(CharSequence columnName, String tableNameUtf16) {
        return LineProtocolException.instance().put("table: ").put(tableNameUtf16).put("; invalid column name: ").put(columnName);
    }

    public static LineProtocolException newColumnsNotAllowed(String columnName, String tableNameUtf16) {
        return LineProtocolException.instance().put("table: ").put(tableNameUtf16).put(", column: ").put(columnName).put(" does not exist, creating new columns is disabled");
    }

    @Override
    public LineProtocolException put(@Nullable Utf8Sequence us) {
        this.message.put(us);
        return this;
    }

    @Override
    public LineProtocolException put(@Nullable CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    @Override
    public LineProtocolException put(long value) {
        this.message.put(value);
        return this;
    }

    @Override
    public LineProtocolException put(char c) {
        this.message.put(c);
        return this;
    }

    private static LineProtocolException instance() {
        LineProtocolException ex = tlException.get();
        assert ((ex = new LineProtocolException()) != null);
        ex.clear(-1);
        return ex;
    }
}

