/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.BuildInformation;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.auth.SocketAuthenticator;
import io.questdb.cutlass.auth.UsernamePasswordMatcher;
import io.questdb.cutlass.pgwire.OptionsListener;
import io.questdb.cutlass.pgwire.PGCircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGKeywords;
import io.questdb.cutlass.pgwire.PGMessageProcessingException;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.Socket;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PGCleartextPasswordAuthenticator
implements SocketAuthenticator {
    public static final char STATUS_IDLE = 'I';
    private static final int INIT_CANCEL_REQUEST = 80877102;
    private static final int INIT_GSS_REQUEST = 80877104;
    private static final int INIT_SSL_REQUEST = 80877103;
    private static final int INIT_STARTUP_MESSAGE = 196608;
    private static final Log LOG = LogFactory.getLog(PGCleartextPasswordAuthenticator.class);
    private static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    private static final byte MESSAGE_TYPE_LOGIN_RESPONSE = 82;
    private static final byte MESSAGE_TYPE_PARAMETER_STATUS = 83;
    private static final byte MESSAGE_TYPE_PASSWORD_MESSAGE = 112;
    private static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    private final BuildInformation buildInformation;
    private final CharacterStore characterStore;
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final int circuitBreakerId;
    private final boolean dumpNetworkTraffic;
    private final DirectUtf8String dus = new DirectUtf8String();
    private final boolean matcherOwned;
    private final OptionsListener optionsListener;
    private final PGCircuitBreakerRegistry registry;
    private final String serverVersion;
    private final ResponseSink sink;
    private byte authType = 0;
    private UsernamePasswordMatcher matcher;
    private long recvBufEnd;
    private long recvBufReadPos;
    private long recvBufStart;
    private long recvBufWritePos;
    private long sendBufEnd;
    private long sendBufReadPos;
    private long sendBufStart;
    private long sendBufWritePos;
    private Socket socket;
    private State state = State.EXPECT_INIT_MESSAGE;
    private CharSequence username;

    public PGCleartextPasswordAuthenticator(PGConfiguration configuration, BuildInformation buildInformation, NetworkSqlExecutionCircuitBreaker circuitBreaker, PGCircuitBreakerRegistry registry, OptionsListener optionsListener, UsernamePasswordMatcher matcher, boolean matcherOwned) {
        this.matcher = matcher;
        this.matcherOwned = matcherOwned;
        this.characterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
        this.circuitBreakerId = registry.add(circuitBreaker);
        this.registry = registry;
        this.sink = new ResponseSink();
        this.serverVersion = configuration.getServerVersion();
        this.circuitBreaker = circuitBreaker;
        this.optionsListener = optionsListener;
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.buildInformation = buildInformation;
    }

    @Override
    public void clear() {
        this.authType = 0;
        this.circuitBreaker.setSecret(-1);
        this.circuitBreaker.resetMaxTimeToDefault();
        this.circuitBreaker.unsetTimer();
        Misc.clear(this.characterStore);
    }

    @Override
    public void close() {
        this.registry.remove(this.circuitBreakerId);
        Misc.free(this.circuitBreaker);
        if (this.matcherOwned) {
            this.matcher = Misc.freeIfCloseable(this.matcher);
        }
    }

    @Override
    public int denyAccess(CharSequence message) throws AuthenticatorException {
        this.prepareErrorResponse(message);
        this.state = State.WRITE_AND_AUTH_FAILURE;
        return this.handleIO();
    }

    @Override
    public byte getAuthType() {
        return this.authType;
    }

    @Override
    public CharSequence getPrincipal() {
        return this.username;
    }

    @Override
    public long getRecvBufPos() {
        return this.recvBufWritePos;
    }

    @Override
    public long getRecvBufPseudoStart() {
        return this.recvBufReadPos;
    }

    @Override
    public int handleIO() throws AuthenticatorException {
        try {
            block12: while (true) {
                switch (this.state) {
                    case EXPECT_INIT_MESSAGE: {
                        int r = this.readFromSocket();
                        if (r != -1) {
                            return r;
                        }
                        r = this.processInitMessage();
                        if (r == -1) continue block12;
                        return r;
                    }
                    case EXPECT_PASSWORD_MESSAGE: {
                        int r = this.readFromSocket();
                        if (r != -1) {
                            return r;
                        }
                        r = this.processPasswordMessage();
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_EXPECT_PASSWORD_MESSAGE: {
                        int r = this.writeToSocketAndAdvance(State.EXPECT_PASSWORD_MESSAGE);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_EXPECT_INIT_MESSAGE: {
                        int r = this.writeToSocketAndAdvance(State.EXPECT_INIT_MESSAGE);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_AUTH_SUCCESS: {
                        int r = this.writeToSocketAndAdvance(State.AUTH_SUCCESS);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_AUTH_FAILURE: {
                        int r = this.writeToSocketAndAdvance(State.AUTH_FAILED);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case AUTH_SUCCESS: {
                        this.circuitBreaker.of(this.socket.getFd());
                        return -1;
                    }
                    case AUTH_FAILED: {
                        return 3;
                    }
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError();
        }
        catch (PGMessageProcessingException e) {
            throw AuthenticatorException.INSTANCE;
        }
    }

    @Override
    public void init(@NotNull Socket socket, long recvBuffer, long recvBufferLimit, long sendBuffer, long sendBufferLimit) {
        this.circuitBreaker.setSecret(this.registry.getNewSecret());
        this.state = State.EXPECT_INIT_MESSAGE;
        this.username = null;
        this.socket = socket;
        this.recvBufStart = recvBuffer;
        this.recvBufReadPos = recvBuffer;
        this.recvBufWritePos = recvBuffer;
        this.recvBufEnd = recvBufferLimit;
        this.sendBufStart = sendBuffer;
        this.sendBufReadPos = sendBuffer;
        this.sendBufWritePos = sendBuffer;
        this.sendBufEnd = sendBufferLimit;
    }

    @Override
    public boolean isAuthenticated() {
        return this.state == State.AUTH_SUCCESS;
    }

    @Override
    public int loginOK() throws AuthenticatorException {
        this.compactRecvBuf();
        this.prepareLoginOk();
        this.state = State.WRITE_AND_AUTH_SUCCESS;
        return this.handleIO();
    }

    private static int getIntUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getInt(address));
    }

    private int availableToRead() {
        return (int)(this.recvBufWritePos - this.recvBufReadPos);
    }

    private void checkCapacity(long capacity) {
        if (this.sendBufWritePos + capacity > this.sendBufEnd) {
            throw NoSpaceLeftInResponseBufferException.instance(capacity);
        }
    }

    private void compactRecvBuf() {
        long len = this.recvBufWritePos - this.recvBufReadPos;
        if (len > 0L) {
            Vect.memmove(this.recvBufStart, this.recvBufReadPos, len);
        }
        this.recvBufReadPos = this.recvBufStart;
        this.recvBufWritePos = this.recvBufStart + len;
    }

    private void compactSendBuf() {
        long len = this.sendBufWritePos - this.sendBufReadPos;
        if (len > 0L) {
            Vect.memmove(this.sendBufStart, this.sendBufReadPos, len);
        }
        this.sendBufReadPos = this.sendBufStart;
        this.sendBufWritePos = this.sendBufStart + len;
    }

    private void prepareBackendKeyData(ResponseSink responseSink) {
        responseSink.put('K');
        responseSink.putInt(12);
        responseSink.putInt(this.circuitBreakerId);
        responseSink.putInt(this.circuitBreaker.getSecret());
    }

    private void prepareErrorResponse(CharSequence errorMessage) {
        this.sink.put((byte)69);
        long addr = this.sink.skip();
        this.sink.put('C');
        this.sink.encodeUtf8Z("00000");
        this.sink.put('M');
        this.sink.encodeUtf8Z(errorMessage);
        this.sink.put('S');
        this.sink.encodeUtf8Z("ERROR");
        this.sink.put('\u0000');
        this.sink.putLen(addr);
    }

    private void prepareGssResponse() {
        this.sink.put('N');
    }

    private void prepareLoginOk() {
        this.sink.put((byte)82);
        this.sink.putInt(8);
        this.sink.putInt(0);
        this.prepareParams(this.sink, "TimeZone", "GMT");
        this.prepareParams(this.sink, "application_name", "QuestDB");
        this.prepareParams(this.sink, "server_version", this.serverVersion);
        this.prepareParams(this.sink, "integer_datetimes", "on");
        this.prepareParams(this.sink, "client_encoding", "UTF8");
        if (!this.dumpNetworkTraffic && this.buildInformation != null) {
            this.prepareParams(this.sink, "questdb_version", this.buildInformation.getSwVersion());
        }
        this.prepareBackendKeyData(this.sink);
        this.prepareReadyForQuery();
    }

    private void prepareLoginResponse() {
        this.sink.put((byte)82);
        this.sink.putInt(8);
        this.sink.putInt(3);
    }

    private void prepareParams(ResponseSink sink, CharSequence name, CharSequence value) {
        sink.put((byte)83);
        long addr = sink.skip();
        sink.encodeUtf8Z(name);
        sink.encodeUtf8Z(value);
        sink.putLen(addr);
    }

    private void prepareReadyForQuery() {
        this.sink.put((byte)90);
        this.sink.putInt(5);
        this.sink.put('I');
    }

    private void prepareSslResponse() {
        this.sink.put('N');
    }

    private void processCancelMessage() {
        int pid = PGCleartextPasswordAuthenticator.getIntUnsafe(this.recvBufReadPos);
        this.recvBufReadPos += 4L;
        int secret = PGCleartextPasswordAuthenticator.getIntUnsafe(this.recvBufReadPos);
        this.recvBufReadPos += 4L;
        LOG.info().$("cancel request [pid=").$(pid).I$();
        try {
            this.registry.cancel(pid, secret);
        }
        catch (CairoException e) {
            LOG.error().$safe(e.getFlyweightMessage()).$();
        }
    }

    private int processInitMessage() throws PGMessageProcessingException {
        int availableToRead = this.availableToRead();
        if (availableToRead < 4) {
            return 0;
        }
        int msgLen = PGCleartextPasswordAuthenticator.getIntUnsafe(this.recvBufReadPos);
        if (msgLen > availableToRead) {
            return 0;
        }
        this.recvBufReadPos += 4L;
        int protocol = PGCleartextPasswordAuthenticator.getIntUnsafe(this.recvBufReadPos);
        this.recvBufReadPos += 4L;
        switch (protocol) {
            case 196608: {
                this.processStartupMessage(msgLen);
                break;
            }
            case 80877102: {
                this.processCancelMessage();
                return 3;
            }
            case 80877103: {
                this.compactRecvBuf();
                this.prepareSslResponse();
                this.state = State.WRITE_AND_EXPECT_INIT_MESSAGE;
                break;
            }
            case 80877104: {
                this.compactRecvBuf();
                this.prepareGssResponse();
                this.state = State.WRITE_AND_EXPECT_INIT_MESSAGE;
                break;
            }
            default: {
                LOG.error().$("unknown init message [protocol=").$(protocol).$(']').$();
                throw PGMessageProcessingException.INSTANCE;
            }
        }
        return -1;
    }

    private int processPasswordMessage() throws PGMessageProcessingException {
        int availableToRead = this.availableToRead();
        if (availableToRead < 5) {
            return 0;
        }
        byte msgType = Unsafe.getUnsafe().getByte(this.recvBufReadPos);
        assert (msgType == 112);
        int msgLen = PGCleartextPasswordAuthenticator.getIntUnsafe(this.recvBufReadPos + 1L);
        long msgLimit = this.recvBufReadPos + (long)msgLen + 1L;
        if (this.recvBufWritePos < msgLimit) {
            return 0;
        }
        this.recvBufReadPos += 5L;
        long hi = PGConnectionContext.getUtf8StrSize(this.recvBufReadPos, msgLimit, "bad password length", null);
        this.authType = this.verifyPassword(this.username, this.recvBufReadPos, (int)(hi - this.recvBufReadPos));
        if (this.authType != 0) {
            this.recvBufReadPos = msgLimit;
            this.state = State.AUTH_SUCCESS;
        } else {
            LOG.info().$("bad password for user [user=").$(this.username).$(']').$();
            this.prepareErrorResponse("invalid username/password");
            this.state = State.WRITE_AND_AUTH_FAILURE;
        }
        return -1;
    }

    private void processStartupMessage(int msgLen) throws PGMessageProcessingException {
        long msgLimit = this.recvBufStart + (long)msgLen;
        long lo = this.recvBufReadPos;
        while (lo < msgLimit - 1L) {
            long nameLo = lo;
            long nameHi = PGConnectionContext.getUtf8StrSize(lo, msgLimit, "malformed property name", null);
            long valueLo = nameHi + 1L;
            long valueHi = PGConnectionContext.getUtf8StrSize(valueLo, msgLimit, "malformed property value", null);
            lo = valueHi + 1L;
            if (PGKeywords.isUser(nameLo, nameHi - nameLo)) {
                CharacterStoreEntry e = this.characterStore.newEntry();
                e.put(this.dus.of(valueLo, valueHi, false));
                this.username = e.toImmutable();
            }
            boolean parsed = true;
            if (PGKeywords.isOptions(nameLo, nameHi - nameLo)) {
                if (PGKeywords.startsWithTimeoutOption(valueLo, valueHi - valueLo)) {
                    try {
                        this.dus.of(valueLo + 21L, valueHi, false);
                        long statementTimeout = Numbers.parseLong(this.dus);
                        this.optionsListener.setSqlTimeout(statementTimeout);
                    }
                    catch (NumericException ex) {
                        parsed = false;
                    }
                } else {
                    parsed = false;
                }
            }
            if (parsed) {
                LOG.debug().$("property [name=").$(this.dus.of(nameLo, nameHi, false)).$(", value=").$(this.dus.of(valueLo, valueHi, false)).$(']').$();
                continue;
            }
            LOG.info().$("invalid property [name=").$safe(this.dus.of(nameLo, nameHi, false)).$(", value=").$(this.dus.of(valueLo, valueHi, false)).$(']').$();
        }
        this.characterStore.clear();
        this.recvBufReadPos = msgLimit;
        this.compactRecvBuf();
        this.prepareLoginResponse();
        this.state = State.WRITE_AND_EXPECT_PASSWORD_MESSAGE;
    }

    private int readFromSocket() {
        int bytesRead = this.socket.recv(this.recvBufWritePos, (int)(this.recvBufEnd - this.recvBufWritePos));
        PGConnectionContext.dumpBuffer('>', this.recvBufWritePos, bytesRead, this.dumpNetworkTraffic);
        if (bytesRead < 0) {
            return 3;
        }
        this.recvBufWritePos += (long)bytesRead;
        return -1;
    }

    private int writeToSocketAndAdvance(State nextState) {
        int toWrite = (int)(this.sendBufWritePos - this.sendBufReadPos);
        int n = this.socket.send(this.sendBufReadPos, toWrite);
        PGConnectionContext.dumpBuffer('<', this.sendBufReadPos, n, this.dumpNetworkTraffic);
        if (n < 0) {
            return 3;
        }
        this.sendBufReadPos += (long)n;
        this.compactSendBuf();
        if (this.sendBufReadPos == this.sendBufWritePos) {
            this.state = nextState;
            return -1;
        }
        return 1;
    }

    protected byte verifyPassword(CharSequence username, long passwordPtr, int passwordLen) {
        return this.matcher.verifyPassword(username, passwordPtr, passwordLen);
    }

    private static enum State {
        EXPECT_INIT_MESSAGE,
        EXPECT_PASSWORD_MESSAGE,
        WRITE_AND_EXPECT_INIT_MESSAGE,
        WRITE_AND_EXPECT_PASSWORD_MESSAGE,
        WRITE_AND_AUTH_SUCCESS,
        WRITE_AND_AUTH_FAILURE,
        AUTH_SUCCESS,
        AUTH_FAILED;

    }

    private class ResponseSink
    implements Utf8Sink {
        private ResponseSink() {
        }

        @Override
        public Utf8Sink put(@Nullable Utf8Sequence us) {
            return this;
        }

        @Override
        public Utf8Sink put(byte b) {
            PGCleartextPasswordAuthenticator.this.checkCapacity(1L);
            Unsafe.getUnsafe().putByte(PGCleartextPasswordAuthenticator.this.sendBufWritePos++, b);
            return this;
        }

        public void putInt(int i) {
            PGCleartextPasswordAuthenticator.this.checkCapacity(4L);
            Unsafe.getUnsafe().putInt(PGCleartextPasswordAuthenticator.this.sendBufWritePos, Numbers.bswap(i));
            PGCleartextPasswordAuthenticator.this.sendBufWritePos += 4L;
        }

        public void putLen(long start) {
            int len = (int)(PGCleartextPasswordAuthenticator.this.sendBufWritePos - start);
            Unsafe.getUnsafe().putInt(start, Numbers.bswap(len));
        }

        @Override
        public Utf8Sink putNonAscii(long lo, long hi) {
            long size = hi - lo;
            PGCleartextPasswordAuthenticator.this.checkCapacity(size);
            Vect.memcpy(PGCleartextPasswordAuthenticator.this.sendBufWritePos, lo, size);
            PGCleartextPasswordAuthenticator.this.sendBufWritePos += size;
            return this;
        }

        void encodeUtf8Z(CharSequence value) {
            this.put(value);
            PGCleartextPasswordAuthenticator.this.checkCapacity(1L);
            this.put((byte)0);
        }

        long skip() {
            PGCleartextPasswordAuthenticator.this.checkCapacity(4L);
            long checkpoint = PGCleartextPasswordAuthenticator.this.sendBufWritePos;
            PGCleartextPasswordAuthenticator.this.sendBufWritePos += 4L;
            return checkpoint;
        }
    }
}

