/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGMessageProcessingException;
import io.questdb.cutlass.pgwire.PGNonNullBinaryArrayView;
import io.questdb.cutlass.pgwire.PGOids;
import io.questdb.cutlass.pgwire.PGResponseSink;
import io.questdb.cutlass.pgwire.PGUtils;
import io.questdb.cutlass.pgwire.TypeContainer;
import io.questdb.cutlass.pgwire.TypesAndInsert;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.CompiledQueryImpl;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SCSequence;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.QueryPausedException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.BinarySequence;
import io.questdb.std.BitSet;
import io.questdb.std.Chars;
import io.questdb.std.DirectBinarySequence;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.ObjectPool;
import io.questdb.std.ObjectStackPool;
import io.questdb.std.QuietCloseable;
import io.questdb.std.SimpleAssociativeCache;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.Vect;
import io.questdb.std.WeakSelfReturningObjectPool;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.datetime.millitime.Dates;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class PGPipelineEntry
implements QuietCloseable,
Mutable {
    public static final int SYNC_DESC_NONE = 0;
    public static final int SYNC_DESC_PARAMETER_DESCRIPTION = 2;
    public static final int SYNC_DESC_ROW_DESCRIPTION = 1;
    private static final int ERROR_TAIL_MAX_SIZE = 23;
    private static final Log LOG = LogFactory.getLog(PGPipelineEntry.class);
    private static final int ROW_DESCRIPTION_COLUMN_RECORD_FIXED_SIZE = 18;
    private static final int SYNC_BIND = 1;
    private static final int SYNC_COMPUTE_CURSOR_SIZE = 3;
    private static final int SYNC_DATA = 4;
    private static final int SYNC_DATA_EXHAUSTED = 6;
    private static final int SYNC_DATA_SUSPENDED = 7;
    private static final int SYNC_DESCRIBE = 2;
    private static final int SYNC_DONE = 5;
    private static final int SYNC_PARSE = 0;
    private final ObjectPool<PGNonNullBinaryArrayView> arrayViewPool = new ObjectPool<PGNonNullBinaryArrayView>(PGNonNullBinaryArrayView::new, 1);
    private final CairoEngine engine;
    private final StringSink errorMessageSink = new StringSink();
    private final int maxRecompileAttempts;
    private final BitSet msgBindParameterFormatCodes = new BitSet();
    private final BitSet msgBindSelectFormatCodes = new BitSet();
    private final IntList msgParseParameterTypeOIDs;
    private final ObjList<Utf8String> namedPortals = new ObjList();
    private final LongList outParameterTypeDescriptionTypes;
    private final ObjList<String> pgResultSetColumnNames;
    private final IntList pgResultSetColumnTypes;
    private final Utf8StringSink utf8StringSink = new Utf8StringSink();
    boolean isCopy = false;
    private boolean cacheHit = false;
    private CompiledQueryImpl compiledQuery;
    private RecordCursor cursor;
    private boolean empty;
    private boolean error = false;
    private int errorMessagePosition;
    private RecordCursorFactory factory = null;
    private int msgBindParameterValueCount;
    private short msgBindSelectFormatCodeCount = 0;
    private Utf8String namedPortal;
    private Utf8String namedStatement;
    private Operation operation = null;
    private int outResendArrayFlatIndex = 0;
    private int outResendColumnIndex = 0;
    private boolean outResendCursorRecord = false;
    private boolean outResendRecordHeader = true;
    private long parameterValueArenaHi;
    private long parameterValueArenaLo;
    private long parameterValueArenaPtr = 0L;
    private PGPipelineEntry parentPreparedStatementPipelineEntry;
    private boolean portal = false;
    private Utf8Sequence preparedStatementNameToDeallocate;
    private long sqlAffectedRowCount = 0L;
    private long sqlReturnRowCount = 0L;
    private long sqlReturnRowCountLimit = 0L;
    private long sqlReturnRowCountToBeSent = 0L;
    private String sqlTag = null;
    private CharSequence sqlText = null;
    private boolean sqlTextHasSecret = false;
    private short sqlType = 0;
    private boolean stalePlanError = false;
    private boolean stateBind;
    private boolean stateClosed;
    private int stateDesc;
    private boolean stateExec = false;
    private boolean stateParse;
    private boolean stateParseExecuted = false;
    private int stateSync = 0;
    private TypesAndInsert tai = null;
    private TypesAndSelect tas = null;

    public PGPipelineEntry(CairoEngine engine) {
        this.engine = engine;
        this.maxRecompileAttempts = engine.getConfiguration().getMaxSqlRecompileAttempts();
        this.msgParseParameterTypeOIDs = new IntList();
        this.outParameterTypeDescriptionTypes = new LongList();
        this.pgResultSetColumnTypes = new IntList();
        this.pgResultSetColumnNames = new ObjList();
    }

    public void bindPortalName(Utf8String portalName) {
        this.namedPortals.add(portalName);
    }

    public void cacheIfPossible(@NotNull AssociativeCache<TypesAndSelect> tasCache, @NotNull SimpleAssociativeCache<TypesAndInsert> taiCache) {
        if (this.isPortal() || this.isPreparedStatement()) {
            return;
        }
        if (this.tas != null) {
            this.cursor = Misc.free(this.cursor);
            this.factory = null;
            tasCache.put(this.sqlText, this.tas);
            this.tas = null;
        } else if (this.tai != null) {
            taiCache.put(this.sqlText, this.tai);
            this.tai = null;
        }
    }

    @Override
    public void clear() {
        if (this.sqlType != 0) {
            LOG.error().$("Object Pool contains dirty PGPipeline entries. This is likely a bug, please report it to https://github.com/questdb/questdb/issues/new?template=bug_report.yaml").$();
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.isCopy) {
            this.tai = Misc.free(this.tai);
            this.operation = Misc.free(this.operation);
            if (this.compiledQuery != null) {
                Misc.free(this.compiledQuery.getUpdateOperation());
            }
        } else {
            this.tai = null;
            this.operation = null;
        }
        this.errorMessageSink.clear();
        this.msgBindParameterFormatCodes.clear();
        this.msgBindSelectFormatCodes.clear();
        this.msgParseParameterTypeOIDs.clear();
        this.outParameterTypeDescriptionTypes.clear();
        this.pgResultSetColumnNames.clear();
        this.pgResultSetColumnTypes.clear();
        this.namedPortals.clear();
        this.isCopy = false;
        this.cacheHit = false;
        this.cursor = Misc.free(this.cursor);
        this.error = false;
        this.empty = false;
        this.errorMessagePosition = 0;
        this.factory = Misc.free(this.factory);
        this.msgBindParameterValueCount = 0;
        this.msgBindSelectFormatCodeCount = 0;
        this.outResendColumnIndex = 0;
        this.outResendCursorRecord = false;
        this.outResendRecordHeader = true;
        if (this.parameterValueArenaPtr != 0L) {
            this.parameterValueArenaPtr = Unsafe.free(this.parameterValueArenaPtr, this.parameterValueArenaHi - this.parameterValueArenaPtr, 49);
        }
        this.parentPreparedStatementPipelineEntry = null;
        this.portal = false;
        this.namedPortal = null;
        this.namedStatement = null;
        this.preparedStatementNameToDeallocate = null;
        this.sqlAffectedRowCount = 0L;
        this.sqlReturnRowCount = 0L;
        this.sqlReturnRowCountLimit = 0L;
        this.sqlReturnRowCountToBeSent = 0L;
        this.sqlTag = null;
        this.sqlText = null;
        this.sqlTextHasSecret = false;
        this.sqlType = 0;
        this.stalePlanError = false;
        this.stateBind = false;
        this.stateClosed = false;
        this.stateDesc = 0;
        this.stateExec = false;
        this.stateParse = false;
        this.stateParseExecuted = false;
        this.stateSync = 0;
        this.tas = null;
        this.arrayViewPool.clear();
        this.utf8StringSink.clear();
    }

    public void commit(ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters) throws PGMessageProcessingException {
        try {
            for (ObjObjHashMap.Entry<TableToken, TableWriterAPI> entry : pendingWriters) {
                TableWriterAPI w = (TableWriterAPI)entry.value;
                if (w != null) {
                    w.commit();
                }
                entry.value = Misc.free(w);
            }
            pendingWriters.clear();
        }
        catch (Throwable th) {
            this.rollback(pendingWriters);
            throw this.kaput().put(th);
        }
    }

    public void compileNewSQL(CharSequence sqlText, CairoEngine engine, SqlExecutionContext sqlExecutionContext, WeakSelfReturningObjectPool<TypesAndInsert> taiPool, boolean recompile) throws PGMessageProcessingException {
        this.sqlText = sqlText;
        if (!recompile) {
            sqlExecutionContext.resetFlags();
        }
        boolean bl = this.empty = sqlText == null || sqlText.length() == 0;
        if (this.empty) {
            this.cacheHit = true;
            sqlExecutionContext.setCacheHit(true);
            return;
        }
        try {
            this.cacheHit = false;
            sqlExecutionContext.setCacheHit(false);
            try (SqlCompiler compiler = engine.getSqlCompiler();){
                if (!recompile) {
                    this.msgParseDefineBindVariableTypes(sqlExecutionContext.getBindVariableService());
                }
                CompiledQuery cq = compiler.compile(sqlText, sqlExecutionContext);
                this.msgParseCopyOutTypeDescriptionTypeOIDs(sqlExecutionContext.getBindVariableService());
                this.setupEntryAfterSQLCompilation(sqlExecutionContext, taiPool, cq);
            }
            this.validatePgResultSetColumnTypesAndNames();
        }
        catch (Throwable th) {
            if (th instanceof PGMessageProcessingException) {
                throw (PGMessageProcessingException)th;
            }
            throw this.kaput().put(th);
        }
    }

    @NotNull
    public PGPipelineEntry copyIfExecuted(ObjectStackPool<PGPipelineEntry> entryPool) {
        if (!this.stateExec) {
            return this;
        }
        PGPipelineEntry newEntry = entryPool.next();
        newEntry.copyOf(this);
        return newEntry;
    }

    public int getErrorMessagePosition() {
        return this.errorMessagePosition;
    }

    public StringSink getErrorMessageSink() {
        if (!this.error) {
            this.errorMessageSink.clear();
            this.error = true;
        }
        return this.errorMessageSink;
    }

    public int getInt(long address, long msgLimit, CharSequence errorMessage) throws PGMessageProcessingException {
        if (address + 4L <= msgLimit) {
            return PGConnectionContext.getIntUnsafe(address);
        }
        throw this.kaput().put(errorMessage);
    }

    public Utf8String getNamedPortal() {
        return this.namedPortal;
    }

    public ObjList<Utf8String> getNamedPortals() {
        return this.namedPortals;
    }

    public Utf8String getNamedStatement() {
        return this.namedStatement;
    }

    public PGPipelineEntry getParentPreparedStatementPipelineEntry() {
        return this.parentPreparedStatementPipelineEntry;
    }

    public short getShort(long address, long msgLimit, CharSequence errorMessage) throws PGMessageProcessingException {
        if (address + 2L <= msgLimit) {
            return PGConnectionContext.getShortUnsafe(address);
        }
        throw this.kaput().put(errorMessage);
    }

    public CharSequence getSqlText() {
        return this.sqlText;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isFactory() {
        return this.factory != null;
    }

    public boolean isPortal() {
        return this.portal;
    }

    public boolean isPreparedStatement() {
        return this.namedStatement != null;
    }

    public boolean isStateClosed() {
        return this.stateClosed;
    }

    public boolean isStateExec() {
        return this.stateExec;
    }

    public void msgBindCopyParameterFormatCodes(long lo, long msgLimit, short parameterFormatCodeCount, short parameterValueCount) throws PGMessageProcessingException {
        this.msgBindParameterValueCount = parameterValueCount;
        this.msgBindParameterFormatCodes.clear();
        if (parameterFormatCodeCount > 0) {
            if (parameterFormatCodeCount == 1) {
                short code = this.getShort(lo, msgLimit, "could not read parameter formats");
                if (code == 1) {
                    for (int i = 0; i < parameterValueCount; ++i) {
                        this.msgBindParameterFormatCodes.set(i);
                    }
                }
            } else if (lo + (long)(2 * parameterFormatCodeCount) <= msgLimit) {
                for (int i = 0; i < parameterFormatCodeCount; ++i) {
                    if (PGConnectionContext.getShortUnsafe(lo + (long)(i * 2)) != 1) continue;
                    this.msgBindParameterFormatCodes.set(i);
                }
            } else {
                throw this.kaput().put("invalid format code count [value=").put(parameterFormatCodeCount).put(']');
            }
        }
    }

    public long msgBindCopyParameterValuesArea(long lo, long msgLimit) throws PGMessageProcessingException {
        long valueAreaSize = this.msgBindComputeParameterValueAreaSize(lo, msgLimit);
        if (valueAreaSize > 0L) {
            long sz = Numbers.ceilPow2(valueAreaSize);
            if (this.parameterValueArenaPtr == 0L) {
                this.parameterValueArenaLo = this.parameterValueArenaPtr = Unsafe.malloc(sz, 49);
                this.parameterValueArenaHi = this.parameterValueArenaPtr + sz;
            } else if (this.parameterValueArenaHi - this.parameterValueArenaPtr < valueAreaSize) {
                this.parameterValueArenaLo = this.parameterValueArenaPtr = Unsafe.realloc(this.parameterValueArenaPtr, this.parameterValueArenaHi - this.parameterValueArenaPtr, sz, 49);
                this.parameterValueArenaHi = this.parameterValueArenaPtr + sz;
            }
            long len = Math.min(valueAreaSize, msgLimit);
            Vect.memcpy(this.parameterValueArenaLo, lo, len);
            if (len < valueAreaSize) {
                this.parameterValueArenaLo += len;
                throw PGMessageProcessingException.INSTANCE;
            }
            this.parameterValueArenaLo = this.parameterValueArenaPtr;
        }
        return lo + valueAreaSize;
    }

    public void msgBindCopySelectFormatCodes(long lo, short selectFormatCodeCount) {
        this.msgBindSelectFormatCodes.clear();
        this.msgBindSelectFormatCodeCount = selectFormatCodeCount;
        if (this.factory != null && selectFormatCodeCount > 0) {
            for (int i = 0; i < selectFormatCodeCount; ++i) {
                if (PGConnectionContext.getShortUnsafe(lo) == 1) {
                    this.msgBindSelectFormatCodes.set(i);
                }
                lo += 2L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int msgExecute(SqlExecutionContext sqlExecutionContext, int transactionState, WeakSelfReturningObjectPool<TypesAndInsert> taiPool, ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters, WriterSource writerSource, CharacterStore bindVariableCharacterStore, DirectUtf8String directUtf8String, ObjectPool<DirectBinarySequence> binarySequenceParamsPool, SCSequence tempSequence, Consumer<? super Utf8Sequence> namedStatementDeallocator) throws PGMessageProcessingException {
        if (this.stateParseExecuted) {
            this.stateParseExecuted = false;
            return transactionState;
        }
        sqlExecutionContext.containsSecret(this.sqlTextHasSecret);
        try {
            switch (this.sqlType) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 10: 
                case 14: 
                case 25: {
                    this.copyParameterValuesToBindVariableService(sqlExecutionContext, bindVariableCharacterStore, directUtf8String, binarySequenceParamsPool);
                    break;
                }
            }
            switch (this.sqlType) {
                case 1: 
                case 8: 
                case 25: {
                    this.msgExecuteSelect(sqlExecutionContext, transactionState, pendingWriters, taiPool, this.maxRecompileAttempts);
                    return transactionState;
                }
                case 2: 
                case 10: {
                    this.msgExecuteInsert(sqlExecutionContext, transactionState, pendingWriters, writerSource, taiPool);
                    return transactionState;
                }
                case 14: {
                    this.msgExecuteUpdate(sqlExecutionContext, transactionState, pendingWriters, tempSequence, taiPool);
                    return transactionState;
                }
                case 4: {
                    this.msgExecuteDDL(sqlExecutionContext, transactionState, tempSequence, taiPool);
                    return transactionState;
                }
                case 24: {
                    namedStatementDeallocator.accept(this.preparedStatementNameToDeallocate);
                    return transactionState;
                }
                case 18: {
                    int n = 1;
                    return n;
                }
                case 19: {
                    this.commit(pendingWriters);
                    int n = 0;
                    return n;
                }
                case 20: {
                    this.rollback(pendingWriters);
                    int n = 0;
                    return n;
                }
                case 21: {
                    this.engine.getMetrics().pgWireMetrics().markStart();
                    try (OperationFuture fut = this.operation.execute(sqlExecutionContext, tempSequence);){
                        fut.await();
                        this.sqlAffectedRowCount = fut.getAffectedRowsCount();
                        return transactionState;
                    }
                    finally {
                        this.engine.getMetrics().pgWireMetrics().markComplete();
                    }
                }
                case 7: 
                case 9: 
                case 32: {
                    this.engine.getMetrics().pgWireMetrics().markStart();
                    try (OperationFuture fut = this.operation.execute(sqlExecutionContext, tempSequence);){
                        fut.await();
                        return transactionState;
                    }
                    finally {
                        this.engine.getMetrics().pgWireMetrics().markComplete();
                    }
                }
                default: {
                    if (this.empty) return transactionState;
                    this.engine.getMetrics().pgWireMetrics().markStart();
                    try {
                        this.engine.execute(this.sqlText, sqlExecutionContext);
                        return transactionState;
                    }
                    finally {
                        this.engine.getMetrics().pgWireMetrics().markComplete();
                    }
                }
            }
        }
        catch (PGMessageProcessingException e) {
            throw e;
        }
        catch (Throwable th) {
            if (th instanceof FlyweightMessageContainer) {
                int errno;
                this.setErrorMessagePosition(((FlyweightMessageContainer)((Object)th)).getPosition());
                StringSink errorMsgSink = this.getErrorMessageSink();
                if (th instanceof CairoException && (errno = ((CairoException)th).getErrno()) != -1) {
                    errorMsgSink.put('[');
                    errorMsgSink.put(errno);
                    errorMsgSink.put("] ");
                }
                errorMsgSink.put(((FlyweightMessageContainer)((Object)th)).getFlyweightMessage());
            } else {
                String msg = th.getMessage();
                if (msg != null) {
                    this.getErrorMessageSink().put(msg);
                } else {
                    this.getErrorMessageSink().putAscii("Internal error. Exception type: ").putAscii(th.getClass().getSimpleName());
                }
            }
            if (th instanceof AssertionError) {
                LOG.critical().$("error in pgwire execute, ex=").$(th).$();
                return transactionState;
            } else {
                LOG.error().$(this.getErrorMessageSink()).$();
            }
            return transactionState;
        }
        finally {
            bindVariableCharacterStore.clear();
        }
    }

    public void msgParseCopyParameterTypesFrom(PGPipelineEntry that) {
        this.msgParseParameterTypeOIDs.addAll(that.msgParseParameterTypeOIDs);
    }

    public void msgParseCopyParameterTypesFromMsg(long lo, short parameterTypeCount) {
        this.msgParseParameterTypeOIDs.setPos(parameterTypeCount);
        for (int i = 0; i < parameterTypeCount; ++i) {
            this.msgParseParameterTypeOIDs.setQuick(i, Unsafe.getUnsafe().getInt(lo + (long)i * 4L));
        }
    }

    public void msgSync(SqlExecutionContext sqlExecutionContext, ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters, PGResponseSink utf8Sink) throws QueryPausedException, NoSpaceLeftInResponseBufferException {
        if (this.isError()) {
            this.outError(utf8Sink, pendingWriters);
        } else {
            block0 : switch (this.stateSync) {
                case 0: {
                    if (this.stateParse) {
                        PGPipelineEntry.outParseComplete(utf8Sink);
                    }
                    this.stateSync = 1;
                }
                case 1: {
                    if (this.stateBind) {
                        PGPipelineEntry.outBindComplete(utf8Sink);
                    }
                    this.stateSync = 2;
                }
                case 2: {
                    switch (this.stateDesc) {
                        case 2: {
                            this.outParameterTypeDescription(utf8Sink);
                            this.stateDesc = 1;
                        }
                        case 1: {
                            if (this.factory != null) {
                                this.outRowDescription(utf8Sink);
                                break;
                            }
                            PGPipelineEntry.outNoData(utf8Sink);
                        }
                    }
                    this.stateSync = 3;
                }
                case 3: 
                case 4: {
                    if (this.empty && !this.isPreparedStatement() && !this.portal) {
                        PGPipelineEntry.outEmptyQuery(utf8Sink);
                        this.stateSync = 5;
                        break;
                    }
                    if (this.stateExec) {
                        switch (this.sqlType) {
                            case 1: 
                            case 8: 
                            case 25: {
                                this.outCursor(sqlExecutionContext, utf8Sink);
                                break block0;
                            }
                            case 2: 
                            case 10: {
                                utf8Sink.bookmark();
                                utf8Sink.put((byte)67);
                                long addr = utf8Sink.skipInt();
                                ((Utf8Sink)utf8Sink.put(this.sqlTag).putAscii(" 0 ").put(this.sqlAffectedRowCount)).put((byte)0);
                                utf8Sink.putLen(addr);
                                this.stateSync = 5;
                                break block0;
                            }
                            case 14: 
                            case 21: {
                                this.outCommandComplete(utf8Sink, this.sqlAffectedRowCount);
                                this.stateSync = 5;
                                break block0;
                            }
                        }
                        utf8Sink.put((byte)67);
                        long addr = utf8Sink.skipInt();
                        utf8Sink.put(this.sqlTag).put((byte)0);
                        utf8Sink.putLen(addr);
                        this.stateSync = 5;
                    }
                }
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (this.stateSync) {
                case 6: {
                    this.cursor = Misc.free(this.cursor);
                    this.outCommandComplete(utf8Sink, this.sqlReturnRowCount);
                    break;
                }
                case 7: {
                    PGPipelineEntry.outPortalSuspended(utf8Sink);
                    if (this.portal) break;
                    this.cursor = Misc.free(this.cursor);
                }
            }
            if (this.stateClosed) {
                PGPipelineEntry.outSimpleMsg(utf8Sink, (byte)51);
            }
            if (this.isError()) {
                this.outError(utf8Sink, pendingWriters);
            }
        }
        this.clearState();
    }

    public void ofCachedInsert(CharSequence utf16SqlText, TypesAndInsert tai) {
        this.sqlText = utf16SqlText;
        this.sqlTag = tai.getSqlTag();
        this.sqlType = tai.getSqlType();
        this.cacheHit = true;
        this.tai = tai;
        this.outParameterTypeDescriptionTypes.clear();
        this.outParameterTypeDescriptionTypes.addAll(tai.getPgOutParameterTypes());
    }

    public void ofCachedSelect(CharSequence utf16SqlText, TypesAndSelect tas) {
        this.sqlText = utf16SqlText;
        this.factory = tas.getFactory();
        this.sqlTag = tas.getSqlTag();
        this.sqlType = tas.getSqlType();
        this.tas = tas;
        this.cacheHit = true;
        this.outParameterTypeDescriptionTypes.clear();
        this.outParameterTypeDescriptionTypes.addAll(tas.getOutPgParameterTypes());
    }

    public void ofEmpty(CharSequence utf16SqlText) {
        this.sqlText = utf16SqlText;
        this.empty = true;
    }

    public void ofSimpleCachedSelect(CharSequence sqlText, SqlExecutionContext sqlExecutionContext, TypesAndSelect tas) throws SqlException {
        this.setStateDesc(1);
        this.empty = sqlText == null || sqlText.length() == 0;
        this.sqlText = sqlText;
        this.factory = tas.getFactory();
        this.sqlTag = tas.getSqlTag();
        this.sqlType = tas.getSqlType();
        this.tas = tas;
        this.cacheHit = true;
        this.outParameterTypeDescriptionTypes.clear();
        assert (tas.getOutPgParameterTypes().size() == 0);
        sqlExecutionContext.setCacheHit(this.cacheHit);
        sqlExecutionContext.getCircuitBreaker().resetTimer();
        this.cursor = this.factory.getCursor(sqlExecutionContext);
        this.copyPgResultSetColumnTypesAndNames();
        this.setStateExec(true);
    }

    public void ofSimpleQuery(CharSequence sqlText, SqlExecutionContext sqlExecutionContext, CompiledQuery cq, WeakSelfReturningObjectPool<TypesAndInsert> taiPool) throws PGMessageProcessingException {
        this.sqlText = sqlText;
        this.empty = sqlText == null || sqlText.length() == 0;
        this.cacheHit = false;
        if (!this.empty) {
            try {
                this.setupEntryAfterSQLCompilation(sqlExecutionContext, taiPool, cq);
                this.copyPgResultSetColumnTypesAndNames();
            }
            catch (Throwable e) {
                throw this.kaput().put(e);
            }
        }
        if (cq.getType() == 1 || cq.getType() == 25 || cq.getType() == 8) {
            this.setStateDesc(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters) {
        try {
            for (ObjObjHashMap.Entry<TableToken, TableWriterAPI> entry : pendingWriters) {
                entry.value = Misc.free((TableWriterAPI)entry.value);
            }
        }
        finally {
            pendingWriters.clear();
        }
    }

    public void setErrorMessagePosition(int errorMessagePosition) {
        this.errorMessagePosition = errorMessagePosition;
    }

    public void setNamedPortal(boolean portal, Utf8String namedPortal) {
        this.portal = portal;
        this.sqlText = Chars.toString(this.sqlText);
        this.namedPortal = namedPortal;
    }

    public void setNamedStatement(Utf8String namedStatement) {
        this.sqlText = Chars.toString(this.sqlText);
        this.namedStatement = namedStatement;
    }

    public void setParentPreparedStatement(PGPipelineEntry preparedStatementPipelineEntry) {
        this.parentPreparedStatementPipelineEntry = preparedStatementPipelineEntry;
    }

    public void setReturnRowCountLimit(int rowCountLimit) {
        this.sqlReturnRowCountLimit = rowCountLimit;
    }

    public void setStateBind(boolean stateBind) {
        this.stateBind = stateBind;
    }

    public void setStateClosed(boolean stateClosed, boolean isStatementClose) {
        this.stateClosed = stateClosed;
        this.namedPortal = null;
        this.portal = false;
        if (isStatementClose) {
            this.namedStatement = null;
        }
    }

    public void setStateDesc(int stateDesc) {
        this.stateDesc = stateDesc;
    }

    public void setStateExec(boolean stateExec) {
        this.stateExec = stateExec;
    }

    public void setStateParse(boolean stateParse) {
        this.stateParse = stateParse;
    }

    private static void outBindComplete(PGResponseSink utf8Sink) {
        PGPipelineEntry.outSimpleMsg(utf8Sink, (byte)50);
    }

    private static void outEmptyQuery(PGResponseSink utf8Sink) {
        PGPipelineEntry.outSimpleMsg(utf8Sink, (byte)73);
    }

    private static void outNoData(PGResponseSink utf8Sink) {
        PGPipelineEntry.outSimpleMsg(utf8Sink, (byte)110);
    }

    private static void outParseComplete(PGResponseSink utf8Sink) {
        PGPipelineEntry.outSimpleMsg(utf8Sink, (byte)49);
    }

    private static void outPortalSuspended(PGResponseSink utf8Sink) {
        PGPipelineEntry.outSimpleMsg(utf8Sink, (byte)115);
    }

    private static void outSimpleMsg(PGResponseSink utf8Sink, byte msgByte) {
        utf8Sink.bookmark();
        utf8Sink.put(msgByte);
        utf8Sink.putIntDirect(PGConnectionContext.INT_BYTES_X);
        utf8Sink.bookmark();
    }

    private static void setBindVariableAsBin(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService, ObjectPool<DirectBinarySequence> binarySequenceParamsPool) throws SqlException {
        bindVariableService.setBin(variableIndex, (BinarySequence)binarySequenceParamsPool.next().of(valueAddr, valueSize));
    }

    private long calculateRecordTailSize(Record record, int columnCount, long maxBlobSize, long sendBufferSize) throws PGMessageProcessingException {
        long recordSize = 0L;
        for (int i = this.outResendColumnIndex; i < columnCount; ++i) {
            int columnType = this.pgResultSetColumnTypes.getQuick(2 * i);
            short typeTag = ColumnType.tagOf(columnType);
            short columnBinaryFlag = this.getPgResultSetColumnFormatCode(i, typeTag);
            if (columnBinaryFlag == 0 && this.txtAndBinSizesCanBeDifferent(columnType)) {
                return -1L;
            }
            int geohashSize = Math.abs(this.pgResultSetColumnTypes.getQuick(2 * i + 1));
            int columnValueSize = PGUtils.calculateColumnBinSize(this, record, i, columnType, geohashSize, maxBlobSize, this.outResendArrayFlatIndex);
            if (columnValueSize < 0) {
                return -1L;
            }
            if ((long)columnValueSize >= sendBufferSize && !ColumnType.isArray(columnType)) {
                return -1L;
            }
            recordSize += (long)columnValueSize;
        }
        return recordSize;
    }

    private void copyOf(PGPipelineEntry blueprint) {
        this.msgParseParameterTypeOIDs.clear();
        this.msgParseParameterTypeOIDs.addAll(blueprint.msgParseParameterTypeOIDs);
        this.outParameterTypeDescriptionTypes.clear();
        this.outParameterTypeDescriptionTypes.addAll(blueprint.outParameterTypeDescriptionTypes);
        this.pgResultSetColumnTypes.clear();
        this.pgResultSetColumnTypes.addAll(blueprint.pgResultSetColumnTypes);
        this.pgResultSetColumnNames.clear();
        this.pgResultSetColumnNames.addAll(blueprint.pgResultSetColumnNames);
        this.compiledQuery = blueprint.compiledQuery;
        this.isCopy = true;
        this.cacheHit = blueprint.cacheHit;
        this.empty = blueprint.empty;
        this.operation = blueprint.operation;
        this.parentPreparedStatementPipelineEntry = blueprint.parentPreparedStatementPipelineEntry;
        this.namedStatement = blueprint.namedStatement;
        this.sqlTag = blueprint.sqlTag;
        this.sqlText = blueprint.sqlText;
        this.sqlType = blueprint.sqlType;
        this.sqlTextHasSecret = blueprint.sqlTextHasSecret;
        this.tai = blueprint.tai;
        this.tas = blueprint.tas;
    }

    private void copyParameterValuesToBindVariableService(SqlExecutionContext sqlExecutionContext, CharacterStore characterStore, DirectUtf8String directUtf8String, ObjectPool<DirectBinarySequence> binarySequenceParamsPool) throws PGMessageProcessingException, SqlException {
        BindVariableService bindVariableService = sqlExecutionContext.getBindVariableService();
        bindVariableService.clear();
        long lo = this.parameterValueArenaPtr;
        long msgLimit = this.parameterValueArenaHi;
        int n = this.outParameterTypeDescriptionTypes.size();
        for (int i = 0; i < n; ++i) {
            long encodedType = this.outParameterTypeDescriptionTypes.getQuick(i);
            int nativeType = Numbers.decodeLowInt(encodedType);
            bindVariableService.define(i, nativeType, 0);
            if (i >= this.msgBindParameterValueCount) continue;
            int valueSize = this.getInt(lo, msgLimit, "malformed bind variable");
            lo += 4L;
            if (valueSize == -1) continue;
            if (lo + (long)valueSize > msgLimit) {
                throw this.kaput().put("bind variable value is beyond the message limit [variableIndex=").put(i).put(", valueSize=").put(valueSize).put(']');
            }
            if (encodedType != 0L) {
                if (this.msgBindParameterFormatCodes.get(i)) {
                    int pgWireType = Numbers.decodeHighInt(encodedType);
                    switch (pgWireType) {
                        case 0x17000000: {
                            this.setBindVariableAsInt(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case 0x14000000: {
                            this.setBindVariableAsLong(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case -1610350592: 
                        case 1510211584: {
                            this.setBindVariableAsTimestamp(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case 0x15000000: {
                            this.setBindVariableAsShort(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case -1123942400: {
                            this.setBindVariableAsDouble(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case -1140719616: {
                            this.setBindVariableAsFloat(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case 302252032: {
                            this.setBindVariableAsChar(i, lo, valueSize, bindVariableService, characterStore);
                            break;
                        }
                        case 973340672: {
                            this.setBindVariableAsDate(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case 0x10000000: {
                            this.setBindVariableAsBoolean(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case 0x11000000: {
                            PGPipelineEntry.setBindVariableAsBin(i, lo, valueSize, bindVariableService, binarySequenceParamsPool);
                            break;
                        }
                        case -2046099456: {
                            this.setUuidBindVariable(i, lo, valueSize, bindVariableService);
                            break;
                        }
                        case -134021120: 
                        case -33357824: {
                            this.setBindVariableAsArray(i, lo, valueSize, msgLimit, bindVariableService);
                            break;
                        }
                        default: {
                            this.setBindVariableAsStr(i, lo, valueSize, bindVariableService, characterStore, directUtf8String);
                            break;
                        }
                    }
                } else {
                    this.setBindVariableAsStr(i, lo, valueSize, bindVariableService, characterStore, directUtf8String);
                }
            }
            lo += (long)valueSize;
        }
    }

    private void copyPgResultSetColumnTypesAndNames() {
        assert (this.pgResultSetColumnTypes.size() == 0);
        assert (this.pgResultSetColumnNames.size() == 0);
        if (this.factory == null) {
            return;
        }
        RecordMetadata m = this.factory.getMetadata();
        int columnCount = m.getColumnCount();
        this.pgResultSetColumnTypes.setPos(2 * columnCount);
        this.pgResultSetColumnNames.setPos(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            int columnType = m.getColumnType(i);
            this.pgResultSetColumnTypes.setQuick(2 * i, columnType);
            this.pgResultSetColumnTypes.setQuick(2 * i + 1, GeoHashes.getBitFlags(columnType));
            this.pgResultSetColumnNames.setQuick(i, m.getColumnName(i));
        }
    }

    private void defineBindVariableType(BindVariableService bindVariableService, int j) throws SqlException {
        switch (this.msgParseParameterTypeOIDs.getQuick(j)) {
            case 0x17000000: {
                bindVariableService.define(j, 5, 0);
                break;
            }
            case 0x14000000: {
                bindVariableService.define(j, 6, 0);
                break;
            }
            case -1610350592: 
            case 1510211584: {
                bindVariableService.define(j, 8, 0);
                break;
            }
            case 0x15000000: {
                bindVariableService.define(j, 3, 0);
                break;
            }
            case -1123942400: {
                bindVariableService.define(j, 10, 0);
                break;
            }
            case -1140719616: {
                bindVariableService.define(j, 9, 0);
                break;
            }
            case 302252032: {
                bindVariableService.define(j, 4, 0);
                break;
            }
            case 973340672: {
                bindVariableService.define(j, 7, 0);
                break;
            }
            case 0x10000000: {
                bindVariableService.define(j, 1, 0);
                break;
            }
            case 0x11000000: {
                bindVariableService.define(j, 18, 0);
                break;
            }
            case -2046099456: {
                bindVariableService.define(j, 19, 0);
                break;
            }
            case -134021120: 
            case -33357824: {
                bindVariableService.define(j, 27, 0);
                break;
            }
            case 0: {
                break;
            }
            default: {
                bindVariableService.define(j, 11, 0);
            }
        }
    }

    private void ensureCompiledQuery() {
        if (this.compiledQuery == null) {
            this.compiledQuery = new CompiledQueryImpl(this.engine);
        }
    }

    private void ensureValueLength(int variableIndex, int sizeRequired, int sizeActual) throws PGMessageProcessingException {
        if (sizeRequired == sizeActual) {
            return;
        }
        throw this.kaput().put("bad parameter value length [sizeRequired=").put(sizeRequired).put(", sizeActual=").put(sizeActual).put(", variableIndex=").put(variableIndex).put(']');
    }

    private long estimateRecordSize(Record record, int columnCount) throws PGMessageProcessingException {
        long recordSize = 0L;
        for (int i = 0; i < columnCount; ++i) {
            int columnType = this.pgResultSetColumnTypes.getQuick(2 * i);
            short typeTag = ColumnType.tagOf(columnType);
            short columnBinaryFlag = this.getPgResultSetColumnFormatCode(i, typeTag);
            int geohashSize = Math.abs(this.pgResultSetColumnTypes.getQuick(2 * i + 1));
            long columnValueSize = columnBinaryFlag == 0 && this.txtAndBinSizesCanBeDifferent(columnType) ? PGUtils.estimateColumnTxtSize(record, i, typeTag) : (long)PGUtils.calculateColumnBinSize(this, record, i, columnType, geohashSize, Long.MAX_VALUE, 0);
            if (columnValueSize < 0L) {
                return Long.MIN_VALUE;
            }
            recordSize += columnValueSize;
        }
        return recordSize;
    }

    private short getPgResultSetColumnFormatCode(int columnIndex) {
        int columnType = this.pgResultSetColumnTypes.getQuick(columnIndex * 2);
        return this.getPgResultSetColumnFormatCode(columnIndex, columnType);
    }

    private short getPgResultSetColumnFormatCode(int columnIndex, int columnType) {
        if (columnType != 18) {
            return (this.msgBindSelectFormatCodeCount > 1 ? this.msgBindSelectFormatCodes.get(columnIndex) : this.msgBindSelectFormatCodes.get(0)) ? (short)1 : 0;
        }
        return 1;
    }

    private boolean isTextFormat() {
        return this.msgBindSelectFormatCodeCount == 0 || this.msgBindSelectFormatCodeCount == 1 && !this.msgBindSelectFormatCodes.get(0);
    }

    private PGMessageProcessingException kaput() {
        return PGMessageProcessingException.instance(this);
    }

    private long msgBindComputeParameterValueAreaSize(long lo, long msgLimit) throws PGMessageProcessingException {
        if (this.msgBindParameterValueCount > 0) {
            long l = lo;
            for (int j = 0; j < this.msgBindParameterValueCount; ++j) {
                int valueSize = this.getInt(lo, msgLimit, "malformed bind variable");
                lo += 4L;
                if (valueSize <= 0) continue;
                lo += (long)valueSize;
            }
            return lo - l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgExecuteDDL(SqlExecutionContext sqlExecutionContext, int transactionState, SCSequence tempSequence, WeakSelfReturningObjectPool<TypesAndInsert> taiPool) throws SqlException, PGMessageProcessingException {
        if (transactionState != 3) {
            this.engine.getMetrics().pgWireMetrics().markStart();
            try {
                this.ensureCompiledQuery();
                int attempt = 1;
                while (true) {
                    try (OperationFuture fut = this.compiledQuery.execute(sqlExecutionContext, tempSequence, false);){
                        fut.await();
                        this.sqlAffectedRowCount = fut.getAffectedRowsCount();
                    }
                    catch (TableReferenceOutOfDateException e) {
                        Misc.free(this.compiledQuery.getUpdateOperation());
                        if (attempt == this.maxRecompileAttempts) {
                            throw e;
                        }
                        this.compileNewSQL(this.sqlText, this.engine, sqlExecutionContext, taiPool, true);
                        ++attempt;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.engine.getMetrics().pgWireMetrics().markComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgExecuteInsert(SqlExecutionContext sqlExecutionContext, int transactionState, ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters, WriterSource writerSource, WeakSelfReturningObjectPool<TypesAndInsert> taiPool) throws SqlException, PGMessageProcessingException {
        block3 : switch (transactionState) {
            case 0: 
            case 1: {
                sqlExecutionContext.setCacheHit(this.cacheHit);
                this.engine.getMetrics().pgWireMetrics().markStart();
                try {
                    int attempt = 1;
                    while (true) {
                        InsertOperation insertOp = this.tai.getInsert();
                        try {
                            InsertMethod m = insertOp.createMethod(sqlExecutionContext, writerSource);
                            try {
                                this.sqlAffectedRowCount = m.execute(sqlExecutionContext);
                                TableWriterAPI writer = m.popWriter();
                                pendingWriters.put(writer.getTableToken(), writer);
                                break block3;
                            }
                            catch (Throwable th) {
                                TableWriterAPI w = m.popWriter();
                                if (w != null) {
                                    pendingWriters.remove(w.getTableToken());
                                }
                                Misc.free(w);
                                throw th;
                            }
                        }
                        catch (TableReferenceOutOfDateException e) {
                            this.tai = Misc.free(this.tai);
                            if (attempt == this.maxRecompileAttempts) {
                                throw e;
                            }
                            this.compileNewSQL(this.sqlText, this.engine, sqlExecutionContext, taiPool, true);
                            ++attempt;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.engine.getMetrics().pgWireMetrics().markComplete();
                }
            }
            case 3: {
                break;
            }
            default: {
                assert (false) : "unknown transaction state: " + transactionState;
                break;
            }
        }
    }

    private void msgExecuteSelect(SqlExecutionContext sqlExecutionContext, int transactionState, ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters, WeakSelfReturningObjectPool<TypesAndInsert> taiPool, int maxRecompileAttempts) throws SqlException, PGMessageProcessingException {
        if (this.cursor == null) {
            this.engine.getMetrics().pgWireMetrics().markStart();
            if (transactionState == 0) {
                this.commit(pendingWriters);
            }
            sqlExecutionContext.getCircuitBreaker().resetTimer();
            sqlExecutionContext.setCacheHit(this.cacheHit);
            if (this.isPreparedStatement()) {
                this.cacheHit = true;
            }
            try {
                int attempt = 1;
                while (true) {
                    if (this.factory != null) {
                        try {
                            this.cursor = this.factory.getCursor(sqlExecutionContext);
                            break;
                        }
                        catch (TableReferenceOutOfDateException e) {
                            if (attempt == maxRecompileAttempts) {
                                throw e;
                            }
                            this.factory = Misc.free(this.factory);
                        }
                    }
                    this.compileNewSQL(this.sqlText, this.engine, sqlExecutionContext, taiPool, true);
                    ++attempt;
                }
            }
            catch (Throwable e) {
                this.tas = Misc.free(this.tas);
                this.factory = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgExecuteUpdate(SqlExecutionContext sqlExecutionContext, int transactionState, ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters, SCSequence tempSequence, WeakSelfReturningObjectPool<TypesAndInsert> taiPool) throws SqlException, PGMessageProcessingException {
        if (transactionState != 3) {
            this.engine.getMetrics().pgWireMetrics().markStart();
            this.ensureCompiledQuery();
            try {
                int attempt = 1;
                while (true) {
                    try {
                        UpdateOperation updateOperation = this.compiledQuery.getUpdateOperation();
                        TableToken tableToken = updateOperation.getTableToken();
                        int index = pendingWriters.keyIndex(tableToken);
                        if (index < 0) {
                            updateOperation.withContext(sqlExecutionContext);
                            TableWriterAPI tableWriterAPI = pendingWriters.valueAt(index);
                            tableWriterAPI.commit();
                            this.sqlAffectedRowCount = tableWriterAPI.apply(updateOperation);
                            break;
                        }
                        try (OperationFuture fut = this.compiledQuery.execute(sqlExecutionContext, tempSequence, false);){
                            fut.await();
                            this.sqlAffectedRowCount = fut.getAffectedRowsCount();
                        }
                    }
                    catch (TableReferenceOutOfDateException e) {
                        Misc.free(this.compiledQuery.getUpdateOperation());
                        if (attempt == this.maxRecompileAttempts) {
                            throw e;
                        }
                        this.compileNewSQL(this.sqlText, this.engine, sqlExecutionContext, taiPool, true);
                        ++attempt;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.engine.getMetrics().pgWireMetrics().markComplete();
            }
        }
    }

    private void msgParseCopyOutTypeDescriptionTypeOIDs(BindVariableService bindVariableService) {
        int n = bindVariableService.getIndexedVariableCount();
        this.outParameterTypeDescriptionTypes.setPos(n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                int nativeType;
                Function f;
                int oid = 0;
                if (this.msgParseParameterTypeOIDs.size() > i) {
                    oid = this.msgParseParameterTypeOIDs.getQuick(i);
                }
                if ((f = bindVariableService.getFunction(i)) != null) {
                    nativeType = f.getType();
                    if (oid == 0 || oid == -435683328) {
                        oid = Numbers.bswap(PGOids.getTypeOid(nativeType));
                    }
                } else {
                    nativeType = 0;
                }
                this.outParameterTypeDescriptionTypes.setQuick(i, Numbers.encodeLowHighInts(nativeType, oid));
            }
        }
    }

    private void msgParseDefineBindVariableTypes(BindVariableService bindVariableService) throws SqlException {
        bindVariableService.clear();
        int n = this.msgParseParameterTypeOIDs.size();
        for (int i = 0; i < n; ++i) {
            this.defineBindVariableType(bindVariableService, i);
        }
    }

    private void outColBinArr(PGResponseSink utf8Sink, Record record, int columnIndex, int columnType) {
        ArrayView array = record.getArray(columnIndex, columnType);
        if (array.getDimCount() == 0) {
            utf8Sink.setNullValue();
            return;
        }
        short elemType = array.getElemType();
        if (this.outResendArrayFlatIndex == 0) {
            int nDims = array.getDimCount();
            int componentTypeOid = PGOids.getTypeOid(elemType);
            int notNullCount = PGUtils.countNotNull(array, 0);
            utf8Sink.putNetworkInt(PGUtils.calculateArrayColBinSize(array, notNullCount) - 4);
            utf8Sink.putNetworkInt(nDims);
            utf8Sink.putIntDirect(notNullCount < array.getCardinality() ? 1 : 0);
            utf8Sink.putNetworkInt(componentTypeOid);
            for (int i = 0; i < nDims; ++i) {
                utf8Sink.putNetworkInt(array.getDimLen(i));
                utf8Sink.putNetworkInt(1);
            }
        }
        try {
            if (array.isVanilla()) {
                int len = array.getFlatViewLength();
                for (int i = this.outResendArrayFlatIndex; i < len; ++i) {
                    switch (elemType) {
                        case 6: {
                            utf8Sink.putNetworkInt(8);
                            utf8Sink.putNetworkLong(array.getLong(i));
                            break;
                        }
                        case 10: {
                            double val = array.getDouble(i);
                            if (Numbers.isFinite(val)) {
                                utf8Sink.putNetworkInt(8);
                                utf8Sink.putNetworkDouble(val);
                                break;
                            }
                            utf8Sink.setNullValue();
                        }
                    }
                    utf8Sink.bookmark();
                    this.outResendArrayFlatIndex = i + 1;
                }
            } else {
                this.outColBinArrRecursive(utf8Sink, array, elemType, 0, 0, 0);
            }
            this.outResendArrayFlatIndex = 0;
        }
        catch (NoSpaceLeftInResponseBufferException e) {
            utf8Sink.resetToBookmark();
            throw e;
        }
    }

    private int outColBinArrRecursive(PGResponseSink utf8Sink, ArrayView array, short elemType, int dim, int flatIndex, int outFlatIndex) {
        int count = array.getDimLen(dim);
        int stride = array.getStride(dim);
        if (dim < array.getDimCount() - 1) {
            for (int i = 0; i < count; ++i) {
                outFlatIndex = this.outColBinArrRecursive(utf8Sink, array, elemType, dim + 1, flatIndex, outFlatIndex);
                flatIndex += stride;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (outFlatIndex == this.outResendArrayFlatIndex) {
                    switch (elemType) {
                        case 6: {
                            long val = array.getLong(flatIndex);
                            if (val != Long.MIN_VALUE) {
                                utf8Sink.putNetworkInt(8);
                                utf8Sink.putNetworkDouble(val);
                                break;
                            }
                            utf8Sink.setNullValue();
                            break;
                        }
                        case 10: {
                            double val = array.getDouble(flatIndex);
                            if (Numbers.isFinite(val)) {
                                utf8Sink.putNetworkInt(8);
                                utf8Sink.putNetworkDouble(val);
                                break;
                            }
                            utf8Sink.setNullValue();
                            break;
                        }
                    }
                    utf8Sink.bookmark();
                    ++this.outResendArrayFlatIndex;
                }
                ++outFlatIndex;
                flatIndex += stride;
            }
        }
        return outFlatIndex;
    }

    private void outColBinBool(PGResponseSink utf8Sink, Record record, int columnIndex) {
        utf8Sink.putNetworkInt(1);
        utf8Sink.put(record.getBool(columnIndex) ? (byte)1 : 0);
    }

    private void outColBinByte(PGResponseSink utf8Sink, Record record, int columnIndex) {
        byte value = record.getByte(columnIndex);
        utf8Sink.putNetworkInt(2);
        utf8Sink.putNetworkShort(value);
    }

    private void outColBinDate(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long longValue = record.getDate(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            utf8Sink.putNetworkInt(8);
            utf8Sink.putNetworkLong(longValue * 1000L - 946684800000000L);
        } else {
            utf8Sink.setNullValue();
        }
    }

    private void outColBinDouble(PGResponseSink utf8Sink, Record record, int columnIndex) {
        double value = record.getDouble(columnIndex);
        if (Numbers.isNull(value)) {
            utf8Sink.setNullValue();
        } else {
            utf8Sink.putNetworkInt(8);
            utf8Sink.putNetworkDouble(value);
        }
    }

    private void outColBinFloat(PGResponseSink utf8Sink, Record record, int columnIndex) {
        float value = record.getFloat(columnIndex);
        if (Numbers.isNull(value)) {
            utf8Sink.setNullValue();
        } else {
            utf8Sink.putNetworkInt(4);
            utf8Sink.putNetworkFloat(value);
        }
    }

    private void outColBinInt(PGResponseSink utf8Sink, Record record, int columnIndex) {
        int value = record.getInt(columnIndex);
        if (value != Integer.MIN_VALUE) {
            utf8Sink.checkCapacity(8L);
            utf8Sink.putIntUnsafe(0L, PGConnectionContext.INT_BYTES_X);
            utf8Sink.putIntUnsafe(4L, Numbers.bswap(value));
            utf8Sink.bump(8);
        } else {
            utf8Sink.setNullValue();
        }
    }

    private void outColBinLong(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            utf8Sink.putNetworkInt(8);
            utf8Sink.putNetworkLong(longValue);
        } else {
            utf8Sink.setNullValue();
        }
    }

    private void outColBinShort(PGResponseSink utf8Sink, Record record, int columnIndex) {
        short value = record.getShort(columnIndex);
        utf8Sink.putNetworkInt(2);
        utf8Sink.putNetworkShort(value);
    }

    private void outColBinTimestamp(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long longValue = record.getTimestamp(columnIndex);
        if (longValue == Long.MIN_VALUE) {
            utf8Sink.setNullValue();
        } else {
            utf8Sink.putNetworkInt(8);
            utf8Sink.putNetworkLong(longValue - 946684800000000L);
        }
    }

    private void outColBinUuid(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long hi;
        long lo = record.getLong128Lo(columnIndex);
        if (Uuid.isNull(lo, hi = record.getLong128Hi(columnIndex))) {
            utf8Sink.setNullValue();
        } else {
            utf8Sink.putNetworkInt(16);
            utf8Sink.putNetworkLong(hi);
            utf8Sink.putNetworkLong(lo);
        }
    }

    private void outColBinary(PGResponseSink utf8Sink, Record record, int i) throws PGMessageProcessingException {
        BinarySequence sequence = record.getBin(i);
        if (sequence == null) {
            utf8Sink.setNullValue();
        } else {
            long blobSize = sequence.length();
            if (blobSize < utf8Sink.getMaxBlobSize()) {
                utf8Sink.put(sequence);
            } else {
                throw this.kaput().put("blob is too large [blobSize=").put(blobSize).put(", maxBlobSize=").put(utf8Sink.getMaxBlobSize()).put(", columnIndex=").put(i).put(']');
            }
        }
    }

    private void outColChar(PGResponseSink utf8Sink, Record record, int columnIndex) {
        char charValue = record.getChar(columnIndex);
        if (charValue == '\u0000') {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            utf8Sink.put(charValue);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColInterval(PGResponseSink utf8Sink, Record record, int col) {
        Interval interval = record.getInterval(col);
        if (Interval.NULL.equals(interval)) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            interval.toSink(utf8Sink);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColString(PGResponseSink utf8Sink, Record record, int columnIndex) {
        CharSequence strValue = record.getStrA(columnIndex);
        if (strValue == null) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            utf8Sink.put(strValue);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColSymbol(PGResponseSink utf8Sink, Record record, int columnIndex) {
        CharSequence strValue = record.getSymA(columnIndex);
        if (strValue == null) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            utf8Sink.put(strValue);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColTxtArr(PGResponseSink utf8Sink, Record record, int columnIndex, int columnType) {
        ArrayView arrayView = record.getArray(columnIndex, columnType);
        if (arrayView.getDimCount() == 0) {
            utf8Sink.setNullValue();
            return;
        }
        long a = utf8Sink.skipInt();
        ArrayTypeDriver.arrayToPgWire(arrayView, utf8Sink);
        utf8Sink.putLenEx(a);
    }

    private void outColTxtBool(PGResponseSink utf8Sink, Record record, int columnIndex) {
        utf8Sink.putNetworkInt(1);
        utf8Sink.put(record.getBool(columnIndex) ? (char)'t' : 'f');
    }

    private void outColTxtByte(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long a = utf8Sink.skipInt();
        utf8Sink.put((int)record.getByte(columnIndex));
        utf8Sink.putLenEx(a);
    }

    private void outColTxtDate(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long longValue = record.getDate(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            long a = utf8Sink.skipInt();
            DateFormatUtils.PG_DATE_MILLI_TIME_Z_PRINT_FORMAT.format(longValue, DateFormatUtils.EN_LOCALE, null, utf8Sink);
            utf8Sink.putLenEx(a);
        } else {
            utf8Sink.setNullValue();
        }
    }

    private void outColTxtDouble(PGResponseSink utf8Sink, Record record, int columnIndex) {
        double doubleValue = record.getDouble(columnIndex);
        if (Numbers.isNull(doubleValue)) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            utf8Sink.put(doubleValue);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColTxtFloat(PGResponseSink responseUtf8Sink, Record record, int columnIndex) {
        float floatValue = record.getFloat(columnIndex);
        if (Numbers.isNull(floatValue)) {
            responseUtf8Sink.setNullValue();
        } else {
            long a = responseUtf8Sink.skipInt();
            responseUtf8Sink.put(floatValue);
            responseUtf8Sink.putLenEx(a);
        }
    }

    private void outColTxtGeoByte(PGResponseSink utf8Sink, Record rec, int col, int bitFlags) {
        this.outColTxtGeoHash(utf8Sink, rec.getGeoByte(col), bitFlags);
    }

    private void outColTxtGeoHash(PGResponseSink utf8Sink, long value, int bitFlags) {
        if (value == -1L) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            if (bitFlags < 0) {
                GeoHashes.appendCharsUnsafe(value, -bitFlags, utf8Sink);
            } else {
                GeoHashes.appendBinaryStringUnsafe(value, bitFlags, utf8Sink);
            }
            utf8Sink.putLenEx(a);
        }
    }

    private void outColTxtGeoInt(PGResponseSink utf8Sink, Record rec, int col, int bitFlags) {
        this.outColTxtGeoHash(utf8Sink, rec.getGeoInt(col), bitFlags);
    }

    private void outColTxtGeoLong(PGResponseSink utf8Sink, Record rec, int col, int bitFlags) {
        this.outColTxtGeoHash(utf8Sink, rec.getGeoLong(col), bitFlags);
    }

    private void outColTxtGeoShort(PGResponseSink utf8Sink, Record rec, int col, int bitFlags) {
        this.outColTxtGeoHash(utf8Sink, rec.getGeoShort(col), bitFlags);
    }

    private void outColTxtIPv4(PGResponseSink utf8Sink, Record record, int columnIndex) {
        int value = record.getIPv4(columnIndex);
        if (value == 0) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            Numbers.intToIPv4Sink(utf8Sink, value);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColTxtInt(PGResponseSink utf8Sink, Record record, int i) {
        int intValue = record.getInt(i);
        if (intValue != Integer.MIN_VALUE) {
            long a = utf8Sink.skipInt();
            utf8Sink.put(intValue);
            utf8Sink.putLenEx(a);
        } else {
            utf8Sink.setNullValue();
        }
    }

    private void outColTxtLong(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            long a = utf8Sink.skipInt();
            utf8Sink.put(longValue);
            utf8Sink.putLenEx(a);
        } else {
            utf8Sink.setNullValue();
        }
    }

    private void outColTxtLong256(PGResponseSink utf8Sink, Record record, int columnIndex) {
        Long256 long256Value = record.getLong256A(columnIndex);
        if (long256Value.getLong0() == Long.MIN_VALUE && long256Value.getLong1() == Long.MIN_VALUE && long256Value.getLong2() == Long.MIN_VALUE && long256Value.getLong3() == Long.MIN_VALUE) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            Numbers.appendLong256(long256Value, utf8Sink);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColTxtShort(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long a = utf8Sink.skipInt();
        utf8Sink.put(record.getShort(columnIndex));
        utf8Sink.putLenEx(a);
    }

    private void outColTxtTimestamp(PGResponseSink utf8Sink, Record record, int i) {
        long longValue = record.getTimestamp(i);
        if (longValue == Long.MIN_VALUE) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            TimestampFormatUtils.PG_TIMESTAMP_FORMAT.format(longValue, DateFormatUtils.EN_LOCALE, null, utf8Sink);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColTxtUuid(PGResponseSink utf8Sink, Record record, int columnIndex) {
        long hi;
        long lo = record.getLong128Lo(columnIndex);
        if (Uuid.isNull(lo, hi = record.getLong128Hi(columnIndex))) {
            utf8Sink.setNullValue();
        } else {
            long a = utf8Sink.skipInt();
            Numbers.appendUuid(lo, hi, utf8Sink);
            utf8Sink.putLenEx(a);
        }
    }

    private void outColVarchar(PGResponseSink responseUtf8Sink, Record record, int i) {
        Utf8Sequence strValue = record.getVarcharA(i);
        if (strValue == null) {
            responseUtf8Sink.setNullValue();
        } else {
            responseUtf8Sink.putNetworkInt(strValue.size());
            responseUtf8Sink.put(strValue);
        }
    }

    private void outCommandComplete(PGResponseSink utf8Sink, long rowCount) {
        utf8Sink.bookmark();
        utf8Sink.put((byte)67);
        long addr = utf8Sink.skipInt();
        ((Utf8Sink)utf8Sink.put(this.sqlTag).putAscii(' ').put(rowCount)).put((byte)0);
        utf8Sink.putLen(addr);
    }

    private void outComputeCursorSize() {
        this.sqlReturnRowCount = 0L;
        this.sqlReturnRowCountToBeSent = this.sqlReturnRowCountLimit > 0L ? this.sqlReturnRowCountLimit : Long.MAX_VALUE;
    }

    private void outCursor(SqlExecutionContext sqlExecutionContext, PGResponseSink utf8Sink) throws QueryPausedException {
        if (this.pgResultSetColumnTypes.size() == 0) {
            this.copyPgResultSetColumnTypesAndNames();
        }
        switch (this.stateSync) {
            case 3: {
                this.outComputeCursorSize();
                this.stateSync = 4;
            }
            case 4: {
                utf8Sink.bookmark();
                this.outCursor(sqlExecutionContext, utf8Sink, this.factory.getMetadata().getColumnCount());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void outCursor(SqlExecutionContext sqlExecutionContext, PGResponseSink utf8Sink, int columnCount) throws QueryPausedException {
        block11: {
            if (!sqlExecutionContext.getCircuitBreaker().isTimerSet()) {
                sqlExecutionContext.getCircuitBreaker().resetTimer();
            }
            long recordStartAddress = utf8Sink.getSendBufferPtr();
            try {
                Record record = this.cursor.getRecord();
                if (this.outResendCursorRecord) {
                    this.outRecord(utf8Sink, record, columnCount);
                    recordStartAddress = utf8Sink.getSendBufferPtr();
                }
                while (this.sqlReturnRowCount < this.sqlReturnRowCountToBeSent && this.cursor.hasNext()) {
                    this.outResendCursorRecord = true;
                    this.outResendRecordHeader = true;
                    this.outRecord(utf8Sink, record, columnCount);
                    recordStartAddress = utf8Sink.getSendBufferPtr();
                }
            }
            catch (DataUnavailableException e) {
                utf8Sink.resetToBookmark();
                throw QueryPausedException.instance(e.getEvent(), sqlExecutionContext.getCircuitBreaker());
            }
            catch (NoSpaceLeftInResponseBufferException e) {
                throw e;
            }
            catch (Throwable th) {
                LOG.debug().$("unexpected error in outCursor [ex=").$(th).I$();
                utf8Sink.resetToBookmark(recordStartAddress);
                if (th instanceof FlyweightMessageContainer) {
                    int errno;
                    StringSink errorMsgSink = this.getErrorMessageSink();
                    if (th instanceof CairoException && (errno = ((CairoException)th).getErrno()) != -1) {
                        errorMsgSink.put('[');
                        errorMsgSink.put(errno);
                        errorMsgSink.put("] ");
                    }
                    errorMsgSink.put(((FlyweightMessageContainer)((Object)th)).getFlyweightMessage());
                }
                String msg = th.getMessage();
                if (msg != null) {
                    this.getErrorMessageSink().put(msg);
                } else {
                    this.getErrorMessageSink().putAscii("no message provided (internal error)");
                }
                if (!(th instanceof AssertionError)) break block11;
                LOG.critical().$("error in pgwire execute, ex=").$(th).$();
            }
        }
        this.stateSync = this.sqlReturnRowCount < this.sqlReturnRowCountToBeSent ? 6 : 7;
        this.engine.getMetrics().pgWireMetrics().markComplete();
    }

    private void outError(PGResponseSink utf8Sink, ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters) {
        this.rollback(pendingWriters);
        utf8Sink.resetToBookmark();
        utf8Sink.bookmark();
        boolean emptyBuffer = utf8Sink.getWrittenBytes() == 0L;
        int position = this.getErrorMessagePosition();
        utf8Sink.put((byte)69);
        long addr = utf8Sink.skipInt();
        utf8Sink.putAscii('C');
        if (this.stalePlanError) {
            utf8Sink.putZ("0A000");
            utf8Sink.putAscii('R');
            utf8Sink.putZ("RevalidateCachedQuery");
        } else {
            utf8Sink.putZ("00000");
        }
        utf8Sink.putAscii('M');
        StringSink errorSink = this.getErrorMessageSink();
        int remainingBufferBytes = (int)(utf8Sink.getSendBufferSize() - utf8Sink.getWrittenBytes());
        if (emptyBuffer) {
            if (!utf8Sink.putWithLimit(errorSink, remainingBufferBytes - 23 - 4)) {
                utf8Sink.put("...");
            }
            utf8Sink.put((byte)0);
        } else {
            utf8Sink.putZ(errorSink);
        }
        utf8Sink.putAscii('S');
        utf8Sink.putZ("ERROR");
        if (position > -1) {
            ((Utf8Sink)utf8Sink.putAscii('P').put(position + 1)).put((byte)0);
        }
        utf8Sink.put((byte)0);
        utf8Sink.putLen(addr);
    }

    private void outParameterTypeDescription(PGResponseSink utf8Sink) {
        utf8Sink.put((byte)116);
        long offset = utf8Sink.skipInt();
        int n = this.outParameterTypeDescriptionTypes.size();
        utf8Sink.putNetworkShort((short)n);
        for (int i = 0; i < n; ++i) {
            int pgType = Numbers.decodeHighInt(this.outParameterTypeDescriptionTypes.getQuick(i));
            utf8Sink.putIntDirect(pgType);
        }
        utf8Sink.putLen(offset);
    }

    private void outRecord(PGResponseSink utf8Sink, Record record, int columnCount) throws PGMessageProcessingException {
        long messageLengthAddress = 0L;
        if (this.outResendColumnIndex == 0 && this.outResendRecordHeader) {
            utf8Sink.put((byte)68);
            messageLengthAddress = utf8Sink.skipInt();
            utf8Sink.putNetworkShort((short)columnCount);
            utf8Sink.bookmark();
        }
        boolean isMsgLengthRequired = messageLengthAddress > 0L;
        try {
            while (this.outResendColumnIndex < columnCount) {
                int colIndex = this.outResendColumnIndex;
                int type = this.pgResultSetColumnTypes.getQuick(2 * colIndex);
                short typeTag = ColumnType.tagOf(type);
                short columnBinaryFlag = this.getPgResultSetColumnFormatCode(colIndex, type);
                int tagWithFlag = PGOids.toColumnBinaryType(columnBinaryFlag, typeTag);
                switch (tagWithFlag) {
                    case -2147483643: {
                        this.outColBinInt(utf8Sink, record, colIndex);
                        break;
                    }
                    case 5: {
                        this.outColTxtInt(utf8Sink, record, colIndex);
                        break;
                    }
                    case 25: {
                        this.outColTxtIPv4(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483616: 
                    case 32: {
                        this.outColInterval(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483622: 
                    case 26: {
                        this.outColVarchar(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483637: 
                    case -2147483618: 
                    case 11: 
                    case 30: {
                        this.outColString(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483636: 
                    case 12: {
                        this.outColSymbol(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483642: {
                        this.outColBinLong(utf8Sink, record, colIndex);
                        break;
                    }
                    case 6: {
                        this.outColTxtLong(utf8Sink, record, colIndex);
                        break;
                    }
                    case 3: {
                        this.outColTxtShort(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483638: {
                        this.outColBinDouble(utf8Sink, record, colIndex);
                        break;
                    }
                    case 10: {
                        this.outColTxtDouble(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483639: {
                        this.outColBinFloat(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483645: {
                        this.outColBinShort(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483641: {
                        this.outColBinDate(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483640: {
                        this.outColBinTimestamp(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483646: {
                        this.outColBinByte(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483629: {
                        this.outColBinUuid(utf8Sink, record, colIndex);
                        break;
                    }
                    case 9: {
                        this.outColTxtFloat(utf8Sink, record, colIndex);
                        break;
                    }
                    case 8: {
                        this.outColTxtTimestamp(utf8Sink, record, colIndex);
                        break;
                    }
                    case 7: {
                        this.outColTxtDate(utf8Sink, record, colIndex);
                        break;
                    }
                    case 1: {
                        this.outColTxtBool(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483647: {
                        this.outColBinBool(utf8Sink, record, colIndex);
                        break;
                    }
                    case 2: {
                        this.outColTxtByte(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483630: 
                    case 18: {
                        this.outColBinary(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483644: 
                    case 4: {
                        this.outColChar(utf8Sink, record, colIndex);
                        break;
                    }
                    case -2147483635: 
                    case 13: {
                        this.outColTxtLong256(utf8Sink, record, colIndex);
                        break;
                    }
                    case 14: {
                        this.outColTxtGeoByte(utf8Sink, record, colIndex, this.pgResultSetColumnTypes.getQuick(2 * colIndex + 1));
                        break;
                    }
                    case 15: {
                        this.outColTxtGeoShort(utf8Sink, record, colIndex, this.pgResultSetColumnTypes.getQuick(2 * colIndex + 1));
                        break;
                    }
                    case 16: {
                        this.outColTxtGeoInt(utf8Sink, record, colIndex, this.pgResultSetColumnTypes.getQuick(2 * colIndex + 1));
                        break;
                    }
                    case 17: {
                        this.outColTxtGeoLong(utf8Sink, record, colIndex, this.pgResultSetColumnTypes.getQuick(2 * colIndex + 1));
                        break;
                    }
                    case 33: {
                        utf8Sink.setNullValue();
                        break;
                    }
                    case 19: {
                        this.outColTxtUuid(utf8Sink, record, colIndex);
                        break;
                    }
                    case 27: {
                        this.outColTxtArr(utf8Sink, record, colIndex, type);
                        break;
                    }
                    case -2147483621: {
                        this.outColBinArr(utf8Sink, record, colIndex, type);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                ++this.outResendColumnIndex;
                utf8Sink.bookmark();
            }
        }
        catch (NoSpaceLeftInResponseBufferException e) {
            if (this.isTextFormat()) {
                assert (messageLengthAddress > 0L);
                this.resetIncompleteRecord(utf8Sink, messageLengthAddress);
                if (utf8Sink.getWrittenBytes() == 0L) {
                    long estimatedSize = this.estimateRecordSize(record, columnCount);
                    e.setBytesRequired(estimatedSize);
                }
            } else {
                utf8Sink.resetToBookmark();
                if (isMsgLengthRequired) {
                    long sizeInBuffer = utf8Sink.getSendBufferPtr() - messageLengthAddress;
                    assert (sizeInBuffer > 0L);
                    try {
                        long recordTailSize = this.calculateRecordTailSize(record, columnCount, utf8Sink.getMaxBlobSize(), utf8Sink.getSendBufferSize());
                        long msgLength = sizeInBuffer + recordTailSize;
                        if (recordTailSize > 0L && msgLength <= Integer.MAX_VALUE) {
                            PGConnectionContext.putInt(messageLengthAddress, (int)msgLength);
                            this.outResendRecordHeader = false;
                        } else {
                            this.resetIncompleteRecord(utf8Sink, messageLengthAddress);
                            if (utf8Sink.getWrittenBytes() == 0L) {
                                e.setBytesRequired(this.estimateRecordSize(record, columnCount));
                            }
                        }
                    }
                    catch (PGMessageProcessingException bpe) {
                        this.resetIncompleteRecord(utf8Sink, messageLengthAddress);
                        throw bpe;
                    }
                }
            }
            throw e;
        }
        if (isMsgLengthRequired) {
            utf8Sink.putLen(messageLengthAddress);
        }
        utf8Sink.bookmark();
        this.outResendCursorRecord = false;
        this.outResendColumnIndex = 0;
        this.outResendRecordHeader = true;
        ++this.sqlReturnRowCount;
    }

    private void outRowDescription(PGResponseSink utf8Sink) {
        if (this.pgResultSetColumnTypes.size() == 0) {
            this.copyPgResultSetColumnTypesAndNames();
        }
        int n = this.pgResultSetColumnTypes.size() / 2;
        long messageLengthAddress = 0L;
        if (this.outResendColumnIndex == 0 && this.outResendRecordHeader) {
            utf8Sink.put((byte)84);
            messageLengthAddress = utf8Sink.skipInt();
            utf8Sink.putNetworkShort((short)n);
            utf8Sink.bookmark();
        }
        boolean isMsgLengthRequired = messageLengthAddress > 0L;
        try {
            while (this.outResendColumnIndex < n) {
                int i = this.outResendColumnIndex;
                int typeFlag = this.pgResultSetColumnTypes.getQuick(2 * i);
                int columnType = PGOids.toColumnType(ColumnType.isNull(typeFlag) ? 11 : typeFlag);
                utf8Sink.putZ(this.pgResultSetColumnNames.get(i));
                utf8Sink.putIntDirect(0);
                utf8Sink.putNetworkShort((short)(i + 1));
                int pgType = PGOids.getTypeOid(columnType);
                utf8Sink.putNetworkInt(pgType);
                short xSize = PGOids.X_PG_TYPE_TO_SIZE_MAP.get(pgType);
                utf8Sink.putDirectShort(xSize);
                int xTypeModifier = PGOids.getXAttTypMod(pgType);
                utf8Sink.putDirectInt(xTypeModifier);
                utf8Sink.putNetworkShort(this.getPgResultSetColumnFormatCode(i));
                utf8Sink.bookmark();
                ++this.outResendColumnIndex;
            }
        }
        catch (NoSpaceLeftInResponseBufferException e) {
            utf8Sink.resetToBookmark();
            if (isMsgLengthRequired) {
                long sizeInBuffer = utf8Sink.getSendBufferPtr() - messageLengthAddress;
                assert (sizeInBuffer > 0L);
                long tailSize = 0L;
                for (int i = this.outResendColumnIndex; i < n; ++i) {
                    String columnName = this.pgResultSetColumnNames.get(i);
                    assert (columnName != null && !columnName.isEmpty());
                    int utf8Bytes = Utf8s.utf8Bytes(columnName);
                    tailSize += (long)(utf8Bytes + 1 + 18);
                }
                assert (tailSize > 0L);
                long messageSizeWithHeader = sizeInBuffer + tailSize;
                if (messageSizeWithHeader <= Integer.MAX_VALUE) {
                    PGConnectionContext.putInt(messageLengthAddress, (int)messageSizeWithHeader);
                    this.outResendRecordHeader = false;
                } else {
                    this.resetIncompleteRecord(utf8Sink, messageLengthAddress);
                    if (utf8Sink.getWrittenBytes() == 0L) {
                        e.setBytesRequired(messageSizeWithHeader + 1L);
                    }
                }
            }
            throw e;
        }
        if (isMsgLengthRequired) {
            utf8Sink.putLen(messageLengthAddress);
        }
        utf8Sink.bookmark();
        this.outResendColumnIndex = 0;
        this.outResendRecordHeader = true;
    }

    private void resetIncompleteRecord(PGResponseSink utf8Sink, long messageLengthAddress) {
        this.outResendColumnIndex = 0;
        this.outResendRecordHeader = true;
        utf8Sink.resetToBookmark(messageLengthAddress - 1L);
    }

    private void setBindVariableAsArray(int i, long lo, int valueSize, long msgLimit, BindVariableService bindVariableService) throws SqlException, PGMessageProcessingException {
        int dimensions = this.getInt(lo, msgLimit, "malformed array dimensions");
        lo += 4L;
        valueSize -= 4;
        if (dimensions == 0) {
            throw this.kaput().put("array dimensions cannot be zero");
        }
        if (dimensions > 32) {
            throw this.kaput().put("array dimensions cannot be greater than maximum array dimensions [dimensions=").put(dimensions).put(", max=").put(32L).put(']');
        }
        this.getInt(lo, msgLimit, "malformed array null flag");
        valueSize -= 4;
        int componentOid = this.getInt(lo += 4L, msgLimit, "malformed array component oid");
        lo += 4L;
        valueSize -= 4;
        PGNonNullBinaryArrayView arrayView = this.arrayViewPool.next();
        for (int j = 0; j < dimensions; ++j) {
            int dimensionSize = this.getInt(lo, msgLimit, "malformed array dimension size");
            arrayView.addDimLen(dimensionSize);
            lo += 4L;
            valueSize -= 4;
            lo += 4L;
            valueSize -= 4;
        }
        arrayView.setPtrAndCalculateStrides(lo, lo + (long)valueSize, componentOid, this);
        bindVariableService.setArray(i, arrayView);
    }

    private void setBindVariableAsBoolean(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws SqlException, PGMessageProcessingException {
        this.ensureValueLength(variableIndex, 1, valueSize);
        byte val = Unsafe.getUnsafe().getByte(valueAddr);
        bindVariableService.setBoolean(variableIndex, val == 1);
    }

    private void setBindVariableAsChar(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService, CharacterStore characterStore) throws PGMessageProcessingException, SqlException {
        CharacterStoreEntry e = characterStore.newEntry();
        if (!Utf8s.utf8ToUtf16(valueAddr, valueAddr + (long)valueSize, e)) {
            throw this.kaput().put("invalid char UTF8 bytes [variableIndex=").put(variableIndex).put(']');
        }
        bindVariableService.setChar(variableIndex, characterStore.toImmutable().charAt(0));
    }

    private void setBindVariableAsDate(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws SqlException, PGMessageProcessingException {
        this.ensureValueLength(variableIndex, 4, valueSize);
        int days = PGConnectionContext.getIntUnsafe(valueAddr);
        long millis = Dates.addDays(946684800000L, days);
        bindVariableService.setDate(variableIndex, millis);
    }

    private void setBindVariableAsDouble(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 8, valueSize);
        bindVariableService.setDouble(variableIndex, Double.longBitsToDouble(PGConnectionContext.getLongUnsafe(valueAddr)));
    }

    private void setBindVariableAsFloat(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 4, valueSize);
        bindVariableService.setFloat(variableIndex, Float.intBitsToFloat(PGConnectionContext.getIntUnsafe(valueAddr)));
    }

    private void setBindVariableAsInt(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 4, valueSize);
        bindVariableService.setInt(variableIndex, PGConnectionContext.getIntUnsafe(valueAddr));
    }

    private void setBindVariableAsLong(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 8, valueSize);
        bindVariableService.setLong(variableIndex, PGConnectionContext.getLongUnsafe(valueAddr));
    }

    private void setBindVariableAsShort(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 2, valueSize);
        bindVariableService.setShort(variableIndex, PGConnectionContext.getShortUnsafe(valueAddr));
    }

    private void setBindVariableAsStr(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService, CharacterStore characterStore, DirectUtf8String utf8String) throws PGMessageProcessingException {
        block9: {
            CharacterStoreEntry e = characterStore.newEntry();
            Function fn = bindVariableService.getFunction(variableIndex);
            try {
                if (fn != null && fn.getType() == 26) {
                    boolean ascii;
                    int sequenceType = Utf8s.getUtf8SequenceType(valueAddr, valueAddr + (long)valueSize);
                    switch (sequenceType) {
                        case 0: {
                            ascii = true;
                            break;
                        }
                        case 1: {
                            ascii = false;
                            break;
                        }
                        default: {
                            throw this.kaput().put("invalid varchar bind variable type [variableIndex=").put(variableIndex).put(']');
                        }
                    }
                    bindVariableService.setVarchar(variableIndex, (Utf8Sequence)utf8String.of(valueAddr, valueAddr + (long)valueSize, ascii));
                    break block9;
                }
                if (Utf8s.utf8ToUtf16(valueAddr, valueAddr + (long)valueSize, e)) {
                    bindVariableService.setStr(variableIndex, characterStore.toImmutable());
                    break block9;
                }
                throw this.kaput().put("invalid UTF8 encoding for string value [variableIndex=").put(variableIndex).put(']');
            }
            catch (PGMessageProcessingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw this.kaput().put(ex);
            }
        }
    }

    private void setBindVariableAsTimestamp(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 8, valueSize);
        bindVariableService.setTimestamp(variableIndex, PGConnectionContext.getLongUnsafe(valueAddr) + 946684800000000L);
    }

    private void setUuidBindVariable(int variableIndex, long valueAddr, int valueSize, BindVariableService bindVariableService) throws PGMessageProcessingException, SqlException {
        this.ensureValueLength(variableIndex, 16, valueSize);
        long hi = PGConnectionContext.getLongUnsafe(valueAddr);
        long lo = PGConnectionContext.getLongUnsafe(valueAddr + 8L);
        bindVariableService.setUuid(variableIndex, lo, hi);
    }

    private void setupEntryAfterSQLCompilation(SqlExecutionContext sqlExecutionContext, WeakSelfReturningObjectPool<TypesAndInsert> taiPool, CompiledQuery cq) {
        sqlExecutionContext.storeTelemetry(cq.getType(), (short)3);
        this.sqlType = cq.getType();
        switch (this.sqlType) {
            case 7: 
            case 9: 
            case 21: 
            case 32: {
                this.operation = cq.getOperation();
                this.sqlTag = "OK";
                break;
            }
            case 25: {
                this.sqlTag = "EXPLAIN";
                this.factory = cq.getRecordCursorFactory();
                this.tas = new TypesAndSelect(this.factory, this.sqlType, "EXPLAIN", this.msgParseParameterTypeOIDs, this.outParameterTypeDescriptionTypes);
                break;
            }
            case 1: {
                this.sqlTag = "SELECT";
                this.factory = cq.getRecordCursorFactory();
                this.tas = new TypesAndSelect(this.factory, this.sqlType, this.sqlTag, this.msgParseParameterTypeOIDs, this.outParameterTypeDescriptionTypes);
                break;
            }
            case 8: {
                this.sqlTag = "PSEUDO_SELECT";
                this.factory = cq.getRecordCursorFactory();
                break;
            }
            case 2: 
            case 10: {
                InsertOperation insertOp = cq.popInsertOperation();
                this.tai = (TypesAndInsert)taiPool.pop();
                this.sqlTag = this.sqlType == 2 ? "INSERT" : "TAG_INSERT_AS_SELECT";
                this.tai.of(insertOp, this.sqlType, this.sqlTag, this.msgParseParameterTypeOIDs, this.outParameterTypeDescriptionTypes);
                break;
            }
            case 14: {
                String sqlText = cq.getSqlText();
                UpdateOperation updateOperation = cq.getUpdateOperation();
                updateOperation.withSqlStatement(sqlText);
                this.ensureCompiledQuery();
                this.compiledQuery.ofUpdate(updateOperation);
                this.compiledQuery.withSqlText(sqlText);
                this.sqlTag = "UPDATE";
                break;
            }
            case 6: {
                this.sqlTag = "SET";
                break;
            }
            case 24: {
                this.utf8StringSink.clear();
                this.utf8StringSink.put(cq.getStatementName());
                this.preparedStatementNameToDeallocate = this.utf8StringSink;
                this.sqlTag = "DEALLOCATE";
                break;
            }
            case 18: {
                this.sqlTag = "BEGIN";
                break;
            }
            case 19: {
                this.sqlTag = "COMMIT";
                break;
            }
            case 20: {
                this.sqlTag = "ROLLBACK";
                break;
            }
            case 29: {
                this.sqlTag = "ALTER ROLE";
                break;
            }
            case 28: {
                this.sqlTag = "CREATE ROLE";
                break;
            }
            case 4: {
                this.ensureCompiledQuery();
                this.compiledQuery.ofAlter(AlterOperation.deepCloneOf(cq.getAlterOperation()));
                this.compiledQuery.withSqlText(cq.getSqlText());
                this.sqlTag = "OK";
                break;
            }
            default: {
                this.sqlTag = "OK";
            }
        }
        this.sqlTextHasSecret = sqlExecutionContext.containsSecret();
        this.stateParseExecuted = cq.executedAtParseTime();
    }

    private boolean txtAndBinSizesCanBeDifferent(int columnType) {
        short typeTag = ColumnType.tagOf(columnType);
        return !ColumnType.isVarSize(typeTag) && !ColumnType.isGeoHash(columnType) && typeTag != 1 && typeTag != 4 && typeTag != 25 && typeTag != 13 && typeTag != 12;
    }

    private void validatePgResultSetColumnTypesAndNames() throws PGMessageProcessingException {
        if (this.factory == null) {
            return;
        }
        RecordMetadata currentMetadata = this.factory.getMetadata();
        int currentColumnCount = currentMetadata.getColumnCount();
        int cachedColumnCount = this.pgResultSetColumnNames.size();
        if (cachedColumnCount == 0) {
            assert (this.pgResultSetColumnTypes.size() == 0);
            this.copyPgResultSetColumnTypesAndNames();
            return;
        }
        if (cachedColumnCount != currentColumnCount) {
            this.stalePlanError = true;
            this.error = true;
            throw this.kaput().put("cached plan must not change result type");
        }
        for (int i = 0; i < currentColumnCount; ++i) {
            String cachedColumnName;
            int cachedColumnType;
            int cachedPgColumnType;
            int currentColumnType = currentMetadata.getColumnType(i);
            int currentPgColumnType = PGOids.getTypeOid(ColumnType.isNull(currentColumnType) ? 11 : currentColumnType);
            if (currentPgColumnType != (cachedPgColumnType = PGOids.getTypeOid(ColumnType.isNull(cachedColumnType = this.pgResultSetColumnTypes.getQuick(2 * i)) ? 11 : cachedColumnType))) {
                this.stalePlanError = true;
                this.error = true;
                throw this.kaput().put("cached plan must not change result type");
            }
            String currentColumnName = currentMetadata.getColumnName(i);
            if (!Chars.equals(currentColumnName, cachedColumnName = this.pgResultSetColumnNames.getQuick(i))) {
                this.stalePlanError = true;
                this.error = true;
                throw this.kaput().put("cached plan must not change result type");
            }
            this.pgResultSetColumnTypes.setQuick(2 * i, currentColumnType);
            this.pgResultSetColumnTypes.setQuick(2 * i + 1, GeoHashes.getBitFlags(currentColumnType));
        }
    }

    void clearState() {
        this.error = false;
        this.stalePlanError = false;
        this.stateSync = 0;
        this.stateParse = false;
        this.stateBind = false;
        this.stateDesc = 0;
        this.stateExec = false;
        this.stateClosed = false;
        this.arrayViewPool.clear();
    }

    void copyStateFrom(PGPipelineEntry that) {
        this.stateParse = that.stateParse;
        this.stateBind = that.stateBind;
        this.stateDesc = that.stateDesc;
        this.stateExec = that.stateExec;
        this.stateClosed = that.stateClosed;
    }

    boolean isDirty() {
        return this.error || this.stateSync != 0 || this.stateParse || this.stateBind || this.stateDesc != 0 || this.stateExec || this.stateClosed;
    }

    boolean msgParseReconcileParameterTypes(short parameterTypeCount, TypeContainer typeContainer) {
        IntList cachedTypes = typeContainer.getPgInParameterTypeOIDs();
        int cachedTypeCount = cachedTypes.size();
        if (parameterTypeCount != cachedTypeCount) {
            return false;
        }
        for (int i = 0; i < cachedTypeCount; ++i) {
            if (cachedTypes.getQuick(i) == this.msgParseParameterTypeOIDs.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    boolean msgParseReconcileParameterTypes(TypeContainer typeContainer) {
        assert (this.msgParseParameterTypeOIDs.size() <= Short.MAX_VALUE);
        return this.msgParseReconcileParameterTypes((short)this.msgParseParameterTypeOIDs.size(), typeContainer);
    }
}

