/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.JsonPlanSink;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.TextPlanSink;

public class ExplainPlanFactory
extends AbstractRecordCursorFactory {
    private static final GenericRecordMetadata METADATA = new GenericRecordMetadata();
    private final RecordCursorFactory base;
    private final ExplainPlanRecordCursor cursor;
    private boolean isBaseClosed;

    public ExplainPlanFactory(RecordCursorFactory base, int format) {
        super(METADATA);
        this.base = base;
        this.cursor = new ExplainPlanRecordCursor(format);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(this.base, executionContext);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("EXPLAIN");
    }

    @Override
    protected void _close() {
        if (!this.isBaseClosed) {
            this.base.close();
            this.isBaseClosed = true;
        }
    }

    static {
        METADATA.add(new TableColumnMetadata("QUERY PLAN", 11));
    }

    public class ExplainPlanRecordCursor
    implements RecordCursor {
        private final PlanSink planSink;
        private final Record record;
        private int row = 0;
        private int rowCount;

        public ExplainPlanRecordCursor(int format) {
            this.planSink = format == 2 ? new JsonPlanSink() : new TextPlanSink();
            this.record = new ExplainPlanRecord(this.planSink);
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.row++ < this.rowCount;
        }

        public void of(RecordCursorFactory base, SqlExecutionContext executionContext) throws SqlException {
            try (RecordCursor ignored = base.getCursor(executionContext);){
                this.planSink.of(base, executionContext);
            }
            this.rowCount = this.planSink.getLineCount();
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            return this.rowCount;
        }

        @Override
        public void toTop() {
            this.row = 0;
        }
    }

    public class ExplainPlanRecord
    implements Record {
        private final PlanSink planSink;

        public ExplainPlanRecord(PlanSink sink) {
            this.planSink = sink;
        }

        @Override
        public CharSequence getStrA(int col) {
            return this.planSink.getLine(ExplainPlanFactory.this.cursor.row);
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStrA(col);
        }

        @Override
        public int getStrLen(int col) {
            return this.planSink.getLine(ExplainPlanFactory.this.cursor.row).length();
        }
    }
}

