/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class InSymbolCursorFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(KC)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Record.CharSequenceFunction func;
        int zeroColumnType;
        Function valueFunction = args.getQuick(0);
        Function cursorFunction = args.getQuick(1);
        int n = zeroColumnType = !cursorFunction.isNullConstant() ? cursorFunction.getRecordCursorFactory().getMetadata().getColumnType(0) : 33;
        if (ColumnType.isNull(zeroColumnType)) {
            if (valueFunction.isNullConstant()) {
                return BooleanConstant.TRUE;
            }
            SymbolFunction symbolFunction = (SymbolFunction)args.getQuick(0);
            if (symbolFunction.isSymbolTableStatic()) {
                return new SymbolInNullCursorFunc(symbolFunction);
            }
            return new StrInNullCursorFunc(symbolFunction);
        }
        switch (zeroColumnType) {
            case 11: {
                func = Record.GET_STR;
                break;
            }
            case 12: {
                func = Record.GET_SYM;
                break;
            }
            case 26: {
                func = Record.GET_VARCHAR;
                break;
            }
            default: {
                throw SqlException.position(position).put("supported column types are VARCHAR, SYMBOL and STRING, found: ").put(ColumnType.nameOf(zeroColumnType));
            }
        }
        if (valueFunction.isNullConstant()) {
            return new StrInCursorFunc(NullConstant.NULL, cursorFunction, func);
        }
        SymbolFunction symbolFunction = (SymbolFunction)args.getQuick(0);
        if (symbolFunction.isSymbolTableStatic()) {
            return new SymbolInCursorFunc(symbolFunction, cursorFunction, func);
        }
        return new StrInCursorFunc(symbolFunction, cursorFunction, func);
    }

    private static class SymbolInNullCursorFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function valueArg;

        public SymbolInNullCursorFunc(Function valueArg) {
            this.valueArg = valueArg;
        }

        @Override
        public Function getArg() {
            return this.valueArg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.valueArg.getInt(rec) == Integer.MIN_VALUE;
        }

        @Override
        public boolean isThreadSafe() {
            return this.valueArg.isThreadSafe();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.valueArg).val(" in null");
        }
    }

    private static class StrInNullCursorFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function valueArg;

        public StrInNullCursorFunc(Function valueArg) {
            this.valueArg = valueArg;
        }

        @Override
        public Function getArg() {
            return this.valueArg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.valueArg.getSymbol(rec) == null;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.valueArg).val(" in null");
        }
    }

    private static class StrInCursorFunc
    extends BooleanFunction
    implements BinaryFunction {
        private final Function cursorArg;
        private final Record.CharSequenceFunction func;
        private final StringSink sink = new StringSink();
        private final Function valueArg;
        private final CharSequenceHashSet valueSet = new CharSequenceHashSet();
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public StrInCursorFunc(Function valueArg, Function cursorArg, Record.CharSequenceFunction func) {
            this.valueArg = valueArg;
            this.cursorArg = cursorArg;
            this.func = func;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.valueSet.contains(this.valueArg.getSymbol(rec));
        }

        @Override
        public Function getLeft() {
            return this.valueArg;
        }

        @Override
        public Function getRight() {
            return this.cursorArg;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.valueArg.init(symbolTableSource, executionContext);
            this.cursorArg.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            this.valueSet.clear();
            RecordCursorFactory factory = this.cursorArg.getRecordCursorFactory();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                Record record = cursor.getRecord();
                this.sink.clear();
                while (cursor.hasNext()) {
                    CharSequence value = this.func.get(record, 0, this.sink);
                    if (value == null) {
                        this.valueSet.addNull();
                        continue;
                    }
                    int toIndex = this.valueSet.keyIndex(value);
                    if (toIndex <= -1) continue;
                    this.valueSet.addAt(toIndex, Chars.toString(value));
                }
            }
        }

        @Override
        public boolean isThreadSafe() {
            return this.valueArg.isThreadSafe();
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof StrInCursorFunc) {
                StrInCursorFunc thatF = (StrInCursorFunc)that;
                thatF.valueSet.clear();
                thatF.valueSet.addAll(this.valueSet);
                this.stateShared = true;
                thatF.stateInherited = true;
            }
            BinaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.valueArg).val(" in ").val(this.cursorArg);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class SymbolInCursorFunc
    extends BooleanFunction
    implements BinaryFunction {
        private final Function cursorArg;
        private final Record.CharSequenceFunction func;
        private final IntHashSet symbolKeys = new IntHashSet();
        private final SymbolFunction valueArg;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public SymbolInCursorFunc(SymbolFunction valueArg, Function cursorArg, Record.CharSequenceFunction func) {
            this.valueArg = valueArg;
            this.cursorArg = cursorArg;
            this.func = func;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.symbolKeys.keyIndex(this.valueArg.getInt(rec) + 1) < 0;
        }

        @Override
        public Function getLeft() {
            return this.valueArg;
        }

        @Override
        public Function getRight() {
            return this.cursorArg;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.valueArg.init(symbolTableSource, executionContext);
            this.cursorArg.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            this.symbolKeys.clear();
            RecordCursorFactory factory = this.cursorArg.getRecordCursorFactory();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                StaticSymbolTable symbolTable = this.valueArg.getStaticSymbolTable();
                assert (symbolTable != null);
                Record record = cursor.getRecord();
                StringSink sink = Misc.getThreadLocalSink();
                while (cursor.hasNext()) {
                    int key = symbolTable.keyOf(this.func.get(record, 0, sink));
                    if (key == -2) continue;
                    this.symbolKeys.add(key + 1);
                }
            }
        }

        @Override
        public boolean isThreadSafe() {
            return this.valueArg.isThreadSafe();
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof SymbolInCursorFunc) {
                SymbolInCursorFunc thatF = (SymbolInCursorFunc)that;
                thatF.symbolKeys.clear();
                thatF.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatF.stateInherited = true;
            }
            BinaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.valueArg).val(" in ").val(this.cursorArg);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }
}

