/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToVarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CastBooleanToVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(T\u00f8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.getQuick(0);
        if (func.isConstant()) {
            return new VarcharConstant(func.getStrA(null));
        }
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToVarcharFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            return this.arg.getVarcharA(rec);
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            return this.arg.getVarcharB(rec);
        }

        @Override
        public boolean isThreadSafe() {
            return this.arg.isThreadSafe();
        }
    }
}

