/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrArrayFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CurrentSchemasFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "current_schemas(T)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CurrentSchemaFunction();
    }

    private static class CurrentSchemaFunction
    extends StrArrayFunction
    implements FunctionExtension {
        private CurrentSchemaFunction() {
        }

        @Override
        public FunctionExtension extendedOps() {
            return this;
        }

        @Override
        public int getArrayLength() {
            return 1;
        }

        @Override
        public Record getRecord(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return "{public}";
        }

        @Override
        public CharSequence getStrA(Record rec, int arrayIndex) {
            return "public";
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStrA(rec);
        }

        @Override
        public CharSequence getStrB(Record rec, int arrayIndex) {
            return this.getStrA(rec, arrayIndex);
        }

        @Override
        public int getStrLen(Record rec) {
            return this.getStrA(rec).length();
        }

        @Override
        public int getStrLen(Record rec, int arrayIndex) {
            return this.getStrA(rec, arrayIndex).length();
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("current_schemas()");
        }
    }
}

