/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GeoByteFunction;

public class GeoByteColumn
extends GeoByteFunction {
    private static final GeoByteColumn[] COLUMNS;
    private final int columnIndex;

    private GeoByteColumn(int columnIndex, int columnType) {
        super(columnType);
        this.columnIndex = columnIndex;
    }

    public static GeoByteColumn newInstance(int columnIndex, int columnType) {
        assert (ColumnType.getGeoHashBits(columnType) >= 1 && ColumnType.getGeoHashBits(columnType) <= 7);
        int bits = 7;
        if (columnIndex < 32) {
            return COLUMNS[columnIndex * 7 + ColumnType.getGeoHashBits(columnType) - 1];
        }
        return new GeoByteColumn(columnIndex, columnType);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public byte getGeoByte(Record rec) {
        return rec.getGeoByte(this.columnIndex);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        int bits = 7;
        COLUMNS = new GeoByteColumn[32 * bits];
        for (int col = 0; col < 32; ++col) {
            for (int bit = 1; bit <= 7; ++bit) {
                GeoByteColumn.COLUMNS[col * bits + bit - 1] = new GeoByteColumn(col, ColumnType.getGeoHashTypeWithBits(bit));
            }
        }
    }
}

