/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.groupby.FirstSymbolGroupByFunction;
import org.jetbrains.annotations.NotNull;

public class LastNotNullSymbolGroupByFunction
extends FirstSymbolGroupByFunction {
    public LastNotNullSymbolGroupByFunction(@NotNull SymbolFunction arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (this.arg.getInt(record) != Integer.MIN_VALUE) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "last_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        int srcVal = srcValue.getInt(this.valueIndex + 1);
        if (srcVal == Integer.MIN_VALUE) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putInt(this.valueIndex + 1, srcVal);
        }
    }
}

