/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByUtf8Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public final class MinVarcharGroupByFunction
extends VarcharFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private final GroupByUtf8Sink sinkA = new GroupByUtf8Sink();
    private final GroupByUtf8Sink sinkB = new GroupByUtf8Sink();
    private int valueIndex;

    public MinVarcharGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void clear() {
        this.sinkA.of(0L);
        this.sinkB.of(0L);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        Utf8Sequence val = this.arg.getVarcharA(record);
        if (val == null) {
            mapValue.putLong(this.valueIndex, 0L);
        } else {
            this.sinkA.of(0L).put(val);
            mapValue.putLong(this.valueIndex, this.sinkA.ptr());
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        Utf8Sequence val = this.arg.getVarcharA(record);
        if (val != null) {
            long ptr = mapValue.getLong(this.valueIndex);
            if (ptr == 0L) {
                this.sinkA.of(0L).put(val);
                mapValue.putLong(this.valueIndex, this.sinkA.ptr());
                return;
            }
            this.sinkA.of(ptr);
            if (Utf8s.compare(this.sinkA, val) > 0) {
                this.sinkA.clear();
                this.sinkA.put(val);
                mapValue.putLong(this.valueIndex, this.sinkA.ptr());
            }
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        long ptr = rec.getLong(this.valueIndex);
        return ptr == 0L ? null : this.sinkA.of(ptr);
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        return this.getVarcharA(rec);
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcPtr = srcValue.getLong(this.valueIndex);
        if (srcPtr == 0L) {
            return;
        }
        long destPtr = destValue.getLong(this.valueIndex);
        if (destPtr == 0L || Utf8s.compare(this.sinkA.of(destPtr), this.sinkB.of(srcPtr)) > 0) {
            destValue.putLong(this.valueIndex, srcPtr);
        }
    }

    @Override
    public void setAllocator(GroupByAllocator allocator) {
        this.sinkA.setAllocator(allocator);
        this.sinkB.setAllocator(allocator);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("min(").val(this.arg).val(')');
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
    }
}

