/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.SingleRecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.map.RecordValueSinkFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class RankFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final String NAME = "rank";
    private static final ArrayColumnTypes RANK_COLUMN_TYPES = new ArrayColumnTypes();
    private static final String SIGNATURE = "rank()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        if (windowContext.isEmpty()) {
            throw SqlException.emptyWindowContext(position);
        }
        if (windowContext.getNullsDescPos() > 0) {
            throw SqlException.$(windowContext.getNullsDescPos(), "RESPECT/IGNORE NULLS is not supported for current window function");
        }
        if (windowContext.isOrdered()) {
            if (windowContext.getPartitionByRecord() != null) {
                return new RankOverPartitionFunction(windowContext.getPartitionByKeyTypes(), windowContext.getPartitionByRecord(), windowContext.getPartitionBySink(), configuration, false, NAME);
            }
            return new RankFunction(configuration, false, NAME);
        }
        return new RankNoOrderFunction(windowContext.getPartitionByRecord(), NAME);
    }

    static {
        RANK_COLUMN_TYPES.add(6);
        RANK_COLUMN_TYPES.add(6);
        RANK_COLUMN_TYPES.add(6);
    }

    protected static class RankOverPartitionFunction
    extends LongFunction
    implements Function,
    WindowFunction,
    Reopenable {
        private final CairoConfiguration configuration;
        private final boolean dense;
        private final ColumnTypes keyColumnTypes;
        private final String name;
        private final VirtualRecord partitionByRecord;
        private final RecordSink partitionBySink;
        private int chainTypeIndex;
        private int columnIndex;
        private Map map;
        private long rank;
        private RecordComparator recordComparator;
        private RecordValueSink recordValueSink;

        public RankOverPartitionFunction(ColumnTypes keyColumnTypes, VirtualRecord partitionByRecord, RecordSink partitionBySink, CairoConfiguration configuration, boolean dense, String name) {
            this.partitionByRecord = partitionByRecord;
            this.partitionBySink = partitionBySink;
            this.keyColumnTypes = keyColumnTypes;
            this.configuration = configuration;
            this.dense = dense;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            Misc.free(this.map);
            Misc.freeObjList(this.partitionByRecord.getFunctions());
        }

        @Override
        public void computeNext(Record record) {
            long count;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            if (mapValue.isNew()) {
                this.rank = 1L;
                count = 1L;
            } else {
                this.rank = mapValue.getLong(this.chainTypeIndex);
                count = mapValue.getLong(this.chainTypeIndex + 1);
                this.recordComparator.setLeft(mapValue);
                if (this.recordComparator.compare(record) != 0) {
                    this.rank = this.dense ? this.rank + 1L : count;
                }
            }
            this.recordValueSink.copy(record, mapValue);
            mapValue.putLong(this.chainTypeIndex, this.rank);
            mapValue.putLong(this.chainTypeIndex + 1, count + 1L);
        }

        @Override
        public long getLong(Record rec) {
            return this.rank;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            Function.init(this.partitionByRecord.getFunctions(), symbolTableSource, executionContext, null);
        }

        @Override
        public void initRecordComparator(SqlCodeGenerator sqlGenerator, RecordMetadata metadata, ArrayColumnTypes chainTypes, IntList orderIndices, ObjList<ExpressionNode> orderBy, IntList orderByDirection) throws SqlException {
            if (orderIndices == null) {
                orderIndices = sqlGenerator.toOrderIndices(metadata, orderBy, orderByDirection);
            }
            if (chainTypes.getColumnCount() == 0) {
                EntityColumnFilter entityColumnFilter = sqlGenerator.getEntityColumnFilter();
                int size = metadata.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    chainTypes.add(metadata.getColumnType(i));
                }
                this.chainTypeIndex = metadata.getColumnCount();
                entityColumnFilter.of(this.chainTypeIndex);
                this.recordValueSink = RecordValueSinkFactory.getInstance(sqlGenerator.getAsm(), chainTypes, entityColumnFilter);
                this.recordComparator = sqlGenerator.getRecordComparatorCompiler().newInstance(chainTypes, orderIndices);
                chainTypes.add(6);
                chainTypes.add(6);
                this.map = MapFactory.createUnorderedMap(this.configuration, this.keyColumnTypes, chainTypes);
            } else {
                this.map = MapFactory.createUnorderedMap(this.configuration, this.keyColumnTypes, RANK_COLUMN_TYPES);
                this.recordComparator = sqlGenerator.getRecordComparatorCompiler().newInstance(chainTypes, orderIndices);
            }
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            long count;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            if (mapValue.isNew()) {
                this.rank = 1L;
                count = 1L;
            } else {
                long lastOffset = mapValue.getLong(0);
                this.rank = mapValue.getLong(1);
                count = mapValue.getLong(2);
                this.recordComparator.setLeft(record);
                if (this.recordComparator.compare(spi.getRecordAt(lastOffset)) != 0) {
                    this.rank = this.dense ? this.rank + 1L : count;
                }
            }
            mapValue.putLong(0, recordOffset);
            mapValue.putLong(1, this.rank);
            mapValue.putLong(2, count + 1L);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.rank);
        }

        @Override
        public void reopen() {
            if (this.map != null) {
                this.map.reopen();
            }
            this.rank = 0L;
        }

        @Override
        public void reset() {
            Misc.free(this.map);
            this.rank = 0L;
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val("()");
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            Misc.clear(this.map);
            this.rank = 0L;
        }
    }

    protected static class RankFunction
    extends LongFunction
    implements Function,
    WindowFunction,
    Reopenable {
        private final CairoConfiguration configuration;
        private final boolean dense;
        private final String name;
        private int columnIndex;
        private long count = 1L;
        private long lastRecordOffset;
        private long rank;
        private RecordComparator recordComparator;
        private RecordSink recordSink;
        private SingleRecordSink singleRecordSinkA;
        private SingleRecordSink singleRecordSinkB;

        public RankFunction(CairoConfiguration configuration, boolean dense, String name) {
            this.configuration = configuration;
            this.dense = dense;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            Misc.free(this.singleRecordSinkA);
            Misc.free(this.singleRecordSinkB);
        }

        @Override
        public void computeNext(Record record) {
            SingleRecordSink singleRecordSink = this.count % 2L == 0L ? this.singleRecordSinkA : this.singleRecordSinkB;
            singleRecordSink.clear();
            this.recordSink.copy(record, singleRecordSink);
            if (this.count == 1L) {
                this.rank = 1L;
            } else if (!this.singleRecordSinkA.memeq(this.singleRecordSinkB)) {
                this.rank = this.dense ? this.rank + 1L : this.count;
            }
            ++this.count;
        }

        @Override
        public long getLong(Record rec) {
            return this.rank;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void initRecordComparator(SqlCodeGenerator sqlGenerator, RecordMetadata metadata, ArrayColumnTypes chainTypes, IntList orderIndices, ObjList<ExpressionNode> orderBy, IntList orderByDirection) throws SqlException {
            if (chainTypes.getColumnCount() == 0) {
                int i;
                ListColumnFilter listColumnFilter = sqlGenerator.getIndexColumnFilter();
                listColumnFilter.clear();
                int size = orderBy.size();
                for (i = 0; i < size; ++i) {
                    ExpressionNode tok = orderBy.getQuick(i);
                    int index = metadata.getColumnIndexQuiet(tok.token);
                    listColumnFilter.add(index + 1);
                }
                size = metadata.getColumnCount();
                for (i = 0; i < size; ++i) {
                    chainTypes.add(metadata.getColumnType(i));
                }
                this.recordSink = RecordSinkFactory.getInstance(sqlGenerator.getAsm(), chainTypes, listColumnFilter);
                this.singleRecordSinkA = new SingleRecordSink((long)this.configuration.getSqlWindowStorePageSize() * (long)this.configuration.getSqlWindowStoreMaxPages() / 2L, 50);
                this.singleRecordSinkB = new SingleRecordSink((long)this.configuration.getSqlWindowStorePageSize() * (long)this.configuration.getSqlWindowStoreMaxPages() / 2L, 50);
            } else {
                if (orderIndices == null) {
                    orderIndices = sqlGenerator.toOrderIndices(metadata, orderBy, orderByDirection);
                }
                this.recordComparator = sqlGenerator.getRecordComparatorCompiler().newInstance(chainTypes, orderIndices);
            }
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            if (this.count == 1L) {
                this.rank = 1L;
            } else {
                this.recordComparator.setLeft(record);
                if (this.recordComparator.compare(spi.getRecordAt(this.lastRecordOffset)) != 0) {
                    this.rank = this.dense ? this.rank + 1L : this.count;
                }
            }
            this.lastRecordOffset = recordOffset;
            ++this.count;
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.rank);
        }

        @Override
        public void reopen() {
            this.count = 1L;
            if (this.singleRecordSinkA != null) {
                this.singleRecordSinkA.reopen();
            }
            if (this.singleRecordSinkB != null) {
                this.singleRecordSinkB.reopen();
            }
        }

        @Override
        public void reset() {
            this.count = 1L;
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val("() over ()");
        }

        @Override
        public void toTop() {
            this.count = 1L;
            super.toTop();
        }
    }

    protected static class RankNoOrderFunction
    extends LongFunction
    implements Function,
    WindowFunction,
    Reopenable {
        private static final long RANK_CONST = 1L;
        private final String name;
        private final VirtualRecord partitionByRecord;
        private int columnIndex;

        public RankNoOrderFunction(VirtualRecord partitionByRecord, String name) {
            this.partitionByRecord = partitionByRecord;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            if (this.partitionByRecord != null) {
                Misc.freeObjList(this.partitionByRecord.getFunctions());
            }
        }

        @Override
        public long getLong(Record rec) {
            return 1L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            if (this.partitionByRecord != null) {
                Function.init(this.partitionByRecord.getFunctions(), symbolTableSource, executionContext, null);
            }
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), 1L);
        }

        @Override
        public void reopen() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val("()");
            if (this.partitionByRecord != null) {
                sink.val(" over (");
                sink.val("partition by ");
                sink.val(this.partitionByRecord.getFunctions());
                sink.val(')');
            } else {
                sink.val(" over ()");
            }
        }
    }
}

