/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevNotKeyedRecordCursor;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillPrevNotKeyedRecordCursorFactory
extends AbstractSampleByNotKeyedRecordCursorFactory {
    private final SampleByFillPrevNotKeyedRecordCursor cursor;

    public SampleByFillPrevNotKeyedRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, int groupByValueCount, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        super(base, groupByMetadata, recordFunctions);
        try {
            SimpleMapValue simpleMapValue = new SimpleMapValue(groupByValueCount);
            GroupByFunctionsUpdater updater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
            this.cursor = new SampleByFillPrevNotKeyedRecordCursor(configuration, groupByFunctions, updater, recordFunctions, timestampIndex, timestampSampler, simpleMapValue, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            throw e;
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sample By");
        sink.attr("fill").val("prev");
        sink.optAttr((CharSequence)"values", this.cursor.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    protected AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }
}

