/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.griffin.engine.table.AsyncFilteredNegativeLimitRecordCursor;
import io.questdb.griffin.engine.table.AsyncFilteredRecordCursor;
import io.questdb.mp.SCSequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncFilteredRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final PageFrameReducer REDUCER = AsyncFilteredRecordCursorFactory::filter;
    private final RecordCursorFactory base;
    private final SCSequence collectSubSeq = new SCSequence();
    private final AsyncFilteredRecordCursor cursor;
    private final Function filter;
    private final PageFrameSequence<AsyncFilterAtom> frameSequence;
    private final Function limitLoFunction;
    private final int limitLoPos;
    private final int maxNegativeLimit;
    private final AsyncFilteredNegativeLimitRecordCursor negativeLimitCursor;
    private final int workerCount;
    private DirectLongList negativeLimitRows;

    public AsyncFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull RecordCursorFactory base, @NotNull Function filter, @NotNull PageFrameReduceTaskFactory reduceTaskFactory, @Nullable ObjList<Function> perWorkerFilters, @Nullable Function limitLoFunction, int limitLoPos, int workerCount) {
        super(base.getMetadata());
        assert (!(base instanceof AsyncFilteredRecordCursorFactory));
        this.base = base;
        this.filter = filter;
        this.cursor = new AsyncFilteredRecordCursor(configuration, filter, base.getScanDirection());
        this.negativeLimitCursor = new AsyncFilteredNegativeLimitRecordCursor(configuration, base.getScanDirection());
        int columnCount = base.getMetadata().getColumnCount();
        IntList columnTypes = new IntList(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            int columnType = base.getMetadata().getColumnType(i);
            columnTypes.add(columnType);
        }
        AsyncFilterAtom atom = new AsyncFilterAtom(configuration, filter, perWorkerFilters, columnTypes);
        this.frameSequence = new PageFrameSequence<AsyncFilterAtom>(configuration, messageBus, atom, REDUCER, reduceTaskFactory, workerCount, 0);
        this.limitLoFunction = limitLoFunction;
        this.limitLoPos = limitLoPos;
        this.maxNegativeLimit = configuration.getSqlMaxNegativeLimit();
        this.workerCount = workerCount;
    }

    public PageFrameSequence<AsyncFilterAtom> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.frameSequence.of(this.base, executionContext, collectSubSeq, order);
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.limitLoFunction != null;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int order;
        long rowsRemaining;
        int baseOrder;
        int n = baseOrder = this.base.getScanDirection() == 2 ? 1 : 0;
        if (this.limitLoFunction != null) {
            this.limitLoFunction.init(this.frameSequence.getSymbolTableSource(), executionContext);
            rowsRemaining = this.limitLoFunction.getLong(null);
            if (rowsRemaining > -1L) {
                order = baseOrder;
            } else {
                order = PartitionFrameCursorFactory.reverse(baseOrder);
                rowsRemaining = -rowsRemaining;
            }
        } else {
            rowsRemaining = Long.MAX_VALUE;
            order = baseOrder;
        }
        if (order != baseOrder && rowsRemaining != Long.MAX_VALUE) {
            if (rowsRemaining > (long)this.maxNegativeLimit) {
                throw SqlException.position(this.limitLoPos).put("absolute LIMIT value is too large, maximum allowed value: ").put(this.maxNegativeLimit);
            }
            if (this.negativeLimitRows == null) {
                this.negativeLimitRows = new DirectLongList(this.maxNegativeLimit, 46);
            }
            this.negativeLimitCursor.of(this.execute(executionContext, this.collectSubSeq, order), rowsRemaining, this.negativeLimitRows);
            return this.negativeLimitCursor;
        }
        this.cursor.of(this.execute(executionContext, this.collectSubSeq, order), rowsRemaining);
        return this.cursor;
    }

    @Override
    @NotNull
    public Function getFilter() {
        return this.filter;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public TableToken getTableToken() {
        return this.base.getTableToken();
    }

    @Override
    public void halfClose() {
        Misc.free(this.frameSequence);
        this.cursor.freeRecords();
        this.negativeLimitCursor.freeRecords();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean supportsFilterStealing() {
        return this.limitLoFunction == null;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.base.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        int order;
        long rowsRemaining;
        int baseOrder;
        sink.type("Async Filter");
        sink.meta("workers").val(this.workerCount);
        int n = baseOrder = this.base.getScanDirection() == 2 ? 1 : 0;
        if (this.limitLoFunction != null) {
            try {
                this.limitLoFunction.init(this.frameSequence.getSymbolTableSource(), sink.getExecutionContext());
                rowsRemaining = this.limitLoFunction.getLong(null);
            }
            catch (Exception e) {
                rowsRemaining = Long.MAX_VALUE;
            }
            if (rowsRemaining > -1L) {
                order = baseOrder;
            } else {
                order = PartitionFrameCursorFactory.reverse(baseOrder);
                rowsRemaining = -rowsRemaining;
            }
        } else {
            rowsRemaining = Long.MAX_VALUE;
            order = baseOrder;
        }
        if (rowsRemaining != Long.MAX_VALUE) {
            sink.attr("limit").val(rowsRemaining);
        }
        sink.attr("filter").val(this.frameSequence.getAtom());
        sink.child(this.base, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filter(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        DirectLongList rows = task.getFilteredRows();
        long frameRowCount = task.getFrameRowCount();
        AsyncFilterAtom atom = task.getFrameSequence(AsyncFilterAtom.class).getAtom();
        PageFrameMemory frameMemory = task.populateFrameMemory();
        record.init(frameMemory);
        rows.clear();
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == task.getFrameSequence();
        int filterId = atom.maybeAcquireFilter(workerId, owner, circuitBreaker);
        Function filter = atom.getFilter(filterId);
        try {
            for (long r = 0L; r < frameRowCount; ++r) {
                record.setRowIndex(r);
                if (!filter.getBool(record)) continue;
                rows.add(r);
            }
        }
        finally {
            atom.releaseFilter(filterId);
        }
        if (frameMemory.getFrameFormat() == 0) {
            atom.preTouchColumns(record, rows, frameRowCount);
        }
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.negativeLimitRows);
        this.halfClose();
        Misc.free(this.filter);
    }
}

