/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PartitionFrame;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.vm.NullMemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.griffin.engine.table.TablePageFrameCursor;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.Nullable;

public class BwdTableReaderPageFrameCursor
implements TablePageFrameCursor {
    private final int columnCount;
    private final IntList columnIndexes;
    private final LongList columnPageAddresses = new LongList();
    private final IntList columnSizeShifts;
    private final TableReaderPageFrame frame = new TableReaderPageFrame();
    private final int pageFrameMaxRows;
    private final int pageFrameMinRows;
    private final LongList pageSizes = new LongList();
    private final int sharedQueryWorkerCount;
    private PartitionFrameCursor partitionFrameCursor;
    private TableReader reader;
    private long reenterPageFrameRowLimit;
    private PartitionDecoder reenterParquetDecoder;
    private boolean reenterPartitionFrame = false;
    private long reenterPartitionHi;
    private int reenterPartitionIndex;
    private long reenterPartitionLo;

    public BwdTableReaderPageFrameCursor(IntList columnIndexes, IntList columnSizeShifts, int sharedQueryWorkerCount, int pageFrameMinRows, int pageFrameMaxRows) {
        this.columnIndexes = columnIndexes;
        this.columnSizeShifts = columnSizeShifts;
        this.columnCount = columnIndexes.size();
        this.sharedQueryWorkerCount = sharedQueryWorkerCount;
        this.pageFrameMinRows = pageFrameMinRows;
        this.pageFrameMaxRows = pageFrameMaxRows;
    }

    @Override
    public void calculateSize(RecordCursor.Counter counter) {
        this.partitionFrameCursor.calculateSize(counter);
    }

    @Override
    public void close() {
        this.partitionFrameCursor = Misc.free(this.partitionFrameCursor);
    }

    @Override
    public IntList getColumnIndexes() {
        return this.columnIndexes;
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.reader.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public TableReader getTableReader() {
        return this.reader;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.reader.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    @Nullable
    public PageFrame next(long skipTarget) {
        if (this.reenterPartitionFrame) {
            if (this.reenterParquetDecoder != null) {
                return this.computeParquetFrame(this.reenterPartitionLo, this.reenterPartitionHi);
            }
            return this.computeNativeFrame(this.reenterPartitionLo, this.reenterPartitionHi);
        }
        PartitionFrame partitionFrame = this.partitionFrameCursor.next(skipTarget);
        if (partitionFrame != null) {
            this.reenterPartitionIndex = partitionFrame.getPartitionIndex();
            long lo = partitionFrame.getRowLo();
            long hi = partitionFrame.getRowHi();
            if (hi - lo <= skipTarget) {
                this.frame.partitionIndex = this.reenterPartitionIndex;
                this.frame.partitionLo = lo;
                this.frame.partitionHi = hi;
                return this.frame;
            }
            return this.nextSlow(partitionFrame, lo, hi);
        }
        return null;
    }

    @Override
    public TablePageFrameCursor of(PartitionFrameCursor partitionFrameCursor) {
        this.partitionFrameCursor = partitionFrameCursor;
        this.reader = partitionFrameCursor.getTableReader();
        this.toTop();
        return this;
    }

    @Override
    public long size() {
        return this.partitionFrameCursor.size();
    }

    @Override
    public boolean supportsSizeCalculation() {
        return this.partitionFrameCursor.supportsSizeCalculation();
    }

    @Override
    public void toTop() {
        this.partitionFrameCursor.toTop();
        this.reenterPartitionFrame = false;
        this.reenterParquetDecoder = null;
        this.clearAddresses();
    }

    private void clearAddresses() {
        this.columnPageAddresses.setAll(2 * this.columnCount, 0L);
        this.pageSizes.setAll(2 * this.columnCount, -1L);
    }

    private TableReaderPageFrame computeNativeFrame(long partitionLo, long partitionHi) {
        int columnIndex;
        int i;
        int base = this.reader.getColumnBase(this.reenterPartitionIndex);
        long adjustedLo = Math.max(partitionLo, partitionHi - this.reenterPageFrameRowLimit);
        for (i = 0; i < this.columnCount; ++i) {
            columnIndex = this.columnIndexes.getQuick(i);
            long top = this.reader.getColumnTop(base, columnIndex);
            if (top <= adjustedLo || top >= partitionHi) continue;
            adjustedLo = top;
        }
        for (i = 0; i < this.columnCount; ++i) {
            columnIndex = this.columnIndexes.getQuick(i);
            int readerColIndex = TableReader.getPrimaryColumnIndex(base, columnIndex);
            MemoryCR colMem = this.reader.getColumn(readerColIndex);
            long top = colMem instanceof NullMemoryCMR ? partitionHi : this.reader.getColumnTop(base, columnIndex);
            long partitionLoAdjusted = adjustedLo - top;
            long partitionHiAdjusted = partitionHi - top;
            int sh = this.columnSizeShifts.getQuick(i);
            if (partitionHiAdjusted > 0L) {
                if (sh > -1) {
                    long address = colMem.getPageAddress(0);
                    long addressSize = partitionHiAdjusted << sh;
                    long offset = partitionLoAdjusted << sh;
                    this.columnPageAddresses.setQuick(2 * i, address + offset);
                    this.pageSizes.setQuick(2 * i, addressSize - offset);
                    continue;
                }
                int columnType = this.reader.getMetadata().getColumnType(columnIndex);
                ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                MemoryCR auxCol = this.reader.getColumn(readerColIndex + 1);
                long auxAddress = auxCol.getPageAddress(0);
                long auxOffsetLo = columnTypeDriver.getAuxVectorOffset(partitionLoAdjusted);
                long auxOffsetHi = columnTypeDriver.getAuxVectorOffset(partitionHiAdjusted);
                long dataSize = columnTypeDriver.getDataVectorSizeAt(auxAddress, partitionHiAdjusted - 1L);
                long dataAddress = dataSize > 0L ? colMem.getPageAddress(0) : 0L;
                this.columnPageAddresses.setQuick(2 * i, dataAddress);
                this.columnPageAddresses.setQuick(2 * i + 1, auxAddress + auxOffsetLo);
                this.pageSizes.setQuick(2 * i, dataSize);
                this.pageSizes.setQuick(2 * i + 1, auxOffsetHi - auxOffsetLo);
                continue;
            }
            this.columnPageAddresses.setQuick(2 * i, 0L);
            this.columnPageAddresses.setQuick(2 * i + 1, 0L);
            this.pageSizes.setQuick(2 * i, partitionHiAdjusted - partitionLoAdjusted << (sh > -1 ? sh : 0));
            this.pageSizes.setQuick(2 * i + 1, 0L);
        }
        if (partitionLo < adjustedLo) {
            this.reenterPartitionLo = partitionLo;
            this.reenterPartitionHi = adjustedLo;
            this.reenterPartitionFrame = true;
        } else {
            this.reenterPartitionFrame = false;
        }
        this.frame.partitionLo = adjustedLo;
        this.frame.partitionHi = partitionHi;
        this.frame.format = 0;
        this.frame.parquetAddr = 0L;
        this.frame.rowGroupIndex = -1;
        this.frame.rowGroupLo = -1;
        this.frame.rowGroupHi = -1;
        this.frame.partitionIndex = this.reenterPartitionIndex;
        return this.frame;
    }

    private TableReaderPageFrame computeParquetFrame(long partitionLo, long partitionHi) {
        long adjustedLo;
        PartitionDecoder.Metadata metadata = this.reenterParquetDecoder.metadata();
        int rowGroupCount = metadata.rowGroupCount();
        long rowCount = 0L;
        int rowGroupIndex = 0;
        for (int i = 0; i < rowGroupCount; ++i) {
            rowGroupIndex = i;
            long rowGroupSize = metadata.rowGroupSize(i);
            if (partitionHi <= rowCount + rowGroupSize) break;
            rowCount += rowGroupSize;
        }
        if ((adjustedLo = Math.max(partitionLo, rowCount)) > partitionLo) {
            this.reenterPartitionLo = partitionLo;
            this.reenterPartitionHi = adjustedLo;
            this.reenterPartitionFrame = true;
        } else {
            this.reenterPartitionFrame = false;
        }
        this.frame.partitionLo = adjustedLo;
        this.frame.partitionHi = partitionHi;
        this.frame.format = 1;
        this.frame.parquetAddr = this.reenterParquetDecoder.getFileAddr();
        this.frame.parquetFileSize = this.reenterParquetDecoder.getFileSize();
        this.frame.rowGroupIndex = rowGroupIndex;
        this.frame.rowGroupLo = (int)(adjustedLo - rowCount);
        this.frame.rowGroupHi = (int)(partitionHi - rowCount);
        this.frame.partitionIndex = this.reenterPartitionIndex;
        return this.frame;
    }

    private TableReaderPageFrame nextSlow(PartitionFrame partitionFrame, long lo, long hi) {
        byte format = partitionFrame.getPartitionFormat();
        if (format == 1) {
            this.clearAddresses();
            this.reenterParquetDecoder = partitionFrame.getParquetDecoder();
            this.reenterPageFrameRowLimit = 0L;
            return this.computeParquetFrame(lo, hi);
        }
        assert (format == 0);
        this.reenterParquetDecoder = null;
        this.reenterPageFrameRowLimit = Math.min((long)this.pageFrameMaxRows, Math.max((long)this.pageFrameMinRows, (hi - lo) / (long)Math.max(this.sharedQueryWorkerCount, 1)));
        return this.computeNativeFrame(lo, hi);
    }

    private class TableReaderPageFrame
    implements PageFrame {
        private byte format;
        private long parquetAddr;
        private long parquetFileSize;
        private long partitionHi;
        private int partitionIndex;
        private long partitionLo;
        private int rowGroupHi;
        private int rowGroupIndex;
        private int rowGroupLo;

        private TableReaderPageFrame() {
        }

        @Override
        public long getAuxPageAddress(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.columnPageAddresses.getQuick(2 * columnIndex + 1);
        }

        @Override
        public long getAuxPageSize(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.pageSizes.getQuick(2 * columnIndex + 1);
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return BwdTableReaderPageFrameCursor.this.reader.getBitmapIndexReader(this.partitionIndex, BwdTableReaderPageFrameCursor.this.columnIndexes.getQuick(columnIndex), direction);
        }

        @Override
        public int getColumnCount() {
            return BwdTableReaderPageFrameCursor.this.columnCount;
        }

        @Override
        public byte getFormat() {
            return this.format;
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.columnPageAddresses.getQuick(2 * columnIndex);
        }

        @Override
        public long getPageSize(int columnIndex) {
            return BwdTableReaderPageFrameCursor.this.pageSizes.getQuick(2 * columnIndex);
        }

        @Override
        public long getParquetAddr() {
            assert (this.parquetAddr != 0L || this.format != 1);
            return this.parquetAddr;
        }

        @Override
        public long getParquetFileSize() {
            assert (this.parquetFileSize > 0L || this.format != 1);
            return this.parquetFileSize;
        }

        @Override
        public int getParquetRowGroup() {
            return this.rowGroupIndex;
        }

        @Override
        public int getParquetRowGroupHi() {
            return this.rowGroupHi;
        }

        @Override
        public int getParquetRowGroupLo() {
            return this.rowGroupLo;
        }

        @Override
        public long getPartitionHi() {
            return this.partitionHi;
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getPartitionLo() {
            return this.partitionLo;
        }
    }
}

