/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;

public class DeferredSymbolIndexRowCursorFactory
implements FunctionBasedRowCursorFactory {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final int indexDirection;
    private final Function symbol;
    private int symbolKey;

    public DeferredSymbolIndexRowCursorFactory(int columnIndex, Function symbol, boolean cachedIndexReaderCursor, int indexDirection) {
        this.columnIndex = columnIndex;
        this.symbolKey = -2;
        this.symbol = symbol;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        if (this.symbolKey == -2) {
            return EmptyRowCursor.INSTANCE;
        }
        return pageFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, pageFrame.getPartitionLo(), pageFrame.getPartitionHi() - 1L);
    }

    @Override
    public Function getFunction() {
        return this.symbol;
    }

    @Override
    public void init(PageFrameCursor pageFrameCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
        this.symbol.init(pageFrameCursor, sqlExecutionContext);
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void prepareCursor(PageFrameCursor pageFrameCursor) {
        int symbolKey = pageFrameCursor.getSymbolTable(this.columnIndex).keyOf(this.symbol.getSymbol(null));
        this.symbolKey = symbolKey != -2 ? TableUtils.toIndexKey(symbolKey) : -2;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type(BitmapIndexReader.nameOf(this.indexDirection)).type(" scan").meta("on").putBaseColumnName(this.columnIndex);
        sink.meta("deferred").val("true");
        sink.attr("filter").putBaseColumnName(this.columnIndex).val('=').val(this.symbol);
    }
}

