/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import java.util.Iterator;
import java.util.Map;

public final class ReaderPoolRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int CURRENT_TXN_COLUMN_INDEX = 3;
    private static final int LAST_ACCESS_TIMESTAMP_COLUMN_INDEX = 2;
    private static final RecordMetadata METADATA;
    private static final int OWNER_THREAD_COLUMN_INDEX = 1;
    private static final int TABLE_NAME_COLUMN_INDEX = 0;
    private final CairoEngine cairoEngine;

    public ReaderPoolRecordCursorFactory(CairoEngine cairoEngine) {
        super(METADATA);
        this.cairoEngine = cairoEngine;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        ReaderPoolCursor readerPoolCursor = new ReaderPoolCursor();
        readerPoolCursor.of(this.cairoEngine.getReaderPoolEntries());
        return readerPoolCursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("reader_pool");
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("table_name", 11)).add(1, new TableColumnMetadata("owner_thread_id", 6)).add(2, new TableColumnMetadata("last_access_timestamp", 8)).add(3, new TableColumnMetadata("current_txn", 6));
        METADATA = metadata;
    }

    private static class ReaderPoolCursor
    implements NoRandomAccessRecordCursor {
        private final ReaderPoolEntryRecord record = new ReaderPoolEntryRecord();
        private int allocationIndex = 0;
        private long currentTxn;
        private Iterator<Map.Entry<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>>> iterator;
        private long lastAccessTimestamp;
        private long owner_thread;
        private AbstractMultiTenantPool.Entry<ReaderPool.R> poolEntry;
        private Map<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>> readerPoolEntries;
        private TableToken tableToken;

        private ReaderPoolCursor() {
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            TableReader reader;
            do {
                if (!this.selectPoolEntry()) {
                    return false;
                }
                this.owner_thread = this.poolEntry.getOwnerVolatile(this.allocationIndex);
                this.lastAccessTimestamp = this.poolEntry.getReleaseOrAcquireTime(this.allocationIndex);
                reader = this.poolEntry.getTenant(this.allocationIndex);
                ++this.allocationIndex;
            } while (reader == null);
            this.currentTxn = reader.getTxn();
            this.tableToken = reader.getTableToken();
            return true;
        }

        public void of(Map<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>> readerPoolEntries) {
            this.readerPoolEntries = readerPoolEntries;
            this.toTop();
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void toTop() {
            this.iterator = this.readerPoolEntries.entrySet().iterator();
            this.allocationIndex = 0;
            this.poolEntry = null;
        }

        private boolean selectPoolEntry() {
            while (true) {
                if (this.poolEntry == null) {
                    assert (this.allocationIndex == 0);
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    Map.Entry<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>> mapEntry = this.iterator.next();
                    this.poolEntry = mapEntry.getValue();
                    return true;
                }
                if (this.allocationIndex != 32) break;
                this.poolEntry = this.poolEntry.getNext();
                this.allocationIndex = 0;
            }
            return true;
        }

        private class ReaderPoolEntryRecord
        implements Record {
            private ReaderPoolEntryRecord() {
            }

            @Override
            public long getLong(int col) {
                switch (col) {
                    case 1: {
                        return ReaderPoolCursor.this.owner_thread == -1L ? Long.MIN_VALUE : ReaderPoolCursor.this.owner_thread;
                    }
                    case 3: {
                        return ReaderPoolCursor.this.currentTxn;
                    }
                }
                throw CairoException.nonCritical().put("unsupported column number. [column=").put(col).put("]");
            }

            @Override
            public CharSequence getStrA(int col) {
                assert (col == 0);
                return ReaderPoolCursor.this.tableToken.getTableName();
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }

            @Override
            public long getTimestamp(int col) {
                assert (col == 2);
                return ReaderPoolCursor.this.lastAccessTimestamp;
            }
        }
    }
}

