/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.bytes;

import io.questdb.cairo.CairoException;
import io.questdb.std.Mutable;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.BorrowableAsNativeByteSink;
import io.questdb.std.bytes.ByteSequence;
import io.questdb.std.bytes.DirectByteSequence;
import io.questdb.std.bytes.NativeByteSink;
import org.jetbrains.annotations.NotNull;

public class DirectByteSink
implements DirectByteSequence,
BorrowableAsNativeByteSink,
QuietCloseable,
Mutable {
    private static final int BYTE_SINK_PTR_OFFSET = 0;
    private static final int BYTE_SINK_LO_OFFSET = 8;
    private static final int BYTE_SINK_HI_OFFSET = 16;
    private static final int BYTE_SINK_OVERFLOW_OFFSET = 24;
    private static final int BYTE_SINK_ASCII_OFFSET = 28;
    private final long initialCapacity;
    private final int memoryTag;
    private long impl;
    private long lastAllocatedCapacity;
    private final NativeByteSink byteSink = new NativeByteSink(){

        @Override
        public void close() {
            DirectByteSink.this.closeByteSink();
        }

        @Override
        public long ptr() {
            return DirectByteSink.this.impl;
        }
    };

    public DirectByteSink(long initialCapacity, int memoryTag) {
        this(initialCapacity, true, memoryTag);
    }

    public DirectByteSink(long initialCapacity, boolean alloc, int memoryTag) {
        assert (initialCapacity >= 0L);
        assert (initialCapacity <= Integer.MAX_VALUE);
        this.initialCapacity = initialCapacity;
        this.memoryTag = memoryTag;
        if (alloc) {
            this.inflate();
        } else {
            this.impl = 0L;
        }
    }

    public static native long implBook(long var0, long var2);

    public static native long implCreate(long var0);

    public static native void implDestroy(long var0);

    public void advance(long written) {
        this.setImplPtr(this.getImplPtr() + written);
    }

    public long allocatedCapacity() {
        return this.getImplHi() - this.getImplLo();
    }

    @Override
    @NotNull
    public NativeByteSink borrowDirectByteSink() {
        assert (this.impl != 0L);
        this.lastAllocatedCapacity = this.allocatedCapacity();
        return this.byteSink;
    }

    @Override
    public void clear() {
        this.setImplPtr(this.getImplLo());
        this.setAscii(true);
    }

    @Override
    public void close() {
        this.deflate();
    }

    public long ensureCapacity(long required) {
        assert (required >= 0L);
        long p = this.getImplPtr();
        long available = this.getImplHi() - p;
        if (available >= required) {
            return p;
        }
        long initCapacity = this.allocatedCapacity();
        p = DirectByteSink.implBook(this.impl, required);
        if (p == 0L) {
            if (this.getImplOverflow()) {
                throw CairoException.critical(0).put("buffer overflow, buffer capacity is requested to be over 2 GiB");
            }
            throw CairoException.nonCritical().setOutOfMemory(true).put("could not allocate DirectByteSink [required=").put(required).put(']');
        }
        long newCapacity = this.allocatedCapacity();
        if (newCapacity > initCapacity) {
            Unsafe.incrReallocCount();
            Unsafe.recordMemAlloc(newCapacity - initCapacity, this.memoryTag);
        }
        return p;
    }

    @Override
    public long hi() {
        return this.getImplPtr();
    }

    public boolean isAscii() {
        return Unsafe.getUnsafe().getByte(this.impl + 28L) != 0;
    }

    @Override
    public long ptr() {
        return this.getImplLo();
    }

    public DirectByteSink put(byte b) {
        long dest = this.ensureCapacity(1L);
        Unsafe.getUnsafe().putByte(dest, b);
        this.advance(1L);
        return this;
    }

    public DirectByteSink put(ByteSequence bs) {
        if (bs != null) {
            int bsSize = bs.size();
            long dest = this.ensureCapacity(bsSize);
            for (int i = 0; i < bsSize; ++i) {
                Unsafe.getUnsafe().putByte(dest + (long)i, bs.byteAt(i));
            }
            this.advance(bsSize);
        }
        return this;
    }

    public DirectByteSink put(DirectByteSequence dbs) {
        if (dbs == null) {
            return this;
        }
        return this.put(dbs.lo(), dbs.hi());
    }

    public DirectByteSink put(long lo, long hi) {
        long len = hi - lo;
        long dest = this.ensureCapacity(len);
        Vect.memcpy(dest, lo, len);
        this.advance(len);
        return this;
    }

    public DirectByteSink putByte(byte value) {
        Unsafe.getUnsafe().putByte(this.ensureCapacity(1L), value);
        this.advance(1L);
        return this;
    }

    public DirectByteSink putDouble(double value) {
        Unsafe.getUnsafe().putDouble(this.ensureCapacity(8L), value);
        this.advance(8L);
        return this;
    }

    public DirectByteSink putFloat(float value) {
        Unsafe.getUnsafe().putFloat(this.ensureCapacity(4L), value);
        this.advance(4L);
        return this;
    }

    public DirectByteSink putInt(int value) {
        Unsafe.getUnsafe().putInt(this.ensureCapacity(4L), value);
        this.advance(4L);
        return this;
    }

    public DirectByteSink putLong(long value) {
        Unsafe.getUnsafe().putLong(this.ensureCapacity(8L), value);
        this.advance(8L);
        return this;
    }

    public DirectByteSink putShort(short value) {
        Unsafe.getUnsafe().putShort(this.ensureCapacity(2L), value);
        this.advance(2L);
        return this;
    }

    public void reopen() {
        if (this.impl == 0L) {
            this.inflate();
        }
    }

    public void reserve(long minCapacity) {
        if (minCapacity > this.allocatedCapacity()) {
            this.ensureCapacity(minCapacity);
        }
    }

    public void resetCapacity() {
        if (this.allocatedCapacity() > this.initialCapacity) {
            this.deflate();
            this.inflate();
        } else {
            this.clear();
        }
    }

    public void setAscii(boolean ascii) {
        Unsafe.getUnsafe().putByte(this.impl + 28L, (byte)(ascii ? 1 : 0));
    }

    @Override
    public int size() {
        return (int)(this.getImplPtr() - this.getImplLo());
    }

    public long tailPadding() {
        return this.getImplHi() - this.getImplPtr();
    }

    private void closeByteSink() {
        long capacityChange = this.allocatedCapacity() - this.lastAllocatedCapacity;
        if (capacityChange != 0L) {
            Unsafe.incrReallocCount();
            Unsafe.recordMemAlloc(capacityChange, this.memoryTag);
        }
    }

    private void deflate() {
        if (this.impl == 0L) {
            return;
        }
        long capAdjustment = -1L * this.allocatedCapacity();
        DirectByteSink.implDestroy(this.impl);
        Unsafe.incrFreeCount();
        Unsafe.recordMemAlloc(capAdjustment, this.memoryTag);
        this.impl = 0L;
    }

    private long getImplHi() {
        assert (this.impl != 0L);
        return Unsafe.getUnsafe().getLong(this.impl + 16L);
    }

    private long getImplLo() {
        assert (this.impl != 0L);
        return Unsafe.getUnsafe().getLong(this.impl + 8L);
    }

    private boolean getImplOverflow() {
        return Unsafe.getUnsafe().getByte(this.impl + 24L) != 0;
    }

    private long getImplPtr() {
        return Unsafe.getUnsafe().getLong(this.impl + 0L);
    }

    private void inflate() {
        this.impl = DirectByteSink.implCreate(this.initialCapacity);
        if (this.impl == 0L) {
            throw CairoException.nonCritical().setOutOfMemory(true).put("could not allocate direct byte sink [maxCapacity=").put(this.initialCapacity).put(']');
        }
        Unsafe.recordMemAlloc(this.allocatedCapacity(), this.memoryTag);
        Unsafe.incrMallocCount();
    }

    private void setImplPtr(long ptr) {
        Unsafe.getUnsafe().putLong(this.impl + 0L, ptr);
    }

    static {
        Os.init();
    }
}

