/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.filewatch;

import io.questdb.FileEventCallback;
import io.questdb.cairo.CairoException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.Epoll;
import io.questdb.network.EpollAccessor;
import io.questdb.network.EpollFacade;
import io.questdb.std.Files;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.filewatch.FileWatcher;
import io.questdb.std.filewatch.LinuxAccessor;
import io.questdb.std.filewatch.LinuxAccessorFacade;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.nio.file.Paths;

public final class LinuxFileWatcher
extends FileWatcher {
    private static final Log LOG = LogFactory.getLog(LinuxFileWatcher.class);
    private final LinuxAccessorFacade accessorFacade;
    private final long buf;
    private final int bufSize = LinuxAccessor.getSizeofEvent() + 4096;
    private final Path dirPath = new Path();
    private final Epoll epoll;
    private final DirectUtf8Sink fileName = new DirectUtf8Sink(0L);
    private final long inotifyFd;
    private final long readEndFd;
    private final int wd;
    private final long writeEndFd;

    public LinuxFileWatcher(LinuxAccessorFacade accessorFacade, EpollFacade epollFacade, Utf8Sequence filePath, FileEventCallback callback) {
        super(callback);
        this.accessorFacade = accessorFacade;
        this.epoll = new Epoll(epollFacade, 2);
        try {
            int inotifyFd2 = accessorFacade.inotifyInit();
            if (inotifyFd2 < 0) {
                throw CairoException.critical(Os.errno()).put("inotify_init error");
            }
            this.inotifyFd = Files.createUniqueFd(inotifyFd2);
            this.dirPath.of(filePath).parent();
            this.fileName.put(Paths.get(filePath.toString(), new String[0]).getFileName().toString());
            this.wd = accessorFacade.inotifyAddWatch(this.inotifyFd, this.dirPath.$().ptr(), LinuxAccessor.IN_CREATE | LinuxAccessor.IN_MODIFY | LinuxAccessor.IN_MOVED_TO | LinuxAccessor.IN_CLOSE_WRITE);
            if (this.wd < 0) {
                throw CairoException.critical(Os.errno()).put("inotify_add_watch exited");
            }
            if (this.epoll.control(this.inotifyFd, 0L, EpollAccessor.EPOLL_CTL_ADD, EpollAccessor.EPOLLIN) < 0) {
                throw CairoException.critical(Os.errno()).put("epoll_ctl error");
            }
            this.buf = Unsafe.malloc(this.bufSize, 36);
            if (this.buf < 0L) {
                throw CairoException.critical(Os.errno()).put("malloc error");
            }
            long fds = accessorFacade.pipe();
            if (fds < 0L) {
                throw CairoException.critical(Os.errno()).put("create a pipe error");
            }
            this.readEndFd = Files.createUniqueFd((int)(fds >>> 32));
            this.writeEndFd = Files.createUniqueFd((int)fds);
            if (this.epoll.control(this.readEndFd, 0L, EpollAccessor.EPOLL_CTL_ADD, EpollAccessor.EPOLLIN) < 0) {
                throw CairoException.critical(Os.errno()).put("epoll_ctl error");
            }
        }
        catch (RuntimeException e) {
            this.cleanUp();
            throw e;
        }
    }

    @Override
    public void waitForChange() {
        int len;
        if (this.epoll.poll(-1) < 0) {
            throw CairoException.critical(Os.errno()).put("epoll_wait error");
        }
        if (this.isClosed()) {
            return;
        }
        int res = this.accessorFacade.readEvent(this.inotifyFd, this.buf, this.bufSize);
        if (res < 0) {
            throw CairoException.critical(Os.errno()).put("read error");
        }
        int i = 0;
        do {
            len = Unsafe.getUnsafe().getInt(this.buf + (long)i + (long)LinuxAccessor.getEventFilenameSizeOffset());
            if (!Utf8s.equals(this.fileName, this.buf + (long)(i += LinuxAccessor.getEventFilenameOffset()), this.fileName.size())) continue;
            this.callback.onFileEvent();
            break;
        } while ((i += len) < res);
        if (this.epoll.control(this.inotifyFd, 0L, EpollAccessor.EPOLL_CTL_MOD, EpollAccessor.EPOLLIN) < 0) {
            throw CairoException.critical(Os.errno()).put("epoll_ctl error");
        }
    }

    private void cleanUp() {
        Misc.free(this.dirPath);
        Misc.free(this.fileName);
        if (this.inotifyFd > 0L && this.accessorFacade.inotifyRmWatch(this.inotifyFd, this.wd) < 0) {
            System.out.println(this.inotifyFd);
        }
        this.epoll.close();
        if (this.inotifyFd > 0L) {
            Files.close(this.inotifyFd);
        }
        if (this.readEndFd > 0L) {
            Files.close(this.readEndFd);
        }
        if (this.writeEndFd > 0L) {
            Files.close(this.writeEndFd);
        }
        if (this.buf > 0L) {
            Unsafe.free(this.buf, this.bufSize, 36);
        }
    }

    @Override
    protected void _close() {
        this.cleanUp();
        LOG.info().$("inotify filewatcher closed").$();
    }

    @Override
    protected void releaseWait() {
        this.accessorFacade.writePipe(this.writeEndFd);
    }
}

