/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.MigrateOutput;

public class MigrateResult
extends HtmlResult {
    public static final String COMMAND = "migrate";
    public String initialSchemaVersion;
    public String targetSchemaVersion;
    public String schemaName;
    public List<MigrateOutput> migrations;
    public int migrationsExecuted;
    public boolean success;
    public String flywayVersion;
    public String database;
    public List<String> warnings = new ArrayList<String>();

    public MigrateResult(String flywayVersion, String database, String schemaName) {
        super(LocalDateTime.now(), COMMAND);
        this.flywayVersion = flywayVersion;
        this.database = database;
        this.schemaName = schemaName;
        this.migrations = new ArrayList<MigrateOutput>();
        this.success = true;
    }

    MigrateResult(MigrateResult migrateResult) {
        super(migrateResult.getTimestamp(), migrateResult.getOperation());
        this.flywayVersion = migrateResult.flywayVersion;
        this.database = migrateResult.database;
        this.schemaName = migrateResult.schemaName;
        this.migrations = migrateResult.migrations;
        this.success = migrateResult.success;
        this.migrationsExecuted = migrateResult.migrationsExecuted;
        this.initialSchemaVersion = migrateResult.initialSchemaVersion;
        this.targetSchemaVersion = migrateResult.targetSchemaVersion;
        this.warnings = migrateResult.warnings;
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public long getTotalMigrationTime() {
        if (this.migrations == null) {
            return 0L;
        }
        return this.migrations.stream().filter(Objects::nonNull).mapToLong(migrateOutput -> migrateOutput.executionTime).sum();
    }
}

