/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.configuration;

import com.usthe.sureness.configuration.SurenessJakartaServletFilter;
import com.usthe.sureness.configuration.SurenessProperties;
import com.usthe.sureness.matcher.DefaultPathRoleMatcher;
import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.matcher.TreePathRoleMatcher;
import com.usthe.sureness.mgt.SecurityManager;
import com.usthe.sureness.mgt.SurenessSecurityManager;
import com.usthe.sureness.processor.DefaultProcessorManager;
import com.usthe.sureness.processor.ProcessorManager;
import com.usthe.sureness.processor.support.DigestProcessor;
import com.usthe.sureness.processor.support.JwtProcessor;
import com.usthe.sureness.processor.support.NoneProcessor;
import com.usthe.sureness.processor.support.PasswordProcessor;
import com.usthe.sureness.processor.support.SessionProcessor;
import com.usthe.sureness.provider.SurenessAccountProvider;
import com.usthe.sureness.provider.annotation.AnnotationPathTreeProvider;
import com.usthe.sureness.provider.ducument.DocumentAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentPathTreeProvider;
import com.usthe.sureness.subject.SubjectFactory;
import com.usthe.sureness.subject.SurenessSubjectFactory;
import com.usthe.sureness.subject.creater.BasicSubjectJakartaServletCreator;
import com.usthe.sureness.subject.creater.BasicSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.BasicSubjectServletCreator;
import com.usthe.sureness.subject.creater.BasicSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.DigestSubjectJakartaServletCreator;
import com.usthe.sureness.subject.creater.DigestSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.DigestSubjectServletCreator;
import com.usthe.sureness.subject.creater.DigestSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.JwtSubjectJakartaServletCreator;
import com.usthe.sureness.subject.creater.JwtSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.JwtSubjectServletCreator;
import com.usthe.sureness.subject.creater.JwtSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsJakartaServletCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsJaxRsCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsServletCreator;
import com.usthe.sureness.subject.creater.JwtSubjectWsSpringReactiveCreator;
import com.usthe.sureness.subject.creater.NoneSubjectJakartaServletCreator;
import com.usthe.sureness.subject.creater.NoneSubjectJaxRsCreator;
import com.usthe.sureness.subject.creater.NoneSubjectServletCreator;
import com.usthe.sureness.subject.creater.NoneSubjectSpringReactiveCreator;
import com.usthe.sureness.subject.creater.SessionSubjectJakartaServletCreator;
import com.usthe.sureness.subject.creater.SessionSubjectServletCreator;
import com.usthe.sureness.util.JsonWebTokenUtil;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="sureness", name={"enable"}, havingValue="true", matchIfMissing=true)
@ConditionalOnResource(resources={"META-INF/spring.factories"})
@AutoConfigureAfter(value={SurenessProperties.class})
public class SurenessAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SurenessAutoConfiguration.class);
    private final SurenessProperties surenessProperties;

    public SurenessAutoConfiguration(SurenessProperties properties) {
        this.surenessProperties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={SurenessAccountProvider.class})
    SurenessAccountProvider accountProvider() {
        return new DocumentAccountProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={PathTreeProvider.class})
    PathTreeProvider pathTreeProvider() {
        return new DocumentPathTreeProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={SubjectFactory.class})
    @ConditionalOnBean(value={SurenessProperties.class})
    SubjectFactory subjectFactory() {
        SurenessProperties.ContainerType containerType;
        HashSet<SurenessProperties.AuthType> authTypes;
        SurenessSubjectFactory subjectFactory = new SurenessSubjectFactory();
        ArrayList<Object> subjectCreates = new ArrayList<Object>();
        SurenessProperties.AuthType[] authTypeArr = this.surenessProperties.getAuths();
        HashSet<SurenessProperties.AuthType> hashSet = authTypes = authTypeArr == null ? new HashSet<SurenessProperties.AuthType>() : new HashSet<SurenessProperties.AuthType>(Arrays.asList(authTypeArr));
        if (authTypes.isEmpty()) {
            LOGGER.info("[sureness-starter] - use default authTypes: Basic, Jwt");
            authTypes = new HashSet(2);
            authTypes.add(SurenessProperties.AuthType.BASIC);
            authTypes.add(SurenessProperties.AuthType.JWT);
        }
        if ((containerType = this.surenessProperties.getContainer()) == null) {
            LOGGER.info("[sureness-starter] - use default supportTypes: Servlet, Websocket");
            containerType = SurenessProperties.ContainerType.Servlet;
        }
        boolean enableWebsocket = this.surenessProperties.getWebsocket() != null && this.surenessProperties.getWebsocket().isEnable();
        switch (containerType) {
            case Servlet: {
                subjectCreates.add(new NoneSubjectServletCreator());
                if (enableWebsocket) {
                    subjectCreates.add(new JwtSubjectWsServletCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.BASIC)) {
                    subjectCreates.add(new BasicSubjectServletCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.JWT)) {
                    subjectCreates.add(new JwtSubjectServletCreator());
                    subjectCreates.add(new JwtSubjectWsServletCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.DIGEST)) {
                    subjectCreates.add(new DigestSubjectServletCreator());
                }
                if (this.surenessProperties.getWebsocket() == null || !this.surenessProperties.getWebsocket().isEnable()) break;
                subjectCreates.add(new SessionSubjectServletCreator());
                break;
            }
            case Jakarta_Servlet: {
                subjectCreates.add(new NoneSubjectJakartaServletCreator());
                if (enableWebsocket) {
                    subjectCreates.add(new JwtSubjectJakartaServletCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.BASIC)) {
                    subjectCreates.add(new BasicSubjectJakartaServletCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.JWT)) {
                    subjectCreates.add(new JwtSubjectJakartaServletCreator());
                    subjectCreates.add(new JwtSubjectWsJakartaServletCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.DIGEST)) {
                    subjectCreates.add(new DigestSubjectJakartaServletCreator());
                }
                if (this.surenessProperties.getWebsocket() == null || !this.surenessProperties.getWebsocket().isEnable()) break;
                subjectCreates.add(new SessionSubjectJakartaServletCreator());
                break;
            }
            case JAX_RS: {
                subjectCreates.add(new NoneSubjectJaxRsCreator());
                if (enableWebsocket) {
                    subjectCreates.add(new JwtSubjectWsJaxRsCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.BASIC)) {
                    subjectCreates.add(new BasicSubjectJaxRsCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.JWT)) {
                    subjectCreates.add(new JwtSubjectJaxRsCreator());
                    subjectCreates.add(new JwtSubjectWsJaxRsCreator());
                }
                if (!authTypes.contains((Object)SurenessProperties.AuthType.DIGEST)) break;
                subjectCreates.add(new DigestSubjectJaxRsCreator());
                break;
            }
            case Spring_Reactor: {
                subjectCreates.add(new NoneSubjectSpringReactiveCreator());
                if (enableWebsocket) {
                    subjectCreates.add(new JwtSubjectWsSpringReactiveCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.BASIC)) {
                    subjectCreates.add(new BasicSubjectSpringReactiveCreator());
                }
                if (authTypes.contains((Object)SurenessProperties.AuthType.JWT)) {
                    subjectCreates.add(new JwtSubjectSpringReactiveCreator());
                }
                if (!authTypes.contains((Object)SurenessProperties.AuthType.DIGEST)) break;
                subjectCreates.add(new DigestSubjectSpringReactiveCreator());
            }
        }
        subjectFactory.registerSubjectCreator(subjectCreates);
        LOGGER.info("[sureness-starter] - SurenessSubjectFactory init success");
        return subjectFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityManager.class})
    SecurityManager securityManager(ProcessorManager processorManager, TreePathRoleMatcher pathRoleMatcher, SubjectFactory subjectFactory) {
        String jwtSecret;
        if (this.surenessProperties.getJwt() != null && (jwtSecret = this.surenessProperties.getJwt().getSecret()) != null && !"".equals(jwtSecret)) {
            JsonWebTokenUtil.setDefaultSecretKey((String)jwtSecret);
        }
        SurenessSecurityManager securityManager = SurenessSecurityManager.getInstance();
        securityManager.setPathRoleMatcher(pathRoleMatcher);
        securityManager.setSubjectFactory(subjectFactory);
        securityManager.setProcessorManager(processorManager);
        return securityManager;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProcessorManager.class})
    ProcessorManager processorManager(SurenessAccountProvider accountProvider) {
        HashSet<SurenessProperties.AuthType> authTypes;
        LinkedList<Object> processorList = new LinkedList<Object>();
        NoneProcessor noneProcessor = new NoneProcessor();
        processorList.add(noneProcessor);
        SurenessProperties.AuthType[] authTypeArr = this.surenessProperties.getAuths();
        HashSet<SurenessProperties.AuthType> hashSet = authTypes = authTypeArr == null ? new HashSet<SurenessProperties.AuthType>() : new HashSet<SurenessProperties.AuthType>(Arrays.asList(authTypeArr));
        if (authTypes.isEmpty()) {
            LOGGER.info("[sureness-starter] - use default authTypes: Basic, Jwt");
            authTypes = new HashSet(2);
            authTypes.add(SurenessProperties.AuthType.BASIC);
            authTypes.add(SurenessProperties.AuthType.JWT);
        }
        if (authTypes.contains((Object)SurenessProperties.AuthType.JWT)) {
            JwtProcessor jwtProcessor = new JwtProcessor();
            processorList.add(jwtProcessor);
        }
        if (authTypes.contains((Object)SurenessProperties.AuthType.BASIC)) {
            PasswordProcessor passwordProcessor = new PasswordProcessor();
            passwordProcessor.setAccountProvider(accountProvider);
            processorList.add(passwordProcessor);
        }
        if (authTypes.contains((Object)SurenessProperties.AuthType.DIGEST)) {
            DigestProcessor digestProcessor = new DigestProcessor();
            digestProcessor.setAccountProvider(accountProvider);
            processorList.add(digestProcessor);
        }
        if (this.surenessProperties.getSession() != null && this.surenessProperties.getSession().isEnable()) {
            SessionProcessor sessionProcessor = new SessionProcessor();
            processorList.add(sessionProcessor);
        }
        return new DefaultProcessorManager(processorList);
    }

    @Bean
    @ConditionalOnMissingBean(value={TreePathRoleMatcher.class})
    TreePathRoleMatcher pathRoleMatcher(List<PathTreeProvider> pathTreeProviders) {
        SurenessProperties.AnnotationProperties annotationProperties;
        DefaultPathRoleMatcher pathRoleMatcher = new DefaultPathRoleMatcher();
        if (pathTreeProviders == null) {
            pathTreeProviders = new ArrayList<PathTreeProvider>();
        }
        if (pathTreeProviders.isEmpty()) {
            pathTreeProviders.add((PathTreeProvider)new DocumentPathTreeProvider());
        }
        if ((annotationProperties = this.surenessProperties.getAnnotation()) != null && annotationProperties.isEnable()) {
            List<String> scanPackages = annotationProperties.getScanPackages();
            if (scanPackages == null || scanPackages.isEmpty()) {
                LOGGER.error("[sureness-starter] - annotation is enable but annotation.scanPackages is null, need config!");
            } else {
                AnnotationPathTreeProvider annotationPathTreeProvider = new AnnotationPathTreeProvider();
                annotationPathTreeProvider.setScanPackages(scanPackages);
                pathTreeProviders.add((PathTreeProvider)annotationPathTreeProvider);
            }
        }
        pathRoleMatcher.setPathTreeProviderList(pathTreeProviders);
        pathRoleMatcher.buildTree();
        return pathRoleMatcher;
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnExpression(value="'${sureness.container:Jakarta_Servlet}'.equalsIgnoreCase('jakarta_servlet')")
    public FilterRegistrationBean<SurenessJakartaServletFilter> filterRegistration(SecurityManager securityManager) {
        SurenessJakartaServletFilter surenessFilter = new SurenessJakartaServletFilter(securityManager);
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setFilter((Filter)surenessFilter);
        registration.setName("SurenessFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }
}

