/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertHandler;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;

public class CteInsertStrategy
implements SqmMultiTableInsertStrategy {
    public static final String SHORT_NAME = "cte";
    private final EntityPersister rootDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final CteTable entityCteTable;

    public CteInsertStrategy(EntityMappingType rootEntityType, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(rootEntityType.getEntityPersister(), runtimeModelCreationContext);
    }

    public CteInsertStrategy(EntityPersister rootDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.rootDescriptor = rootDescriptor;
        this.sessionFactory = runtimeModelCreationContext.getSessionFactory();
        Dialect dialect = runtimeModelCreationContext.getDialect();
        if (!dialect.supportsNonQueryWithCTE()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support CTE that can take UPDATE or DELETE statements as well");
        }
        if (!dialect.supportsValuesList()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support VALUES lists");
        }
        String originalTableName = rootDescriptor.getEntityPersister().getSynchronizedQuerySpaces()[0];
        Object name = Identifier.isQuoted(originalTableName) ? dialect.quote("HTE_" + Identifier.unQuote(originalTableName)) : "HTE_" + originalTableName;
        Object qualifiedTableName = ((String)name).length() > dialect.getMaxIdentifierLength() ? ((String)name).substring(0, dialect.getMaxIdentifierLength()) : name;
        this.entityCteTable = CteTable.createEntityTable((String)qualifiedTableName, rootDescriptor);
    }

    @Override
    public int executeInsert(SqmInsertStatement<?> sqmInsertStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new CteInsertHandler(this.entityCteTable, sqmInsertStatement, domainParameterXref, this.sessionFactory).execute(context);
    }

    protected EntityPersister getRootDescriptor() {
        return this.rootDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected CteTable getEntityCteTable() {
        return this.entityCteTable;
    }
}

