/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.MemoryExhaustionChecker;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionHandler;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.session.SessionState;

class DefaultMemoryExhaustionChecker
implements MemoryExhaustionChecker {
    private MapJoinMemoryExhaustionHandler memoryExhaustionHandler;

    DefaultMemoryExhaustionChecker(SessionState.LogHelper console, HashTableSinkDesc hashTableSinkDesc) {
        this.memoryExhaustionHandler = new MapJoinMemoryExhaustionHandler(console, hashTableSinkDesc.getHashtableMemoryUsage());
    }

    @Override
    public void checkMemoryOverhead(long rowNumber, long hashTableScale, int tableContainerSize) {
        if (rowNumber > hashTableScale && rowNumber % hashTableScale == 0L) {
            this.memoryExhaustionHandler.checkMemoryStatus(tableContainerSize, rowNumber);
        }
    }
}

