/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class PartExprEvalUtils {
    public static Object evalExprWithPart(ExprNodeDesc expr, Partition p) throws HiveException {
        String[] partKeyTypes;
        LinkedHashMap<String, String> partSpec = p.getSpec();
        Properties partProps = p.getSchema();
        if (p.getTable().hasNonNativePartitionSupport()) {
            if (!partSpec.keySet().containsAll(expr.getCols())) {
                return null;
            }
            partKeyTypes = (String[])p.getTable().getStorageHandler().getPartitionKeys(p.getTable()).stream().map(FieldSchema::getType).toArray(String[]::new);
        } else {
            String pcolTypes = partProps.getProperty("partition_columns.types");
            partKeyTypes = pcolTypes.trim().split(":");
        }
        if (partSpec.size() != partKeyTypes.length) {
            if (DDLUtils.isIcebergTable(p.getTable())) {
                return null;
            }
            throw new HiveException("Internal error : Partition Spec size, " + partSpec.size() + " doesn't match partition key definition size, " + partKeyTypes.length);
        }
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<Object> partValues = new ArrayList<Object>();
        ArrayList<AbstractPrimitiveWritableObjectInspector> partObjectInspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>();
        int i = 0;
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            partNames.add(entry.getKey());
            AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)partKeyTypes[i++]));
            partValues.add(ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)oi).convert((Object)entry.getValue()));
            partObjectInspectors.add(oi);
        }
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr);
        ObjectInspector evaluateResultOI = evaluator.initialize((ObjectInspector)partObjectInspector);
        Object evaluateResultO = evaluator.evaluate(partValues);
        return ((PrimitiveObjectInspector)evaluateResultOI).getPrimitiveJavaObject(evaluateResultO);
    }

    public static Pair<PrimitiveObjectInspector, ExprNodeEvaluator> prepareExpr(ExprNodeDesc expr, List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos) throws HiveException {
        ArrayList<AbstractPrimitiveJavaObjectInspector> partObjectInspectors = new ArrayList<AbstractPrimitiveJavaObjectInspector>();
        for (int i = 0; i < partColumnNames.size(); ++i) {
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)partColumnTypeInfos.get(i)));
        }
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partColumnNames, partObjectInspectors);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr);
        ObjectInspector evaluateResultOI = evaluator.initialize((ObjectInspector)objectInspector);
        return Pair.of((Object)((PrimitiveObjectInspector)evaluateResultOI), (Object)evaluator);
    }

    public static Object evaluateExprOnPart(Pair<PrimitiveObjectInspector, ExprNodeEvaluator> pair, Object partColValues) throws HiveException {
        return ((PrimitiveObjectInspector)pair.getLeft()).getPrimitiveJavaObject(((ExprNodeEvaluator)pair.getRight()).evaluate(partColValues));
    }
}

