/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.log.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;

public class IncrementalLoadEvent
extends ReplState {
    @JsonProperty
    private String dbName;
    @JsonProperty
    private String eventId;
    @JsonProperty
    private String eventType;
    @JsonProperty
    private String eventsLoadProgress;
    @JsonProperty
    @JsonSerialize(using=ReplUtils.TimeSerializer.class)
    private Long loadTime;
    @JsonProperty
    private String eventDuration;
    private long loadTimeMillis;

    public IncrementalLoadEvent(String dbName, String eventId, String eventType, long eventSeqNo, long numEvents, long previousTimestamp, ReplStatsTracker replStatsTracker) {
        this.dbName = dbName;
        this.eventId = eventId;
        this.eventType = eventType;
        this.eventsLoadProgress = new String(new StringBuilder().append(eventSeqNo).append("/").append(numEvents));
        this.loadTimeMillis = System.currentTimeMillis();
        this.loadTime = this.loadTimeMillis / 1000L;
        this.eventDuration = this.loadTimeMillis - previousTimestamp + " ms";
        replStatsTracker.addEntry(eventType, eventId, this.loadTimeMillis - previousTimestamp);
    }

    public long getLoadTimeMillis() {
        return this.loadTimeMillis;
    }
}

