/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.TableHandler;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;

public class CommitTxnHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        if (!AcidUtils.isAcidEnabled(context.hiveConf)) {
            context.log.error("Cannot load transaction events as acid is not enabled");
            throw new SemanticException("Cannot load transaction events as acid is not enabled");
        }
        CommitTxnMessage msg = this.deserializer.getCommitTxnMessage(context.dmd.getPayload());
        int numEntry = msg.getTables() == null ? 0 : msg.getTables().size();
        ArrayList tasks = new ArrayList();
        String dbName = context.dbName;
        String tableNamePrev = null;
        String tblName = null;
        ReplTxnWork work = new ReplTxnWork(HiveUtils.getReplPolicy(context.dbName), context.dbName, null, msg.getTxnId(), ReplTxnWork.OperationType.REPL_COMMIT_TXN, context.eventOnlyReplicationSpec(), context.getDumpDirectory(), context.getMetricCollector());
        if (numEntry > 0) {
            context.log.debug("Commit txn handler for txnid " + msg.getTxnId() + " databases : " + msg.getDatabases() + " tables : " + msg.getTables() + " partitions : " + msg.getPartitions() + " files : " + msg.getFilesList() + " write ids : " + msg.getWriteIds());
        }
        for (int idx = 0; idx < numEntry; ++idx) {
            String actualTblName = (String)msg.getTables().get(idx);
            String actualDBName = (String)msg.getDatabases().get(idx);
            String completeName = Table.getCompleteName(actualDBName, actualTblName);
            if (tableNamePrev == null || !completeName.equals(tableNamePrev)) {
                Path location = HiveUtils.getDumpPath(new Path(context.location), actualDBName, actualTblName);
                tblName = actualTblName;
                dbName = context.isDbNameEmpty() ? actualDBName : context.dbName;
                MessageHandler.Context currentContext = new MessageHandler.Context(context, dbName, context.getDumpDirectory(), context.getMetricCollector());
                currentContext.setLocation(location.toUri().toString());
                TableHandler tableHandler = new TableHandler();
                tasks.addAll(tableHandler.handle(currentContext));
                this.readEntitySet.addAll(tableHandler.readEntities());
                this.writeEntitySet.addAll(tableHandler.writeEntities());
                this.getUpdatedMetadata().copyUpdatedMetadata(tableHandler.getUpdatedMetadata());
                tableNamePrev = completeName;
            }
            try {
                WriteEventInfo writeEventInfo = new WriteEventInfo(((Long)msg.getWriteIds().get(idx)).longValue(), dbName, tblName, msg.getFiles(idx));
                if (msg.getPartitions().get(idx) != null && !((String)msg.getPartitions().get(idx)).isEmpty()) {
                    writeEventInfo.setPartition((String)msg.getPartitions().get(idx));
                }
                work.addWriteEventInfo(writeEventInfo);
                continue;
            }
            catch (Exception e) {
                throw new SemanticException("Failed to extract write event info from commit txn message : " + e.getMessage());
            }
        }
        Task<ReplTxnWork> commitTxnTask = TaskFactory.get(work, context.hiveConf);
        if (!context.isDbNameEmpty()) {
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), context.dbName, null, null);
        }
        context.log.debug("Added Commit txn task : {}", (Object)commitTxnTask.getId());
        if (tasks.isEmpty()) {
            return Collections.singletonList(commitTxnTask);
        }
        DAGTraversal.traverse(tasks, new AddDependencyToLeaves(commitTxnTask));
        return tasks;
    }
}

